<?php
defined( 'ABSPATH' ) or die( 'Not Authorized!' );

class Kanews_Stories_Admin {

    public function __construct() {
			// Check if the theme is enabled
			if( ! class_exists( 'KANEWS_WEATHER' ) ){
				return;
			}	
			self::plugin_options();
    }
		
		function plugin_options() {
			//
			// Set a unique slug-like ID
			$prefix = 'kanews_stories';

			// Web Stories availability notice for settings page
			$kanews_ws_notice = '';
			if ( ! shortcode_exists('web_stories') ) {
				$install_url = admin_url('plugin-install.php?s=web%20stories&tab=search&type=term');
				$kanews_ws_notice = '<div class="kanews-alert kanews-alert-warning" style="margin:10px 0;padding:10px;background:#fff3cd;border:1px solid #ffeeba;color:#856404;">Harici (Web Stories) modu için <strong>Google Web Stories</strong> eklentisini yükleyip etkinleştirin. <a href="'.esc_url($install_url).'" target="_blank">Eklentiyi yükle</a></div>';
			}

			//
			// Create options
			CSF::createOptions( $prefix, array(
				'menu_title' => 'Kanews Hikayeler',
				'menu_slug'  => 'kanews-stories',
				    'menu_type'           => 'submenu',
    'menu_parent'         => 'kanews-options',
			) );

			//
			// Create a section
			CSF::createSection( $prefix, array(
				'title'  => 'Tab Title 1',
				'fields' => array(

					array(
						'id'			=> 'kanews_stories',
						'title'			=> __('Hikayeleri Göster', WPS_TEXT_DOMAIN),
						'type'     => 'switcher',
						'default'  => false,
					),
					array(
						'id'      => 'kanews_stories_mode',
						'type'    => 'select',
						'title'   => esc_html__('Sistem', WPS_TEXT_DOMAIN),
						'options' => array(
							'internal' => esc_html__('Dahili', WPS_TEXT_DOMAIN),
							'external' => esc_html__('Harici (Web Stories)', WPS_TEXT_DOMAIN),
						),
						'default' => 'internal',
					),
					array(
						'type'    => 'content',
						'content' => $kanews_ws_notice,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_stories_style',
						'type'    => 'select',
						'default'    => '1',
						'title'   => esc_html__('Görünüm', WPS_TEXT_DOMAIN),
						'options' => array(
							'1' => esc_html__('Görünüm', WPS_TEXT_DOMAIN).' #1',
							'2' => esc_html__('Görünüm', WPS_TEXT_DOMAIN).' #2',
						),
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					array(
						'id'			=> 'kanews_stories_hide_title',
						'title'			=> __('Hikaye Kategori Başlıklarını Gizle', WPS_TEXT_DOMAIN),
						'type'     => 'switcher',
						'default'  => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					array(
						'id'			=> 'kanews_stories_post',
						'title'			=> __('Gösterilecek Hikaye Sayısı', WPS_TEXT_DOMAIN),
						'description'			=> __('Kategori başına gösterilecek hikaye sayısı.', WPS_TEXT_DOMAIN),
						'type'     => 'slider',
						'min'      => 0,
						'max'      => 20,
						'step'     => 1,
						'default'  => 5,
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					array(
						'id'		=> 'kanews_stories_time',
						'title'		=>  __( 'Son 24 Saati Baz Alsın' , WPS_TEXT_DOMAIN ),
						'description'		=>  __( 'On durumunda oluşturduğunuz kategorilerde son 24 saatte paylaşılan yazılar eklenir, off durumunda oluşturduğunuz kategorilerde yazıların yayınlanma tarihine bakılmaksızın son yazılar hikaye olarak eklenir.' , WPS_TEXT_DOMAIN ),
						'type'  => 'switcher',
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					array(
						'id'			=> 'kanews_stories_dr',
						'title'			=> __('Geçiş Süresi', WPS_TEXT_DOMAIN),
						'description'			=> __('Hikayeler arası geçiş süresini ayarlayın (saniye)', WPS_TEXT_DOMAIN),
						'type'     => 'slider',
						'min'      => 0,
						'max'      => 60,
						'step'     => 1,
						'default'  => 5,
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					array(
						'id'			=> 'kanews_stories_dr',
						'title'			=> __('Kategorilerde Yazıların Sıralanışı', WPS_TEXT_DOMAIN),
						'type'     => 'slider',
						'min'      => 0,
						'max'      => 60,
						'step'     => 1,
						'default'  => 5,
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					
					array(
						'id'      => 'kanews_stories_order',
						'type'    => 'select',
						'title'			=> __('Kategori Yazılarının Sıralanışı', WPS_TEXT_DOMAIN),
						'options' => array(
							'' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
							'modified' => esc_html__('Düzenlenme Tarihine Göre', 'kanews'),
						),
						'default' => 'modified',
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
					),
					// Web Stories ayarları (Harici)
					array(
						'id'		  => 'kanews_webstories_post',
						'title'		=> __('Web Stories Adedi', WPS_TEXT_DOMAIN),
						'type'		 => 'slider',
						'min'		  => 1,
						'max'		  => 20,
						'step'		 => 1,
						'default'	 => 5,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_cats',
						'type'    => 'text',
						'title'   => esc_html__('Web Stories Kategorileri', WPS_TEXT_DOMAIN),
						'description' => __('Kategori sluglarını virgülle ayırarak girin. Örn: spor,magazin', WPS_TEXT_DOMAIN),
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_view',
						'type'    => 'select',
						'title'   => esc_html__('Görünüm (Web Stories)', WPS_TEXT_DOMAIN),
						'options' => array(
							'circles'  => esc_html__('Circles', WPS_TEXT_DOMAIN),
							'carousel' => esc_html__('Carousel', WPS_TEXT_DOMAIN),
							// 'grid'     => esc_html__('Grid', WPS_TEXT_DOMAIN),
							// 'list'     => esc_html__('Liste', WPS_TEXT_DOMAIN),
						),
						'default' => 'circles',
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_columns',
						'type'    => 'slider',
						'title'   => esc_html__('Sütun Sayısı', WPS_TEXT_DOMAIN),
						'min'     => 1,
						'max'     => 6,
						'step'    => 1,
						'default' => 1,
						'dependency' => array( 'kanews_stories_mode|kanews_webstories_view', '==|any', 'external|grid,list' ),
					),
					array(
						'id'      => 'kanews_webstories_show_title',
						'type'    => 'switcher',
						'title'   => esc_html__('Başlığı Göster', WPS_TEXT_DOMAIN),
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_excerpt',
						'type'    => 'switcher',
						'title'   => esc_html__('Özeti Göster', WPS_TEXT_DOMAIN),
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_show_author',
						'type'    => 'switcher',
						'title'   => esc_html__('Yazarı Göster', WPS_TEXT_DOMAIN),
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_show_date',
						'type'    => 'switcher',
						'title'   => esc_html__('Tarihi Göster', WPS_TEXT_DOMAIN),
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_sharp_corners',
						'type'    => 'switcher',
						'title'   => esc_html__('Köşeleri Keskin Yap', WPS_TEXT_DOMAIN),
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_orderby',
						'type'    => 'select',
						'title'   => esc_html__('Sıralama Alanı', WPS_TEXT_DOMAIN),
						'options' => array(
							'post_date'  => esc_html__('Yayın Tarihi', WPS_TEXT_DOMAIN),
							'post_title' => esc_html__('Başlık', WPS_TEXT_DOMAIN),
						),
						'default' => 'post_date',
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_order',
						'type'    => 'select',
						'title'   => esc_html__('Sıralama Yönü', WPS_TEXT_DOMAIN),
						'options' => array(
							'DESC' => 'DESC',
							'ASC'  => 'ASC',
						),
						'default' => 'DESC',
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_archive_link',
						'type'    => 'switcher',
						'title'   => esc_html__('Arşiv Bağlantısı Göster', WPS_TEXT_DOMAIN),
						'default' => false,
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_archive_link_label',
						'type'    => 'text',
						'title'   => esc_html__('Arşiv Bağlantısı Etiketi', WPS_TEXT_DOMAIN),
						'default' => 'View all stories',
						'dependency' => array( 'kanews_stories_mode|kanews_webstories_archive_link', '==|==', 'external|true' ),
					),
					array(
						'id'      => 'kanews_webstories_image_alignment',
						'type'    => 'select',
						'title'   => esc_html__('Resim Hizası (Liste)', WPS_TEXT_DOMAIN),
						'options' => array(
							'left'  => esc_html__('Sol', WPS_TEXT_DOMAIN),
							'right' => esc_html__('Sağ', WPS_TEXT_DOMAIN),
						),
						'default' => 'left',
						'dependency' => array( 'kanews_stories_mode|kanews_webstories_view', '==|==', 'external|list' ),
					),
					array(
						'id'      => 'kanews_webstories_class',
						'type'    => 'text',
						'title'   => esc_html__('Ek CSS Sınıfları', WPS_TEXT_DOMAIN),
						'default' => '',
						'dependency' => array( 'kanews_stories_mode', '==', 'external' ),
					),
					array(
						'id'      => 'kanews_webstories_circle_size',
						'type'    => 'slider',
						'title'   => esc_html__('Daire Boyutu (Circles/Carousel)', WPS_TEXT_DOMAIN),
						'min'     => 80,
						'max'     => 300,
						'step'    => 10,
						'default' => 150,
						'dependency' => array( 'kanews_stories_mode|kanews_webstories_view', '==|any', 'external|circles,carousel' ),
					),

					
					array(
						'id'		=> 'kanews_story_cats',
						'title'		=> __( 'Hikaye Kategorisi Oluşturun', WPS_TEXT_DOMAIN ),
						'type'		=> 'group',
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
						'fields' => array(
							array(
								'id'          => 'title',
								'title'       => __( 'Başlık', WPS_TEXT_DOMAIN ),
								'type'        => 'text',
							),
							array(
								'id'          => 'id',
								'title'       => __( 'Kategori Seç', WPS_TEXT_DOMAIN ),
								'default'         => '',
								  'placeholder' => 'Select a category',

								'type'        => 'select',
								'options'        => 'category',
							),							
							array(
								'id'          => 'uid',
								'title'       => __( 'Yazar Seç', WPS_TEXT_DOMAIN ),
								'default'     => '',
								  'placeholder' => 'Select a author',

								'type'        => 'select',
								'options'     => 'users',
							),
							array(
								'id'      => 'color',
								'type'    => 'color',
								'title'   => esc_html__('Kategori Rengi', WPS_TEXT_DOMAIN)
							),
							array(
								'id'          => 'image',
								'title'       => __( 'Kategori Görseli', WPS_TEXT_DOMAIN ),
								'description'			=> __('Görsel boyutunun <code>90x90</code> ebatlarında olması tavsiye edilir.', WPS_TEXT_DOMAIN),
								'default'         => '',
								'type'        => 'upload',
								'operator'    => 'and'
							),
						)
					),
					
					
					array(
						'id'		=> 'kanews_story_site',
						'title'		=> __( 'Özel Hikayeler', WPS_TEXT_DOMAIN ),
						'description'		=> __( 'Bu kısımda blog kategorilerinin dışında özel hikayeler oluşturabilirsiniz.', WPS_TEXT_DOMAIN ),
						'type'		=> 'group',
						'dependency' => array( 'kanews_stories_mode', '==', 'internal' ),
						'fields' => array(
						array(
							'id'          => 'title',
							'title'       => __( 'Hikaye Kategori Adı', WPS_TEXT_DOMAIN ),
							'default'     => '',
							'type'        => 'text',
						),
						array(
								'id'      => 'color',
								'type'    => 'color',
								'title'   => esc_html__('Hikaye Kategori Rengi', WPS_TEXT_DOMAIN)
							),
						array(
							'id'          => 'image',
							'title'       => __( 'Hikaye Kategori Görseli', WPS_TEXT_DOMAIN ),
							'description'			=> __('Görsel boyutunun <code>90x90</code> ebatlarında olması tavsiye edilir.', WPS_TEXT_DOMAIN),
							'default'         => '',
							'type'        => 'upload',
							'operator'    => 'and'
						),
						array(
							'id'		=> 'stories',
							'title'		=> __( 'Hikaye Ekle', WPS_TEXT_DOMAIN ),
							'type'		=> 'group',
							'fields' => array(
								array(
									'id'          => 'title',
									'title'       => __( 'Başlık', WPS_TEXT_DOMAIN ),
									'type'        => 'text',
								),
								array(
									'id'		=> 'link',
									'title'		=> __( 'Link', WPS_TEXT_DOMAIN ),
									'type'		=> 'text',
								),
								array(
									'id'          => 'image',
									'title'       => __( 'Hikaye Görseli', WPS_TEXT_DOMAIN ),
									'default'         => '',
									'type'        => 'upload',
								),
								array(
									'id'          => 'date',
									'title'       => __( 'Hikaye Tarihi', WPS_TEXT_DOMAIN ),
									'default'         => '',
									'type'        => 'date',
								),
							)
						),
						
						)
					),
					
						
						array(
							'type'    => 'subheading',
							'content' => esc_html__('Hazır Ayarlar', 'kanews'),
						),
						array(
							'type'    => 'content',
							'content' => '
								<p>
								<a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/spor/options2.txt" class="button">Spor Demo</a>
								</p>
								',
						),
						
						array(
							'type' => 'backup',
						),
						
								
					

				)
			) );

		}

}

add_filter( 'init', 'Kanews_Stories_Admin_init' );
function Kanews_Stories_Admin_init(){
	if( ! class_exists( 'CSF' ) )
		return;
	new Kanews_Stories_Admin();
}
