<?php
/**
 * Single view template.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

$this->load_parts( [ 'html-start' ] );
?>

<?php $this->load_parts( [ 'header' ] ); ?>

<article class="amp-wp-article">
	<header class="amp-wp-article-header">
		<h1 class="amp-wp-title"><?php echo esc_html( $this->get( 'post_title' ) ); ?></h1>
		<?php $post_desc = get_post_field($this->ID, 'post_excerpt', true);
			if($post_desc != '' && (kanews_get_amp_option('amp-post-excerpt') == true || kanews_get_amp_option('amp-post-excerpt') == NULL)) {
				echo '<p>'.$post_desc.'</p>';
			}  ?>
		<?php $this->load_parts( apply_filters( 'amp_post_article_header_meta', [ 'post-meta' ] ) ); ?>
	</header>
	
	<?php if(get_post_meta($this->ID, 'show_post_thumbnail', true ) == 'on' ): ?>
		<?php $this->load_parts( [ 'featured-image' ] ); ?>
	<?php elseif(get_post_meta( $this->ID, 'show_post_thumbnail', true ) != 'off' && kanews_get_option('show-post-thumbnail') != false  ): ?>
		<?php $this->load_parts( [ 'featured-image' ] ); ?>
	<?php endif; ?>

	<div class="amp-wp-article-assets">
		<div class="amp-wp-article-google-news">
			<?php if(kanews_get_option('google-news-link') != '' && (kanews_get_amp_option('amp-google-news') == true || kanews_get_amp_option('amp-google-news') == NULL)):?>
				<div class="google-news">
					<a target="_blank" rel="nofollow noopener" title="<?php esc_html_e( 'Google News ile Abone Ol', 'kanews' ); ?>" href="<?php echo kanews_get_option('google-news-link'); ?>" class="google-news-link">
					<amp-img alt="google news"
						src="<?php echo KAN_TEMPLATE_URL .'/assets/img/google-news.svg'; ?>"
						width="140"
						height="38"
						layout="responsive">
					</amp-img>
					</a>
				</div>
			<?php endif; ?>
		</div>

		<?php if(kanews_get_amp_option('amp-post-share')): $buttons = kanews_get_amp_option('amp-share-buttons', array('twitter', 'whatsapp', 'email', 'pinterest')); ?>
		<?php if( is_array($buttons) ): ?>
			<div class="amp-wp-article-social-share">
				<?php if(in_array('twitter', $buttons)) { ?>
				<amp-social-share type="twitter" width="28" height="28"
				data-param-text="<?php echo get_the_title($this->ID) ?>"
				data-param-url="<?php echo get_the_permalink($this->ID); ?>">
				</amp-social-share>
				<?php } if(in_array('pinterest', $buttons)) { ?>
				<amp-social-share type="pinterest" width="28" height="28"
				data-param-text="<?php echo get_the_title($this->ID) ?>"
				data-param-href="<?php echo get_the_permalink($this->ID); ?>"
				data-param-media="<?php echo get_the_post_thumbnail_url( 'featured_image' ); ?>">
				</amp-social-share>
				<?php } if(in_array('whatsapp', $buttons)) { ?>
				<amp-social-share type="whatsapp" width="28" height="28"
				data-param-text="<?php echo get_the_title($this->ID) ?> - <?php echo get_the_permalink($this->ID); ?>">
				</amp-social-share>
				<?php } if(in_array('linkedin', $buttons)) { ?>
				<amp-social-share type="linkedin" width="28" height="28"
				data-param-text="<?php echo get_the_title($this->ID) ?>"
				data-param-url="<?php echo get_the_permalink($this->ID); ?>">
				</amp-social-share>
				<?php } if(in_array('email', $buttons)) { ?>
				<amp-social-share type="email" width="28" height="28"
				data-param-subject="<?php echo get_the_title($this->ID) ?>">
				</amp-social-share>
				<?php } ?>
			</div>
		<?php endif; ?>
		<?php endif; ?>
	</div>

	<div class="amp-wp-article-content">
		<?php 
		do_action( 'amp_article_above', $this );

		$meta = get_post_meta( $this->ID, 'post_insight', true ) == 1 ? 1 : 0;

    $author = get_post_field ('post_author', $this->ID);
    $user = get_current_user_id();
    
    if($author == $user)
    	echo $this->get( 'post_amp_content' );
    elseif( $meta != '1' )
    	echo $this->get( 'post_amp_content' );
    elseif( kanews_insights_control() == true )
			echo $this->get( 'post_amp_content' );
		else {
			$out = kanews_private_content();
			echo wp_trim_words(  $this->get( 'post_amp_content' ), 40, $out );
		}
		
		do_action( 'amp_article_below', $this );
		?>
	</div>

	<footer class="amp-wp-article-footer">
		<?php $this->load_parts( apply_filters( 'amp_post_article_footer_meta', [ 'meta-taxonomy', 'meta-comments-link' ] ) ); ?>
	</footer>
	
</article>

<?php $this->load_parts( array( 'related-posts' ) ); ?>


<?php $this->load_parts( [ 'footer' ] ); ?>

<?php
$this->load_parts( [ 'html-end' ] );
