<?php
defined( 'ABSPATH' ) || exit; // Exit if accessed directly


// Check core class for avoid errors
if( class_exists( 'CSF' ) ) {

  $prefix = 'kanews_amp';

  CSF::createOptions( $prefix, array(
    'menu_title' => esc_html__('AMP', 'Admin Menu Title',  'kanews'),
    'menu_slug'  => 'kanews-amp',
    'menu_type'           => 'submenu',
    'menu_parent'         => 'kanews-options',
    'framework_title'     => esc_html__('Kanews Tema Ayarları', 'kanews'),
    'show_bar_menu' => false,
    'admin_bar_menu_icon' => 'dashicons-admin-generic',
    'footer_credit'         => esc_html__('Kan Themes Gururla Sunar.', 'kanews'),
    'footer_text'         => '',
    'theme'               => 'light'
	) );


  /**
	 * AMP 
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('AMP Ayarları', 'kanews'),
    'icon'  => 'fas fa-fire-alt',
    'fields' => array(
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=amp&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Amp</a> eklentisinin kurulu olması gerekiyor. Template Mode: Okuyucu olmalı!        ',
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Ayarları', 'kanews'),
      ),
       // Logo
       array(
        'id'     => 'amp-logo',
        
        'type'   => 'fieldset',
        'title'   => esc_html__('Site Logosu', 'kanews' ),
        'fields' => array(
          array(
            'id'      => 'type',
            'type'    => 'radio',
            'inline'  => false,
            'options' => array(
              'text'    => esc_html__('Yazı', 'kanews'),
              'img'    => esc_html__('Görsel', 'kanews'),
            ),
          ),
          array(
            'id'    => 'logo-text',
            'type'  => 'text',
            
            'title' => __('Site İsmi', 'kanews'),
            'dependency' => array( 'type', '==', 'text' ),
          ),
          array(
            'type'       => 'media',
            'id'          => 'logo-img',
            'button_title' => esc_html__('Görsel', 'kanews'),
            'dependency' => array( 'type', '==', 'img' ),
          ),
        ),
        'default' => array(
          'type' => 'text',
          'logo-text' => KAN_THEME_NAME,
        ),
      ),
      array(
        'id'      => 'amp-menu',
        'title'   => esc_html__('Menu', 'kanews'),
        'type'    => 'switcher',
        
        'default' => true
      ),
      array(
        'id'      => 'amp-search',
        'title'   => esc_html__('Arama', 'kanews'),
        'type'    => 'switcher',
        
        'default' => true
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('İçerik Ayaları', 'kanews'),
      ),
      array(
        'id'      => 'amp-post-excerpt',
        'title'   => esc_html__('Yazı Açıklaması', 'kanews'),
        
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'amp-post-author',
        'title'   => esc_html__('Yazar', 'kanews'),
        
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'amp-post-published',
        'title'   => esc_html__('Yayınlanma Tarihi ', 'kanews'),
        
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'amp-post-updated',
        'title'   => esc_html__('Güncelleme Tarihi', 'kanews'),
        
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'amp-post-share',
        'title'   => esc_html__('Yazıyı Paylaş', 'kanews'),
        
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'amp-share-buttons',
        'type'    => 'button_set',
        'title'   => esc_html__('Paylaş Butonları', 'kanews'),
        'dependency' => array( 'amp-post-share', '==', 'true' ),
        'multiple' => true,
        'options' => array(
          'twitter' => 'Twitter',
          'whatsapp' => 'Whatsapp',
          'telegram' => 'Telegram',
          'pinterest' => 'Pinterest',
          'email' => 'E-Posta',
        ),
        'default' => array('twitter', 'whatsapp', 'email', 'pinterest')
      ),
      array(
        'id'      => 'amp-google-news',
        'title'   => esc_html__('Google News', 'kanews'),
        
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'amp-cats',
        'title'   => esc_html__('Kategoriler', 'kanews'),
        
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'amp-tags',
        'title'   => esc_html__('Etiketler', 'kanews'),
        
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'amp-related',
        'title'   => esc_html__('Benzer Yazılar', 'kanews'),
        
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'amp-related-sortby',
        'type'    => 'radio',
        'title'   => esc_html__('Göre Sırala', 'kanews'),
        'dependency' => array( 'amp-related', '!=', 'false' ),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
          'post-modified' => esc_html__('Düzenlenme Tarihine Göre', 'kanews'),
          'commented' => esc_html__('En Çok Yorum Yapılan', 'kanews'),
          'random' => esc_html__('Rastgele', 'kanews')
        ),
        'default' => 'random'
      ),
      array(
        'id'       => 'amp-related-count',
        'type'     => 'slider',
        'dependency' => array( 'amp-related', '!=', 'false' ),
        'title'    => esc_html__('Yazı Sayısı', 'kanews'),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 6,
      ),

      // Footer
      array(
        'type'    => 'subheading',
        'content' => __('Reklam Yönetimi', 'kanews'),
      ),
      array(
        'id'    => 'amp-auto-ads-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Otomatik Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-auto-ads',
        'type'  => 'code_editor',
        'sanitize' => false,
        
        'subtitle'  => esc_html__('Amp için otomatik reklamlar kodunuzu ekleyin. Sadece [amp-ad-auto] kodunu ekleyin.', 'kanews'),
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-auto-ads-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'amp-ad-header-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        
        'title'  => esc_html__('Header Altı', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-header',
        'type'  => 'code_editor',
        'sanitize' => false,
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-ad-header-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'amp-ad-footer-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        
        'title'  => esc_html__('Footer Üstü', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-footer',
        'type'  => 'code_editor',
        'sanitize' => false,
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-ad-footer-switch', '==', 'true' ),
      ),      
      array(
        'id'    => 'amp-ad-single-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Başlangıç', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-single-above',
        'type'  => 'code_editor',
        
        'sanitize' => false,
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-ad-single-above-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'amp-ad-single-amid-switch',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Yazı Ortası', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-single-amid',
        'type'  => 'code_editor',
        'sanitize' => false,
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-ad-single-amid-switch', '==', 'true' ),
      ),

      array(
        'id'       => 'amp-ad-single-amid-limit',
        'type'     => 'slider',
        'title'    => esc_html__('Paragraf Seçimi', 'kanews'),
        'dependency' => array( 'amp-ad-single-amid-switch', '==', 'true' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
      ),
      array(
        'id'    => 'amp-ad-single-amid-switch2',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Yazı Ortası', 'kanews').' #2',
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-single-amid2',
        'type'  => 'code_editor',
        'sanitize' => false,
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-ad-single-amid-switch2', '==', 'true' ),
      ),

      array(
        'id'       => 'amp-ad-single-amid-limit2',
        'type'     => 'slider',
        'title'    => esc_html__('Paragraf Seçimi', 'kanews'),
        'dependency' => array( 'amp-ad-single-amid-switch2', '==', 'true' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
      ),
      array(
        'id'    => 'amp-ad-single-below-switch',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Yazı Sonu', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-single-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'amp-ad-single-below-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'amp-ad-single-shortcode-switch',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Kısakod İle Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'amp-ad-single-shortcode',
        'type'  => 'code_editor',
        'sanitize' => false,
        'subtitle'  => esc_html__('Kısakodu eklediğiniz alanlarda gözükür. Kullanılması gereken kısakod: [kanews-ad]', 'kanews'),
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-shortcode-switch', '==', 'true' ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar', 'kanews'),
      ),

      // WP Head
      array(
        'id'    => 'amp-wp-head',
        'type'  => 'code_editor',
        
        'sanitize' => false,
        'desc'  => esc_html__('Head etiketi içerisine kod eklemenizi sağlar, örneğin meta kodları.', 'kanews'),
        'title'  => esc_html__('Head Kodları', 'kanews'),
      ),

      array(
        'id'    => 'amp-custom-css',
        'type'  => 'code_editor',
        'settings' => array(
          'theme'  => 'mbo',
          'mode'   => 'css',
        ),
        'title'  => esc_html__('Ek CSS', 'kanews'),
      ),

      // WP Footer
      array(
        'id'    => 'amp-wp-footer',
        'type'  => 'code_editor',
        
        'sanitize' => false,
        'desc'  => esc_html__('Body etiketinin sonuna kod eklemenizi sağlar, örneğin google analiz kodları, adsense kodları.', 'kanews'),
        'title'  => esc_html__('Footer Kodları', 'kanews'),
      ),
    )
  ));




}