<?php
namespace Kanews\Assets;

class BackEndAsset {
  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  public function __construct() {
    add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
    add_action( 'enqueue_block_editor_assets', array( $this, 'block_editor_assets' ) );
    add_editor_style( 'editor-styles.css' );

    add_action( 'admin_init', array( $this, 'load_gfonts' ) );
    add_action( 'admin_head', array( $this, 'gfonts_custom_css' ) );
  }

  public function enqueue_scripts() {	
    wp_enqueue_style( 'kanews-admin', KAN_TEMPLATE_URL. '/assets/css/admin.css', false, KAN_THEME_VER);
    wp_enqueue_script( 'kanews-admin-js', KAN_TEMPLATE_URL . '/assets/js/admin/admin.js', array( 'jquery' ), KAN_THEME_VER, true );
    wp_localize_script(
      'kanews-admin-js',
      'kanewsAdminConfig',
      array(
        'ajaxUrl'   => admin_url( 'admin-ajax.php' ),
        'testNonce' => wp_create_nonce( 'kanews_ai_test_provider' ),
        'aiNonce'   => wp_create_nonce( 'kanews_ai_nonce_action' ),
        // Sadece local / geliştirici ortamında define('KAN_DEV_MODE', true); ise dev etiketi göster
        'devMode'   => ( defined( 'KAN_DEV_MODE' ) && true === KAN_DEV_MODE ),
      )
    );
	}

  public function block_editor_assets() {
		wp_enqueue_style(
			'kanews-editor',
			get_template_directory_uri() . "/editor-styles.css",
			array(),
			'1.0'
		);
	}

  public function load_gfonts() {
    global $pagenow;
    if ( $pagenow == 'post.php'  || $pagenow == 'post-new.php' || $pagenow == 'page.php' || $pagenow == 'page.php' ) {
      add_action('admin_footer', 'dynamic_scripts');
    }
  } 
	

  public function gfonts_custom_css() {
		
		$font_final = kanews_global_font('site-font');
		$font_final2 = kanews_global_font('single-font');
		
		if( $font_final2 == 'System' ) {
			$return_font = '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif';
		} elseif( $font_final2 != '' ) {
			$return_font = $font_final2;
		} elseif( $font_final == 'System' ) {
			$return_font = '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif';
		} elseif( $font_final != '' ) {
			$return_font = $font_final;
		} else 
			$return_font = 'Inter';
		
		echo '<style>:root {
			--theme_font: "'.$return_font.'", sans-serif;
		}</style>';
		
  }

}