<?php

namespace Kanews\Kai\AI;

interface ProviderInterface
{
    public function id(): string;

    public function hasCredentials(): bool;

    /**
     * Sends a chat style prompt to the provider and returns normalized response.
     *
     * @param array $prompt
     * @return array{content:string,raw:array}
     */
    public function chat(array $prompt): array;
}

