<?php

namespace Kanews\Kai;

use Kanews\Kai\AI\Client as AiClient;
use Kanews\Kai\Admin\AdminUi;
use Kanews\Kai\Audio\AudioBriefingController;
use Kanews\Kai\Chat\ChatController;
use Kanews\Kai\Feeds\FeedManager;
use Kanews\Kai\Tasks\AjaxTaskController;

class Manager
{
    private static $instance;

    private $aiClient;
    private $adminUi;
    private $chatController;
    private $audioController;
    private $ajaxController;
    private $feedManager;

    private function __construct()
    {
        $this->aiClient       = new AiClient();
        $this->adminUi        = new AdminUi($this);
        $this->chatController = new ChatController($this);
        $this->audioController= new AudioBriefingController($this);
        $this->ajaxController = new AjaxTaskController($this);
        $this->feedManager    = new FeedManager($this);
    }

    public static function instance(): self
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function boot(): void
    {
        $this->adminUi->register();
        $this->chatController->register();
        $this->audioController->register();
        $this->ajaxController->register();
        $this->feedManager->register();
    }

    public function ai(): AiClient
    {
        return $this->aiClient;
    }

    public function feeds(): FeedManager
    {
        return $this->feedManager;
    }

    public function audio(): AudioBriefingController
    {
        return $this->audioController;
    }

    public function adminUi(): AdminUi
    {
        return $this->adminUi;
    }
}

