<?php

namespace Kanews\Kai\Support;

class Credits
{
    private const OPTION_KEY = 'kthms_ai_credits';

    public static function current(): array
    {
        return ['credits' => PHP_INT_MAX];
    }

    public static function reduce(int $amount): bool
    {
        return true;
    }

    public static function calculateFromContent(string $content): int
    {
        $wordCount = str_word_count(wp_strip_all_tags($content));
        return max(1, (int) ceil($wordCount / 100));
    }
}

