<?php

namespace Kanews\Kai\Support;

class Options
{
    public static function get(string $key, $default = null)
    {
        // Read only from dedicated KAI options storage. No fallback to kanews_options.
        $kaiOptions = get_option('kanews_kai_options', []);
        if (!is_array($kaiOptions)) {
            $kaiOptions = [];
        }
        if (array_key_exists($key, $kaiOptions)) {
            return $kaiOptions[$key];
        }

        return $default;
    }

    public static function getApiKey(string $service): string
    {
        switch ($service) {
            case 'openai':
                return (string) self::get('openai-api', '');
            case 'pexels':
                return (string) self::get('pexels-api', '');
            case 'gemini':
                return (string) self::get('gemini-api', '');
            default:
                return '';
        }
    }

    public static function getDefaultProvider(): string
    {
        $provider = (string) self::get('kai-ai-provider', 'gemini');
        return $provider ?: 'gemini';
    }
}

