<?php
namespace Kanews;
use Kanews\WpHelper;
use Kanews\Helper;
use Kanews\Ads;
use Kanews\Currencies;
use Kanews\PostViews;
use Kanews\Reactions;
use Kanews\Category;
use Kanews\Builder\Widget;
use Kanews\Builder\PageBuilder;
use Kanews\Builder\Modules;
use Kanews\Builder\Terms;
use Kanews\Assets\BackEndAsset;
use Kanews\Assets\FrontEndAsset;
use Kanews\Util\Cache;
use Kanews\Util\Speed;
use Kanews\Util\Seo;
use Kanews\Util\Kai;
use Kanews\Members\Users;
use Kanews\Members\Notifications;
use Kanews\AutoDailyContent;

class Theme {
	private static $instance;

	public static function getInstance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	private function __construct() {
		$this->theme_hook();
		add_action('after_setup_theme', function() {
			$this->includes();
			$this->theme_setup();
			
		});	
	}

	public function includes() {
		require get_parent_theme_file_path('framework/class/Insights.php');
		require get_parent_theme_file_path('framework/class/Standings.php');
		require get_parent_theme_file_path('framework/class/Weather.php');

		require get_parent_theme_file_path('inc/post-like.php');
		require get_parent_theme_file_path('inc/bookmark.php');
		require get_parent_theme_file_path('inc/shortcodes/app.php');
		require get_parent_theme_file_path('inc/opengraph.php');
		require get_parent_theme_file_path('inc/rating.php');
		require get_parent_theme_file_path('inc/pwa.php');
		require get_parent_theme_file_path('inc/basic_user_avatar.php');
		require get_parent_theme_file_path('framework/admin/fields/heartbeat.php');
		require get_parent_theme_file_path('inc/kai.php');
	}

	public function theme_setup() {
		Helper_Wp::getInstance();
		Helper::getInstance();
		Seo::getInstance();

		Ads::getInstance();
		Cache::getInstance();
		Speed::getInstance();
		
		Users::getInstance();
		Notifications::getInstance();

		Currencies::getInstance();
		PostViews::getInstance();
		Reactions::getInstance();
		
		AutoDailyContent::getInstance();
		
		PageBuilder::getInstance();
		Widget::getInstance();
		Modules::getInstance();

		Kai::getInstance();

		if( is_admin() ) {
			Category::getInstance();
			BackEndAsset::getInstance();
			Terms::getInstance();
			Shortcode::getInstance();
			
			require get_parent_theme_file_path('framework/admin/translate.php');
			require get_parent_theme_file_path('amp/theme-options.php');
		} else {
			FrontEndAsset::getInstance();
			require get_parent_theme_file_path('framework/widgets/widget-helpers.php');
		}

	}

	public function theme_hook() {
		add_action( 'wp',  'Kanews\Breadcrumbs::getInstance' );

		add_action( 'after_setup_theme', array( $this, 'theme_support' ) );
		add_action( 'after_switch_theme', array( $this, 'flush_rewrite_rules' ) );
		add_action( 'after_switch_theme', array( $this, 'schedule_auto_daily_cron' ) );
		add_action( 'csf_kanews_options_save_after', array( $this, 'flush_rewrite_rules' ) );
		add_action( 'jpeg_quality', array( $this, 'jpeg_quality' ), 10, 2 );

		add_action( 'kanews_footer',                      'kanews_login_modal', 10 );
		add_action( 'kanews_footer',                      'kanews_mobile_menu', 10 );
		add_action( 'kanews_post_hook',                   'kanews_add_bookmark', 5 );
		add_action( 'kanews_post_hook',                   'kanews_paid_post_badge', 1 );
		add_action( 'kanews_post_hook',                   'kanews_video_time', 10 );
		add_action( 'kanews_entry_above',                 'kanews_link_pages_after', 5 );
		add_action( 'kanews_entry_above',                 'kanews_post_tags', 15, 1 );
		add_filter( 'the_content',                        'kanews_lazyload_post_content', 999 );
		add_filter( 'wp_get_attachment_image_attributes', 'kanews_add_lazyload_to_attachment_image', 10, 2 );
		add_filter( 'wp_calculate_image_srcset',          'kanews_lazyload_disable_srcset' );
		add_filter( 'get_avatar',                         'kanews_lazyload_avatar', 20, 2 );
	}

	public function theme_support() {
		remove_theme_support( 'widgets-block-editor' );
		add_theme_support( 'post-formats', array( 'video', 'gallery' ) );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'woocommerce' );
		
		// add_image_size( 'kanews-manset-1', 1170, 450, true );
		add_image_size( 'kanews-manset-2', 975, 450, true );
		add_image_size( 'kanews-manset-3', 770, 450, true );
		// add_image_size( 'kanews-manset-4', 570, 450, true );
		add_image_size( 'kanews-manset-5', 370, 450, true );

		add_image_size( 'kanews-post-1', 282, 188, true );
		add_image_size( 'kanews-post-2', 570, 285, true );
		add_image_size( 'kanews-post-3', 370, 185, true );

		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Navbar', 'kanews' ),
				'menu-2' => esc_html__( 'Mobil Menü', 'kanews' ),
				'menu-3' => esc_html__( 'Footer Menü', 'kanews' ),
			)
		);		
		
		$left_menu = kanews_get_option('subheader-left', array());
		$right_menu = kanews_get_option('subheader-right', array());
		if( is_array($left_menu) && in_array('menu', $left_menu)) {
			register_nav_menus(
				array(
					'subheader-left' => esc_html__( 'SubHeader Sol Menü', 'kanews' ),
				)
			);
		}
		
		if( is_array($right_menu) && in_array('menu', $right_menu)) {
			register_nav_menus(
				array(
					'subheader-right' => esc_html__( 'SubHeader Sağ Menü', 'kanews' ),
				)
			);
		}

		if (kanews_get_option('big-menu') == true) {
			register_nav_menus(
				array(
					'big-menu' => esc_html__( 'Büyük Menü', 'kanews' ),
				)
			);
		}

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		add_theme_support( 'customize-selective-refresh-widgets' );

		if(function_exists('is_amp_endpoint')) {
			register_nav_menus( array(
				'amp-menu' => esc_html__( 'Amp Menü', 'kanews' ),
			) );
		}
		
		if ( kanews_get_option('wp-admin-bar-disable') )
		show_admin_bar(false);
		
	}
	
	public function flush_rewrite_rules() {
		global $wp_rewrite;
		$wp_rewrite->flush_rules();
	}

	public function jpeg_quality( $quality, $context ) {
		return kanews_get_option('jpeg-quality', 100);
	}
	
	public function schedule_auto_daily_cron() {
		AutoDailyContent::schedule_cron();
	}

}