<?php

namespace Kanews\Util;

use Kanews\Kai\Manager;
use Kanews\Kai\Support\Credits;
use Kanews\Kai\Support\Options;

class Kai
{
    public static function getInstance()
    {
        $manager = Manager::instance();
        $manager->boot();

        return $manager;
    }

    public static function get_api_key($service)
    {
        return Options::getApiKey((string) $service);
    }

    public static function get_site_credits()
    {
        return Credits::current();
    }

    public static function reduce_site_credits($amount)
    {
        return Credits::reduce((int) $amount);
    }
}

