<?php
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

	add_action('after_setup_theme', function() {
  // Create a metabox for posts
	$prefix = 'kanews_post_options';
  CSF::createMetabox( $prefix, array(
    'title'     => 'Kanews Ayarları',
		'data_type' => 'unserialize',
		'show_restore' => true,
    'post_type' => 'post',
  ) );

	$manset_fields =array(
		// Add preview area at the top
    array(
      'type'    => 'subheading',
      'content' => 'Manşet Önizleme',
    ),
		
		array(
			'type'    => 'content',
			'content' => '<div id="kanews-manset-preview" class="kanews-manset-preview">
				<div class="kanews-slide">
					<img src="" class="kanews-slide-thumb" />
					<div class="kanews-slide-overlay"></div>
					<div class="kanews-manset-tag"><span></span><span></span><span></span></div>
					<div class="kanews-slide-content">
						<div class="kanews-category">Kategori</div>
						<div class="kanews-slide-headline"></div>
						<div class="kanews-slide-spot"></div>
					</div>
				</div>
			</div>',
		),

		
		array(
			'type'    => 'subheading',
			'content' => 'Manşet Görseli Oluştur',
		),

		array(
			'type'    => 'content',
			'content' => '<div style="margin: 15px 0;">
				<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 10px;">
					<button type="button" id="kanews-generate-hero-desktop" class="button button-primary button-large" style="padding: 12px;">
						<span class="dashicons dashicons-desktop" style="margin-top: 3px;"></span> Masaüstü Oluştur
					</button>
					<button type="button" id="kanews-generate-hero-mobile" class="button button-primary button-large" style="padding: 12px;">
						<span class="dashicons dashicons-smartphone" style="margin-top: 3px;"></span> Mobil Oluştur
					</button>
				</div>
				<div id="kanews-hero-image-status" style="margin-top: 10px; padding: 10px; background: #f0f0f1; border-radius: 4px; display: none;"></div>
				<p style="margin-top: 10px; color: #666; font-size: 12px;">
					<strong>Not:</strong> "Manşet Görseli (Masaüstü)" veya "Manşet Görseli (Mobil)" alanından bir görsel seçin, 
					"Manşet Başlığı" ve "Vurgulanan Başlık" alanlarını doldurun, renkleri ayarlayın ve ilgili butona tıklayın.
				</p>
			</div>',
		),

		array(
			'id'      => 'manset_desktop',
			'type'    => 'media',
			'preview_size' => 'full',
			'title'   => esc_html__( 'Manşet Görseli (Masaüstü)', 'kanews'),
			'desc'   => esc_html__( 'Manşetin gözükeceği alana göre boyut farklılık gösterebilir.', 'kanews'),
		),

		array(
			'id'      => 'manset_mobile',
			'type'    => 'media',
			'preview_size' => 'full',
			'title'   => esc_html__( 'Manşet Görseli (Mobil)', 'kanews'),
			'desc'   => esc_html__( '345x275px önerilir.', 'kanews'),
		),

		// Manşet imza / logo ayarları
		array(
			'id'      => 'kanews_hero_signature_image',
			'type'    => 'media',
			'title'   => esc_html__( 'İmza / Logo Görseli', 'kanews' ),
			'desc'    => esc_html__( 'Sağ veya sol üst köşeye eklenecek şeffaf PNG logo / imza. Boş bırakırsanız eklenmez.', 'kanews' ),
			'preview_size' => 'thumbnail',
		),

		array(
			'id'      => 'kanews_hero_signature_position',
			'type'    => 'select',
			'title'   => esc_html__( 'İmza Konumu', 'kanews' ),
			'options' => array(
				'top_left'  => esc_html__( 'Sol Üst', 'kanews' ),
				'top_right' => esc_html__( 'Sağ Üst', 'kanews' ),
			),
			'default' => 'top_right',
		),

		// Manşet kırpma ayarları
		array(
			'id'    => 'kanews_hero_crop_width',
			'type'  => 'text',
			'title' => esc_html__( 'Kırpma Genişliği (px)', 'kanews' ),
			'desc'  => esc_html__( 'İsteğe bağlı. Örn: 1200. Boş bırakırsanız orijinal genişlik kullanılır.', 'kanews' ),
		),

		array(
			'id'    => 'kanews_hero_crop_height',
			'type'  => 'text',
			'title' => esc_html__( 'Kırpma Yüksekliği (px)', 'kanews' ),
			'desc'  => esc_html__( 'İsteğe bağlı. Örn: 675. Boş bırakırsanız orijinal yükseklik kullanılır.', 'kanews' ),
		),

		// Manşet içerik hizalama
		array(
			'id'      => 'kanews_hero_text_align',
			'type'    => 'select',
			'title'   => esc_html__( 'Manşet İçerik Hizalaması', 'kanews' ),
			'desc'    => esc_html__( 'Varsayılan ortalıdır. İsterseniz metni sola veya sağa yaslayabilirsiniz.', 'kanews' ),
			'options' => array(
				'center' => esc_html__( 'Ortala', 'kanews' ),
				'left'   => esc_html__( 'Sola Yasla', 'kanews' ),
				'right'  => esc_html__( 'Sağa Yasla', 'kanews' ),
			),
			'default' => 'center',
		),

	

    array(
      'id'    => 'kanews_manset_highlight',
      'type'  => 'text',
      'title' => 'Vurgulanan Başlık',
      'desc'  => 'Bu başlık sarı renkte ana başlığın üstünde gözükecektir.',
    ),
    array(
      'id'    => 'kanews_manset_title',
      'type'  => 'text',
      'title' => 'Manşet Başlığı',
      'desc'  => 'Başlık içinde kelimeyi beyaz yapmak için: **Kelime**, kırmızı yapmak için: ***Kelime*** şeklinde yazabilirsiniz.',
    ),

    array(
      'id'    => 'kanews_manset_excerpt',
      'type'  => 'textarea',
      'title' => 'Manşet Açıklaması',
    ),

    array(
      'id'      => 'post_detail',
      'type'    => 'checkbox',
      'title'   => 'Yazı Detaylarını Gizle',
      'desc'   => 'Yazı başlığı vb gibi detayların görselin üstünde gözükmesini engeller, seçili olduğunda sadece manşet görseli gözükür.',
    ),

	

		
		array(
			'type'    => 'subheading',
			'content' => 'Manşet Etiket',
		),

		array(
			'id'      => 'manset_tag_style',
			'type'    => 'select',
			'default' => '',
			'title'   => 'Manşet Etiket Görünümü',
			'options' => array(
				''	=> 'Varsayılan',
				'1'	=> 'Stil 1 - Pulse Animasyon',
				'2'	=> 'Stil 2 - Border Animasyon',
				'3'	=> 'Stil 3 - 3D Gölge',
				'4'	=> 'Stil 4 - Gradient Ripple',
				'5'	=> 'Stil 5 - Shine Effect',
			)
		),
		
		array(
			'id'      => 'manset_tag',
			'type'    => 'select',
			'default' => '',
			'title'   => 'Manşet Etiket Konumu',
			'options' => array(
				''	=> 'Varsayılan',
				'top-left'	=> 'Yukarıda Solda',
				'top-right'	=> 'Yukarıda Sağda',
				'bottom-right'	=> 'Aşağıda Sağda',
				'bottom-left'	=> 'Aşağıda Solda'
			)
		),

		array(
			'id'    => 'manset_tag_title',
			'type'  => 'text',
			'title' => 'Manşet Etiketi',
		),
		array(
			'id'    => 'manset_tag_bg',
			'type'  => 'color',
			'title' => 'Manşet Etiketi Arkaplan Rengi',
		),
		array(
			'id'    => 'manset_tag_color',
			'type'  => 'color',
			'title' => 'Manşet Etiketi Yazı Rengi',
		),
		
		array(
			'type'    => 'subheading',
			'content' => 'Manşet Tasarım',
		),

		array(
			'id'      => 'manset_detail_position',
			'type'    => 'select',
			'default' => '',
			'title'   => 'Manşet Detay Konumu',
			'options' => array(
				''=> 'Varsayılan',
				'bottom'	=> 'Aşağıda',
				'left'	=> 'Ortada Solda',
				'right'	=> 'Ortada Sağda'
			)
		),

		array(
			'id'    => 'manset_color',
			'type'  => 'color',
			'title' => 'Manşet Kaplama Rengi',
		),

		array(
			'id'    => 'manset_title_color',
			'type'  => 'color',
			'title' => 'Manşet Başlık Rengi',
		),

		array(
			'id'    => 'manset_desc_color',
			'type'  => 'color',
			'title' => 'Manşet Açıklama Rengi',
		),
		
		array(
			'id'                 => 'manset_title_typography',
			'type'               => 'typography',
			'title'              => 'Manşet Başlık Tipografi',
			'font_family'        => true,
			'font_weight_2'      => true,
			'font_weight'        => false,
			'font_style'         => true,
			'font_size'          => true,
			'line_height'        => true,
			'letter_spacing'     => true,
			'text_align'         => false,
			'text-transform'     => true,
			'color'              => false,
			'subset'             => false,
			'backup_font_family' => false,
			'font_variant'       => false,
			'word_spacing'       => false,
			'text_decoration'    => false,
		),
		
		array(
			'id'                 => 'manset_desc_typography',
			'type'               => 'typography',
			'title'              => 'Manşet Açıklama Tipografi',
			'font_family'        => false,
			'font_weight_2'      => true,
			'font_weight'        => false,
			'font_style'         => true,
			'font_size'          => true,
			'line_height'        => true,
			'letter_spacing'     => true,
			'text_align'         => false,
			'text-transform'     => true,
			'color'              => false,
			'subset'             => false,
			'backup_font_family' => false,
			'font_variant'       => false,
			'word_spacing'       => false,
			'text_decoration'    => false,
		),

		

	);



	// Yazı
  CSF::createSection( $prefix, array(
    'title'  =>  esc_html__( 'Yazı Ayarları', 'kanews' ),
    'fields' => array(

			array(
				'id'      => 'kanews_bik_id',
				'type'    => 'text',
				'title'   => esc_html__('Basın İlan NO', 'kanews'),
				'desc'   => 'Bu bir resmi ilan ise, basın ilan kurumundan aldığınız ilan numarasını girin.',
			),

			array(
				'id'      => 'kanews_post_title',
				'type'    => 'text',
				'title'   => esc_html__('Yazı Başlığı', 'kanews'),
			),
			array(
				'id'      => 'kanews_post_featured',
				'type'    => 'media',
				'title'   => esc_html__('Yazı Öne Çıkarılan Görseli', 'kanews'),
				'desc'   => esc_html__('Yazı içinde öne çıkarılan görsel yerine gösterilir.', 'kanews'),
			),

			array(
				'id'      => 'post_insight',
				'type'    => 'select',
				'default' => '0',
				'title'   => esc_html__('Kanews Insights', 'kanews'),
				'options' => array(
					'0'	=> esc_html__( 'Herkese Açık', 'kanews' ),
					'1'	=> esc_html__( 'Ücretli İçerik', 'kanews' ),
					'2'	=> esc_html__( 'Süreli Ücretli İçerik', 'kanews' ),
				)
			),

			array(
				'id'      => 'post_insight_countdown',
				'type'    => 'select',
				'title'   => esc_html__('İçeriğin Herkese Açılacağı Tarih', 'kanews'),
				'dependency' => array( 'post_insight', '==', '2' ),
				'type'  => 'date',
				'settings' => array(	
					'dateFormat'      => 'yy/mm/dd',
				)
			),

			array(
				'id'      => 'select_post_layout',
				'type'    => 'image_select',
				'title'   => esc_html__('Görünüm', 'kanews'),
				'options' => array(
				'default' => KAN_TEMPLATE_URL .'/assets/img/options/default.jpg',
				'1' => KAN_TEMPLATE_URL .'/assets/img/options/single-1.jpg',
				'2' => KAN_TEMPLATE_URL .'/assets/img/options/single-2.jpg',
				'3' => KAN_TEMPLATE_URL .'/assets/img/options/single-3.jpg',
				'4' => KAN_TEMPLATE_URL .'/assets/img/options/single-4.jpg',
				'5' => KAN_TEMPLATE_URL .'/assets/img/options/single-5.jpg',
				'6' => KAN_TEMPLATE_URL .'/assets/img/options/single-6.jpg',
				),
				'default' => 'default',
			),

			array(
				'id'      => 'select_post_layout_block',
				'type'    => 'select',
				'default_value' => 'default',
				'title'   => esc_html__('Görünüm', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'box'	=> esc_html__( 'Kutu', 'kanews' ),
					'flat'	=> esc_html__( 'Düz', 'kanews' ),
				)
			),

			array(
				'id'      => 'post_pagination_type',
				'type'    => 'select',
				'default_value' => 'default',
				'title'   => esc_html__('Sayfalama Tipi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'number'	=> esc_html__( 'Numaralı Sayfalama', 'kanews' ),
					'infinite'	=> esc_html__( 'Aşağı İndikçe Yükle', 'kanews' ),
					'button'	=> esc_html__( 'Daha Fazla Yükle Butonu ile', 'kanews' ),
				)
			),

			array(
				'id'      => 'primary_cat_color',
				'type'    => 'select',
				
				'default' => '',
				'title'   => esc_html__('Kategori Rengini Uygula', 'kanews'),
				'options' => array(
					''	=> 'Varsayılan',
					'on'	=> esc_html__( 'Evet', 'kanews' ),
					'off'	=> esc_html__( 'Hayır', 'kanews' )
				)
			),
			array(
				'id'      => 'show_post_ads',
				'type'    => 'select',
				'default' => '',
				'default' => '',
				'title'   => esc_html__('Reklamlar', 'kanews'),
				'options' => array(
					''	=> 'Varsayılan',
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
        'id'          => 'select_infinite_next',
        'type'        => 'select',
        'title'       => esc_html__('Sonra Gelen yazı', 'kanews'),
        'desc'        => esc_html__('Sayfa sonunda yüklenecek yazıyı seçin.', 'kanews'),
        'chosen'      => true,
        'multiple'    => false,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'posts',
        'placeholder' => esc_html__( 'Yazı Seçin', 'kanews' ),
      ),

			array(
				'id'      => 'show_post_reading_bar',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Okuma Barı', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_breacrumb',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Breadcrumb', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_share',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazıyı Paylaş', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),


			array(
				'id'      => 'show_post_excerpt',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazı Açıklaması', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_thumbnail',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Öne Çıkarılan Görsel', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_author',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazar', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_posts_related',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Benzer Yazılar', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_posts_related2',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('İlgili Yazılar', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_cat',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Kategori', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_date',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yayınlanma Tarihi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_update_date',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Düzenleme Tarihi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_views',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Okunma Sayısı', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_read_time',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Okuma Süresi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_assets',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazı Araçları', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_tags',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Etiketler', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_like',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazıyı Beğen', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_bookmark',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazıyı Favorilerine Ekle', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),
			
			array(
				'id'      => 'post_text_to_speech',
				'type'    => 'media',
				'library' => 'audio',
				'title'   => esc_html__('Yazının Ses Dosyası', 'kanews'),
			),
			
			array(
				'id'      => 'post_text_to_speech2',
				'type'    => 'text',
				'title'   => esc_html__('Yazının Ses Dosyası Linki (Veya)', 'kanews'),
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__('KAI Sohbet Ayarları', 'kanews'),
			),

			array(
				'id'    => 'kai-chat-override',
				'title'  => esc_html__('KAI Sohbet Durumunu Özelleştir', 'kanews'),
				'desc'  => esc_html__('Bu makale için KAI sohbet sisteminin durumunu özelleştir.', 'kanews'),
				'type'  => 'button_set',
				'options' => array(
					''     => esc_html__('Tema Ayarlarını Kullan', 'kanews'),
					'on'   => esc_html__('Aktif', 'kanews'),
					'off'  => esc_html__('Pasif', 'kanews'),
				),
				'default' => ''
			),
		)
	) );

	  // Manşet
		CSF::createSection( $prefix, array(
			'title'  => esc_html__( 'Manşet Ayarları', 'kanews' ),
	
			'fields' => $manset_fields
		) );
	
		// Video Galeri
		CSF::createSection( $prefix, array(
			'title'  => esc_html__( 'Video Galeri', 'kanews' ),
			'fields' => array(
	
				array(
					'type'    => 'subheading',
					'content' => esc_html__('Video Galeri', 'kanews'),
				),
	
				array(
					'type'    => 'notice',
					'style'   => 'danger',
					'content' => esc_html__( 'Yazı formatını Video olarak seçmeyin unutmayın!', 'kanews' ),
				),
	
				array(
					'id'    => 'video_embed',
					'type'  => 'text',
					'title' => esc_html__( 'Video Linki', 'kanews' ),
				),
	
				array(
					'id'    => 'video_src',
					'type'  => 'text',
					'title' => esc_html__( 'HTML5 Video Linki', 'kanews' ),
				),
	
				array(
					'id'    => 'iframe_src',
					'type'  => 'text',
					'title' => esc_html__( 'Iframe Linki', 'kanews' ),
				),
	
				array(
					'id'    => 'video_time',
					'type'  => 'text',
					'title' => esc_html__( 'Video Süresi', 'kanews' ),
				),
			
			)
		) );

	///////////////////////
	// Create a metabox for pages
	$prefix = 'kanews_page_options';
  CSF::createMetabox( $prefix, array(
    'title'     => esc_html__( 'Kanews Ayarları', 'kanews' ),
		'data_type' => 'unserialize',
		'show_restore' => true,
    'post_type' => 'page',
  ) );
	
	CSF::createSection( $prefix, array(
    'title'  => esc_html__( 'Genel Ayarlar', 'kanews' ),
    'fields' => array(

      array(
        'id'    => '_page_color',
        'type'  => 'color',
        'title' => esc_html__( 'Sayfa Rengi', 'kanews' ),
      ),

			array(
				'id'      => 'page_header',
				'type'    => 'select',
				'default' => 'on',
				'title'   => esc_html__('Page Header', 'kanews'),
				'options' => array(
					'on'	=> esc_html__( 'Oluştur', 'kanews' ),
					'off'	=> esc_html__( 'Oluşturma', 'kanews' )
				)
			),

			array(
				'id'      => 'post_insight',
				'type'    => 'select',
				'default' => '0',
				'title'   => esc_html__('Kanews Insights', 'kanews'),
				'options' => array(
					'0'	=> esc_html__( 'Herkese Açık', 'kanews' ),
					'1'	=> esc_html__( 'Ücretli İçerik', 'kanews' ),
				)
			),

			array(
				'id'      => 'show_post_ads',
				'type'    => 'select',
				'default' => 'on',
				'title'   => esc_html__('Reklamlar', 'kanews'),
				'options' => array(
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_thumbnail',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Öne Çıkarılan Görsel', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_date',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yayınlanma Tarihi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_update_date',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Düzenleme Tarihi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'page_auto_refresh',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Otomatik Sayfa Yenileme', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Aktif', 'kanews' ),
					'off'	=> esc_html__( 'Pasif', 'kanews' )
				)
			),

    )
  ) );
	
	CSF::createSection( $prefix, array(
    'title'  => esc_html__( 'Özel Sayfalar', 'kanews' ),
    'fields' => array(

			array(
				'id'      => 'custom_page_related',
				'type'    => 'select',
				'default' => '',
				'title'   => esc_html__('İlgilinizi Çekebilir Kategorisi', 'kanews'),
				'desc'   => esc_html__('İlgilinizi Çekebilir Kategorisi', 'kanews'),
				'options' => 'kanews_category_list'
			),

    )
  ) );

	///////////////////////
	// Create a metabox for columist
	$prefix = 'kanews_columnist_options';
  CSF::createMetabox( $prefix, array(
    'title'     => esc_html__( 'Kanews Ayarları', 'kanews' ),
		'data_type' => 'unserialize',
		'show_restore' => true,
    'post_type' => 'columist',
  ) );

	 // Manşet
	 CSF::createSection( $prefix, array(
    'title'  => esc_html__( 'Manşet Ayarları', 'kanews' ),

    'fields' => $manset_fields
  ) );
	
	CSF::createSection( $prefix, array(
    'title'  => esc_html__( 'Genel Ayarlar', 'kanews' ),
    'fields' => array(

			array(
				'id'      => 'show_post_thumbnail',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Öne Çıkarılan Görsel', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),


			array(
				'id'      => 'post_text_to_speech',
				'type'    => 'media',
				'library' => 'audio',
				'title'   => esc_html__('Yazının Ses Dosyası', 'kanews'),
			),

			array(
				'id'      => 'show_post_share',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazıyı Paylaş', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),


			array(
				'id'      => 'show_post_excerpt',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazı Açıklaması', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),


			array(
				'id'      => 'show_post_author',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazar', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_date',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yayınlanma Tarihi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_update_date',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Düzenleme Tarihi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_views',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Okunma Sayısı', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_read_time',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Okuma Süresi', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_assets',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazı Araçları', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'on'	=> esc_html__( 'Göster', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_like',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazıyı Beğen', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

			array(
				'id'      => 'show_post_bookmark',
				'type'    => 'select',
				'default' => 'default',
				'title'   => esc_html__('Yazıyı Favorilerine Ekle', 'kanews'),
				'options' => array(
					'default'	=> esc_html__( 'Varsayılan', 'kanews' ),
					'off'	=> esc_html__( 'Gösterme', 'kanews' )
				)
			),

    )
  ) );

	///////////////////////
	// Create a metabox for companies
	$prefix = 'kanews_companies_options';
  CSF::createMetabox( $prefix, array(
    'title'     => esc_html__( 'Kanews Ayarları', 'kanews' ),
		'data_type' => 'unserialize',
		'show_restore' => true,
    'post_type' => 'firma',
  ) );
	
	CSF::createSection( $prefix, array(
    'title'  => esc_html__( 'Genel Ayarlar', 'kanews' ),
    'fields' => array(

			array(
				'id'      => 'comp_name',
				'type'    => 'text',
				'title'   => esc_html__('Firma Adı', 'kanews'),
			),
			array(
				'id'      => 'comp_auth',
				'type'    => 'text',
				'title'   => esc_html__('Firma Yetkilisi', 'kanews'),
			),
			array(
				'id'      => 'comp_city',
				'type'    => 'text',
				'title'   => esc_html__('Firma Şehri', 'kanews'),
			),
			array(
				'id'      => 'comp_adress',
				'type'    => 'textarea',
				'title'   => esc_html__('Firma Adresi', 'kanews'),
			),
			array(
				'id'      => 'comp_mail',
				'type'    => 'text',
				'title'   => esc_html__('Firma E-Posta', 'kanews'),
			),
			array(
				'id'      => 'comp_tel',
				'type'    => 'text',
				'title'   => esc_html__('Firma Telefonu', 'kanews'),
			),
			array(
				'id'      => 'comp_fax',
				'type'    => 'text',
				'title'   => esc_html__('Firma Fax Numarası', 'kanews'),
			),
			array(
				'id'      => 'comp_site',
				'type'    => 'text',
				'title'   => esc_html__('Firma Web Sitesi', 'kanews'),
			),
			array(
				'id'      => 'comp_map',
				'type'    => 'text',
				'title'   => esc_html__('Firma Harita URL', 'kanews'),
			),

    )
  ) );

	// Create a metabox for ilan
	$prefix = 'kanews_ilan_options';
  CSF::createMetabox( $prefix, array(
    'title'     => esc_html__( 'Kanews Ayarları', 'kanews' ),
		'data_type' => 'unserialize',
		'show_restore' => true,
    'post_type' => 'ilan',
  ) );
	
	CSF::createSection( $prefix, array(
    'title'  => esc_html__( 'Genel Ayarlar', 'kanews' ),
    'fields' => array(

			array(
				'id'      => 'ilan_price',
				'type'    => 'text',
				'title'   => esc_html__('İlan Fiyatı', 'kanews'),
			),
			array(
				'id'      => 'ilan_adress',
				'type'    => 'text',
				'title'   => esc_html__('Tam Adres', 'kanews'),
			),
			array(
				'id'      => 'ilan_mail',
				'type'    => 'text',
				'title'   => esc_html__('E-Posta', 'kanews'),
			),
			array(
				'id'      => 'ilan_tel',
				'type'    => 'text',
				'title'   => esc_html__('Telefon', 'kanews'),
			),
			array(
				'id'      => 'ilan_tel2',
				'type'    => 'text',
				'title'   => esc_html__('Telefon', 'kanews').' 2',
			),
			array(
				'id'      => 'ilan_whatsapp',
				'type'    => 'text',
				'title'   => esc_html__('Whatsapp', 'kanews'),
			),
			array(
				'id'      => 'ilan_map',
				'type'    => 'text',
				'title'   => esc_html__('Harita URL', 'kanews'),
			),
			array(
				'id'      => 'ilan_thumb1',
				'type'    => 'media',
				'preview_size' => 'full',
				'title'   => sprintf(esc_html__( 'İlan Görseli %s', 'kanews'), '1'),
			),
			array(
				'id'      => 'ilan_thumb2',
				'type'    => 'media',
				'preview_size' => 'full',
				'title'   => sprintf(esc_html__( 'İlan Görseli %s', 'kanews'), '2'),
			),
			array(
				'id'      => 'ilan_thumb3',
				'type'    => 'media',
				'preview_size' => 'full',
				'title'   => sprintf(esc_html__( 'İlan Görseli %s', 'kanews'), '3'),
			),
			array(
				'id'      => 'ilan_thumb4',
				'type'    => 'media',
				'preview_size' => 'full',
				'title'   => sprintf(esc_html__( 'İlan Görseli %s', 'kanews'), '4'),
			),
			array(
				'id'      => 'ilan_thumb5',
				'type'    => 'media',
				'preview_size' => 'full',
				'title'   => sprintf(esc_html__( 'İlan Görseli %s', 'kanews'), '5'),
			),
			array(
        'id'     => 'ilan_list',
        'type'   => 'group',
        'title'  => esc_html__('İlan Detayları', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'    => 'text',
            'type'  => 'text',
            'title' => esc_html__('Detay', 'kanews'),
          ),
        )
      ),

    )
  ) );



});
}


function kanews_category_list() {
	$categories_obj = get_categories();
	$cats['hide'] = esc_html__( 'Gösterme', 'kanews' );

	foreach ($categories_obj as $pn_cat) {
		$cats[$pn_cat->cat_ID] = $pn_cat->cat_name;
	}

	return $cats;
}