<?php
defined( 'ABSPATH' ) || exit; // Exit if accessed directly


// Check core class for avoid errors
if( class_exists( 'CSF' ) ) {


  $prefix = 'kanews_options';
  
  add_action('after_setup_theme', function() use ($prefix) {

  CSF::createOptions( $prefix, array(
    'menu_title' => esc_html__('kanews', 'Admin Menu Title'),
    'menu_slug'  => 'kanews-options',
    'menu_type'           => 'submenu',
    'menu_parent'         => 'kanews',
    'framework_title'     => 'Kanews <span class="kan-theme-ver">'.KAN_THEME_VER.'</span>',
    'show_bar_menu' => false,
    'admin_bar_menu_icon' => 'dashicons-admin-generic',
    'footer_credit'         => esc_html__('Kan Themes Gururla Sunar.'),
    'footer_text'         => '',
    'theme'               => 'dark',
    'database'               => 'option'
	) );

  /**
	 * General Settings
	 */
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Genel Ayarlar'),
    'icon'  => 'fas fa-cog',
    'fields' => array(
      
      // Logo
      array(
        'type'    => 'heading',
        'content' => esc_html__('Logo Ayaları'),
      ),
      array(
        'id'     => 'logo',
        'type'   => 'fieldset',
        'title'   => esc_html__('Site Logosu'),
        'fields' => array(
          array(
            'id'      => 'type',
            'type'    => 'radio',
            'inline'  => false,
            'options' => array(
              'text'    => esc_html__('Yazı'),
              'img'    => esc_html__('Görsel'),
            ),
          ),
          array(
            'id'    => 'logo-text',
            'type'  => 'text',
            'title' => __('Site İsmi'),
            'dependency' => array( 'type', '==', 'text' ),
          ),
          array(
            'type'       => 'media',
            'id'          => 'logo-img',
            'button_title' => esc_html__('Görsel'),
            'dependency' => array( 'type', '==', 'img' ),
          ),
        ),
        'default' => array(
          'type' => 'text',
          'logo-text' => KAN_THEME_NAME,
        ),
      ),
      // Retina Logo
      array(
        'id'    => 'logo-mobile',
        'title'  => esc_html__('Retina Logo'),
        'desc'  => esc_html__('Ana logodan 2 kat daha büyük olmalıdır.'),
        'type'  => 'media'
      ),
      // Dark Logo
      array(
        'id'    => 'logo-dark',
        
        'title'  => esc_html__('Koyu Mod Logo'),
        'desc'  => esc_html__('Koyu mod aktif edildiğinde gözükecek olan logo.'),
        'type'  => 'media'
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Genel Ayarlar'),
      ),
      
      
      // Dark Mode
      array(
        'id'    => 'default-mode',
        'title'  => esc_html__('Varsayılan Mod'),
        'desc'  => esc_html__('Siteye ilk girişte hangi mod görünecek.'),
        'type'  => 'select',
        'options' => array(
          'light' => esc_html__('Açık'),

          'dark' => esc_html__('Koyu'),
          'system' => esc_html__('Sistem'),
        ),
        'default' => 'light'
      ),
      array(
        'id'    => 'mode',
        'title'  => esc_html__('Gece/Gündüz Modu'),
        'type'  => 'switcher',
        'default' => true
      ),

      array(
        'id'      => 'ajax-search',
        'title'   => esc_html__('Ajax Search'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Views
      array(
        'id'    => 'post-views',
        'title'  => esc_html__('Okunma Sayısı'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'post-views-source',
        'type'    => 'select',
        'title'   => esc_html__('Okunma Sayısı Kaynağı'),
        'dependency' => array( 'post-views', '==', 'true' ),
        'options' => array(
          'theme' => esc_html__('Tema'),
          'post-views-counter' => esc_html__('Post Views Counter'),
        ),
        'default' => 'theme'
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'dependency' => array( 'post-views-source', '==', 'post-views-counter' ),
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=post-views-counter&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Post Views Counter</a> eklentisinin kurulu olması gerekiyor.',
      ),
      
      // Sticky Sidebar
      array(
        'id'    => 'sticky-sidebar',
        'title'  => esc_html__('Yapışkan Sidebar'),
        'type'  => 'switcher',
        'default' => true
      ), 

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Seo Ayarları'),
      ),
      // Article Json LD
      array(
        'id'    => 'json-ld',
        'title'  => esc_html__('Yapısal Veri İşaretlemesi'),
        'help'  => esc_html__('Her wordpress yazısına json ld formatında yazının verilerini işaretler ve arama motorları bu verileri işler.'),
        'type'  => 'switcher',
        'default' => true
      ), 

      array(
        'id'      => 'article-json-ld-format',
        'type'    => 'select',
        'title'   => esc_html__('Yazılar için Yapısal Veri Tipi'),
        
        'dependency'  => array( 'json-ld', '==|==', 'true|true' ),
        'options' => array(
          'article' => esc_html__('Makale'),
          'NewsArticle' => esc_html__('Haber'),
          'BlogPosting' => esc_html__('Blog Yazısı'),
        ),
        'default' => 'NewsArticle'
      ),
      // Breadcrumb Json LD
      array(
        'id'    => 'breadcrumb',
        'title'  => esc_html__('Breadcrumb için Yapısal Veri'),
        'help'  => esc_html__('Her wordpress sayfasına json ld formatında breadcrumb verilerini ekler ve arama motorları bu verilerini işler.'),
        'type'  => 'switcher',
        'dependency' => array( 'json-ld', '==', 'true','', 'visible'  ),
        'default' => true
      ), 
      // OpenGraph
      array(
        'id'    => 'open-graph',
        'title'  => esc_html__('Open Graph Etiketleri'),
        'help'  => esc_html__('Sosyal medya siteleri için meta etiketi olarak yazı ve ana sayfalara site/yazı verilerini ekler ve sosyal medya siteleri bu verileri işler.'),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Auto Refresh
      array(
        'id'    => 'auto-refresh',
        
        'title'  => esc_html__('Otomatik Sayfa Yenileme'),
        'help'  => esc_html__('Ziyaretçi belirlediğiniz süre boyunca aynı sayfada kalırsa otomatik olarak sayfa yenileme işlemi yapar.'),
        'type'  => 'switcher',
        'default' => false
      ), 
      array(
        'id'       => 'auto-refresh-time',
        'type'     => 'slider',
        'title'    => esc_html__('Otomatik Sayfa Yenileme Süresi'),
        'help'    => esc_html__('Saniye cinsinden belirlemeniz gerekir.'),
        'dependency' => array( 'auto-refresh', '==', 'true' ),
        'min'      => 60,
        'max'      => 1000,
        'step'     => 1,
        'default'  => 300,
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Hız Ayarları'),
      ),
      // Cache 
      array(
        'id'    => 'kanews-cache',
        'title'  => esc_html__('Dahili Önbellekler'),
        'type'  => 'switcher',
        'default' => false
      ), 
      // Speed Opt. 
      array(
        'id'    => 'kanews-speed',
        'title'  => esc_html__('Hız Optimizasyonları'),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Preload sources
      array(
        'id'    => 'kanews-preload',
        'class'  => 'no-border',
        'title'  => esc_html__('Preload'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Dns Prefetch
      array(
        'id'    => 'kanews-dns-prefetch',
        'class'  => 'no-border',
        'title'  => esc_html__('DNS Prefetch'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'default' => true
      ), 
      // JS Defer
      array(
        'id'    => 'kanews-js-defer',
        'title'  => esc_html__('JS Defer'),
        'class'  => 'no-border',
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'default' => true
      ), 
      array(
        'id'    => 'kanews-speed-remove-emoji',
        'title'  => esc_html__('Emoji Desteğini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),
      array(
        'id'    => 'kanews-speed-remove-oembed',
        'title'  => esc_html__('oEmbed Desteğini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),
      array(
        'id'    => 'kanews-speed-remove-rsd',
        'title'  => esc_html__('RSD Linklerini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),
      array(
        'id'    => 'kanews-speed-remove-wp-version',
        'title'  => esc_html__('WP Versiyon Bilgilerini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),
      array(
        'id'    => 'kanews-speed-remove-global-styles',
        'title'  => esc_html__('Global Stilleri Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),
      array(
        'id'    => 'kanews-speed-remove-rest-api',
        'title'  => esc_html__('REST API Desteğini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => false
      ),
      array(
        'id'    => 'kanews-speed-remove-block-styles',
        'title'  => esc_html__('Block Editor Stillerini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),
      array(
        'id'    => 'kanews-speed-remove-classic-theme-styles',
        'title'  => esc_html__('Klasik Tema Stillerini Kaldır'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'class'  => 'no-border',

        'default' => true
      ),

      // LazyLoad
      array(
        'id'    => 'lazy',
        'title'  => esc_html__('Lazy Load'),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Retina Logo
      array(
        'id'    => 'lazy-logo',
        'class'  => 'no-border',
        'title'  => esc_html__('Lazy Load Placeholder'),
        'dependency' => array( 'lazy', '!=', '' ),
        'type'  => 'media'
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar'),
      ),
      
       // Adblock
       array(
        'id'    => 'adblock-detected',
        'title'  => esc_html__('Reklam Engelleyicilerini Tespit Et'),
        'type'  => 'switcher',
        'default' => false
      ), 
       // Back to top
       array(
        'id'    => 'back-to-top',
        'title'  => esc_html__('Başa Dön Tuşu'),
        'type'  => 'switcher',
        'default' => true
      ), 
       // Right Click
       array(
        'id'    => 'right-click',
        'title'  => esc_html__('Sağ Tıkları Yasakla'),
        'type'  => 'switcher',
        'default' => false
      ), 
       // Copy
       array(
        'id'    => 'copy-event',
        'title'  => esc_html__('Kopyalama İşlemlerini Yasakla'),
        'type'  => 'switcher',
        
        'default' => false
      ), 
      // RSS Feed
      array(
        'id'       => 'featured-to-rss',
        'type'     => 'switcher',
        'default' => false,
        'title'    => esc_html__( 'RSS Feed\'ine Öne Çıkarılan Görseli Dahil Et'),
      ),

       // Privacy Policy Box
       array(
        'id'    => 'privacy-policy',
        'title'  => esc_html__('Gizlilik Politikası Uyarısı'),
        'type'  => 'switcher',
        'default' => false
      ), 
      // Privacy Policy Page
      array(
        'id'          => 'privacy-policy-page',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('Gizlilik Politikası Sayfası'),
        'dependency'  => array( 'privacy-policy', '==', 'true' ),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin')
      ),
      // Default Thumbnail
      array(
        'id'    => 'default-thumbnail',
        
        'title'  => esc_html__('Varsayılan Öne Çıkarılan Görsel'),
        'type'  => 'media'
      ),
      // WP Head
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Head Kodları'),
      ),
      array(
        'id'    => 'wp-head',
        'type'  => 'code_editor',
        'sanitize' => false,
        'desc'  => esc_html__('Head etiketi içerisine kod eklemenizi sağlar, örneğin meta kodları.'),
      ),

      // WP Footer
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Footer Kodları'),
      ),
      array(
        'id'    => 'wp-footer',
        'type'  => 'code_editor',
        'sanitize' => false,
        'desc'  => esc_html__('Body etiketinin sonuna kod eklemenizi sağlar, örneğin google analiz kodları, adsense kodları.'),
      ),
		)
	));
	
	/**
	 * Header
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Header Ayarları'),
    'icon'  => 'fas fa-heading',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Header Ayarları'),
      ),
      
      // Layout
      array(
        'id'      => 'header-layout',
        'type'    => 'image_select',
        'title'   => esc_html__('Görünüm'),
        'options' => array(
          'style-1' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/1.png',
          'style-2' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/2.png',
          // 'style-3' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/3.png',
          'style-4' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/4.png',
        ),
        'default' => 'style-1',
      ),
      
      array(
        'id'      => 'header-skin',
        'type'    => 'select',
        // 'dependency' => array( 'header-layout', '==', 'style-1' ),
        'title'   => esc_html__('Header Renk Modu'),
        'options' => array(
          'dark' => esc_html__('Koyu'),
          'light' => esc_html__('Açık'),
        ),
        'default' => 'dark'
      ),
      array(
        'id'      => 'navbar-skin',
        'type'    => 'select',
        'dependency' => array( 'header-layout', '!=', 'style-2' ),
        'title'   => esc_html__('Navbar Renk Modu'),
        'options' => array(
					'light' => esc_html__('Açık'),
          'dark' => esc_html__('Koyu'),
        ),
        'default' => 'light'
      ),

      
      array(
        'id'      => 'header-wide',
        'type'    => 'select',
        'dependency' => array( 'header-layout', '==', 'style-2' ),
        'title'   => esc_html__('Genişlik'),
        'options' => array(
          'wide' => esc_html__('Geniş'),
          'normal' => esc_html__('Normal'),
        ),
        'default' => 'wide'
      ),

      array(
        'id'     => 'header-buttons',
        'type'   => 'group',
        'title'  => esc_html__('Butonlar'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          array(
            'id'      => 'color',
            'type'    => 'color',
            'title'   => esc_html__('Arkaplan')
          ),
        ),
      ),

      array(
        'id'    => 'header-prayer',
        'title'  => esc_html__('Ramazan Sahur/İftar Geri Sayım'),
        'type'  => 'switcher',
        'class' => 'yeni',
        'default' => false
      ),

      array(
        'id'          => 'header-prayer-page',
        'type'        => 'select',
        'title'       => esc_html__('Detay Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'dependency' => array( 'header-prayer', '==', 'true' ),
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),

      array(
        'id'         => 'header-prayer-page-city',
        'type'       => 'text',
        'title'      => esc_html__('Şehir'),
        'desc'      => esc_html__('Sadece iller'),
        'default'    => 'İstanbul',
        'dependency' => array( 'header-prayer', '==', 'true' ),
      ),
      array(
        'id'         => 'header-prayer-page-city2',
        'type'       => 'text',
        'title'      => esc_html__('İlçe'),
        'desc'      => esc_html__('Sadece ilçeler'),
        'dependency' => array( 'header-prayer', '==', 'true' ),
      ),

      // Sub Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header'),
      ),
      array(
        'id'    => 'subheader-switch',
        'title'  => esc_html__('Sub Header'),
        'type'  => 'switcher',
        'default' => true
      ),

      array(
        'id'      => 'subheader-position',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Konum'),
        'options' => array(
          'top' => esc_html__('Üst'),
          'bottom' => esc_html__('Alt'),
        ),
        'default' => 'top'
      ),

      // Sub Header: Left
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header Sol Kısım Ayarları'),
      ),
      array(
        'id'      => 'subheader-left',
        'type'    => 'button_set',
        
        'multiple'    => true,
        'title'   => esc_html__('Modül'),
        'options' => array(
          'weather' => esc_html__('Hava Durumu'),
          'currencies' => esc_html__('Öne Çıkan Kurlar'),
          'breaking-news' => esc_html__('Son Dakika'),
          'menu' => esc_html__('Menü'),
          'date' => esc_html__('Tarih'),
          'html' => esc_html__('HTML'),
          // 'secim'       => esc_html__('Seçim Sayacı'),
          'disable' => esc_html__('Hiçbir şey'),
        ),
        'default' => 'currencies'
      ),

      array(
        'id'         => 'subheader-left-editor',
        'title'      => esc_html__('Editör'),
        'class'  => 'no-border',
        'type'  => 'code_editor',
        'sanitize' => false,
        'dependency' => array( 'subheader-left', 'any', 'html' ),
      ),
      array(
        'id'         => 'subheader-left-date-format',
        'type'       => 'text',
        'class'  => 'no-border',
        'default'       => 'j F Y, D',
        'desc'      =>  '<a href="https://wordpress.org/support/article/formatting-date-and-time/#format-string-examples">Tarih formatı örnekleri</a>',
        'title'      => esc_html__('Tarih Formatı'),
        'dependency' => array( 'subheader-left', 'any', 'date' ),
      ),


      // Sub Header Left: Weather Deault City
      array(
        'id'         => 'subheader-weather-city',
        'type'       => 'text',
        'class'  => 'no-border',
        'title'      => esc_html__('Şehir'),
        'default'      => 'İstanbul',
        'dependency' => array( 'subheader-left', 'any', 'weather' ),
      ),
      array(
        'type'    => 'submessage',
        'style'   => 'info',
        'class'  => 'no-border',
        'content' => esc_html__( 'Api anahtarı girdiğinizden emin olun.').' <a href="'.admin_url('admin.php?page=kanews-options#tab=veri-guncelleme').'">'.esc_html__( 'Tıkla ve Ekle').'</a>',
        'dependency' => array( 'subheader-left', 'any', 'weather' ),
      ),

      // Sub Header Left: Select Currencies
      array(
        'id'      => 'subheader-left-currencies',
        'type'    => 'button_set',
        'class'  => 'no-border',
        'title'   => esc_html__('Gözükecek Para Birimleri'),
        'dependency' => array( 'subheader-left', 'any', 'currencies' ),
        'multiple' => true,
        'options' => get_currencies_arrays(),
        'default' => array('usd', 'euro', 'gbp', 'btc', 'ise-100', 'gau')
      ),

      // Sub Header Left: Set Query for Breaking News Ticker
      array(
        'id'          => 'subheader-left-bn-cats',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('Kategoriler'),
        'dependency'  => array( 'subheader-left', 'any', 'breaking-news' ),
        'chosen'      => true,
        'multiple'    => true,
        'sortable'    => true,
        'options'     => 'category',
        'placeholder' => esc_html__('Tüm Kategoriler')
      ),

      array(
        'id'      => 'subheader-left-bn-sortby',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Göre Sırala'),
        'dependency' => array( 'subheader-left', 'any', 'breaking-news' ),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre'),
          'modified' => esc_html__('Düzenlenme Tarihine Göre'),
        ),
        'default' => 'modified'
      ),

      array(
        'id'       => 'subheader-left-bn-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Yazı Sayısı'),
        'dependency' => array( 'subheader-left', 'any', 'breaking-news' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 5,
      ),


      // Sub Header: Right
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header Sağ Kısım Ayarları'),
      ),

      array(
        'id'      => 'subheader-right',
        'type'    => 'button_set',
        'multiple'    => true,
        'title'   => esc_html__('Modül'),
        'options' => array(
          'weather' => esc_html__('Hava Durumu'),
          'currencies' => esc_html__('Öne Çıkan Kurlar'),
          'menu' => esc_html__('Menü'),
          'date' => esc_html__('Tarih'),
          'html' => esc_html__('HTML'),
          // 'secim'       => esc_html__('Seçim Sayacı'),
          'disable' => esc_html__('Hiçbir şey'),
        ),
        'default' => 'menu'
      ),

      array(
        'id'         => 'subheader-right-editor',
        'title'      => esc_html__('Editör'),
        'type'  => 'code_editor',
        'class'  => 'no-border',
        'sanitize' => false,
        'dependency' => array( 'subheader-right', 'any', 'html' ),
      ),
      array(
        'id'         => 'subheader-right-date-format',
        'type'       => 'text',
        'default'       => 'j F Y, D',
        'class'  => 'no-border',
        'desc'      =>  '<a href="https://wordpress.org/support/article/formatting-date-and-time/#format-string-examples">Tarih formatı örnekleri</a>',
        'title'      => esc_html__('Tarih Formatı'),
        'dependency' => array( 'subheader-right', 'any', 'date' ),
      ),


       // Sub Header Right: Weather Deault City
      array(
        'id'         => 'subheader-weather-city2',
        'type'       => 'text',
        'class'  => 'no-border',
        'title'      => esc_html__('Hava Durumu Varsayılan Şehir'),
        'default'    => 'İstanbul',
        'dependency' => array( 'subheader-right', 'any', 'weather' ),
        'desc'       => esc_html__('Hava durumunda varsayılan olarak gösterilecek şehir.'),
      ),
      array(
        'type'    => 'submessage',
        'style'   => 'info',
        'class'  => 'no-border',
        'content' => esc_html__( 'Api anahtarı girdiğinizden emin olun.').' <a href="'.admin_url('admin.php?page=kanews-options#tab=veri-guncelleme').'">'.esc_html__( 'Tıkla ve Ekle').'</a>',
        'dependency' => array( 'subheader-right', 'any', 'weather' ),
      ),

      // Sub Header Right: Select Currencies
      array(
        'id'         => 'subheader-right-currencies',
        'type'       => 'button_set',
        'class'  => 'no-border',
        'title'      => esc_html__('Gözükecek Para Birimleri'),
        'dependency' => array( 'subheader-right', 'any', 'currencies' ),
        'multiple'   => true,
        'options' => get_currencies_arrays(),
        'default' => array('ise-100', 'gau', 'eur-usd')
      ),

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Sol Kısım Ayarları'),
      ),
      // Big Menu
      array(
        'id'      => 'big-menu',
        'title'   => esc_html__('Büyük Menü'),
        'help'    => esc_html__('Logo yanında bulunan menü butonuna tıklandığında büyük bir menü açar.'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'big-menu-style',
        'class'    => 'yeni',
        'type'    => 'select',
        'default' => 'style1',
        'class'   => 'no-border',
        'title'   => esc_html__('Büyük Menü Görünümü'),
        'options' => array(
          'style1' => esc_html__('Görünüm').' #1',
          'style2' => esc_html__('Görünüm').' #2',
        ),
      ),
      
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Sağ Kısım Ayarları'),
      ),
      // User/Login Button
      array(
        'id'      => 'login-user-button',
        'title'   => esc_html__('Üyelik Butonu'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Search Button
      array(
        'id'      => 'search-button',
        'title'   => esc_html__('Arama Butonu'),
        'type'    => 'switcher',
        'default' => false
      ),
      // action Button
      array(
        'id'      => 'action-button',
        'title'   => esc_html__('Araçlar Butonu'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'action-buttons-style',
        'type'    => 'select',
        'default'    => 'style2',
        'class'  => 'no-border',
        'title'   => esc_html__('Araçlar Butonu Görünümü'),
        'options' => array(
          'style1' => esc_html__('Görünüm').' #1',
          'style2' => esc_html__('Görünüm').' #2',
          'style3' => esc_html__('Görünüm').' #3',
        ),
      ),
      array(
        'id'     => 'action-buttons',
        'type'   => 'group',
        'class'  => 'no-border',
        'title'  => esc_html__('Araçlar'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'      => 'popular',
            'title'   => esc_html__('Popülerlere Ekle'),
            'type'    => 'switcher',
            'default' => false
          ),
          array(
            'id'      => 'use-title',
            'title'   => esc_html__('Başlık Olarak Kullan'),
            'type'    => 'switcher',
            'default' => false
          ),
          array(
            'id'    => 'desc',
            'dependency' => array( 'use-title', '!=', 'true' ),
            'type'  => 'text',
            'title' => __('Açıklama'),
          ),
          array(
            'id'         => 'icon_type',
            'default'    => 'icon',
            'type'       => 'button_set',
            'title'      => esc_html__('İkon Tipi'),
            'dependency' => array( 'use-title', '!=', 'true' ),
            'multiple'   => false,
            'options'    => array(
              'icon'     => esc_html__('İkon'),
              'image'    => esc_html__('Görsel'),
            ),
          ),
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'dependency' => array( 'icon_type|use-title', '==|==', 'icon|false' ),
            'title' => esc_html__('İkon'),
          ),
          array(
            'id'       => 'img',
            'dependency' => array( 'icon_type', '==', 'image' ),
            'type'     => 'upload',
            'title'    => 'Görsel',
          ),
          array(
            'id'         => 'link_type',
            'type'       => 'button_set',
            'default'    => 'page',
            'dependency' => array( 'use-title', '!=', 'true' ),
            'title'      => esc_html__('Link Tipi'),
            'multiple'   => false,
            'options'    => array(
              'page'     => esc_html__('Sayfa'),
              'custom'    => esc_html__('Özel Link'),
            ),
          ),
          array(
            'id'          => 'page',
            'type'        => 'select',
            'dependency' => array( 'link_type', '==', 'page' ),
            'title'       => esc_html__('Sayfa'),
            'chosen'      => true,
            'sortable'    => true,
            'ajax'        => true,
            'options'     => 'pages',
            'placeholder' => esc_html__('Sayfa Seçin'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'Link',
            'dependency' => array( 'link_type|use-title', '==|==', 'custom|false' ),
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          array(
            'id'      => 'blank',
            'title'   => esc_html__('Yeni Sekmede Aç'),
            'type'    => 'switcher',
            'default' => false
          ),
          array(
            'id'      => 'color',
            'type'    => 'color',
            'dependency' => array( 'use-title', '!=', 'true' ),
            'title'   => esc_html__('Renk')
          ),
          
        ),
      ),


      // Header Middle
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Orta Kısım Ayarları'),
        'dependency'  => array( 'header-layout', '!=', 'style-3||style-4' ),
        'help' => esc_html__('Header Orta Kısım Ayarları'),
      ),
      array(
        'id'         => 'header-center',
        'type'       => 'button_set',
        'dependency'  => array( 'header-layout', '!=', 'style-3||style-4' ),
        'desc'      => esc_html__('Gözükmesini istediğiniz modülü seçin.'),
        'options'    => array(
          'disable'      => esc_html__('Boş Kalsın'),
          'custom'      => esc_html__('Özel Alan'),
          'search'      => esc_html__('Arama Kutusu'),
          // 'secim'       => esc_html__('Seçim Sayacı'),
          'currencies'  => esc_html__('Döviz Kurları')
        ),
        'default' => 'search'
      ),
      // Header Middle: Select Currencies
      array(
        'id'         => 'header-center-currencies',
        'type'       => 'button_set',
        'class'  => 'no-border',
        'title'      => esc_html__('Gözükecek Para Birimleri'),
        'dependency' => array( 'header-center', '==', 'currencies' ),
        'multiple'   => true,
        'options' => get_currencies_arrays(),
        'default' => array('usd', 'euro', 'gbp', 'btc', 'ise-100', 'gau')
      ), 
      // Header Middle: Custom
      array(
        'id'         => 'header-center-custom',
        'type'       => 'wp_editor',
        'class'  => 'no-border',
        'dependency' => array( 'header-center', '==', 'custom' ),
      ),
    

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Navbar Ayarları'),
      ),
      
      array(
        'id'      => 'sticky-navbar',
        'title'   => esc_html__('Yapışkan Navbar'),
        
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'home-button',
        'title'   => esc_html__('Ana sayfa Butonu'),
        'dependency' => array( 'header-layout', '!=', 'style-3' ),
        'type'    => 'switcher',
        'default' => true
      ),

      array(
        'id'    => 'colorfull-line',
        'title'  => esc_html__('Renkli Şerit'),
        'type'  => 'switcher',
        'default' => false
      ),

      // Breaking News
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Son Dakika Barı'),
      ),

      array(
        'id'      => 'subnavbar-left-bn',
        'title'   => esc_html__('Son Dakika Barı'),
        'type'    => 'switcher',
        'class'  => 'no-border',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'subnavbar-left-bn-mobile',
        'title'   => esc_html__('Mobilde Göster'),
        'class'  => 'no-border',
        'type'    => 'switcher',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'subnavbar-left-bn-custom',
        'title'   => esc_html__('Özel Listeleme'),
        'type'    => 'switcher',
        'class'    => 'yeni no-border',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'     => 'subnavbar-left-bn-customx',
        'type'   => 'group',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'true' ),
        'title'  => esc_html__('Liste'),
        'class'  => 'no-border',
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
        ),
        'default' => array(
          array(
            'title' => 'Euro 2024',
            'url' => '#',
          ),
          array(
            'title' => 'Kabine Toplantısı',
            'url' => '#',
          ),
          array(
            'title' => 'Enflasyon',
            'url' => '#',
          ),
          array(
            'title' => 'Asgari Ücret',
            'url' => '#',
          ),
          array(
            'title' => 'Son Depremler',
            'url' => '#',
          ),
          array(
            'title' => 'Cumhurbaşkanı Erdoğan',
            'url' => '#',
          ),
          array(
            'title' => 'Altın',
            'url' => '#',
          ),
          array(
            'title' => 'Dolar',
            'url' => '#',
          ),
          array(
            'title' => 'Borsa',
            'url' => '#',
          ),
        ),
      ),

      // Sub Header Left: Set Query for Breaking News Ticker
      array(
        'id'          => 'subnavbar-left-bn-cats',
        'type'        => 'select',
        'title'       => esc_html__('Kategoriler'),
        'chosen'      => true,
        'multiple'    => true,
        'class'  => 'no-border',
        'sortable'    => true,
        'options'     => 'category',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'placeholder' => esc_html__('Tüm Kategoriler')
      ),

      array(
        'id'      => 'subnavbar-left-bn-sortby',
        'type'    => 'select',
        'class'  => 'no-border',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'title'   => esc_html__('Göre Sırala'),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre'),
          'modified' => esc_html__('Düzenlenme Tarihine Göre'),
        ),
        'default' => 'modified'
      ),

      array(
        'id'       => 'subnavbar-left-bn-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'title'    => esc_html__('Yazı Sayısı'),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 5,
      ),

      array(
        'id'          => 'subnavbar-left-bn-post-not-in',
        'type'        => 'select',
        'class'  => 'no-border',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'title'       => esc_html__('Hariç Tutulan Yazılar'),
        'chosen'      => true,
        'multiple'    => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'posts',
        'placeholder' => esc_html__( 'Yazı Seçin'),
      ),

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Modüler Alan'),
      ),

      array(
        'id'      => 'header-top-modules',
        'title'   => esc_html__('Modüler Alan'),
        'class'  => 'no-border',
        'desc'    => esc_html__('Sitenin en üstünde gösterilir.'),
        'type'    => 'switcher',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'header-top-modules-mobile',
        'title'   => esc_html__('Mobilde Göster'),
        'class'  => 'no-border',
        'type'    => 'switcher',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'       => 'header-top-module',
        'type'     => 'button_set',
        'class'  => 'no-border',
        'title'    => esc_html__('Gözükecek Modül'),
        'multiple' => false,
        'options'  => array(
          'currencies'  => esc_html__('Öne Çıkan Kurlar'),
          'scores'      => esc_html__('Canlı Skor'),
        ),
      ),

      array(
        'id'      => 'header-top-module-currencies',
        'type'    => 'button_set',
        'class'  => 'no-border',
        'title'   => esc_html__('Gözükecek Para Birimleri'),
        'dependency' => array( 'header-top-module', '==', 'currencies' ),
        'multiple' => true,
        'options' => get_currencies_arrays(),
      ),

      array(
        'id'          => 'header-top-module-page',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('Detay Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),


    )
  ));

  /**
	 * Footer
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Footer Ayarları'),
    'icon'  => 'fas fa-campground',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Footer Ayarları'),
      ),
       // Layout
      array(
        'id'      => 'footer-layout',
        'type'    => 'select',
        'title'   => esc_html__('Görünüm'),
        'options' => array(
          'style-1' => esc_html__('Görünüm').' #1',
          'style-2' => esc_html__('Görünüm').' #2',
        ),
        'default' => 'style-1',
      ),
      array(
        'id'      => 'footer-skin',
        'type'    => 'select',
        
        'title'   => esc_html__('Renk Modu'),
        'options' => array(
          'dark' => esc_html__('Koyu'),
          'light' => esc_html__('Açık'),
        ),
        'default' => 'light'
      ),

      // Widgets
      array(
        'id'    => 'footer-widgets',
        'title'  => esc_html__('Bileşenler'),
        'type'  => 'switcher',
        'dependency' => array( 'footer-layout', '!=', 'style-2' ),
        'default' => false
      ),

      // Sosyal
      array(
        'id'     => 'social-links',
        'type'   => 'group',
        'title'  => esc_html__('Sosyal Medya Hesaplarınız'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'title' => esc_html__('İkon'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
        ),
        'default' => array(
          array(
            'title' => esc_html__('Facebook'),
            'icon' => 'icon-facebook',
            'url' => '#',
          ),
          array(
            'title' => esc_html__('Twitter'),
            'icon' => 'icon-twitter',
            'url' => '#',
          ),
        ),
      ),

      // Copyright
      array(
        'id'    => 'footer-bottom-text',
        'type'  => 'textarea',
        'title'  => esc_html__('Telif Hakkı Yazısı'),
        'desc'  => __('Sitenin altında bulunan alanın ortasında gözükecek olan yazıyı girin, öneri olaak telif hakkı yazısı olabilir. Aşağıdaki kısa kodları destekler.<br>
        <code>%year%</code> : Geçerli yıl<br>
        <code>%site%</code> : Sitenin adı<br>
        <code>%url%</code> : Site Linki
        '),
        'default' => __( '&copy; Telif Hakkı %year%, Tüm Hakları Saklıdır.'),
      ),

    )
  ));
  

  /**
	 * Mobil 
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Mobil Ayarları'),
    'icon'  => 'fas fa-mobile-alt',
    'fields' => array(
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Header'),
      ),

      array(
        'id'      => 'search-button-mobile',
        'title'   => esc_html__('Arama Butonu'),
        'desc'   => esc_html__('Header Ayarları>Arama butonu ayarı aktif olmalı.'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'action-button-mobile',
        'title'   => esc_html__('Araçlar Butonu'),
        'desc'   => esc_html__('Header Ayarları>Araçlar ayarı aktif olmalı.'),
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'login-user-button-mobile',
        'title'   => esc_html__('Üyelik Butonu'),
        'desc'   => esc_html__('Header Ayarları>Üyelik Butonu ayarı aktif olmalı.'),
        'type'    => 'switcher',

        'default' => true
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Tab Menü'),
      ),

      array(
        'id'      => 'tab-bar-desktop',
        'title'   => esc_html__('Masaüstü Tab Menü'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'tab-bar',

        'title'   => esc_html__('Mobil Tab Menü'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'tab-bar-icon',

        'title'   => esc_html__('Sadece ikon'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'tab-bar-bg',
        'type'    => 'color',
        'title'   => esc_html__('Arkaplan')
      ),

      array(
        'id'      => 'tab-bar-color',
        'type'    => 'color',
        'title'   => esc_html__('İkon Rengi')
      ),
    

      array(
        'id'         => 'tab-bar-defaults',
        'type'       => 'button_set',
        'title'      => esc_html__('Varsayılanlar'),
        'multiple'   => true,
        'options'    => array(
          'home'     => esc_html__('Anasayfa'),
          'feed'    => esc_html__('Akış'),
          'account'    => esc_html__('Hesabım'),
          'notifications'    => esc_html__('Bildirimler'),
        ),
        'default' => array('home','feed','account','notifications')
      ),

      array(
        'id'     => 'tab-bar-items',
        'type'   => 'group',
        'title'  => esc_html__('Elemanlar'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),

          array(
            'id'         => 'icon_type',
            'default'    => 'icon',
            'type'       => 'button_set',
            'title'      => esc_html__('İkon Tipi'),
            'multiple'   => false,
            'options'    => array(
              'icon'     => esc_html__('İkon'),
              'image'    => esc_html__('Görsel'),
            ),
          ),
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'dependency' => array( 'icon_type', '==', 'icon' ),
            'title' => esc_html__('İkon'),
          ),
          array(
            'id'       => 'img',
            'dependency' => array( 'icon_type', '==', 'image' ),
            'type'     => 'upload',
            'title'    => 'Görsel',
          ),
          array(
            'id'         => 'link_type',
            'type'       => 'button_set',
            'default'    => 'page',
            'title'      => esc_html__('Link Tipi'),
            'multiple'   => false,
            'options'    => array(
              'page'     => esc_html__('Sayfa'),
              'custom'    => esc_html__('Özel Link'),
            ),
          ),
          array(
            'id'          => 'page',
            'type'        => 'select',
            'dependency' => array( 'link_type', '==', 'page' ),
            'title'       => esc_html__('Sayfa'),
            'chosen'      => true,
            'sortable'    => true,
            'ajax'        => true,
            'options'     => 'pages',
            'placeholder' => esc_html__('Sayfa Seçin'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'dependency' => array( 'link_type', '==', 'custom' ),
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Açılır Menü Ayarları'),
      ),
      // Layout
      array(
        'id'      => 'mobile-menu-style',
        'type'    => 'radio',
        
        'title'   => esc_html__('Menü Düzeni'),
        'options' => array(
          '1' => 'Varsayılan',
          '2' => 'Tam Ekran',
        ),
        'default' => '1',
      ),
      array(
        'id'      => 'mobile-menu-search',
        'title'   => esc_html__('Arama Kutusu'),
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'    => 'mobile-menu-footer-text',
        'type'  => 'textarea',
        'title'  => esc_html__('Telif Hakkı Yazısı'),
        'desc'  => __('Sitenin altında bulunan alanın ortasında gözükecek olan yazıyı girin, öneri olaak telif hakkı yazısı olabilir. Aşağıdaki kısa kodları destekler.<br>
        <code>%year%</code> : Geçerli yıl<br>
        <code>%site%</code> : Sitenin adı<br>
        <code>%url%</code> : Site Linki
        '),
        'default' => __( '&copy; Telif Hakkı %year%, Tüm Hakları Saklıdır.'),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sidebar Ayarları'),
      ),
      array(
        'id'      => 'single-sidebar',
        'title'   => esc_html__('Yazı Sayfasında Sidebarı Göster'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'page-sidebar',
        'title'   => esc_html__('Sayfalarda Sidebarı Göster'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      array(
        'id'      => 'home-sidebar',
        'title'   => esc_html__('Ana Sayfada Sidebarı Göster'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      array(
        'id'      => 'cat-sidebar',
        'title'   => esc_html__('Kategori Sayfalarında Sidebarı Göster'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      array(
        'id'      => 'archive-sidebar',
        'title'   => esc_html__('Arşiv Sayfalarında Sidebarı Göster'),
        'type'    => 'switcher',
        
        'default' => false
      ),
    )
  ));


  /**
	 * Single page
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Yazı Sayfası'),
    'icon'  => 'far fa-newspaper',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Yazı Sayfası'),
      ),
       // Layout
      array(
        'id'      => 'single-layout',
        'type'    => 'image_select',
        
        'title'   => esc_html__('Görünüm'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/single-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/single-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/single-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/single-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/single-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/single-6.jpg',
        ),
        'default' => '1',
      ),
      // Post Header
      array(
        'id'         => 'single-layout-block',
        'type'       => 'radio',
        'title'      => esc_html__('Görünüm Detay'),
        'options'    => array(
          'flat'     => esc_html__('Düz'),
          'box'      => esc_html__('Kutu'),
        ),
        'default' => 'box'
      ),
      // Infinite Post Scroll
      array(
        'id'      => 'infinite-post-scroll',
        'title'   => esc_html__('Sonsuz Yazı Kaydırma'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Pagination
      array(
        'id'         => 'single-pagination',
        'type'       => 'radio',
        'title'      => esc_html__('Yazı içi Sayfalama'),
        'options'    => array(
          'number'   => esc_html__('Numaralı Sayfalama'),
          'infinite' => esc_html__('Aşağı İndikçe Yükle'),
          'button'   => esc_html__('Daha Fazla Yükle'),
        ),
        'default' => 'number'
      ),


      array(
        'type'    => 'subheading',
        'content' => esc_html__('Haber Servisleri'),
      ),
      // Google News
      array(
        'id'       => 'google-news-link',
        'type'     => 'text',
        'title'    => esc_html__( 'Google News'),
        'placeholder'  => 'https://www.'
      ),
      array(
        'id'     => 'news-services',
        'type'   => 'group',
        'class'  => 'no-border',
        'title'  => esc_html__('Servis Oluştur'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          array(
            'id'       => 'img',
            'type'     => 'upload',
            'title'    => 'Logo',
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar'),
      ),
      // Breadcrumb
      array(
        'id'      => 'show-post-reading',
        'title'   => esc_html__('Yazı Okuma Barı'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Breadcrumb
      array(
        'id'      => 'show-post-comments',
        'title'   => esc_html__('Tüm Yazıları Yoruma Kapat'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      // Breadcrumb
      array(
        'id'      => 'show-post-breadcrumb',
        'title'   => esc_html__('Breadcrumb'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Share Switch
      array(
        'id'      => 'show-post-share',
        'title'   => esc_html__('Yazıyı Paylaş'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Share
      array(
        'id'      => 'post-share',
        'type'    => 'button_set',
        'class'  => 'no-border',
        'title'   => esc_html__('Paylaş Butonları'),
        'dependency' => array( 'show-post-share', '==', 'true' ),
        'multiple' => true,
        'options' => array(
          'facebook' => 'Facebook',
          'twitter' => 'Twitter',
          'whatsapp' => 'Whatsapp',
          'telegram' => 'Telegram',
          'pinterest' => 'Pinterest',
          'email' => 'E-Posta',
        ),
        'default' => array('facebook', 'twitter', 'whatsapp', 'email')
      ),
      array(
        'id'         => 'post-share-style',
        'type'       => 'radio',
        'class'  => 'no-border',
        'title'      => esc_html__('Paylaş Butonları Görünümü'),
        'options'    => array(
          // '1'     => esc_html__('Görünüm').' #1',
          '2'     => esc_html__('Görünüm').' #2',
          '3'     => esc_html__('Görünüm').' #3',
          '4'     => esc_html__('Görünüm').' #4',
          '5'     => esc_html__('Görünüm').' #5',
        ),
        'default' => '5'
      ),
      array(
        'id'      => 'post-text-share',
        'title'   => esc_html__('Seçili Yazıyı Paylaş'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Thumbnail
      array(
        'id'      => 'show-post-thumbnail',
        'title'   => esc_html__('Öne Çıkarılan Görsel'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Excerpt
      array(
        'id'      => 'show-post-excerpt',
        'title'   => esc_html__('Yazı Açıklaması'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Cat
      array(
        'id'      => 'show-post-cat',
        'title'   => esc_html__('Kategori'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Author
      array(
        'id'      => 'show-post-author',
        'title'   => esc_html__('Yazar'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Post Date
      array(
        'id'      => 'show-post-date',
        'title'   => esc_html__('Yayınlanma Tarihi'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Post Update Date
      array(
        'id'      => 'show-post-update-date',
        'title'   => esc_html__('Güncelleme Tarihi'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Post Views
      array(
        'id'      => 'show-post-views',
        'title'   => esc_html__('Okunma Sayısı'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Reading Time
      array(
        'id'      => 'show-post-reading-time',
        'title'   => esc_html__('Okuma Süresi'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Assets
      array(
        'id'      => 'show-post-assets',
        'title'   => esc_html__('Yazı Araçları'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Tags
      array(
        'id'      => 'show-post-tags',
        'title'   => esc_html__('Etiketler'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Popular Comments
      array(
        'id'      => 'show-popular-comments',
        'title'   => esc_html__('Popüler Yorumlar'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Excerpt Lenght
      array(
        'id'       => 'popular-comments-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'dependency' => array( 'show-popular-comments', '==', 'true' ),
        'title'    => esc_html__('Popüler Yorum Sayısı'),
        'min'      => 1,
        'max'      => 30,
        'step'     => 1,
        'default'  => 10,
      ),

      // Reaction
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Reaksiyon'),
      ),
      array(
        'id'      => 'reaction-system',
        'title'   => esc_html__('Reaksiyon Sistemi'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'reaction-system-style',
        'type'    => 'select',
        'class'  => 'no-border',
        'default'    => '1',
        'title'   => esc_html__('Tasarım'),
        'options' => array(
          '1' => '#1',
          '2' => '#2',
        )
      ),
      array(
        'id'     => 'reaction-buttons',
        'type'   => 'group',
        'class'  => 'no-border',
        'dependency' => array( 'reaction-system', '==', 'true' ),
        'title'  => esc_html__('Emoji Oluştur'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'    => 'emoji',
            'type'  => 'upload',
            'title' => esc_html__('Emoji'),
            'desc' => '<a href="https://www.flaticon.com/packs/emoji-17?word=emoji" target="_blank">Emoji paketi</a>',
          ),
        ),
        'default' => array(
          array(
            'title' => esc_html__( 'Mutlu'),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/happy.svg',
          ),
          array(
            'title' => esc_html__( 'Üzgün'),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/sad.svg',
          ),
          array(
            'title' => esc_html__( 'Sinirli'),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/angry.svg',
          ),
          array(
            'title' => esc_html__( 'Şaşırmış'),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/shocked.svg',
          ),
          array(
            'title' => esc_html__( 'Virüslü'),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/sick.svg',
          ),
        ),
      ),

      // Related Posts
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Göz Atın Yazıları'),
      ),
      array(
        'id'      => 'related-posts2-style',
        'type'    => 'radio',
        
        'title'   => esc_html__('Görünüm'),
        'options' => array(
          '1' => esc_html__('Görünüm').' #1',
          '2' => esc_html__('Görünüm').' #2',
          '3' => esc_html__('Görünüm').' #3',
          'disable' => 'Gösterme'
        ),
        
        'default' => 'disable',
      ),
      array(
        'id'       => 'related-posts2-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Yazı Sayısı'),
        'dependency' => array( 'related-posts2-style', '!=', 'disable' ),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 4,
        
      ),
      array(
        'id'       => 'related-posts2-plimit',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Paragraf Seçimi'),
        'dependency' => array( 'related-posts2-style', '!=', 'disable' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
        
      ),
      array(
        'id'      => 'related-posts2-sortby',
        'type'    => 'radio',
        'class'  => 'no-border',
        'title'   => esc_html__('Göre Sırala'),
        'dependency' => array( 'related-posts2-style', '!=', 'disable' ),
        'options' => array(
          'cat' => esc_html__('Kategoriye Göre'),
          'tag' => esc_html__('Etikete Göre'),
        ),
        'default' => 'tag',
        
      ),

      // Related Posts
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Benzer Yazılar'),
      ),
      
      array(
        'id'      => 'related-posts-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Görünüm'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),
      array(
        'id'      => 'related-posts-sortby',
        'type'    => 'radio',
        'class'  => 'no-border',
        'title'   => esc_html__('Göre Sırala'),
        'dependency' => array( 'related-posts-style', '!=', 'disable' ),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre'),
          'post-modified' => esc_html__('Düzenlenme Tarihine Göre'),
          'post-viewed' => esc_html__('En Çok Okunan Yazı'),
          'commented' => esc_html__('En Çok Yorum Yapılan'),
          'random' => esc_html__('Rastgele'),
          'tag' => esc_html__('Etikete Göre'),
        ),
        'default' => 'random'
      ),
      array(
        'id'       => 'related-posts-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'dependency' => array( 'related-posts-style', '!=', 'disable' ),
        'title'    => esc_html__('Yazı Sayısı'),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 6,
      ),

      // Newsletter
      array(
        'type'    => 'subheading',
        
        'content' => esc_html__('Haber Bülteni'),
      ),
      array(
        'id'    => 'newsletter',
        'type'  => 'switcher',
        'default' => false,
        'title' => __('Haber Bülteni Formu'),
      ),
      array(
        'id'    => 'newsletter-content',
        'type'  => 'wp_editor',
        'class'  => 'no-border',
        'title' => __('Açıklama'),
        'dependency' => array( 'newsletter', '==', 'true' ),
      ),
      array(
        'id'    => 'newsletter-mailchimp',
        'type'  => 'text',
        'class'  => 'no-border',
        'title' => __('Mailchimp Form Action URL'),
        'desc' => '<a href="https://docs.kanthemes.com/kanews/#/sss?id=mailchimp-b%c3%bclten-formu-i%c3%a7in-action-eylem-linki-nas%c4%b1l-al%c4%b1n%c4%b1r">Nasıl Öğrenirim?</a>',
        'dependency' => array( 'newsletter', '==', 'true' ),
      ),

      
    )
  ));

  /**
	 * Archives 
   */	
   CSF::createSection( $prefix, array(
    'title'  => esc_html__('Arşiv Sayfaları'),
    'icon'  => 'fas fa-archive',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Arşiv Sayfaları'),
      ),
      
      // Pagination
      array(
        'id'         => 'archives-pagination',
        'type'       => 'radio',
        'title'      => esc_html__('Sayfalama Şekli'),
        'options'    => array(
          'classic'     => esc_html__('Klasik Sayfalama'),
          'number'     => esc_html__('Numaralı Sayfalama'),
          'button'     => esc_html__('Daha Fazla Yükle'),
          'infinite'     => esc_html__('Aşağı İndikçe Yükle'),
        ),
        'default' => 'classic'
      ),

      // Excerpt Lenght
      array(
        'id'       => 'excerpt-length',
        'type'     => 'slider',
        'title'    => esc_html__('Arşiv Yazı Açıklama Uzunluğu'),
        'min'      => 0,
        'max'      => 35,
        'step'     => 1,
        'default'  => 7,
      ),

      array(
        'id'    => 'open-link-new-tab',
        'title'  => esc_html__('Linkleri Yeni Sekmede Aç'),
        'type'  => 'switcher',
        'default' => false
      ), 

      // Jpeg Quality
      array(
        'id'       => 'jpeg-quality',
        'type'     => 'slider',
        'title'    => esc_html__('Görsel Kalitesi'),
        'desc'    => esc_html__('Yeni yüklenenlerde geçerli olacaktır veya görsellerinizi yeniden boyutlandırmanız gerekir.'),
        'min'      => 1,
        'max'      => 100,
        'step'     => 1,
        'default'  => 100,
      ),

      array(
        'id'    => 'cat-links',
        'title'  => esc_html__('Arşivlerden Kategori Butonlarını Gizle'),
        'type'  => 'switcher',
        
        'default' => false
      ),

      array(
        'id'          => 'excluded-categories',
        'type'        => 'checkbox',
        'title'       => esc_html__('Liste Dışı Kategoriler'),
        'desc'        => esc_html__('Seçili kategoriler bileşen gibi alanlarda liste dışı bırakılır.'),
        'multiple'    => true,
        'options'     => 'categories',
        'placeholder' => 'Kategori Seç',
      ),

      array(
        'id'      => 'home-recent-post-title',
        'type'    => 'text',
        'title'   => esc_html__('Son Yazılar Başlığı'),
      ),

      // Home Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Anasayfa'),
      ),
      
      array(
        'id'      => 'home-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '1',
      ),

    

      // Category Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kategori Sayfaları'),
      ),
      
      // Cat Archives: Category Recent Post Style
      array(
        'id'      => 'cat-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),

      array(
        'id'          => 'category-sidebar2',
        'type'        => 'checkbox',
        'title'       => esc_html__('Özel Kategori Şablonu'),
        'multiple'    => true,
        'options'     => 'kanews_get_categories',
        'placeholder' => 'Kategori Seç',
      ),

      array(
        'id'    => 'category-right-sidebar',
        'title'  => esc_html__('Sağ Sidebar'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'navbar-sub-category',
        'title'  => esc_html__('Alt Kategori Barı'),
        'type'  => 'switcher',
        'default' => true
      ),

      // Tag Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Etiket Sayfaları'),
      ),
      
      // Tag Archives: Recent Post Style
      array(
        'id'      => 'tag-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '4',
      ),

      // Author Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yazar Sayfaları'),
      ),
      
      // Author Archives: Recent Post Style
      array(
        'id'      => 'author-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),

      array(
        'title' => esc_html__('Diğer Yazarları Göster'),
        'id' => 'other-authors-switch',
        'type' => 'switcher',
        'default' => true
      ),


      // Other
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Sayfalar'),
      ),
      
      // Other Archives: Pages Recent Post Style
      array(
        'id'      => 'other-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '1',
      ),

    )
  ));

  /**
	 * Advertisment
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Reklam Yönetimi'),
    'icon'  => 'fas fa-hand-holding-usd',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Reklam Yönetimi'),
      ),

      array(
        'id'    => 'ad-auto-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Otomatik Reklam'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-auto',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-auto-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-cover-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Kaplama Reklam'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-cover',
        'type'  => 'media',
        'class'  => 'no-border',
        'class'  => 'no-border',
        'title'  => esc_html__('Görsel'),
        'dependency' => array( 'ad-cover-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-cover-color',
        'type'  => 'color',
        'class'  => 'no-border',
        'class'  => 'no-border',
        'title'  => esc_html__('Arkaplan Rengi'),
        'dependency' => array( 'ad-cover-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-cover-link',
        'type'  => 'text',
        'class'  => 'no-border',
        'class'  => 'no-border',
        'title'  => esc_html__('Link'),
        'dependency' => array( 'ad-cover-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-header-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Header Reklamları'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-header',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-header-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-header-below-switch',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Header Üst Reklamları'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-header-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-header-below-switch', '==', 'true' ),
      ),

      // Footer
      array(
        'type'    => 'subheading',
        'content' => __('Footer Reklamları'),
      ),
      array(
        'id'    => 'ad-footer-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Footer Üstü'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-footer',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-footer-switch', '==', 'true' ),
      ),

      // Left Side
      array(
        'type'    => 'subheading',
        'content' => __('Sabit Reklamlar'),
      ),
      array(
        'id'    => 'ad-screen-bottom-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Sabit Alt Reklam'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-screen-bottom',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-screen-bottom-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-left-side-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Sabit Sol Reklam'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-left-side',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'desc'  => esc_html__('Minumum 1500px genişliğie sahip ekranlarda gözükür.'),
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-left-side-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-right-side-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Sabit Sağ Reklam'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-right-side',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'desc'  => esc_html__('Minumum 1500px genişliğie sahip ekranlarda gözükür.'),
        'dependency' => array( 'ad-right-side-switch', '==', 'true' ),
      ),

      // Yazı
      array(
        'type'    => 'subheading',
        'content' => __('Yazı Reklamları'),
      ),
      
      array(
        'id'    => 'ad-single-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Başlangıç'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-above',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-above-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-single-below-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Sonu'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-below-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-amid-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Ortası'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-amid',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-amid-switch', '==', 'true' ),
      ),

      array(
        'id'       => 'ad-single-amid-limit',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Paragraf Seçimi'),
        'dependency' => array( 'ad-single-amid-switch', '==', 'true' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
      ),

      array(
        'id'    => 'ad-single-amid-switch2',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Yazı Ortası').' #2',
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-amid2',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-amid-switch2', '==', 'true' ),
      ),

      array(
        'id'       => 'ad-single-amid-limit2',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Paragraf Seçimi'),
        'dependency' => array( 'ad-single-amid-switch2', '==', 'true' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
      ),

      array(
        'id'    => 'ad-single-meta-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Meta Üstü'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-meta-above',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-meta-above-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-meta-below-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Meta Altı'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-meta-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-meta-below-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-comment-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yorum Bloğu Üstü'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-comment-above',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-comment-above-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-shortcode-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Kısakod İle Reklam'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-shortcode',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'subtitle'  => esc_html__('Kısakodu eklediğiniz alanlarda gözükür. Kullanılması gereken kısakod: [kanews-ad]'),
        'title'  => esc_html__('Reklam Kodu'),
        'dependency' => array( 'ad-single-shortcode-switch', '==', 'true' ),
      ),

       // Yazı
      array(
        'type'    => 'subheading',
        'content' => __('Arşiv Reklamları'),
      ),

      array(
        'id'     => 'ad-archieve-per-post',
        'type'   => 'group',
        'title'  => esc_html__('Reklam Oluştur'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          
          

          
          array(
            'id'       => 'count',
            'type'     => 'slider',
            'title'    => esc_html__('Kaçıncı Yazıdan Sonra Gözükecek'),
            'min'      => 1,
            'max'      => 100,
            'step'     => 1,
            'default'  => 2,
          ),  
          array(
            'id'    => 'code',
            'type'  => 'code_editor',
            'sanitize' => false,
            'title'  => esc_html__('Reklam Kodu'),
          ),
        ),
      ),
    )
  ));

  /**
	 * Kanews Pages 
   */	
   CSF::createSection( $prefix, array(
    'title'  => esc_html__('Kanews Sayfaları'),
    'icon'  => 'fas fa-dice',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Sayfa Oluşturucu'),
      ),
      array(
        'id'          => 'page-builder',
        'type'        => 'checkbox',
        'title'       => esc_html__('Sayfa Oluşturucu'),
        'desc'        => 'Anasayfa benzeri sayfalar oluşturmak içindir. Seçili sayfalar için görünüm>bileşenler sayfasında bileşen alanları oluşturur.',
        'multiple'    => true,
        'options'     => 'kanews_get_pages',
        'placeholder' => 'Kategori Seç',
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kanews Sayfaları'),
        'desc'       => esc_html__('Detay sayfalarında 404 hatası alıyorsanız sayfa seçktikten sonra ayarları iki kez kaydedin veya kalıcı bağlantılarınızı güncelleyin.'),
      ),
      
      // Account Page
      array(
        'id'          => 'account-page',
        'type'        => 'select',
        'title'       => esc_html__('Hesabım Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin')
      ),

      // Kullanım Page
      array(
        'id'          => 'ks-page',
        'type'        => 'select',
        'title'       => esc_html__('Kullanım Sözleşmesi Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin')
      ),


      array(
        'id'          => 'feed-page',
        'type'        => 'select',
        'title'       => esc_html__('Akış Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),


      array(
        'id'          => 'exchange-page',
        'type'        => 'select',
        'title'       => esc_html__('Borsa Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),

      array(
        'id'          => 'doviz-page',
        'type'        => 'select',
        'title'       => esc_html__('Döviz Kurları Sayfası'),
        
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),
      array(
        'id'          => 'emtia-page',
        'type'        => 'select',
        'title'       => esc_html__('Emtia Sayfası'),
        
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Canlı Tv'),
      ),
      
      // Kanallar
      array(
        'id'     => 'live-tv',
        'type'   => 'group',
        'title' => esc_html__('Kanallar'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__('Kanal Adı'),
          ),
          array(
            'id'    => 'logo',
            'type'  => 'upload',
            'title' => esc_html__('Kanal Logosu'),
          ),
          array(
            'id'    => 'channel-title',
            'type'  => 'text',
            'title' => esc_html__('Kanal  Başlığı'),
          ),
          array(
            'id'    => 'content',
            'type'  => 'wp_editor',
            'title' => esc_html__('Kanal Açıklaması'),
          ),
          array(
            'id'    => 'iframe-src',
            'type'  => 'text',
            'rows'  => '1',
            'title' => esc_html__('Embed Linki'),
            'desc' => 'Örnek: https://www.youtube.com/embed/xxxx',
          ),
          array(
            'id'    => 'custom-embed',
            'type'  => 'text',
            'rows'  => '3',
            'sanitize' => 'csf_sanitize_replace_a_to_b',
            'title' => esc_html__('Veya İptv Linki'),
            'desc' => 'Örnek: https://tv-trt1.live.trt.com.tr/master_720.m3u8',
          )
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Gazetete Manşetleri'),
      ),
      
      // Kanallar
      array(
        'id'     => 'newspapers',
        'type'   => 'group',
        'title' => esc_html__('Gazeteler'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__('Gazete Adı'),
          ),
          array(
            'id'    => 'media',
            'type'  => 'text',
            'title' => esc_html__('Görsel'),
          ),
        ),
      ),



      // Puan
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Puan Durumları Sayfası'),
      ),
      
      array(
        'id'      => 'league-standings',
        'type'    => 'button_set',
        'multiple'    => true,
        'title'   => esc_html__('Gösterilecek Ligler'),
        'options' => array(
          'super-lig' => esc_html__('Süper Lig'),
          'almanya-bundesliga' => esc_html__('Bundesliga'),
          'ingiltere-premier-ligi' => esc_html__('Premier Lig'),
          'italya-serie-a' => esc_html__('Serie A'),
          'fransa-ligue-1' => esc_html__('Ligue 1'),
          'ispanya-la-liga' => esc_html__('La Liga'),
          'tff-1-lig' => esc_html__('TFF 1. Lig'),
          'euroleague' => esc_html__('Euroleague'),
          'erkek-basketbol' => esc_html__('Erkek Basket'),
          'kadin-basketbol' => esc_html__('Kadın Basket'),
          'efeler-ligi' => esc_html__('Efeler Ligi'),
          'sultanlar-ligi' => esc_html__('Sultanlar Ligi'),
          'sampiyonlar-ligi' => esc_html__('Şampiyonlar Ligi'),
          'avrupa-ligi' => esc_html__('Avrupa Ligi'),
          'konferans-ligi' => esc_html__('Konferans Ligi'),
        ),
        'default' => [
          'super-lig',
          'almanya-bundesliga',
          'ingiltere-premier-ligi',
          'italya-serie-a',
          'fransa-ligue-1',
          'ispanya-la-liga',
          'tff-1-lig',
          'euroleague',
          'erkek-basketbol',
          'kadin-basketbol',
          'efeler-ligi',
          'sultanlar-ligi'
        ]
      ),
      
      array(
        'id'      => 'league-default',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Varsayılan Lig'),
        'options' => array(
          'super-lig' => esc_html__('Süper Lig'),
          'almanya-bundesliga' => esc_html__('Bundesliga'),
          'ingiltere-premier-ligi' => esc_html__('Premier Lig'),
          'italya-serie-a' => esc_html__('Serie A'),
          'fransa-ligue-1' => esc_html__('Ligue 1'),
          'ispanya-la-liga' => esc_html__('La Liga'),
          'tff-1-lig' => esc_html__('TFF 1. Lig'),
          'euroleague' => esc_html__('Euroleague'),
          'erkek-basketbol' => esc_html__('Erkek Basket'),
          'kadin-basketbol' => esc_html__('Kadın Basket'),
          'efeler-ligi' => esc_html__('Efeler Ligi'),
          'sultanlar-ligi' => esc_html__('Sultanlar Ligi'),
        ),
        'default' => [
          'super-lig'
        ]
      ),


      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yol Durumu Sayfası'),
      ),

      array(
        'id'          => 'traffic-city',
        'type'        => 'text',
        'title'   => esc_html__('Varsayılan Şehir'),
        'desc'        => esc_html__('Sadece il'),
        'default'     => 'İstanbul',
        'placeholder' => esc_html__('Şehir Seç'),
      ),


      array(
        'type'    => 'subheading',
        'content' => esc_html__('Namaz Vakitleri Sayfası'),
      ),
      array(
        'id'          => 'prayer-page',
        'type'        => 'select',
        'title'       => esc_html__('Namaz Vakitleri Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),

      array(
        'id'      => 'prayer-page-city',
        'type'    => 'text',
        'class'  => 'no-border',
        'default'    => 'Ankara',
        'title'   => esc_html__('Varsayılan Şehir'),
      ),
      
      array(
        'id'      => 'prayer-page-city2',
        'type'    => 'text',
        'class'  => 'no-border',
        'title'   => esc_html__('Varsayılan İlçe'),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Nöbetçi Eczaneler Sayfası'),
      ),
      array(
        'id'          => 'eczane-page',
        'type'        => 'select',
        'title'       => esc_html__('Nöbetçi Eczaneler Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),

      array(
        'id'      => 'eczane-page-city',
        'type'    => 'text',
        'class'  => 'no-border',
        'default'    => 'Ankara',
        'title'   => esc_html__('Varsayılan Şehir'),
      ),
      
      array(
        'id'      => 'eczane-page-city2',
        'type'    => 'text',
        'class'  => 'no-border',
        'title'   => esc_html__('Varsayılan İlçe'),
      ),
      

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kripto Paralar Sayfası'),
      ),
      array(
        'id'          => 'crypto-page',
        'type'        => 'select',
        'title'       => esc_html__('Kripto Paralar Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),

      array(
        'id'      => 'crypto-page-index',
        'type'    => 'select',
        'default'    => 'try',
        'title'   => esc_html__('Varsayılan Para Birimi'),
        'options' => array(
          'try' => esc_html__('Türk Lirası'),
          'usdt'=> esc_html__('Amerikan Doları'),
          'eur' => esc_html__('Euro'),
          'btc' => esc_html__('Bitcoin'),
          'eth' => esc_html__('Ethereum'),
        )
      ),


      // Hava Durumu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Hava Durumu Sayfası'),
      ),
      array(
        'id'          => 'weather-page',
        'type'        => 'select',
        'title'       => esc_html__('Hava Durumu Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin'),
      ),
      array(
        'id'          => 'weather-cities',
        'type'        => 'select',
        'title'       => esc_html__('Varsayılan Şehir'),
        'default'     => '745042',
        'class'  => 'no-border',
        'options'     => 'kanews_get_turkey_cities3',
        'placeholder' => esc_html__('Şehir Seç'),
      ),
      array(
        'id'      => 'weather-cities2',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Gösterilecek Şehirler'),
        'options' => array(
          'turkey' => esc_html__('Türk Şehirleri'),
          'global' => esc_html__('Dünyanın Popüler Şehirleri'),
          'karma' => esc_html__('Karma'),
        )
      ),

      // İletişim
      array(
        'type'    => 'subheading',
        'content' => esc_html__('İletişim Sayfası'),
      ),
      array(
        'id'          => 'contact-page-description',
        'type'        => 'textarea',
'class'  => 'no-border',
        'default'        => 'Bizimle her konuda iletişime geçebilirsiniz, ekibimiz gün içinde mesai saatleri kapsamında cevap vermek için hazır bekliyor.',
        'title'       => esc_html__('Açıklama'),
      ),
      array(
        'id'          => 'contact-page-email',
        'type'        => 'text',
        'class'  => 'no-border',
        'default'     => 'admin@siteadresi.com',
        'title'       => esc_html__('E-Posta'),
      ),
      array(
        'id'          => 'contact-page-phone',
        'type'        => 'textarea',
        'class'  => 'no-border',
        'default'     => '850 8888 88',
        'title'       => esc_html__('Telefon'),
      ),
      array(
        'id'          => 'contact-page-address',
        'type'        => 'textarea',
        'class'  => 'no-border',
        'default'     => 'İstanbul/Mecidiyeköy',
        'title'       => esc_html__('Adres'),
      ),
      array(
        'id'          => 'contact-page-form',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('İletişim Formu'),
        'options'     => 'kanews_get_contact_forms',
        'placeholder' => esc_html__('İletişim Formu Seçin'),
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=contact-form-7&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Contact Form 7</a> eklentisinin kurun ve form oluşturun. Eğer form seçilmediyse temaya dahil iletişim formu çalışır.',
      ),

    )
  ));

	/**
	 * Members System
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Üyelik Sistemi'),
		'icon'        => 'far fa-user',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Üyelik Sistemi'),
      ),
      // Membership System
      array(
        'id'    => 'login-system',
        'title'  => esc_html__('Üyelik Sistemi'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'email-activation',
        'title' => esc_html__('Üyeler için E-Posta Onayı'),
        'type'  => 'switcher',
        'dependency' => array( 'notifications', '!=', false ),
        'default' => false
      ),
      
      
      // Disable Admin Bar
      array(
        'id'    => 'wp-admin-bar-disable',
        'title'  => esc_html__('Admin Panel Çubuğunu Gizle'),
        'type'  => 'switcher',
        
        'default' => false
      ),
      // Admin Redirect
      array(
        'id'    => 'wp-admin-redirect',
        'title'  => esc_html__('Wp-admin Sayfalarına Erişimi Engelle'),
        'type'  => 'switcher',
        
        'default' => false
      ),
      // Like System
      array(
        'id'    => 'post-like',
        'title'  => esc_html__('Beğen Sistemi'),
        'type'  => 'switcher',
        'default' => true
      ),
      // Bookmark System
      array(
        'id'    => 'post-bookmark',
        'title'  => esc_html__('Favori Sistemi'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kullanıcı Rozetleri'),
      ),
      array(
        'id'     => 'user-badge',
        'type'   => 'group',
        
        'title'  => esc_html__('Kullanıcı Rozetleri'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Rozet Tanımı'),
          ),
          array(
            'id'      => 'role',
            'type'    => 'select',
            'title'   => esc_html__('Eşleştirilen Wordpress Rolü'),
            'options' => array(
              'subscriber' => esc_html__('Abone'),
              'contributor' => esc_html__('İçerik Sağlayıcı'),
              'columist' => esc_html__('Köşe Yazarı'),
              'author' => esc_html__('Yazar'),
              'editor' => esc_html__('Editör'),
              'administrator' => esc_html__('Yönetici'),
            )
          ),
          array(
            'id'      => 'color',
            'type'    => 'color',
            'title'   => esc_html__('Rozet Arkaplanı')
          ),
        ),
        'default' => array(
          array(
            'title' => esc_html__('Yönetici'),
            'role' => 'administrator',
            'color' => '#e74c3c',
          ),
          array(
            'title' => esc_html__('Editör'),
            'role' => 'editor',
            'color' => '#9b59b6',
          ),
          array(
            'title' => esc_html__('Yazar'),
            'role' => 'author',
            'color' => '#34495e',
          ),
          array(
            'title' => esc_html__('Köşe Yazarı'),
            'role' => 'contributor',
            'color' => '#16a085',
          ),
          array(
            'title' => esc_html__('Üye'),
            'role' => 'subscriber',
            'color' => '#2ecc71',
          ),
        ),
      ),
      array(
        'id'     => 'user-badge-2',
        'type'   => 'group',
        'title'  => esc_html__('Puana Göre Rozetler'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Rozet Tanımı'),
          ),
          array(
            'id'       => 'min',
            'type'     => 'slider',
            'title'    => esc_html__('Minimum Puan'),
            'min'      => 1,
            'max'      => 100000,
            'step'     => 1,
            'default'  => 1,
          ), 
          array(
            'id'       => 'max',
            'type'     => 'slider',
            'title'    => esc_html__('Maksimum Puan'),
            'min'      => 1,
            'max'      => 100000,
            'step'     => 1,
            'default'  => 50,
          ),  

          array(
            'id'      => 'color',
            'type'    => 'color',
            'title'   => esc_html__('Rozet Arkaplanı')
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Puanlama Sistemi'),
      ),
      array(
        'id'    => 'scoring_system',
        'title'  => esc_html__('Puanlama Sistemi'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'       => 'entry_score',
        'type'     => 'slider',
        'title'    => esc_html__('Yazı Puanı'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 50,
      ),  
      array(
        'id'       => 'comment_score',
        'type'     => 'slider',
        'title'    => esc_html__('Yorum Puanı'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 25,
      ),  
      array(
        'id'       => 'avatar_score',
        'type'     => 'slider',
        'title'    => esc_html__('Avatar Puanı'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 15,
      ), 
      array(
        'id'       => 'cover_score',
        'type'     => 'slider',
        'title'    => esc_html__('Profil Arkaplanı Puanı'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 15,
      ), 
      array(
        'id'       => 'social_score',
        'type'     => 'slider',
        'title'    => esc_html__('Sosyal Medya Puanı'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 5,
      ),  

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Bildirim Sistemi'),
      ),

      // Notifications
      array(
        'id'    => 'notifications',
        'title'  => esc_html__('Bildirim Sistemi'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'follow-categories',
        'title' => esc_html__('Kategoriler için Takip Sistemi'),
        'type'  => 'switcher',
        'dependency' => array( 'notifications', '!=', false ),
        'default' => false
      ),

      array(
        'id'    => 'follow-authors',
        'title' => esc_html__('Yazarlar için Takip Sistemi'),
        'type'  => 'switcher',
        'dependency' => array( 'notifications', '!=', false ),
        'default' => false
      ),

      array(
        'id'     => 'fake_notifications',
        'type'   => 'group',
        'title'  => esc_html__('Sahte Bildirimler'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık'),
          ),
          array(
            'id'    => 'date',
            'type'  => 'date',
            'title' => __('Tarih'),
            'settings' => array(
              'dateFormat'      => 'mm/dd/yy',
            )
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => __('Bağlantı'),
          ),
          array(
            'id'      => 'image',
            'type'    => 'upload',
            'title'   => esc_html__('Görsel'),
          ),
          array(
            'id'      => 'show',
            'default' => 'all',
            'type'    => 'select',
            'title'   => esc_html__('Kimler Görecek'),
            'options' => array(
              'members' => esc_html__('Üye'),
              'visitors' => esc_html__('Ziyaretçi'),
              'all' => esc_html__('Herkes'),
            )
          ),
        ),
      ),

      


      array(
        'title'  => esc_html__('Hesabım'),
        'type'  => 'subheading'
      ),
      array(
        'id'    => 'account-logs',
        'title'  => esc_html__('Yöneticiye E-Posta Bildirimi'),
        'desc'  => esc_html__('İçerik eklendiğinde/düzenlendiğinde yöneticiye e-posta gönderilir.'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'columnist-submit',
        'title'  => esc_html__('Köşe Yazısı Gönder'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'columnist-submit-only',
        'title'  => esc_html__('Köşe Yazısı Gönder'),
        'desc'  => esc_html__('Aktif edildiğinde köşe Yazısını sadece köşe yazarları gönderebilir.'),
        'type'  => 'switcher',
        'default' => false
      ),

      // Posting System
      array(
        'id'    => 'post-edit',
        'title'  => esc_html__('İçerik Düzenle'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'post-submit',
        'title'  => esc_html__('İçerik Gönder'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'post-submit-status-editor',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu').' - '.esc_html__('Editör'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status-author',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu').' - '.esc_html__('Yazar'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status-contributor',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu').' - '.esc_html__('İçerik Sağlayıcı'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu').' - '.esc_html__('Üye'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status-columist',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu').' - '.esc_html__('Köşe Yazarı'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      

      
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kanews Insights'),
      ),
      // Subscription System
      array(
        'id'    => 'kanews-insights',
        'title'  => esc_html__('Ücretli Abonelik Sistemi'),
        'desc'  => esc_html__('Woocommerce eklentisi gerektirir.'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'remove-ad',
        'title'  => esc_html__('Reklamı Kaldır Linki'),
        'desc'  => esc_html__('Reklamların sağ üst köşesine reklamı kaldır linki ekler.'),
        'type'  => 'switcher',
        'default' => false
      ),
      // Subscription Page
      array(
        'id'          => 'kanews-insights-page',
        'type'        => 'select',
        'title'       => esc_html__('Abonelik Sayfası'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin')
      ),
      // Header Subscription Button
      array( 
        'id'      => 'kanews-insights-button',
        'dependency' => array( 'kanews-insights', '==', 'true' ),
        'title'   => esc_html__('Abonelik Butonu'),
        'desc'    => esc_html__('Headera kullanıcıları abonelik sayfasına yönlendirecek bir buton ekler.'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'     => 'subscription-faq',
        'type'   => 'group',
        'title' => esc_html__('Sıkça Sorulan Sorular'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__('Başlık'),
          ),
          array(
            'id'    => 'content',
            'type'  => 'textarea',
            'title' => esc_html__('Açıklama'),
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar'),
      ),
      
      
      array(
        'id'                    => 'login-left-background',
        'type'                  => 'background',
        'title'                 => esc_html__( 'Giriş/Kayıt Sol Alan Tasarımı'),
        'background_color'      => true,
        'background_image'      => true,
        'background-position'   => true,
        'background_repeat'     => true,
        'background_attachment' => true,
        'background_size'       => true,
        'background_origin'     => false,
        'background_clip'       => false,
        'background_blend_mode' => false,
        'background_gradient'   => false,
        'default'               => array(
          'background-color'              => '#1d1f26',
          'background-position'           => 'center center',
          'background-repeat'             => 'no-repeat',
          'background-size'               => 'cover',
        )
      ),

    
		)
  ) );
  
  /**
	 * Customizer
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Özelleştirmeler'),
		'icon'        => 'fas fa-fill-drip',
		'fields'      => array(
      // General
      array(
        'type'    => 'heading',
        'content' => esc_html__('Genel Özelleştirmeler'),
      ),
      array(
        'id'       => 'site-container',
        'type'     => 'dimensions',
        'height'   => false,
        'title'    => esc_html__('Site Genişliği'),
        'desc'    => esc_html__('Görsel kalite düşecektir, ayarlayacağınız boyuta göre sitede bozulmalar olabilir. Varsayılan: 1200px'),
        'default'  => array(
          'width'  => '1200',
          'unit'   => 'px',
        ),
      ),
      array(
        'id'                    => 'site-background',
        'type'                  => 'background',
        'title'                 => esc_html__('Site Arkaplanı'),
        'background_color'      => true,
        'background_image'      => true,
        'background-position'   => true,
        'background_repeat'     => true,
        'background_attachment' => true,
        'background_size'       => true,
        'background_origin'     => true,
        'background_clip'       => false,
        'background_blend_mode' => false,
        'background_gradient'   => true,
      ),
      array(
        'id'      => 'switch-primary-color',
        'type'    => 'switcher',
        'default'    => true,
        'desc'   => esc_html__('Kategori renklerini o kategoride ve kategoriye ait yazılarda birincil renk olarak siteye uyarla.'),
        'title'   => esc_html__('Kategori Rengini Uygula')
      ),
      array(
        'id'      => 'primary-color',
        'type'    => 'color',
        'title'   => esc_html__('Birincil Renk')
      ),
      array(
        'id'      => 'primary-amp-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Birincil Renk (AMP)')
      ),
      array(
        'id'          => 'site-font',
        'type'        => 'select',
        'title'       => esc_html__('Site Fontu'),
        'chosen'      => true,
        'options'     => 'kanews_google_fonts',
        'attributes' => array(
          'style'    => 'width: 100%;'
        ),
        'placeholder' => 'Varsayılan',
      ),

      // Block
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Blok'),
      ),
      array(
        'id'      => 'block-border',
        'type'    => 'button_set',
        'title'  => esc_html__('Blok Kenarlık Stili'),
        'options' => array(
          'border' => esc_html__('Border'),
          'box_shadow' => esc_html__('Box Shadow'),
          'none' => esc_html__('Düz'),
        ),
        'default' => 'box_shadow'
      ),
      array(
        'id'      => 'block-border-color',
        'type'    => 'color',
        'title'   => esc_html__('Blok Border Rengi')
      ),
      array(
        'id'       => 'block-border-radius',
        'type'     => 'slider',
        'title'    => esc_html__('Blok Kenarlık Çapı'),
        'min'      => 0,
        'max'      => 25,
        'step'     => 1,
      ),  

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header'),
      ),

      array(
        'id'            => 'height-height-tab',
        'type'          => 'tabbed',
        'title'         => esc_html__('Header Yüksekliği'),
        'desc'          => esc_html__('Logonun bulunduğu bölümün yüksekliği.'),
        'tabs'          => array(
          array(
            'title'     => esc_html__('Masaüstü'),
            'icon'      => 'fa fa-desktop',
            'fields'    => array(
              array(
                'id'       => 'desktop',
                'type'     => 'dimensions',
                'width'   => false,
                'title'    => esc_html__('Yükseklik'),
                'default'  => array(
                  'height'  => '',
                  'unit'   => 'px',
                ),
              )
            )
          ),
          array(
            'title'     => esc_html__('Mobil'),
            'icon'      => 'fa fa-mobile',
            'fields'    => array(
              array(
                'id'       => 'mobile',
                'type'     => 'dimensions',
                'width'   => false,
                
                'title'    => esc_html__('Yükseklik'),
                'default'  => array(
                  'height'  => '',
                  'unit'   => 'px',
                ),
              ),
            ),
          )
        ),
      ),

      array(
        'id'      => 'header-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'header-color-2',
        'type'    => 'color',
        'dependency' => array( 'header-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)')
      ),

      array(
        'id'      => 'subscribe-btn-color',
        'type'    => 'color',
        'dependency' => array( 'kanews-insights-button', '!=', 'false' ),
        'title'   => esc_html__('Abone Ol Buton Rengi')
      ),
      array(
        'id'      => 'header-border-color',
        'type'    => 'color',
        'title'   => esc_html__('Border Rengi')
      ),
      array(
        'id'      => 'header-border-radius',
        'type'    => 'slider',
        'min'      => 0,
        'max'      => 25,
        'step'     => 1,
        'title'   => esc_html__('Border Çapı'),
      ),
      array(
        'id'      => 'header-btn-bgcolor',
        'type'    => 'color',
        'title'   => esc_html__('Buton Arkaplan Rengi')
      ),
      array(
        'id'      => 'header-btn-color',
        'type'    => 'color',
        'title'   => esc_html__('Buton Rengi')
      ),

      // Sub Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header'),
      ),
      array(
        'id'      => 'subheader-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'subheader-link-color',
        'type'    => 'color',
        'title'   => esc_html__('Linklerin Rengi')
      ),

      // Footer
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Footer'),
      ),
      array(
        'id'      => 'footer-color',
        'type'    => 'color',
        'class'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'footer-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'footer-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)')
      ),

      // Navbar
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Navbar'),
      ),
      array(
        'id'      => 'navbar-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'navbar-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'navbar-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)')
      ),
      array(
        'id'      => 'navbarlink-color',
        'type'    => 'color',
        'title'   => esc_html__('Linklerin Rengi')
      ),
      array(
        'id'      => 'navbarlinkhover-color',
        'type'    => 'color',
        'title'   => esc_html__('Linklerin Üzerindeykenki Rengi')
      ),
      array(
        'id'                 => 'navbar-typography',
        'type'               => 'typography',
        'title'              => esc_html__('Tipografi'),
        'font_family'        => true,
        'font_weight_2'      => true,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => false,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => false,
        'text_decoration'    => false,
      ),

    
      // Big Menu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Büyük Menü'),
      ),
      array(
        'id'      => 'bigmenu-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'bigmenu-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'bigmenu-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)')
      ),
      array(
        'id'      => 'bigmenulink-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Linklerin Rengi')
      ),

      // Mobile Menu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Açılır Menü'),
      ),
      array(
        'id'      => 'mobilmenu-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'mobilmenu-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'bigmenu-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)')
      ),
      array(
        'id'      => 'mobilmenu-text-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazıların Rengi')
      ),
      array(
        'id'      => 'mobilmenulink-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Linklerin Rengi')
      ),

      // Mobile Menu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sayfa Barı (Page Header)'),
      ),
      array(
        'id'      => 'pageheader-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'pageheader-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'bigmenu-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)')
      ),
      array(
        'id'      => 'pageheadertext-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazıların Rengi')
      ),

      // Single Post
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yazı Sayfası'),
      ),
      array(
        'id'      => 'single-postitle-color',
        'type'    => 'color',
        'title'   => esc_html__('Yazı Başlığının Rengi')
      ),
      array(
        'id'                 => 'single-postitle-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Başlığının Tipografisi'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_weight_2'      => true,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => true,
      ),
      array(
        'id'      => 'single-postsubtitle-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı Açıklamasının Rengi')
      ),
      array(
        'id'                 => 'single-postsubtitle-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Açıklamasının Tipografisi'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'font_weight_2'      => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => true,
      ),
      array(
        'id'      => 'single-postmeta-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı Metalarının Rengi')
      ),
      array(
        'id'                 => 'single-postmeta-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Metalarının Tipografisi'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => true,
      ),

      
      array(
        'id'      => 'single-postcontent-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı İçeriğinin Rengi')
      ),
      array(
        'id'      => 'single-postcontentlink-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı İçerik Linklerinin Rengi')
      ),
      array(
        'id'      => 'single-postcontentlinkhover-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı İçerik Linklerinin Üzerindeykenki Rengi')
      ),
      array(
        'id'          => 'single-font',
        'type'        => 'select',
        'title'       => esc_html__('Yazı İçeriğinin Fontu'),
        'chosen'      => true,
        
        'options'     => 'kanews_google_fonts',
        'attributes' => array(
          'style'    => 'width: 100%'
        ),
        'placeholder' => 'Varsayılan',
      ),
      array(
        'id'                 => 'single-postcontent-typography',
        'type'               => 'typography',
        'title'              => esc_html__('Yazı İçeriğinin Tipografisi'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => false,
      ),

      // Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Arşivler'),
      ),
      array(
        'id'                 => 'postitle-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Başlığı Tipografisi'),
        'font_family'        => false,
        'font_weight_2'      => true,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => false,
      ),

      // Back To Top
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Başa Dön Tuşu'),
      ),
      array(
        'id'      => 'backtotop-background',
        'type'    => 'color',
        
        'title'   => esc_html__('Vurgulanan Renk')
      ),
      array(
        'id'      => 'backtotop-color',
        'type'    => 'color',
        
        'title'   => esc_html__('İkon Rengi')
      ),

      // Back To Top
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Son Dakika Barı'),
      ),
      array(
        'id'      => 'bn-left-background',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi')
      ),
      array(
        'id'      => 'bn-left-color',
        
        'type'    => 'color',
        'title'   => esc_html__('İçerik Rengi')
      ),

    )
  ));


  /**
	 * Authors
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Yazar Listesi'),
		'icon'        => 'fas fa-flag',
		'fields'      => array(
      array(
        'content'  => '<a href="'.home_url(get_option('kanews_author_base', 'yazarlar')).'">Yazarların Gösterileceği Sayfa</a>',
        'type'    => 'notice',
        'style'   => 'info',
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yazar Listesi Oluştur'),
      ),
      array(
        'id'     => 'author-lists',
        'type'   => 'group',
        'title'  => esc_html__('Liste'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title'  => esc_html__('Başlık'),
          ),
          array(
            'id'          => 'authors',
            'type'        => 'select',
            'title'       => 'Gösterilecek Üyeler',
            'chosen'      => true,
            'multiple'    => true,
            'ajax'        => true,
            'placeholder' => 'Kullanıcı Seçin',
            'options' => 'users',
          ),
        ),
      ),
    )
  ) );

	/**
	 * Popup
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Popup'),
		'icon'        => 'fas fa-flag',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Popup Ayarları'),
      ),
      array(
        'id'    => 'popup',
        'title'  => esc_html__('Popup'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'popup-title',
        'type'  => 'text',
        'title'  => esc_html__('Popup Başlığı'),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Popup Modülleri'),
      ),
      
      array(
        'id'      => 'popup-module',
        'type'    => 'button_set',
        'desc'  => esc_html__('Bileşen seçiliyse görünüm>bileşenler sayfasında Popup bileşen alanına ekli bileşenler gösterilir.'),
        'options' => array(
          'custom' => esc_html__('Özel Alan'),
          'widget' => esc_html__('Bileşen'),
        ),
        'default' => 'custom'
      ),
      array(
        'id'    => 'popup-module-custom',
        'type'  => 'wp_editor',
        'title'  => esc_html__('İçerik'),
        
        'dependency' => array( 'popup-module', '==', 'custom' ),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar'),
      ),
      array(
        'id'       => 'popup-delay',
        'type'     => 'slider',
        'title'    => esc_html__('Gecikme Süresi (sn)'),
        'min'      => 1,
        'max'      => 100,
        'step'     => 1,
        'default'  => 5,
      ),  
      array(
        'id'       => 'popup-expired',
        'type'     => 'slider',
        'title'    => esc_html__('Cookie Geçerlilik Süresi (gün)'),
        'desc'    => esc_html__('Çarpı butonuna basıldıktan kaç gün sonra tekrar gözükeceğini belirleyin.'),
        'min'      => 1,
        'max'      => 365,
        'step'     => 1,
        'default'  => 7,
      ),  
      array(
        'id'       => 'popup-width',
        'type'     => 'slider',
        'title'    => esc_html__('İçerik Genişliği'),
        'min'      => 325,
        'max'      => 992,
        'step'     => 1,
      ),  
    )
  ));

	/**
	 * İlan
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'İlan Sistemi'),
		'icon'        => 'fas fa-thermometer-full',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('İlan Sistemi'),
      ),
      array(
        'id'    => 'ilan-sistemi',
        'title'  => esc_html__('İlan Sistemi'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'ilan-submit',
        'title'  => esc_html__('İlan Gönder'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'ilan-edit',
        'title'  => esc_html__('İlan Düzenle'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'ilan-update',
        'title'  => esc_html__('İlanı Yukarı Taşı'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'dependency' => array( 'ilan-update', '==', 'true' ),
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=simple-custom-post-order&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Simple Custom Post Order</a> eklentisinin kurun ve Ayarlar>SCPOrder sayfasındaki Check to Sort Post Types kısmından İlanları aktif edin.',
      ),
      array(
        'id'    => 'ilan-insights',
        'title'  => esc_html__('Abonelik Sistemiyle Entegre Et'),
        'desc'  => esc_html__('Kanews/Üyelik Sistemi sayfasındaki Ücretli Abonelik Sistemi ayarının aktif olması gerekir. Abone kullanıcılara ilanlarını yukarı taşımaya olanak sağlar. '),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'ilan-submit-status-editor',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Editör)'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'ilan-submit-status-author',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Yazar)'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'ilan-submit-status-contributor',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (İçerik Sağlayıcı)'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'ilan-submit-status',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Üye)'),

        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
    )
  ));

	/**
	 * Firma Rehberi
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Firma Rehberi'),
		'icon'        => 'fas fa-thermometer-full',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Firma Rehberi'),
      ),
      array(
        'id'    => 'firma-rehberi',
        'title'  => esc_html__('Firma Rehberi Sistemi'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'firma-edit',
        'title'  => esc_html__('Firma Düzenle'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'comp-insights',
        'title'  => esc_html__('Abonelik Sistemiyle Entegre Et'),
        'desc'  => esc_html__('Kanews/Üyelik Sistemi sayfasındaki Ücretli Abonelik Sistemi ayarının aktif olması gerekir. Firmayı ekleyen üye abone ise bilgileri gözükür değilse gözükmez.'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'    => 'comp-logged',
        'title'  => esc_html__('Firma Bilgilerini Ziyaretçiler için Gizle'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'comp-submit-status-editor',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Editör)'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'comp-submit-status-author',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Yazar)'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'comp-submit-status-contributor',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (İçerik Sağlayıcı)'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'comp-submit-status',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Üye)'),

        'options' => array(
          'pending' => esc_html__('Onay Sürecinde'),
          'publish' => esc_html__('Yayınla'),
          'draft' => esc_html__('Taslak'),
          'private' => esc_html__('Özel'),
        ),
        'default' => 'pending'
      ),

      array(
        'id'      => 'firma-style',
        'type'    => 'image_select',
        
        'title'   => esc_html__('Arşiv Görünüm'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),

      // Related Posts
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Benzer Firmalar'),
      ),
      
      array(
        'id'      => 'related-firma-style',
        'type'    => 'image_select',
        
        'title'   => esc_html__('Görünüm'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),
      array(
        'id'      => 'related-firma-sortby',
        'type'    => 'radio',
        
        'title'   => esc_html__('Göre Sırala'),
        'dependency' => array( 'related-firma-style', '!=', 'disable' ),
        'desc'   => 'Benzer firmaların sıralanışını belirler, tüm seçenekler ilk olarak ana firmanın kategorisi baz alır',
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre'),
          'commented' => esc_html__('En Çok Yorum Yapılan'),
          'random' => esc_html__('Rastgele'),
        ),
        'default' => 'commented'
      ),
      array(
        'id'       => 'related-firma-count',
        'type'     => 'slider',
        
        'dependency' => array( 'related-firma-style', '!=', 'disable' ),
        'title'    => esc_html__('Firma Sayısı'),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 6,
      ),

		)
  ) );
  
	/**
	 * Cron Job
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Veri Güncelleme'),
		'icon'        => 'fas fa-wifi',
		'fields'      => array(

      array(
        'id'         => 'openweathermap-api',
        'type'       => 'text',
        'title'      => esc_html__('Openweathermap API Anahtarı'),
        'desc'      =>  '<a href="https://openweathermap.org/price" target="_blank">'.esc_html__( 'Api oluşturmak için tıklayın.').'</a>'
      ),

      array(
        'type'    => 'heading',
        'content' => esc_html__('Bilgilendirme'),
      ),
      array(
        'type'    => 'notice',
        'style'   => 'info',
        'content' => 'Dosya konumunu değil ancak dosya isimlerini değiştirebilirsiniz.',
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'content' => 'Borsa İstanbul verilerinin dağıtımı için bir veri yayın kuruluşu üzerinden lisans satın almanız gerekmektedir dolayısıyla borsa istanbul verilerini sitenizde kullanmak telif hakkı ihlaline sebebiyet verebilir. Kanews Borsa İstanbul veya farklı bir kuruluş üzerinden veri dağıtım lisansı sağlamaz.',
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Cron Job Oluştur'),
      ),
      array(
        'type'    => 'content',
        'content' => '
          <h3>1- Sitenizin cpanel veya türevi olan sunucu yönetim paneline girin </h3>
          <h3>2- Gelişmiş > Cron İşleri sayfasına girin. <a target="_blank" href="https://www.kanthemes.com/files/kanews/yardim/cron1.png">Görsel</a> </h3>
          <h3>3- Aşağıdaki kodların her birini tek tek görselde belirtildiği şekilde cron işi olarak ekleyin. Mevcut ayarlardan sadece Ortak Ayarlar kısmında ilgili verinin ne kadar sürede güncellenmesini istiyorsanız o seçeneği seçin.  <a target="_blank" href="https://www.kanthemes.com/files/kanews/yardim/cron2.png">Görsel</a> </h3>
          <ul>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/currencies/doviz71352.php</code> </li>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/standings/standings5kds1.php</code> </li>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/exchange/borsa_2321lsa1.php</code></li>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/gold/gold_k2ns1.php</code></li>
          </ul>

          <p>
          1. için <i>Saatte İki Kez</i>,<br>
          2. için <i>Saatte İki Kez</i>,<br>
          3. için <i>Günde İki Kez</i>,<br>
          4. için <i>Günde İki Kez</i>,<br>
          5. için <i>Saatte Bir Kez</i>,<br>
          6. için <i>Saatte Bir Kez</i>,<br>
          ayarları önerilir.
          </p>
          ',
      ),



      array(
        'type'    => 'subheading',
        'content' => esc_html__('Verileri Manuel Güncelle'),
      ),
      array(
        'type'    => 'content',
        'content' => '
          <p>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/currencies/doviz71352.php" class="button">Döviz Kurlarını Güncelle</a>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/standings/standings5kds1.php" class="button">Puan Durumlarını Güncelle</a>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/exchange/borsa_2321lsa1.php" class="button">Borsa Verilerini Güncelle</a>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/gold/gold_k2ns1.php" class="button">Emtia Verilerini Güncelle</a>
          </p>
          ',
      ),

		)
	) );
  
	/**
	 * PWA
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'PWA'),
		'icon'        => 'fas fa-shield-alt',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'desc'    => '',
        'content' => esc_html__('Progressive Web Apps'),
      ),
      array(
        'id'    => 'pwa-status',
        'title'  => esc_html__('Progressive Web Apps Oluştur'),
        'desc'  => esc_html__('PWA, web sitelerinin mobil cihazlarda native olarak uygulama gibi kullanılmasını sağlayan bir teknolojidir.'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'pwa-name',
        'type'  => 'text',
        'default' => KAN_THEME_NAME,
        'title' => __('Uygulama Adı'),
      ),
      
      array(
        'id'    => 'pwa-short-name',
        'type'  => 'text',
        'default'  => KAN_THEME_NAME,
        'title' => __('Uygulama Kısa Adı'),
      ),
      array(
        'id'    => 'pwa-description',
        'type'  => 'text',
        'title' => __('Uygulama Açıklaması'),
      ),
      array(
        'id'    => 'pwa-starturl',
        'title'  => esc_html__('Uygulama Başlangıç Sayfası'),
        'default'    => home_url( '/?utm_source=homescreen&utm_medium=shortcut'),
        'type'    => 'text',
      ),

      array(
        'id'      => 'pwa-display',
        'type'    => 'select',
        'title'   => esc_html__('Kullanıcı Arayüzü'),
        'options' => array(
          'fullscreen' => esc_html__('Tam Ekran'),
          'standalone' => esc_html__('Standalone'),
          'minimal-ui' => esc_html__('Minimal UI')
        ),
        'default' => 'fullscreen'
      ),

      array(
        'id'      => 'pwa-theme-color',
        'type'    => 'color',
        'title'   => esc_html__('Tema Rengi')
      ),

      array(
        'id'      => 'pwa-bg-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi')
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Hızlı Linkler'),
      ),
      array(
        'id'    => 'pwa-shortcut',
        'title'  => esc_html__('Hızlı Linkleri Göster'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'     => 'pwa-shortcuts',
        'type'   => 'group',
        'dependency' => array( 'pwa-shortcut', '==', 'true' ),
        'title'  => esc_html__('Hızlı Link Oluştur'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Adı'),
          ),
          array(
            'id'     => 'icon',
            'type'   => 'upload',
            'title'  => esc_html__('İkon').' (192x192px)',
            'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'validate' => 'csf_validate_url',
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Ekran Görüntüleri'),
      ),

      array(
        'id'    => 'pwa-screenshot',
        'title'  => esc_html__('Ekran Görüntüleri'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'     => 'pwa-screenshots',
        'desc'   => esc_html__( 'Uygulama mağazalarında ekran görüntüsü olarak gösterilir.'),
        'type'   => 'group',
        'dependency' => array( 'pwa-screenshot', '==', 'true' ),
        'title'  => esc_html__('Ekran Görüntüleri'),
        'button_title'  => esc_html__('Yeni Ekle'),
        'fields' => array(
          array(
            'id'     => 'image',
            'type'   => 'upload',
            'title'  => esc_html__('Görsel').' (192x192px)',
            'desc'   => 'Önerilen Boyutlar: 540x720px - 586x1041px - 1280x720px (Png formatında olması gerekir)',
          ),
          array(
            'id'      => 'size',
            'type'    => 'select',
            'title'   => esc_html__('Boyut'),
            'options' => array(
              '540x720' => '540x720px',
              '586x1041' => '586x1041px',
              '1280x720' => '1280x720px',
            ),
            'default' => '540x720'
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Uygulama İkonu'),
      ),

      array(
        'id'     => 'pwa-icon-48',
        'type'   => 'upload',
        'title'  => esc_html__('İkon').' (48x48px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-72',
        'type'   => 'upload',
        'title'  => esc_html__('İkon').' (72x72px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-96',
        'type'   => 'upload',
        'title'  => esc_html__('İkon').' (96x96px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-128',
        'type'   => 'upload',
        'title'  => esc_html__('İkon').' (128x128px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-192',
        'type'   => 'upload',
        'title'  => esc_html__('İkon').' (192x192px) (Gerekli)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-512',
        'type'   => 'upload',
        'title'  => esc_html__('İkon').' (512x512px)',
        'desc'   => 'Png formatında olmalı, açılış ekranında gösterilir. Oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Popup'),
      ),

      array(
        'id'    => 'pwa-btn',
        'title'  => esc_html__('Durum'),
        'desc'  => esc_html__('Siteye girenlere uygulama yükle popup\'ı gösterir.'),
        'type'  => 'switcher',
        'default' => false
      ),
      
      array(
        'id'    => 'pwa-install-app-text',
        'dependency' => array( 'pwa-btn', '==', 'true' ),
        'title'  => esc_html__('Açıklama'),
        'type'    => 'text',
      ),
      array(
        'id'       => 'pwa-popup-delay',
        
        'type'     => 'slider',
        'dependency' => array( 'pwa-btn', '==', 'true' ),
        'title'    => esc_html__('Gecikme Süresi (sn)'),
        'min'      => 1,
        'max'      => 100,
        'step'     => 1,
        'default'  => 5,
      ),  
      array(
        'id'       => 'pwa-popup-expired',
        'type'     => 'slider',
        'dependency' => array( 'pwa-btn', '==', 'true' ),
        'title'    => esc_html__('Cookie Geçerlilik Süresi (gün)'),
        'desc'    => esc_html__('Çarpı butonuna basıldıktan kaç gün sonra tekrar gözükeceğini belirleyin.'),
        'min'      => 1,
        'max'      => 365,
        'step'     => 1,
        'default'  => 7,
      ),  
		)
	) );

	/**
	 * Database Optimizer
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Veritabanı Optimizer'),
		'icon'        => 'fas fa-database',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Veritabanı Optimizer'),
      ),
      array(
        'type'    => 'notice',
        'style'   => 'warning',
        'content' => esc_html__( '⚠️ BETA: Bu özellik test aşamasındadır. Kullanmadan önce veritabanınızın yedeğini almanız önerilir. İşlem sonuçlarını bizimle paylaşarak geliştirmemize yardımcı olabilirsiniz.'),
      ),
      array(
        'type'    => 'notice',
        'style'   => 'info',
        'content' => esc_html__( 'Bu araç veritabanınızdaki boş array\'leri, boş değerleri ve tekrarlayan meta kayıtlarını temizler. Düzenli kullanım veritabanı performansını artırır.'),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Temizleme İşlemleri'),
      ),
      array(
        'type'    => 'content',
        'content' => '
        <div id="kanews-optimizer-stats" style="margin: 15px 0; padding: 15px; background: #f0f6fc; border: 1px solid #c3c4c7; border-radius: 4px; display: none;">
          <h3 style="margin-top: 0;">' . esc_html__( 'İşlem Öncesi Veritabanı Bilgileri') . '</h3>
          <div id="kanews-stats-content"></div>
        </div>
        <div id="kanews-optimizer-results" style="margin: 15px 0; padding: 10px; background: #f0f0f1; border-left: 4px solid #2271b1; display: none;"></div>
        <div id="kanews-optimizer-share" style="margin: 15px 0; padding: 15px; background: #fff3cd; border: 1px solid #ffc107; border-radius: 4px; display: none;">
          <h3 style="margin-top: 0; color: #856404;">' . esc_html__( 'Sonuçları Paylaş') . '</h3>
          <p style="margin: 10px 0; color: #856404;">' . esc_html__( 'Bu özellik BETA aşamasındadır. Sonuçları bizimle paylaşarak geliştirmemize yardımcı olabilirsiniz. Sonuçları kopyalayıp destek ekibimize gönderebilirsiniz.') . '</p>
          <button type="button" class="button button-secondary" id="kanews-copy-results" style="margin-right: 10px;">
            ' . esc_html__( 'Sonuçları Kopyala') . '
          </button>
          <button type="button" class="button button-secondary" id="kanews-show-results-json">
            ' . esc_html__( 'JSON Olarak Göster') . '
          </button>
          <div id="kanews-results-json" style="margin-top: 15px; padding: 10px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 4px; display: none; max-height: 300px; overflow-y: auto;">
            <pre id="kanews-json-content" style="margin: 0; font-family: monospace; font-size: 11px; white-space: pre-wrap; word-wrap: break-word;"></pre>
          </div>
          <div id="kanews-copy-success" style="margin-top: 10px; padding: 8px; background: #d1e7dd; border: 1px solid #0f5132; border-radius: 4px; color: #0f5132; display: none;">
            ' . esc_html__( '✓ Sonuçlar panoya kopyalandı!') . '
          </div>
        </div>
        <div id="kanews-optimizer-log" style="margin: 15px 0; padding: 15px; background: #f9f9f9; border: 1px solid #c3c4c7; border-radius: 4px; max-height: 400px; overflow-y: auto; display: none;">
          <h3 style="margin-top: 0;">' . esc_html__( 'İşlem Logu') . '</h3>
          <div id="kanews-log-content" style="font-family: monospace; font-size: 12px; line-height: 1.6;"></div>
        </div>
        <div class="kanews-optimizer-buttons" style="display: flex; gap: 10px; flex-wrap: wrap;">
          <button type="button" class="button button-primary kanews-optimize-btn" data-action="clean_post_meta">
            ' . esc_html__( 'Post Meta\'ları Temizle') . '
          </button>
          <button type="button" class="button button-primary kanews-optimize-btn" data-action="remove_duplicates">
            ' . esc_html__( 'Tekrarlayanları Sil') . '
          </button>
          <button type="button" class="button button-primary kanews-optimize-btn" data-action="check_unused_tables">
            ' . esc_html__( 'Kullanılmayan Tabloları Tespit Et') . '
          </button>
          <button type="button" class="button button-hero kanews-optimize-btn" data-action="clean_all">
            ' . esc_html__( 'Hepsini Temizle') . '
          </button>
        </div>
        <script>
        jQuery(document).ready(function($) {
          function formatStats(stats) {
            var html = "<table style=\"width: 100%; border-collapse: collapse;\">";
            
            // Veritabanı Boyutu (en üstte)
            if (stats.database_size) {
              html += "<tr><td colspan=\"2\" style=\"padding: 8px; background: #2271b1; color: #fff; font-weight: bold;\">' . esc_html__( 'Veritabanı Boyutu') . '</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Toplam Boyut') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd; font-weight: bold; color: #2271b1;\">" + (stats.database_size.formatted_size || stats.database_size.size_mb + " MB") + "</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Veri Boyutu') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.database_size.data_size_mb + " MB</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'İndeks Boyutu') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.database_size.index_size_mb + " MB</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Tablo Sayısı') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.database_size.table_count + "</td></tr>";
            }
            
            if (stats.post_meta) {
              html += "<tr><td colspan=\"2\" style=\"padding: 8px; background: #e5e5e5; font-weight: bold; margin-top: 10px;\">' . esc_html__( 'Post Meta') . '</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Toplam Meta') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.post_meta.total_metas + "</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Boş Array\'ler') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.post_meta.empty_arrays + "</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Boş String\'ler') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.post_meta.empty_strings + "</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Temizlenmesi Gereken') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.post_meta.needs_cleaning + "</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Toplam Boş') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.post_meta.total_empty + "</td></tr>";
            }
            
            if (stats.duplicates) {
              html += "<tr><td colspan=\"2\" style=\"padding: 8px; background: #e5e5e5; font-weight: bold; margin-top: 10px;\">' . esc_html__( 'Tekrarlayanlar') . '</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Tekrarlayan Grup') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.duplicates.total_duplicate_groups + "</td></tr>";
              html += "<tr><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">' . esc_html__( 'Tekrarlayan Kayıt') . ':</td><td style=\"padding: 6px 8px; border-bottom: 1px solid #ddd;\">" + stats.duplicates.total_duplicate_records + "</td></tr>";
            }
            
            html += "</table>";
            return html;
          }
          
          function formatLog(log, before, after) {
            var html = "";
            
            if (before) {
              html += "<div style=\"margin-bottom: 15px; padding: 10px; background: #fff3cd; border-left: 4px solid #ffc107;\">";
              html += "<strong>' . esc_html__( 'İşlem Öncesi:') . '</strong><br>";
              if (before.total_metas !== undefined) {
                html += "' . esc_html__( 'Post Meta:') . ' " + before.total_metas + " ' . esc_html__( 'toplam') . ', " + before.empty_arrays + " ' . esc_html__( 'boş array') . ', " + before.empty_strings + " ' . esc_html__( 'boş string') . '<br>";
              }
              if (before.total_duplicate_groups !== undefined) {
                html += "' . esc_html__( 'Tekrarlayanlar:') . ' " + before.total_duplicate_groups + " ' . esc_html__( 'grup') . ', " + before.total_duplicate_records + " ' . esc_html__( 'kayıt') . '<br>";
              }
              html += "</div>";
            }
            
            if (log && log.length > 0) {
              html += "<div style=\"margin-bottom: 15px;\">";
              html += "<strong>' . esc_html__( 'İşlem Detayları:') . '</strong><br>";
              html += "<ul style=\"margin: 10px 0; padding-left: 20px;\">";
              log.forEach(function(item) {
                html += "<li style=\"margin: 5px 0;\">" + item + "</li>";
              });
              html += "</ul>";
              html += "</div>";
            }
            
            if (after) {
              html += "<div style=\"margin-top: 15px; padding: 10px; background: #d1e7dd; border-left: 4px solid #0f5132;\">";
              html += "<strong>' . esc_html__( 'İşlem Sonrası:') . '</strong><br>";
              if (after.total_metas !== undefined) {
                html += "' . esc_html__( 'Post Meta:') . ' " + after.total_metas + " ' . esc_html__( 'toplam') . ', " + after.empty_arrays + " ' . esc_html__( 'boş array') . ', " + after.empty_strings + " ' . esc_html__( 'boş string') . '<br>";
              }
              if (after.total_duplicate_groups !== undefined) {
                html += "' . esc_html__( 'Tekrarlayanlar:') . ' " + after.total_duplicate_groups + " ' . esc_html__( 'grup') . ', " + after.total_duplicate_records + " ' . esc_html__( 'kayıt') . '<br>";
              }
              html += "</div>";
            }
            
            return html;
          }
          
          // Load initial stats
          $.ajax({
            url: ajaxurl,
            type: "POST",
            data: {
              action: "kanews_get_optimizer_stats",
              nonce: "' . wp_create_nonce( 'kanews_optimize_nonce' ) . '"
            },
            success: function(response) {
              if (response.success) {
                $("#kanews-stats-content").html(formatStats(response.data));
                $("#kanews-optimizer-stats").show();
              }
            }
          });
          
          $(".kanews-optimize-btn").on("click", function(e) {
            e.preventDefault();
            var $btn = $(this);
            var action = $btn.data("action");
            var originalText = $btn.text();
            
            $btn.prop("disabled", true).text("' . esc_html__( 'İşleniyor...') . '");
            $("#kanews-optimizer-results").hide();
            $("#kanews-optimizer-log").hide();
            
            // Get stats before operation
            $.ajax({
              url: ajaxurl,
              type: "POST",
              data: {
                action: "kanews_get_optimizer_stats",
                nonce: "' . wp_create_nonce( 'kanews_optimize_nonce' ) . '"
              },
              success: function(statsResponse) {
                var beforeStats = statsResponse.success ? statsResponse.data : null;
                
                // Perform optimization
                $.ajax({
                  url: ajaxurl,
                  type: "POST",
                  data: {
                    action: "kanews_optimize_database",
                    action_type: action,
                    nonce: "' . wp_create_nonce( 'kanews_optimize_nonce' ) . '"
                  },
                  success: function(response) {
                    if (response.success) {
                      var result = response.data;
                      
                      // Store result data for sharing
                      window.kanewsLastResult = {
                        action: action,
                        result: result,
                        before: beforeStats,
                        timestamp: new Date().toISOString(),
                        wp_version: "' . get_bloginfo( 'version' ) . '",
                        theme_version: "' . ( defined( 'KAN_THEME_VERSION' ) ? KAN_THEME_VERSION : 'N/A' ) . '"
                      };
                      
                      // Show result message
                      $("#kanews-optimizer-results")
                        .html("<strong>' . esc_html__( 'Başarılı:') . '</strong> " + result.message)
                        .css({
                          "background": "#d1e7dd",
                          "border-left-color": "#0f5132",
                          "color": "#0f5132"
                        })
                        .show();
                      
                      // Show share section
                      $("#kanews-optimizer-share").show();
                      $("#kanews-results-json").hide();
                      $("#kanews-copy-success").hide();
                      
                      // Show detailed log
                      if (result.log && result.log.length > 0) {
                        var logHtml = formatLog(result.log, result.before, result.after);
                        if (action === "clean_all" && result.results) {
                          logHtml = "";
                          if (result.results.post_meta) {
                            logHtml += "<h4>' . esc_html__( 'Post Meta') . ':</h4>";
                            logHtml += formatLog(result.results.post_meta.log, result.results.post_meta.before, result.results.post_meta.after);
                          }
                          if (result.results.duplicates) {
                            logHtml += "<h4>' . esc_html__( 'Tekrarlayanlar') . ':</h4>";
                            logHtml += formatLog(result.results.duplicates.log, result.results.duplicates.before, result.results.duplicates.after);
                          }
                        }
                        // Show unused tables if available
                        if (result.unused_tables && result.unused_tables.length > 0) {
                          logHtml += "<div style=\"margin-top: 20px;\">";
                          logHtml += "<h4 style=\"color: #d63638;\">' . esc_html__( 'Kullanılmayan Tablolar') . ':</h4>";
                          logHtml += "<table style=\"width: 100%; border-collapse: collapse; margin-top: 10px;\">";
                          logHtml += "<tr style=\"background: #f0f0f1;\"><th style=\"padding: 8px; text-align: left; border: 1px solid #ddd;\">' . esc_html__( 'Tablo Adı') . '</th><th style=\"padding: 8px; text-align: left; border: 1px solid #ddd;\">' . esc_html__( 'Satır Sayısı') . '</th><th style=\"padding: 8px; text-align: left; border: 1px solid #ddd;\">' . esc_html__( 'Boyut') . '</th></tr>";
                          result.unused_tables.forEach(function(table) {
                            logHtml += "<tr><td style=\"padding: 6px 8px; border: 1px solid #ddd;\">" + table.name + "</td>";
                            logHtml += "<td style=\"padding: 6px 8px; border: 1px solid #ddd;\">" + table.rows + "</td>";
                            logHtml += "<td style=\"padding: 6px 8px; border: 1px solid #ddd;\">" + (table.formatted_size || table.size_mb + " MB") + "</td></tr>";
                          });
                          logHtml += "</table>";
                          logHtml += "<p style=\"margin-top: 10px; padding: 10px; background: #fff3cd; border-left: 4px solid #ffc107;\">";
                          logHtml += "<strong>' . esc_html__( 'Uyarı:') . '</strong> " + "' . esc_html__( 'Bu tabloları silmeden önce mutlaka veritabanı yedeği alın. Tabloları manuel olarak silmeniz gerekecektir.') . '";
                          logHtml += "</p>";
                          logHtml += "</div>";
                        }
                        $("#kanews-log-content").html(logHtml);
                        $("#kanews-optimizer-log").show();
                      } else if (result.unused_tables && result.unused_tables.length > 0) {
                        // Show unused tables even if no log
                        var logHtml = "<div style=\"margin-top: 20px;\">";
                        logHtml += "<h4 style=\"color: #d63638;\">' . esc_html__( 'Kullanılmayan Tablolar') . ':</h4>";
                        logHtml += "<table style=\"width: 100%; border-collapse: collapse; margin-top: 10px;\">";
                        logHtml += "<tr style=\"background: #f0f0f1;\"><th style=\"padding: 8px; text-align: left; border: 1px solid #ddd;\">' . esc_html__( 'Tablo Adı') . '</th><th style=\"padding: 8px; text-align: left; border: 1px solid #ddd;\">' . esc_html__( 'Satır Sayısı') . '</th><th style=\"padding: 8px; text-align: left; border: 1px solid #ddd;\">' . esc_html__( 'Boyut') . '</th></tr>";
                        result.unused_tables.forEach(function(table) {
                          logHtml += "<tr><td style=\"padding: 6px 8px; border: 1px solid #ddd;\">" + table.name + "</td>";
                          logHtml += "<td style=\"padding: 6px 8px; border: 1px solid #ddd;\">" + table.rows + "</td>";
                          logHtml += "<td style=\"padding: 6px 8px; border: 1px solid #ddd;\">" + (table.formatted_size || table.size_mb + " MB") + "</td></tr>";
                        });
                        logHtml += "</table>";
                        logHtml += "<p style=\"margin-top: 10px; padding: 10px; background: #fff3cd; border-left: 4px solid #ffc107;\">";
                        logHtml += "<strong>' . esc_html__( 'Uyarı:') . '</strong> " + "' . esc_html__( 'Bu tabloları silmeden önce mutlaka veritabanı yedeği alın. Tabloları manuel olarak silmeniz gerekecektir.') . '";
                        logHtml += "</p>";
                        logHtml += "</div>";
                        $("#kanews-log-content").html(logHtml);
                        $("#kanews-optimizer-log").show();
                      }
                      
                      // Refresh stats
                      $.ajax({
                        url: ajaxurl,
                        type: "POST",
                        data: {
                          action: "kanews_get_optimizer_stats",
                          nonce: "' . wp_create_nonce( 'kanews_optimize_nonce' ) . '"
                        },
                        success: function(statsResponse) {
                          if (statsResponse.success) {
                            $("#kanews-stats-content").html(formatStats(statsResponse.data));
                            $("#kanews-optimizer-stats").show();
                          }
                        }
                      });
                    } else {
                      $("#kanews-optimizer-results")
                        .html("<strong>' . esc_html__( 'Hata:') . '</strong> " + (result.message || "' . esc_html__( 'Bir hata oluştu.') . '"))
                        .css({
                          "background": "#f8d7da",
                          "border-left-color": "#842029",
                          "color": "#842029"
                        })
                        .show();
                    }
                    $btn.prop("disabled", false).text(originalText);
                  },
                  error: function() {
                    $("#kanews-optimizer-results")
                      .html("<strong>' . esc_html__( 'Hata:') . '</strong> ' . esc_html__( 'Bir hata oluştu.') . '")
                      .css({
                        "background": "#f8d7da",
                        "border-left-color": "#842029",
                        "color": "#842029"
                      })
                      .show();
                    $btn.prop("disabled", false).text(originalText);
                  }
                });
              }
            });
          });
          
          // Copy results to clipboard
          $("#kanews-copy-results").on("click", function() {
            if (!window.kanewsLastResult) {
              alert("' . esc_html__( 'Sonuç bulunamadı') . '");
              return;
            }
            
            var resultText = "=== KANEWS VERİTABANI OPTİMİZER SONUÇLARI ===\n\n";
            resultText += "İşlem: " + window.kanewsLastResult.action + "\n";
            resultText += "Tarih: " + new Date(window.kanewsLastResult.timestamp).toLocaleString("tr-TR") + "\n";
            resultText += "WordPress Versiyonu: " + window.kanewsLastResult.wp_version + "\n";
            resultText += "Tema Versiyonu: " + window.kanewsLastResult.theme_version + "\n\n";
            
            if (window.kanewsLastResult.result.message) {
              resultText += "Mesaj: " + window.kanewsLastResult.result.message + "\n\n";
            }
            
            if (window.kanewsLastResult.before) {
              resultText += "--- İŞLEM ÖNCESİ ---\n";
              if (window.kanewsLastResult.before.post_meta) {
                resultText += "Post Meta:\n";
                resultText += "  Toplam: " + window.kanewsLastResult.before.post_meta.total_metas + "\n";
                resultText += "  Boş Array: " + window.kanewsLastResult.before.post_meta.empty_arrays + "\n";
                resultText += "  Boş String: " + window.kanewsLastResult.before.post_meta.empty_strings + "\n";
                resultText += "  Toplam Boş: " + window.kanewsLastResult.before.post_meta.total_empty + "\n";
              }
              if (window.kanewsLastResult.before.duplicates) {
                resultText += "Tekrarlayanlar:\n";
                resultText += "  Grup: " + window.kanewsLastResult.before.duplicates.total_duplicate_groups + "\n";
                resultText += "  Kayıt: " + window.kanewsLastResult.before.duplicates.total_duplicate_records + "\n";
              }
              resultText += "\n";
            }
            
            if (window.kanewsLastResult.result.before) {
              resultText += "--- İŞLEM ÖNCESİ (Detaylı) ---\n";
              if (window.kanewsLastResult.result.before.post_meta) {
                resultText += JSON.stringify(window.kanewsLastResult.result.before.post_meta, null, 2) + "\n\n";
              }
            }
            
            if (window.kanewsLastResult.result.after) {
              resultText += "--- İŞLEM SONRASI ---\n";
              if (window.kanewsLastResult.result.after.post_meta) {
                resultText += JSON.stringify(window.kanewsLastResult.result.after.post_meta, null, 2) + "\n\n";
              }
            }
            
            if (window.kanewsLastResult.result.removed_count !== undefined) {
              resultText += "Silinen: " + window.kanewsLastResult.result.removed_count + "\n";
            }
            if (window.kanewsLastResult.result.updated_count !== undefined) {
              resultText += "Güncellenen: " + window.kanewsLastResult.result.updated_count + "\n";
            }
            if (window.kanewsLastResult.result.removed !== undefined) {
              resultText += "Toplam İşlem: " + window.kanewsLastResult.result.removed + "\n";
            }
            
            if (window.kanewsLastResult.result.log && window.kanewsLastResult.result.log.length > 0) {
              resultText += "\n--- LOG (İlk 50 Kayıt) ---\n";
              var logCount = Math.min(50, window.kanewsLastResult.result.log.length);
              for (var i = 0; i < logCount; i++) {
                resultText += window.kanewsLastResult.result.log[i] + "\n";
              }
              if (window.kanewsLastResult.result.log.length > 50) {
                resultText += "... ve " + (window.kanewsLastResult.result.log.length - 50) + " kayıt daha\n";
              }
            }
            
            resultText += "\n=== JSON FORMATI ===\n";
            resultText += JSON.stringify(window.kanewsLastResult, null, 2);
            
            // Copy to clipboard
            var textarea = document.createElement("textarea");
            textarea.value = resultText;
            textarea.style.position = "fixed";
            textarea.style.opacity = "0";
            document.body.appendChild(textarea);
            textarea.select();
            
            try {
              document.execCommand("copy");
              $("#kanews-copy-success").fadeIn().delay(3000).fadeOut();
            } catch (err) {
              alert("' . esc_html__( 'Kopyalama başarısız. Lütfen manuel olarak kopyalayın.') . '");
            }
            
            document.body.removeChild(textarea);
          });
          
          // Show results as JSON
          $("#kanews-show-results-json").on("click", function() {
            if (!window.kanewsLastResult) {
              alert("' . esc_html__( 'Sonuç bulunamadı') . '");
              return;
            }
            
            var jsonText = JSON.stringify(window.kanewsLastResult, null, 2);
            $("#kanews-json-content").text(jsonText);
            
            if ($("#kanews-results-json").is(":visible")) {
              $("#kanews-results-json").slideUp();
            } else {
              $("#kanews-results-json").slideDown();
            }
          });
        });
        </script>
        ',
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Açıklama'),
      ),
      array(
        'type'    => 'content',
        'content' => '
        <ul style="list-style: disc; margin-left: 20px;">
          <li><strong>' . esc_html__( 'Post Meta\'ları Temizle:') . '</strong> ' . esc_html__( 'Yazılardaki boş meta değerlerini temizler.') . '</li>
          <li><strong>' . esc_html__( 'Tekrarlayanları Sil:') . '</strong> ' . esc_html__( 'Aynı yazı için tekrarlayan meta kayıtlarını siler, sadece ilkini tutar.') . '</li>
          <li><strong>' . esc_html__( 'Kullanılmayan Tabloları Tespit Et:') . '</strong> ' . esc_html__( 'Veritabanındaki kullanılmayan tabloları tespit eder. Tabloları silmeden önce mutlaka yedek alın.') . '</li>
          <li><strong>' . esc_html__( 'Hepsini Temizle') . ':</strong> ' . esc_html__( 'Post meta temizleme ve tekrarlayanları silme işlemlerini sırayla yapar.') . '</li>
        </ul>
        <p style="margin-top: 15px; padding: 10px; background: #fff3cd; border-left: 4px solid #ffc107;">
          <strong>' . esc_html__( 'Uyarı:') . '</strong> ' . esc_html__( 'Bu işlemler geri alınamaz. Önce veritabanınızın yedeğini almanız önerilir.') . '
        </p>
        ',
      ),

		)
	) );

	/**
	 * Backup
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'İçe Aktar / Dışa Aktar'),
		'icon'        => 'fas fa-shield-alt',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('İçe Aktar / Dışa Aktar'),
      ),
      array(
        'type'    => 'content',
        'title' => esc_html__('Hazır Tema Ayarları'),
        'content' => '
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/genel/options.txt" class="button button-hero button-secondary">Genel Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/spor/options.txt" class="button button-hero button-secondary">Spor Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/kripto/options.txt" class="button button-hero button-secondary">Kripto Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/blog/options.txt" class="button button-hero button-secondary">Blog Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/firma/options.txt" class="button button-hero button-secondary">Firma Rehberi Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/finans/options.txt" class="button button-hero button-secondary">Finans Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/world/options.txt" class="button button-hero button-secondary">Global News Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/yerel/options.txt" class="button button-hero button-secondary">Yerel Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/startups/options.txt" class="button button-hero button-secondary">Startups Demo</a>
        ',
      ),
			array(
				'type' => 'backup',
			),

		)
	) );


});
}

add_filter( 'csf_fa5', '__return_false' );


function kanews_get_terms_ilan_kategori() {
  $taxonomies = get_terms( array(
    'taxonomy' => 'ilan-kategori',
    'hide_empty' => true,
  ) );
  $return = array();
  if( !is_wp_error($taxonomies) ) {
    foreach($taxonomies as $taxonomy) {
      $return[$taxonomy->term_id] = $taxonomy->name;
    }
  }
  return $return;
}
function kanews_get_terms_ilan_tag() {
  $taxonomies = get_terms( array(
    'taxonomy' => 'ilan-etiket',
    'hide_empty' => true,
  ) );
  $return = array();
  if( !is_wp_error($taxonomies) ) {
    foreach($taxonomies as $taxonomy) {
      $return[$taxonomy->term_id] = $taxonomy->name;
    }
  }
  return $return;
}
function kanews_get_terms_firma_kategori() {
  $taxonomies = get_terms( array(
    'taxonomy' => 'kategori',
    'hide_empty' => true,
  ) );
  $return = array();
  if( !is_wp_error($taxonomies) ) {
    foreach($taxonomies as $taxonomy) {
      $return[$taxonomy->term_id] = $taxonomy->name;
    }
  }
  return $return;
}

function get_currencies_arrays() {
  return array(
    'usd' => esc_html__('Dolar'),
    'euro' => esc_html__('Euro'),
    'chf' => esc_html__('İsviçre Frangı'),
    'jpy' => esc_html__('Japon Yeni'),
    'rub' => esc_html__('Rus Rublesi'),
    'rub' => esc_html__('Rus Rublesi'),
    'cny' => esc_html__('Çin Yuanı'),
    'gbp' => esc_html__('İngiliz Sterlini'),
    'eur-usd' => esc_html__('Euro/Dolar'),
    'ise-100' => esc_html__('Bist 100'),
    'ukoil' => esc_html__('Petrol'),
    'gau' => esc_html__('Gram Altın'),
    'btc' => esc_html__('Bitcoin'),
    'eth' => esc_html__('Ethereum'),
    'bch' => esc_html__('Bitcoin Cash'),
    'xrp' => esc_html__('XRP'),
    'ltc' => esc_html__('Litecoin'),
    'bnb' => esc_html__('Binance Coin'),
    'sol' => esc_html__('Solana'),
    'avax' => esc_html__('Avalanche'),
    'ada' => esc_html__('Cardano'),
    'dot' => esc_html__('Polkadot'),
    'doge' => esc_html__('Doge Coin'),
    'shib' => esc_html__('Shiba Inu')
  );
}
