<?php
defined( 'ABSPATH' ) || exit; // Exit if accessed directly


// Check core class for avoid errors
if( class_exists( 'CSF' ) ) {

  $prefix = 'kanews_translate';

  CSF::createOptions( $prefix, array(
    'menu_title' => esc_html__('Çeviri', 'kanews'),
    'menu_slug'  => 'kanews-translate',
    'menu_type'           => 'submenu',
    'menu_parent'         => 'kanews-options',
    'framework_title'     => esc_html__('Kanews Tema Ayarları', 'kanews'),
    'show_bar_menu' => false,
    'admin_bar_menu_icon' => 'dashicons-admin-generic',
    'footer_credit'         => esc_html__('Kan Themes Gururla Sunar.', 'kanews'),
    'footer_text'         => '',
    'theme'               => 'light'
	) );

  /**
	 * Translate
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Çeviri', 'kanews' ),
		'icon'        => 'fas fa-language',
		'fields'      => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Çeviri', 'kanews'),
      ),

      array(
        'type'    => 'content',
        'content' => 'Burada olmayan kelime veya cümleleri değiştirmek için aşağıdaki adımları takip edin.<br><br>
        - Wp Admin paneline giriş yapın<br>
        - Sol panelden Eklentiler>Yeni Ekle kısmına girin ve arama kısmına Loco Translate yazın<br>
        - Arama sonuçlarından Loco Translate eklentisini bulun ve Şimdi Kur butonuna tıklayın biraz bekleyin ve karşınıza çıkan Etkinleştir butonuna tıklayın<br>
        - Sayfayı yenileyin ve sol panelden Loco Translate>Temalar kısmına girin Kanews bölümüne tıklayın<br>
        - Açılan sayfada Yeni dil butonuna tıklayın<br>
        - Açılan sayfada Turkish dilini seçin, hemen altında Bir yer seçin: bölümünde ise Diğer kısmındaki “languages/themes/kanews-tr_TR.po” seçeneğini seçin<br>
        - Ardından Çeviri Yapmaya başla butonuna tıklayın ve karşınıza gelen çevirilebilecek kelime/cümleleri çevirmeye başlayın.<br>
        ',
      ),

      array(
        'type'    => 'heading',
        'content' => esc_html__('Çeviri', 'kanews'),
      ),
      // Breadcrumb Birincil
      array(
        'id'      => 'post-breacrumb-main-title',
        'type'    => 'text',
        'title'   => esc_html__('Haberler', 'kanews'),
        'subtitle'    => esc_html__('Breadcrumb birincil link yazısı.', 'kanews'),
      ),
      // Breaking News Title
      array(
        'id'      => 'breaking-new-text',
        'type'    => 'text',
        'title'   => esc_html__('Son Gelişmeler', 'kanews'),
        'subtitle'   => esc_html__('Header sol üstte son dakika çubuğunun başlık yazısı.', 'kanews'),
      ),
      // Like System
      array(
        'id'      => 'like-text',
        'type'    => 'text',
        'title'   => esc_html__('Beğen', 'kanews'),
      ),
      array(
        'id'      => 'unlike-text',
        'type'    => 'text',
        'title'   => esc_html__('Vazgeç', 'kanews'),
        'subtitle'   => esc_html__('Beğenmekten vazgeç', 'kanews'),
      ),

      
      // Bookmark System
      array(
        'id'      => 'bookmark-text',
        'type'    => 'text',
        'title'   => esc_html__('Favorilerime Ekle', 'kanews'),
      ),
      array(
        'id'      => 'unbookmark-text',
        'type'    => 'text',
        'title'   => esc_html__('Favorilerimden Çıkar', 'kanews'),
      ),
      array(
        'id'      => 'related-posts-text',
        'type'    => 'text',
        'title'   => esc_html__('Benzer Haberler', 'kanews'),
      ),
      array(
        'id'      => 'related-post-text',
        'type'    => 'text',
        'title'   => esc_html__('Gözden Kaçmasın', 'kanews'),
      ),
      array(
        'id'      => 'popular-comments-title',
        'type'    => 'text',
        'title'   => esc_html__('Öne Çıkan Yorumlar', 'kanews'),
      ),
      array(
        'id'      => 'login-description',
        'type'    => 'text',
        'title'   => get_bloginfo( 'name' ).' ayrıcalıklarından yararlanmak için hemen giriş yapın veya hesap oluşturun, üstelik tamamen ücretsiz!',
      ),
      array(
        'id'      => 'register-text',
        'type'    => 'text',
        'title'   => esc_html__('Tamamen ücretsiz olarak üyeliğinizi başlatın.', 'kanews'),
      ),
      array(
        'id'      => 'login-text',
        'type'    => 'text',
        'title'   => esc_html__('Zaten hesabınız var mı? O zaman giriş yapın.', 'kanews'),
      ),
      array(
        'id'      => 'account-text',
        'type'    => 'text',
        'title'   => esc_html__('Hesap panonuz sayfasında kaydettiğiniz haberlere, yaptığınız yorumlara ulaşabilir ve şifreniz ile hesap ayrıntılarınızı düzenleyebilirsiniz.', 'kanews'),
      ),
      array(
        'id'      => 'show-children',
        'type'    => 'text',
        'title'   => esc_html__('Yanıtları Göster', 'kanews'),
      ),
      array(
        'id'      => 'hide-children',
        'type'    => 'text',
        'title'   => esc_html__('Yanıtları Gizle', 'kanews'),
      ),
      array(
        'id'      => 'subscribe-post-title',
        'type'    => 'text',
        'title'   => esc_html__('Bu içerik abonelirimize özel olarak hazırlanmıştır.', 'kanews'),
      ),
      array(
        'id'      => 'subscribe-post-desc',
        'type'    => 'text',
        'title'   => esc_html__('İlgili içeriği görebilmek için hemen bir abonelik başlatın veya zaten aboneyseniz giriş yapın.', 'kanews'),
      ),
      array(
        'id'          => 'search-form-text',
        'type'        => 'text',
        'title'       => esc_html__('Aramak istediğiniz kelimeyi yazın..', 'kanews'),
      ),
      array(
        'id'          => 'privacy-policy-text',
        'type'        => 'text',
        'title'       => esc_html__('Bu web sitesinde en iyi deneyimi yaşamanızı sağlamak için çerezler kullanılmaktadır.', 'kanews'),
      ),
      array(
        'id'          => '404-page-title',
        'type'        => 'text',
        'title'       => esc_html__('Aradığınız Sayfa Bulunamadı!', 'kanews'),
      ),
      array(
        'id'          => '404-page-desc',
        'type'        => 'text',
        'title'       => esc_html__('Aradığınız sayfaya ulaşamadık silinmiş, geçici olarak kaldırılmış veya böyle bir sayfa hiç olmamış olabilir, lütfen daha sonra tekrar deneyiniz.', 'kanews'),
      ),
      array(
        'id'          => 'kanews-add-post-text',
        'type'        => 'text',
        
        'title'       => esc_html__('Paylaştığınız içerik editörümüz tarafından incelendikten sonra uygun görüldüğü taktirde yayınlanacaktır.', 'kanews'),
      ),

      array(
        'id'      => 'related-posts2-title',
        'type'    => 'text',
        'title'   => esc_html__('Göz Atın', 'kanews'),
        
      ),

      array(
        'id'          => 'post-submit-text',
        'type'        => 'text',
        
        'title'       => esc_html__('İçerik Gönder', 'kanews'),
      ),
      array(
        'id'          => 'write-a-comment-text',
        'type'        => 'text',
        
        'title'       => esc_html__('Bir Cevap Yaz', 'kanews'),
      ),
      array(
        'id'          => 'feed-description',
        'type'        => 'text',
        
        'title'       => esc_html__('Deneyimini kişiselleştirmene yardımcı olması için, ilgini çeken birkaç konu seç. Takip edebileceğin konulara aşağıdan ulaşabilirsin.', 'kanews'),
      ),
      array(
        'id'          => 'feed-title',
        'type'        => 'text',
        
        'title'       => esc_html__('İlgi alanların neler?', 'kanews'),
      ),
      array(
        'id'          => 'login-left-title',
        'type'        => 'text',
        'title'       => esc_html__('Topluluğumuza hoş geldiniz', 'kanews'),
      ),
      array(
        'id'          => 'login-left-description',
        'type'        => 'text',
        'title'       => esc_html__('Kişiselleştirilmiş, günlük olarak güncellenen ve güzel bir şekilde sunulan platformumuzda, işlevselliğine tam erişim elde etmek için hesap oluşturun.', 'kanews'),
      ),
      array(
        'id'          => 'comp-insights-text',
        'type'        => 'text',
        'title'       => esc_html__('Firmanın aboneliği olmadığı ilgili bilgi gizlenmiştir.', 'kanews'),
      ),
      array(
        'id'          => 'kanews-insights-button-text',
        'type'        => 'text',
        'title'       => esc_html__('Premium\'a Geç', 'kanews'),
      ),
      array(
        'id'          => 'subscrion-plan-text',
        'type'        => 'text',
        'title'       => esc_html__('Reklamsız bir deneyim için, premium içeriklere erişebilmek için hemen planını seç ve bir premium başlat.', 'kanews'),
      ),
      array(
        'id'          => 'read-more',
        'type'        => 'text',
        'title'       => esc_html__('Devamını Oku', 'kanews'),
      ),
      array(
        'id'          => 'news-read',
        'type'        => 'text',
        'title'       => esc_html__('Haberi Oku', 'kanews'),
      ),

		)
	) );


}