<?php

/*-----------------------------------------------------------------------------------*/
# Site Logo
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_logo' ) ) {
	function kanews_logo() {
		$logo = [
			'logo' => kanews_get_option('logo'),
			'logo2' => kanews_get_option('logo-mobile'),
			'url'  => trailingslashit(get_site_url()),
			'name' => get_bloginfo('name'),
		];

		if( is_category() || is_singular() ) {
			$term_id = is_category() ? (int) get_category(get_query_var('cat'),false)->term_id : (int) Kanews\Helper_Wp::primary_category_id(get_the_ID());
			if( ($logo_category = get_term_meta( $term_id, 'kanews_logo', true) ) && isset($logo_category['type']) && $logo_category['type'] != 'default' ) {
				$logo['logo'] = $logo_category;
				if( ($logo_category = get_term_meta( $term_id, 'kanews_logo_mobile', true) ) && isset($logo_category['type']) && $logo_category['type'] != 'default' ) {
					$logo['logo2'] = $logo_category;
				} else {
					$logo['logo2'] = $logo['logo'];
				}
			}
			
		}

		echo '<div class="site-header-logo">';
			if ($logo['logo']['type'] == 'img' && $logo['logo']['logo-img']['url'] != '' ) {
					echo '<a href="'.esc_url( $logo['url'] ).'" title="'.esc_attr($logo['name']).'">';
						if($logo['logo2']['url'] != '')
							echo '<img class="logo-light" src="'.esc_url($logo['logo']['logo-img']['url']).'" srcset="'.esc_url($logo['logo2']['url']).' 2x, '.esc_url($logo['logo']['logo-img']['url']).' 1x" alt="'.esc_attr($logo['logo']['logo-img']['alt']).'" width="'.esc_attr($logo['logo']['logo-img']['width']).'" height="'.esc_attr($logo['logo']['logo-img']['height']).'" />';
						else
							echo '<img class="logo-light" src="'.esc_url($logo['logo']['logo-img']['url']).'" alt="'.esc_attr($logo['logo']['logo-img']['alt']).'" width="'.esc_attr($logo['logo']['logo-img']['width']).'" height="'.esc_attr($logo['logo']['logo-img']['height']).'" />';
					echo '</a>';
			}
			else {
					if($logo['logo']['logo-text'] != '') 
						echo '<a class="site-logo-text" href="'.esc_url( $logo['url'] ).'" title="'.esc_attr($logo['logo']['logo-text']).'">'.$logo['logo']['logo-text'].'</a>';
					else 
						echo '<a class="site-logo-text" href="'.esc_url( $logo['url'] ).'" title="'.esc_attr($logo['name']).'">'.$logo['name'].'</a>';
			}
			if( is_archive() ) {
				if( is_category() || is_tag() )
				echo '<h1 class="sr-only" hidden>'.sprintf(esc_html__( '%s Haberleri', 'kanews' ), single_cat_title('', false)).'</h1>';
				else
				echo '<h1 class="sr-only" hidden>'.single_cat_title('', false).'</h1>';
			}elseif( !is_singular() ){
				echo '<h1 class="sr-only" hidden>'.$logo['name'].'</h1>';
			}
		echo '</div>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Site Nav Menu
/*-----------------------------------------------------------------------------------*/
function kanews_header_nav_menu() {
	$location = 'menu-1';
	$args = array(
			'theme_location' => $location,
			'menu_class'     => 'site-navbar-nav',
			'depth'          => 4,
			'container'      => false,
	);
	
	if (is_category() || is_singular()) {
			$term_id = is_category() ? (int) get_category(get_query_var('cat'), false)->term_id : (int) Kanews\Helper_Wp::primary_category_id(get_the_ID());
	
			if (($menu_category = get_term_meta($term_id, 'kanews_menu', true))) {
					$menu_object = wp_get_nav_menu_object($menu_category);
	
					if ($menu_object) {
							// Menü slug'ını al
							$args['theme_location'] = ''; // Tema konumunu kaldır
							$args['menu'] = $menu_object->slug;
					}
			}
	}
	
	if (has_nav_menu($location)) {
			wp_nav_menu($args);
	 } else { ?>
			<ul class="site-navbar-nav">
					<li class="current-menu-item"><a href="<?php echo admin_url('nav-menus.php'); ?>"><?php esc_html_e('Menü Oluştur', 'kanews'); ?></a></li>
			</ul>
	<?php  }
}

/*-----------------------------------------------------------------------------------*/
# Site Footer Logo
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_footer_logo' ) ) {
	function kanews_footer_logo() {
		$logo = [
			'logo' => kanews_get_option('logo-2'),
			'url'  => get_site_url(),
			'name' => get_bloginfo('name'),
		];
		echo '<div class="site-footer-logo">';
			if ($logo['logo']['type'] == 'img' && $logo['logo']['logo-img']['url'] != '' ) {
					echo '<a href="'.esc_url( apply_filters( 'Kanews/Logo/url', $logo['url'] ) ).'" title="'.$logo['name'].'"><img src="'.$logo['logo']['logo-img']['url'].'" alt="'.$logo['logo']['logo-img']['alt'].'" width="'.$logo['logo']['logo-img']['width'].'" height="'.$logo['logo']['logo-img']['height'].'" /></a>';
			}
			else {
					if($logo['logo']['logo-text'] != '') {
						echo '<a class="site-logo-text" href="'.esc_url( apply_filters( 'Kanews/Logo/url', $logo['url'] ) ).'" title="'.$logo['logo']['logo-text'].'">'.$logo['logo']['logo-text'].'</a>';
					} else {
						echo '<a class="site-logo-text" href="'.esc_url( apply_filters( 'Kanews/Logo/url', $logo['url'] ) ).'" title="'.$logo['name'].'">'.$logo['name'].'</a>';
					}
			}
		echo '</div>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Sosyal Hesaplar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_social_links' ) ) {
	function kanews_social_links($class = '', $class2 = 'd-flex') {
		$social = [
			'links'  => kanews_get_option('social-links'),
		];

		if($social['links']) {
			echo '<div class="site-social-links '.$class.'"><ul class="'.$class2.'">';
			foreach($social['links'] as $link) {
				if ($link['url'] != '' && $link['icon'] != '') {
					echo '<li><a rel="nofollow" title="'.esc_attr($link['title']).'" href="'.esc_url($link['url']).'"><i class="'.esc_attr($link['icon']).'"></i></a></li>';
				}
			}
			echo '</ul></div>';
		}
  }
}

/*-----------------------------------------------------------------------------------*/
# Big Menu
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_header_big_menu' ) ) {
	function kanews_header_big_menu() {
		if ( ! kanews_get_option('big-menu') || kan_is_mobile() )
		return;
	
		echo '<div id="site-menu-block" class="site-menu-block-'.kanews_get_option('big-menu-style', 'style-1').'"><div class="container"><div class="row">';
		if ( has_nav_menu( 'big-menu' ) ) :
			wp_nav_menu( array(
				'theme_location' => 'big-menu',
				'menu_class'     => 'site-menu-block',
				'depth'     		 => '2',
				'container'      => false,
			));
		else: ?>
			<ul class="d-flex"><li><a href="<?php echo admin_url( 'nav-menus.php' ); ?>"><?php esc_html_e( 'Menü Oluştur', 'kanews' ); ?></a></li></ul>
		<?php endif;?>
		<div class="col-12 justify-content-between site-menu-block-footer d-flex flex-wrap align-items-center">
		<?php kanews_social_links('', 'd-flex justify-content-end'); ?>
          <?php if( has_nav_menu( 'menu-3' ) ): ?>
              <div class="site-footer-menu">
                <?php wp_nav_menu( array(
                  'theme_location' => 'menu-3',
                  'menu_class'     => 'd-flex flex-wrap justify-content-center gap-1',
                  'depth'     		 => '1',
                  'container'      => false,
                )); ?>
              </div>
          <?php endif; ?>
            
          </div>
		<?php echo '</div></div></div>';
	}
}
# Big Menu Btn
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_header_big_menu_btn' ) ) {
	function kanews_header_big_menu_btn() {
		if (kanews_get_option('big-menu') == false)
		return;
		
		echo '<button class="site-drawer-menu-btn hidden-mobile header-btn-icon" aria-label="'.esc_html__( 'Menüyü Aç', 'kanews' ).'" data-toggle="site-menu-block"><svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="ellipsis-v"><path fill="currentColor" d="M12,7a2,2,0,1,0-2-2A2,2,0,0,0,12,7Zm0,10a2,2,0,1,0,2,2A2,2,0,0,0,12,17Zm0-7a2,2,0,1,0,2,2A2,2,0,0,0,12,10Z"></path></svg></button>';
	}
}


/*-----------------------------------------------------------------------------------*/
# Breaking News
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_breaking_news_ticker' ) ) {
	function kanews_breaking_news_ticker($title, $query, $control, $date, $sortby = '', $widget = null) {
		if ($query->have_posts()) {
			echo '<div class="kanews-ticker-wrapper col pr-0"><div class="row no-gutters">';

				if ($title != '') 
					echo '<div class="col-auto"><div class="kanews-ticker-heading"><span>'.$title.'</span></div></div>';
					if (isset($control))
					echo '<div class="kanews-ticker-control col-auto"><button class="kanews-ticker-prev" aria-label="'.esc_html__( 'Önceki', 'kanews' ).'"><svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="arrow-circle-left"><path fill="currentColor" d="M8.29,11.29a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l3,3a1,1,0,0,0,1.42-1.42L11.41,13H15a1,1,0,0,0,0-2H11.41l1.3-1.29a1,1,0,0,0,0-1.42,1,1,0,0,0-1.42,0ZM2,12A10,10,0,1,0,12,2,10,10,0,0,0,2,12Zm18,0a8,8,0,1,1-8-8A8,8,0,0,1,20,12Z"></path></svg></button><button aria-label="'.esc_html__( 'Sonraki', 'kanews' ).'" class="kanews-ticker-next"><svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="arrow-circle-right"><path fill="currentColor" d="M15.71,12.71a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L12.59,11H9a1,1,0,0,0,0,2h3.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0ZM22,12A10,10,0,1,0,12,22,10,10,0,0,0,22,12ZM4,12a8,8,0,1,1,8,8A8,8,0,0,1,4,12Z"></path></svg></button></div>';
			
					echo '<div class="kanews-ticker col"><ul class="kanews-ticker-slider">';
						while($query->have_posts()): $query->the_post(); global $post;
							if($sortby == 'post-modified' || $sortby == 'modified')
							$time = get_post_modified_time('G:i');
							else
							$time = get_the_time('G:i');
							$date = ($date == true) ? '<span class="kanews-ticker-date hidden-mobile">'.$time.' </span>' : '';
							echo '<li><a href="'.get_the_permalink($post->ID).'">'.$date.' <div class="kanews-ticker-title truncate truncate-1">'.get_the_title($post->ID).'</div></a></li>';
						endwhile; wp_reset_postdata();
					echo '</ul></div>';

			echo '</div></div>';
		} else {
			echo esc_html__( 'Haber bulanamadı.', 'kanews' );
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Search Form
/*-----------------------------------------------------------------------------------*/
function kanews_header_search_form($type) {
	$option = [
		'switch' => $type,
		'text'   => kanews_translate('search-form-text',  esc_html__( 'Aramak istediğiniz kelimeyi yazın..', 'kanews' ))
	];
	$form = '';
	if ($option['switch'] == 'style1' ) {
		$form = '<form role="search" method="get" class="site-header-search-form " action="' . esc_url( home_url( '/' ) ) . '">
			<i class="icon-search"></i>
			<input data-style="row" class="kanews-ajax-search" type="text" placeholder="' . esc_attr($option['text']) .'" value="' . get_search_query() . '" name="s" />
			<button type="submit">'.esc_html__( 'Ara', 'kanews' ).'</button>
			<div id="kanews-loader"></div>
		</form>';
	} elseif($option['switch'] == 'style2' ) {
		$class = '';
		if( ! kanews_get_option('search-button-mobile', false) )
		$class = 'hidden-mobile';
		$form = '<div id="site-header-search" class="kanews-ajax-search-wrapper '.$class.'"> <button aria-label="'.esc_html__( 'Ara', 'kanews' ).'" class="header-btn-icon" data-toggle="site-header-search-wrapper"><i class="icon-search"></i></button>
		<div id="site-header-search-wrapper" class="is-hidden"><form role="search" method="get" class="site-header-search-form" action="' . esc_url( home_url( '/' ) ) . '">
		<input class="kanews-ajax-search" type="text" placeholder="' . esc_attr($option['text']) .'" value="' . get_search_query() . '" name="s" />
		<button aria-label="'.esc_html__( 'Ara', 'kanews' ).' type="submit"><span class="icon-search icon-2x"></span></button><p>'.esc_html__( 'Aradığınız kelimeyi yazın ve entera basın, kapatmak için esc butonuna tıklayın.', 'kanews' ).'</p>
		<div id="kanews-loader"></div></form><div class="kanews-popup-close-btn search-close-btn"><i class="icon-close"></i></div></div></div>';
	}
	echo $form;
}

/*-----------------------------------------------------------------------------------*/
# Header Action Button
/*-----------------------------------------------------------------------------------*/
function kanews_header_action_btn() {
	$option = kanews_get_option('action-button');
	$option3 = kanews_get_option('action-button-mobile', true) ? '' : 'hidden-mobile';
	$option2 = kanews_get_option('action-buttons');
	$style = kanews_get_option('action-buttons-style', 'style1');
	$popular = '';

	if ( ! $option || !is_array($option2) || empty($option2) )
	return;
		
	if( $style == 'style3' ) {
		echo '<div class="site-header-action-wrap">';
			foreach ($option2 as $action) {
				if ($action['title'] && (!empty($action['img']) || !empty($action['icon'])) && (!empty($action['url']) || !empty($action['page']))) {
					if ($action['link_type'] == 'page') {
							$page_link = $action['page'] != '' ? get_page_link($action['page']) : '#';
					} else {
							$page_link = esc_url($action['url']);
					}
					if ($action['icon_type'] == 'image') {
							$icon = kanews_get_local_image($action['img'], array('width' => 20, 'height' => 20, 'alt' => 'icon'));
					} else {
							$icon = '<i class="' . $action['icon'] . '"></i>';
					}
					$bg_color = '';
					if ($action['color'] != '') {
							$style = 'style="background: ' . $action['color'] . '"';
					} else {
							$style = '';
					}
					
					$blank = isset($action['blank']) && $action['blank'] ? 'target="_blank"' : '';

					echo '<a href="' . $page_link . '"  ' . $blank . ' ' . $style . ' class="site-header-action-item">'. $icon .'</a>';
				}
			}
		echo '</div>';
	} else {
		echo '<div class="site-header-action ' . $option3 . '"><button role="button" aria-expanded="false" data-toggle="site-header-action-content" aria-label="' . esc_html__('Servisler', 'kanews') . '" class="header-btn-icon"><i aria-hidden="true" class="icon-grid"></i></button>';
		echo '<div id="site-header-action-content"><div class="site-header-action-wrapper kanews-scroll site-header-action-' . $style . '">';
		echo '<button data-toggle="site-header-action-content" aria-label="' . esc_html__('Kapat', 'kanews') . '"><i class="icon-close"></i></button>';

		$popular = '';
		foreach ($option2 as $action) {
				if (isset($action['popular']) && $action['popular']) {
						if ($action['title'] && (!empty($action['img']) || !empty($action['icon'])) && (!empty($action['url']) || !empty($action['page']))) {
								if ($action['link_type'] == 'page') {
										$page_link = $action['page'] != '' ? get_page_link($action['page']) : '#';
								} else {
										$page_link = esc_url($action['url']);
								}
								if ($action['icon_type'] == 'image') {
										$icon = kanews_get_local_image($action['img'], array('width' => 20, 'height' => 20, 'alt' => 'icon'));
								} else {
										$icon = '<i class="' . $action['icon'] . '"></i>';
								}
								$bg_color = '';
								if ($action['color'] != '') {
										$style = 'style="background: ' . $action['color'] . '"';
										$split = hexToRgb($action['color']);
										if (isset($split['r']) && isset($split['g']) && isset($split['b'])) {
												$r = $split['r'];
												$g = $split['g'];
												$b = $split['b'];
												$bg_color = "rgb(" . $r . ", " . $g . ", " . $b . ", 0.25)";
										}
								} else {
										$style = '';
								}

								$blank = isset($action['blank']) && $action['blank'] ? 'target="_blank"' : '';
								$popular .= '<a href="' . $page_link . '"  ' . $blank . ' class="site-header-action-btn">';
								$popular .= '<div class="site-header-action-btn-wrapper" ' . (($bg_color != '') ? 'style="background-color:' . $bg_color . '"' : '') . '>';
								$popular .= '<div class="site-header-action-icon bg-primary" ' . $style . '>' . $icon . '</div>';
								$popular .= '<div class="site-header-action-content">';
								$popular .= '<div class="site-header-action-name">' . $action['title'] . '</div>';
								$popular .= '<div class="site-header-action-desc truncate truncate-2">' . $action['desc'] . '</div>';
								$popular .= '</div>';
								$popular .= '</div>';
								$popular .= '</a>';
						}
				}
		}

		if ($popular != '')
		echo '<div class="site-header-action-btn-group popular5"><div class="onjkln2">' . esc_html__('Popüler', 'kanews') . '</div>' . $popular . '</div>';
		echo '<div class="site-header-action-btn-group"><div class="onjkln2">' . esc_html__('Hızlı Erişim', 'kanews') . '</div>';
		foreach ($option2 as $action) {
				if (isset($action['use-title']) && $action['use-title'] && !empty($action['title'])) {
						echo '<div class="onjkln2">' . $action['title'] . '</div>';
				} elseif (!isset($action['popular']) || !$action['popular']) {
						if ($action['title'] && (!empty($action['img']) || !empty($action['icon'])) && (!empty($action['url']) || !empty($action['page']))) {
								if ($action['link_type'] == 'page') {
										$page_link = $action['page'] != '' ? get_page_link($action['page']) : '#';
								} else {
										$page_link = esc_url($action['url']);
								}
								if ($action['icon_type'] == 'image') {
										$icon = kanews_get_local_image($action['img'], array('width' => 20, 'height' => 20, 'alt' => 'icon'));
								} else {
										$icon = '<i class="' . $action['icon'] . '"></i>';
								}
								$bg_color = '';
								if (isset($action['color']) && $action['color'] != '') {
										$style = 'style="background: ' . $action['color'] . '"';
										$split = hexToRgb($action['color']);
										if (isset($split['r']) && isset($split['g']) && isset($split['b'])) {
												$r = $split['r'];
												$g = $split['g'];
												$b = $split['b'];
												$bg_color = "rgb(" . $r . ", " . $g . ", " . $b . ", 0.25)";
										}
								} else {
										$style = '';
								}

								$blank = isset($action['blank']) && $action['blank'] ? 'target="_blank"' : '';

								echo '<a href="' . $page_link . '"  ' . $blank . ' class="site-header-action-btn">';
								echo '<div class="site-header-action-btn-wrapper" ' . (($bg_color != '') ? 'style="background-color:' . $bg_color . '"' : '') . '>';
								echo '<div class="site-header-action-icon bg-primary" ' . $style . '>' . $icon . '</div>';
								echo '<div class="site-header-action-content">';
								echo '<div class="site-header-action-name">' . $action['title'] . '</div>';
								if (isset($action['desc']) && $action['desc'] != '') 
								echo '<div class="site-header-action-desc truncate truncate-2">' . $action['desc'] . '</div>';
								echo '</div>';
								echo '</div>';
								echo '</a>';
						}
				}
		}
		echo '</div></div></div></div>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Post Thumbnail : Manset
/*-----------------------------------------------------------------------------------*/
function kanews_manset_thumbnail($image_src) {
	$lazy = kanews_get_option('lazy');
	if ($lazy != true) {
		echo '<div class="kanews-slide-thumb"><img width="'.$image_src[1].'" height="'.$image_src[2].'" src="'.$image_src[0].'"  alt="manset" /></div>';
	} else {
		echo '<div class="kanews-slide-thumb"><img width="'.$image_src[1].'" height="'.$image_src[2].'" class="kanews-lazy" src="'.kanews_lazy_link().'" data-src="'.$image_src[0].'"  alt="manset" /></div>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Post Thumbnail
/*-----------------------------------------------------------------------------------*/
function kanews_post_thumbnail($size = '', $class = '', $href = false, $return = false) {
	if ( post_password_required())
	return;

	$default = kanews_get_option('default-thumbnail') ? kanews_get_option('default-thumbnail') : '';
	
	if(!has_post_thumbnail() && isset($default['id']) && $default['id'] == '')
	return;

	if($return)
	ob_start();

	if ( $href == false ) :
		?>

		<div class="<?php echo $class; ?>">
			<?php kanews_post_format(); ?>
			<?php if (has_post_thumbnail()): ?>
				<?php the_post_thumbnail($size); ?>
			<?php elseif(isset($default['id']) && $default['id'] != ''):  ?>
				<?php echo wp_get_attachment_image($default['id'], $size); ?>
			<?php endif; ?>
		</div>

	<?php else : ?>

		<a class="<?php echo $class; ?>" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php kanews_post_format(); ?>
			<?php if (has_post_thumbnail()): ?>
			<?php
				the_post_thumbnail(
					$size,
					array(
						'alt' => the_title_attribute(
							array(
								'echo' => false,
							)
						),
					)
				);
			?>
			<?php elseif( isset($default['id']) ): ?>
				<?php echo wp_get_attachment_image($default['id'], $size); ?>
			<?php endif; ?>
		</a>

		<?php
	endif;

	if($return)
	return ob_get_clean();

}

/*-----------------------------------------------------------------------------------*/
# Post Featured
/*-----------------------------------------------------------------------------------*/
function kanews_post_featured($pid, $size = 'large') {
 
		

		$video = false;

		if( get_post_format() != 'video' ) {
			if($video_embed = get_post_meta($pid, 'video_embed', true )): ?>
				<div class="kanews-video embed-container">
					<?php echo wp_oembed_get($video_embed); ?>
				</div>
			<?php $video = true; elseif($video_src = get_post_meta($pid, 'video_src', true )): ?>
				<div class="kanews-video embed-container">
					<video controls >
						<source loading="lazy" type="video/mp4" src="<?php echo esc_attr($video_src); ?>">
					</video>
				</div>
			<?php $video = true; elseif($iframe_src = get_post_meta($pid, 'iframe_src', true )): ?>
				<div class="kanews-video embed-container">
					<iframe frameborder="0" src="<?php echo esc_attr($iframe_src); ?>" class="embed-containers" loading="lazy"></iframe>
				</div>
			<?php $video = true; endif;
		}

		if($video) {
			return;
		}

		$caption = get_the_post_thumbnail_caption();
		$custom_thumb = get_post_meta($pid, 'kanews_post_featured', true);
		$thumb_id = ( !empty($custom_thumb) && isset($custom_thumb['id']) && !empty($custom_thumb['id']) ) ? get_post_meta($pid, 'kanews_post_featured', true)['id'] : get_post_thumbnail_id( $pid );
		$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
		$alt_tag = $alt ? $alt : 'featured'; 
		?>
		<?php if(get_post_meta($pid, 'show_post_thumbnail', true ) == 'on' ): ?>
			<div class="kanews-article-thumbnail">
				<?php $thumbnail = wp_get_attachment_image_src($thumb_id, $size); ?>
				<img class="wp-post-image" src="<?php echo $thumbnail[0]; ?>" width="<?php echo $thumbnail[1]; ?>" height="<?php echo $thumbnail[2]; ?>" alt="<?php echo $alt_tag; ?>"/>
				<?php if($caption): ?>
				<div class="kanews-article-thumbnail-caption"><?php echo $caption; ?></div>
				<?php endif; ?>
			</div>
    <?php elseif(get_post_meta( $pid, 'show_post_thumbnail', true ) != 'off' && kanews_get_option('show-post-thumbnail') != false  ): ?>
	<?php $thumbnail = wp_get_attachment_image_src($thumb_id, $size); ?>
	<?php if( !empty($thumbnail)) : ?>
      <div class="kanews-article-thumbnail">
			
				<img class="wp-post-image" src="<?php echo $thumbnail[0]; ?>" width="<?php echo $thumbnail[1]; ?>" height="<?php echo $thumbnail[2]; ?>" alt="<?php echo $alt_tag; ?>"/>
				<?php if($caption): ?>
				<div class="kanews-article-thumbnail-caption"><?php echo $caption; ?></div>
				<?php endif; ?>
			</div>
			<?php endif; ?>
    <?php endif; 
}

/*-----------------------------------------------------------------------------------*/
# Read More
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_post_format' ) ) {
	function kanews_post_format() { ?>
		<?php $format = get_post_format(); if (false === $format) $format = 'standard'; ?>
		<?php if ($format == 'video') : ?>
			<div class="kanews-post-format" aria-label="<?php esc_attr__('Video Formatında Yazı', 'kanews'); ?>"><i aria-hidden="true" class="icon-play"></i></div>
		<?php elseif ($format == 'gallery') : ?>
			<div class="kanews-post-format" aria-label="<?php esc_attr__('Foto Galeri Formatında Yazı', 'kanews'); ?>"><i aria-hidden="true" class="icon-gallery"></i></div>
		<?php endif; ?>
	<?php }
}

/*-----------------------------------------------------------------------------------*/
# Read More
/*-----------------------------------------------------------------------------------*/
function kanews_read_more() {
	if(get_post_type() != 'columist')
	$title = kanews_translate('news-read', esc_html__( 'Haberi Oku', 'kanews' ));
	else
	$title = kanews_translate('read-more', esc_html__( 'Devamını Oku', 'kanews' ));
	return '<a class="kanews-label kanews-label-post kanews-label-widget" href="'.get_the_permalink().'">'.$title.'</a>';
}

/*-----------------------------------------------------------------------------------*/
# Paid
/*-----------------------------------------------------------------------------------*/
function kanews_paid_post_badge() {
	if ( ! class_exists( 'WooCommerce' ) )
	return;
	$pid = get_the_ID();
	$paid = get_post_meta( $pid, 'post_insight', true ) == 1 ? 1 : 0;
	
	if($paid == 0 )
	return false;

	echo '<div class="kanews-post-paid" aria-label="'.esc_html__( 'Ücretli İçerik', 'kanews' ).'" role="tooltip" data-microtip-position="right"><i class="icon-bolt"></i></div>';
}
/*-----------------------------------------------------------------------------------*/
# Add Bookmark
/*-----------------------------------------------------------------------------------*/
function kanews_add_bookmark() {
	$pid = get_the_ID();
	$default_options = (kanews_get_option('post-bookmark') == false) ? false : true;
	$single_options = get_post_meta( $pid, 'show_post_bookmark', true );
	if($default_options != false && $single_options != 'off' )
		echo kanews_bookmark_button($pid);
}

/*-----------------------------------------------------------------------------------*/
# Get Primary Category
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_primary_category' ) ) {
	function kanews_primary_category($id, $style = '') {
		if(kanews_get_option('cat-links') == true || get_post_type($id) != 'post')
		return false;

		if($id == '')
		return;

		$class     = 'kanews-category';
		$category  = (int) Kanews\Helper_Wp::primary_category_id($id);
		// return $category;


		if( ! empty( $category ) && Kanews\Helper_Wp::term_exists( $category, 'category' ) ){
			$get_the_category       = Kanews\Helper_Wp::get_term_by( 'id', $category, 'category' );
			$primary_category_name  = $get_the_category->name;
			$primary_category_link	= Kanews\Helper_Wp::get_term_link( $category, 'category' );
		} else{
			$get_the_category = get_the_category();
			$category = $get_the_category[0]->term_id;
			if( ! empty( $get_the_category[0] ) ){
				$primary_category_name  = $get_the_category[0]->name;
				$primary_category_link	= Kanews\Helper_Wp::get_term_link( $category, 'category' );
			} else {
				return;
			}
		}

		$cat   = '<a class="'.$class.' '.$style.' kanews-category-'.$category.'" href="'. esc_url( $primary_category_link ) .'">'. $primary_category_name .'</a>';

		return $cat;

	}
}

/*-----------------------------------------------------------------------------------*/
# Avatar
/*-----------------------------------------------------------------------------------*/
function kanews_user_avatar($author, $size, $clean = '', $circle = null) {
	$circle_class = $circle_svg = '';
	if($circle) {
		$circle_class = 'circle-animation';
		$circle_svg = '<svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg" style="enable-background:new -580 439 577.9 194;" xml:space="preserve"> <circle cx="50" cy="50" r="40"></circle> </svg>';
	}
	if($clean == 'yes')
	return get_avatar( $author, $size );
	else
	return '<div class="author-avatar '.$circle_class.'">'.$circle_svg.get_avatar( $author, $size ).'</div>';
}

/*-----------------------------------------------------------------------------------*/
# Lazyload Avatar
/*-----------------------------------------------------------------------------------*/
function kanews_lazyload_avatar( $avatar ){
	if( ! kanews_lazyload_active() || strpos( $avatar, 'data-src' ) !== false ){
		return $avatar;
	}

	$empty_image = kanews_lazyload_placeholder('1e1');

	$avatar = str_replace( '"', "'", $avatar );
	$avatar = str_replace( 'srcset=', 'data-srcset=', $avatar );
	$avatar = str_replace( "src='", "src='". $empty_image ."' data-src='", $avatar );
	$avatar = str_replace( "class='", "class='kanews-lazy ", $avatar );
	
	return $avatar;
}

/*-----------------------------------------------------------------------------------*/
# Widget Title
/*-----------------------------------------------------------------------------------*/
function kanews_widget_title($title, $tag = 'h4', $class = '') {
	if (empty($title))
	return;
	return '<div class="kanews-section-heading '.$class.'"><'.$tag.' class="kanews-section-headline"><span>'.$title.'</span></'.$tag.'></div>';
}

/*-----------------------------------------------------------------------------------*/
# Archives Pagination
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_pagination' ) ) {
	function kanews_pagination($pagination_type = '') {
		if( $pagination_type == '' )
		$pagination_type = (!empty(kanews_get_option('archives-pagination'))) ? kanews_get_option('archives-pagination') : 'classic';
		if ($pagination_type == 'classic') {
			echo '<div class="navigation pagination">';
				echo '<ul class="nav-links">';
					if(get_previous_posts_link())
					echo '<span class="page-numbers prev">'.get_previous_posts_link().'</span>';
					if(get_next_posts_link())
					echo '<span class="page-numbers next">'.get_next_posts_link().'</span>';
				echo '</ul>';
			echo '</div>';
		} elseif ($pagination_type == 'infinite' || $pagination_type == 'button') {
			$next_link = get_next_posts_link(__('Sonra'));
			if($next_link): ?>
			<div hidden>
				<div class="kanews_pagination_prev"><?php previous_posts_link( 'Önceki' ); ?></div>
				<div class="kanews_pagination_next"><?php next_posts_link( 'Sonraki'); ?></div>
			</div>
			<div id="load-more-posts-button-wrapper">
				<div style="display:none" class="page-load-status">
					<div class="loader-ellips infinite-scroll-request">
						<svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40px" height="40px" viewBox="0 0 40 40" enable-background="new 0 0 40 40" xml:space="preserve"> <path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/> <path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"> <animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/> </path> </svg>
					</div>
					<div class="infinite-scroll-last"><?php _e('Daha fazla gösterilecek yazı bulunamadı!', 'kanews'); ?></div>
					<div class="infinite-scroll-error"><?php _e('Tekrar deneyiniz.', 'kanews'); ?></div>
				</div>
				<?php if($pagination_type == 'button'): ?>
					<div class="col-8 col-md-6 m-auto"><button class="kanews-btn kanews-btn-block kanews-btn-sm kanews-btn-o" kanews-data-load-more-button><?php _e('Daha Fazla Yükle', 'kanews'); ?></button></div>
				<?php endif; ?>
			</div>
			<?php endif;
		} else {
			the_posts_pagination( array(
				'prev_text'          => '<i class="icon-arrow icon-90degg"></i>',
				'next_text'          => '<i class="icon-arrow icon-90deg"></i>',
				'mid_size' => 5,
			) );
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Post Date
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_posted_on' ) ) :
	function kanews_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date('j F Y, H:i') )
		);

		$posted_on = sprintf(
			/* translators: %s: post date. */
			esc_html_x( '%s yayınlandı', 'post date', 'kanews' ),
			$time_string
		);

		echo '<span class="posted-on">' . $posted_on . '</span>';
	}
endif;

/*-----------------------------------------------------------------------------------*/
# Post Update Date
/*-----------------------------------------------------------------------------------*/
function kanews_post_updated($pure = false) {
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-update-date updated" datetime="%1$s">%3$s, %2$s</time>';
		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date('H:i') ),
			esc_html( get_the_modified_date('j F Y') )
		);

		echo '<span class="updated-on">'.sprintf(esc_html_x( '%s güncellendi', 'post date', 'kanews' ), $time_string).'</span>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Post Author
/*-----------------------------------------------------------------------------------*/
function kanews_user_subscribe_badge($uid) {
	$sub = kanews_insights_control($uid);
	if($sub == false)
	return;
	
	$icon = '<svg viewBox="0 0 24 24" class="kanews-subscribe-icon"><g><path d="M22.5 12.5c0-1.58-.875-2.95-2.148-3.6.154-.435.238-.905.238-1.4 0-2.21-1.71-3.998-3.818-3.998-.47 0-.92.084-1.336.25C14.818 2.415 13.51 1.5 12 1.5s-2.816.917-3.437 2.25c-.415-.165-.866-.25-1.336-.25-2.11 0-3.818 1.79-3.818 4 0 .494.083.964.237 1.4-1.272.65-2.147 2.018-2.147 3.6 0 1.495.782 2.798 1.942 3.486-.02.17-.032.34-.032.514 0 2.21 1.708 4 3.818 4 .47 0 .92-.086 1.335-.25.62 1.334 1.926 2.25 3.437 2.25 1.512 0 2.818-.916 3.437-2.25.415.163.865.248 1.336.248 2.11 0 3.818-1.79 3.818-4 0-.174-.012-.344-.033-.513 1.158-.687 1.943-1.99 1.943-3.484zm-6.616-3.334l-4.334 6.5c-.145.217-.382.334-.625.334-.143 0-.288-.04-.416-.126l-.115-.094-2.415-2.415c-.293-.293-.293-.768 0-1.06s.768-.294 1.06 0l1.77 1.767 3.825-5.74c.23-.345.696-.436 1.04-.207.346.23.44.696.21 1.04z"></path></g></svg>';
	return '<span role="tooltip" data-microtip-position="bottom" aria-label="'.esc_html__( 'Abone', 'kanews' ).'" class="kanews-subscribe-badge">'.$icon.'</span>';
}

/*-----------------------------------------------------------------------------------*/
# Post Reading Time
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_post_reading_time' ) ) {
	function kanews_post_reading_time($post) {

		$content = $post->post_content;
		$word = str_word_count(strip_tags($content));
		$m = floor($word / 200);
		$s = floor($word % 200 / (200 / 60));
		$output = $m . __('dk', 'kanews') . ($m == 1 ? '' : '') . ', ' . $s . __('sn', 'kanews') . ($s == 1 ? '' : '');
		echo '<span class="kanews-reading-time"><div role="tooltip" data-microtip-position="bottom" aria-label="'.sprintf(esc_attr__( '%s okunabilir', 'kanews' ), $output).'"><i class="icon-bookmark"></i>';
			echo $output;
		echo '</div></span>';
	}
	
}
/*-----------------------------------------------------------------------------------*/
# Post Share
/*-----------------------------------------------------------------------------------*/
function kanews_post_share($pid = 0, $style = '') { 

	$links = (kanews_get_option('post-share')) ? kanews_get_option('post-share') : array('facebook', 'twitter','whatsapp', 'email'); 
	if( $style == '' )
	$style = (kanews_get_option('post-share-style')) ? kanews_get_option('post-share-style') : '1'; 
	$image = wp_get_attachment_image_src(get_post_thumbnail_id($pid), 'full');
	$title = str_replace('|',"\n", esc_attr(get_the_title($pid)));
	$permalink = esc_attr(get_permalink($pid));

	if($style == 5 || kan_is_mobile()): ?>
		<div style="cursor:pointer" class="kanews-label" data-toggle="kanews-popup-share-<?php echo $pid; ?>"><i class="icon-share"></i> <?php esc_html_e( 'Paylaş', 'kanews' ); ?></div>
		

	<div id="kanews-popup-share-<?php echo $pid; ?>" class="kanews-popup">
			<div class="kanews-popup-close" data-toggle="kanews-popup-share-<?php echo $pid; ?>"></div>
			<div class="kanews-popup-content">
			<div class="kanews-popup-close-btn" data-toggle="kanews-popup-share-<?php echo $pid; ?>"><i class="icon-close"></i></div>
				<h4 class="kanews-popup-title"><?php esc_html_e( 'Bu Yazıyı Paylaş', 'kanews' ); ?></h4>
				<ul class="d-flex kanews-popup-share">
					<?php foreach($links as $link ): ?>
						<?php $class = 'bg-'.$link; ?>
						<?php if ($link == 'facebook'): ?>
								<li><a class="<?php echo $class; ?>" rel="external noopener" target="_blank" href="//www.facebook.com/sharer/sharer.php?u=<?php echo $permalink; ?>"><i class="icon-facebook"></i></a></li>
							<?php endif;?>
							
							<?php if ($link == 'twitter'): ?>
								<li><a target="_blank" rel="external noopener" class="<?php echo $class; ?>" href="//www.twitter.com/intent/tweet?text=<?php echo $title; ?> <?php echo $permalink; ?>"><i class="icon-twitter"></i></a></li>
							<?php endif;?>
						
							<?php if ($link == 'whatsapp'): ?>
								<li class="hidden-desktop"><a class="<?php echo $class; ?>" href="whatsapp://send?text=<?php echo $permalink; ?>"><i class="icon-whatsapp"></i></a></li>
								<li class="hidden-mobile"><a class="<?php echo $class; ?>" href="https://api.whatsapp.com/send?text=<?php echo $title; ?> <?php echo $permalink; ?>"><i class="icon-whatsapp"></i></a></li>
							<?php endif; ?>
							
							<?php if ($link == 'pinterest'): ?>
								<li><a target="_blank" rel="external noopener" class="<?php echo $class; ?>" href="//pinterest.com/pin/create/button/?url=&media=<?php echo $image[0]; ?>&description=<?php echo $title; ?>&url=<?php echo $permalink; ?>"><i class="icon-pinterest"></i></a></li>
							<?php endif; ?>
							
							<?php if ($link == 'telegram'): ?>
								<li><a target="_blank" rel="external noopener" class="<?php echo $class; ?>" href="//t.me/share/url?url=<?php echo $permalink; ?>&text=<?php echo $title; ?>"><i class="icon-telegram"></i></a></li>
							<?php endif; ?>
							
							<?php if ($link == 'email'): ?>
								<li><a class="bg-dark kanews-native-share" title="<?php esc_html_e('Paylaş', 'kanews'); ?>" onclick="doSomething()"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" id="icon-share"><path fill="currentColor" d="m21.707 11.293-8-8A1 1 0 0 0 12 4v3.545A11.015 11.015 0 0 0 2 18.5V20a1 1 0 0 0 1.784.62 11.456 11.456 0 0 1 7.887-4.049c.05-.006.175-.016.329-.026V20a1 1 0 0 0 1.707.707l8-8a1 1 0 0 0 0-1.414ZM14 17.586V15.5a1 1 0 0 0-1-1c-.255 0-1.296.05-1.562.085a14.005 14.005 0 0 0-7.386 2.948A9.013 9.013 0 0 1 13 9.5a1 1 0 0 0 1-1V6.414L19.586 12Z"></path></svg></a></li>
							<?php endif; ?>
					<?php endforeach; ?>
				</ul>
				<h6 class="kanews-popup-subtitle"><?php esc_html_e( 'veya linki kopyala', 'kanews' ); ?></h6>
				<div class="kanews-copy-link">
					<input type="text" readonly="" id="input-url-<?php echo $pid; ?>" value="<?php the_permalink( $pid ); ?>">
					<button class="kanews-label kanews-label-bg" role="tooltip" data-microtip-position="top" aria-label="<?php esc_html_e( 'Linki Kopyala', 'kanews' ); ?>" type="button" onclick="copy('input-url-<?php echo $pid; ?>')"><?php esc_html_e( 'Kopyala', 'kanews' ); ?></button>
				</div>
			</div>
		</div>
<?php 
		?>
	
	<?php else: ?>
		<div class="<?php echo 'kanews-article-share style-'.$style; ?>">
			<div class="kanews-label">
				<span class="w-line"><i class="icon-share"></i> <?php esc_html_e( 'Paylaş', 'kanews' ); ?></span>
				<ul class="d-flex">
				<?php foreach($links as $link ): ?>
					<?php switch($style) {
						case '1':
							$class = 'color-'.$link.' border-'.$link.' hover-'.$link.'';
							break;
						case '5':
							$class = 'color-'.$link.' border-'.$link.' hover-'.$link.'';
							break;
						default:
							$class = 'bg-'.$link.'';
						break;
					} ?>
					<?php if ($link == 'facebook'): ?>
							<li><a class="<?php echo $class; ?>" rel="external noopener" target="_blank" href="//www.facebook.com/sharer/sharer.php?u=<?php echo $permalink; ?>"><i class="icon-facebook"></i></a></li>
						<?php endif;?>
						
						<?php if ($link == 'twitter'): ?>
							<li><a target="_blank" rel="external noopener" class="<?php echo $class; ?>" href="//www.twitter.com/intent/tweet?text=<?php echo $title; ?> <?php echo $permalink; ?>"><i class="icon-twitter"></i></a></li>
						<?php endif;?>
					
						<?php if ($link == 'whatsapp'): ?>
							<li class="hidden-desktop"><a class="<?php echo $class; ?>" href="whatsapp://send?text=<?php echo $permalink; ?>"><i class="icon-whatsapp"></i></a></li>
							<li class="hidden-mobile"><a class="<?php echo $class; ?>" href="https://api.whatsapp.com/send?text=<?php echo $title; ?> <?php echo $permalink; ?>"><i class="icon-whatsapp"></i></a></li>
						<?php endif; ?>
						
						<?php if ($link == 'pinterest'): ?>
							<li><a target="_blank" rel="external noopener" class="<?php echo $class; ?>" href="//pinterest.com/pin/create/button/?url=&media=<?php echo $image[0]; ?>&description=<?php echo $title; ?>&url=<?php echo $permalink; ?>"><i class="icon-pinterest"></i></a></li>
						<?php endif; ?>
						
						<?php if ($link == 'telegram'): ?>
							<li><a target="_blank" rel="external noopener" class="<?php echo $class; ?>" href="//t.me/share/url?url=<?php echo $permalink; ?>&text=<?php echo $title; ?>"><i class="icon-telegram"></i></a></li>
						<?php endif; ?>
						
						<?php if ($link == 'email'): ?>
							<li><a class="bg-dark kanews-native-share" onclick="doSomething()"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" id="icon-share"><path fill="currentColor" d="m21.707 11.293-8-8A1 1 0 0 0 12 4v3.545A11.015 11.015 0 0 0 2 18.5V20a1 1 0 0 0 1.784.62 11.456 11.456 0 0 1 7.887-4.049c.05-.006.175-.016.329-.026V20a1 1 0 0 0 1.707.707l8-8a1 1 0 0 0 0-1.414ZM14 17.586V15.5a1 1 0 0 0-1-1c-.255 0-1.296.05-1.562.085a14.005 14.005 0 0 0-7.386 2.948A9.013 9.013 0 0 1 13 9.5a1 1 0 0 0 1-1V6.414L19.586 12Z"></path></svg></a></li>
						<?php endif; ?>
						
				<?php endforeach; ?>
			</ul>
			</div>
			
		</div>
	<?php endif;
}
/*-----------------------------------------------------------------------------------*/
# Post Share
/*-----------------------------------------------------------------------------------*/
function kanews_post_share_2($pid) { 
	$links = (kanews_get_option('post-share')) ? kanews_get_option('post-share') : array('facebook', 'twitter','whatsapp', 'email'); 
	$style = (kanews_get_option('post-share-style')) ? kanews_get_option('post-share-style') : '1'; 
	$image = wp_get_attachment_image_src(get_post_thumbnail_id($pid), 'full');
	$desktop = '';
	if($style != '5' ):
		$desktop = ' hidden-desktop';
	else: ?>
		<div style="cursor:pointer" class="kanews-label <?php echo $desktop; ?>" data-toggle="kanews-popup-share-<?php echo $pid; ?>"><i class="icon-share"></i> <?php esc_html_e( 'Paylaş', 'kanews' ); ?></div>
	<?php endif; ?>
	
	<?php	
}

/*-----------------------------------------------------------------------------------*/
# Breadcrumb
/*-----------------------------------------------------------------------------------*/
function kanews_breadcrumb($pid = '') {
	$default_option = (kanews_get_option('show-post-breadcrumb') == false) ? false : true;
	$single_option  = get_post_meta($pid, 'show_post_breacrumb', true);
	$follow         = kanews_get_option('follow-categories');
	$follow_class   = '';
	$follow_cat     = '';
	$is_page = false;

	if ($single_option == 'off' || $default_option == false)
			return;
	elseif ($single_option == 'default' && $default_option == false)
			return;

	$home_url = home_url('/');
	$home_text = kanews_translate('post-breacrumb-main-title', esc_html__('Haberler', 'kanews'));

	echo "<div class='kanews-breadcrumb'><ol class='d-flex align-items-center'>";
	echo '<li>';
	echo '<a href="' . $home_url . '">';
	echo '<span class="d-flex align-items-center g-05"><svg width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="home"><path fill="currentColor" d="M21.66,10.25l-9-8a1,1,0,0,0-1.32,0l-9,8a1,1,0,0,0-.27,1.11A1,1,0,0,0,3,12H4v9a1,1,0,0,0,1,1H19a1,1,0,0,0,1-1V12h1a1,1,0,0,0,.93-.64A1,1,0,0,0,21.66,10.25ZM13,20H11V17a1,1,0,0,1,2,0Zm5,0H15V17a3,3,0,0,0-6,0v3H6V12H18ZM5.63,10,12,4.34,18.37,10Z"></path></svg> ' . $home_text . '</span>';
	echo '</a>';
	echo '</li>';

	if ( ! is_singular('post') ) {
    $titles = [
        'columist' => esc_html__( 'Yazarlar', 'kanews' ),
        'firma'    => esc_html__( 'Firma Rehberi', 'kanews' ),
        'ilan'    => esc_html__( 'İlan', 'kanews' ),
    ];
    
    $post_type = get_post_type();
    $title = isset($titles[$post_type]) ? $titles[$post_type] : '';
		if( $title != '' )
    echo '<li><a href="' . get_post_type_archive_link( $post_type ) . '">' . $title . '</a></li>';
	}

	if (is_single() || is_category() || is_page()) {
			if (is_single()) {
					$post_type = get_post_type($pid);
					
					// Handle post type with category taxonomy
					if ($post_type === 'post') {
							$category = (int) Kanews\Helper_Wp::primary_category_id($pid);
							if (!empty($category) && Kanews\Helper_Wp::term_exists($category, 'category')) {
									$categories = array_reverse(get_ancestors($category, 'category'));
									$categories[] = $category;

									foreach ($categories as $cat) {
											$term = Kanews\Helper_Wp::get_term_by('id', $cat, 'category');
											$follow_cat = kanews_get_follow_button($cat, $follow);
											echo '<li>
													<a class="kanews-label kanews-label-sm kanews-label-bg" href="' . Kanews\Helper_Wp::get_term_link($cat, 'category') . '"><span>' . $term->name . '</span></a>' . $follow_cat . '
											</li>';
									}
							}
					}
					// Handle firma post type with kategori taxonomy
					elseif ($post_type === 'firma') {
							$terms = get_the_terms($pid, 'kategori');
							if ($terms && !is_wp_error($terms) && !empty($terms)) {
									// Get primary term if available, otherwise use first term
									$primary_term = null;
									$primary_term_id = get_post_meta($pid, 'kanews_primary_kategori', true);
									
									if (!empty($primary_term_id)) {
											foreach ($terms as $term) {
													if ($term->term_id == $primary_term_id) {
															$primary_term = $term;
															break;
													}
											}
									}
									
									if (!$primary_term) {
											$primary_term = $terms[0];
									}
									
									// Add ancestors if any
									if ($primary_term->parent) {
											$ancestors = array_reverse(get_ancestors($primary_term->term_id, 'kategori'));
											foreach ($ancestors as $ancestor_id) {
													$ancestor_term = Kanews\Helper_Wp::get_term_by('id', $ancestor_id, 'kategori');
													if ($ancestor_term && !is_wp_error($ancestor_term)) {
															echo '<li>';
															echo '<a href="' . Kanews\Helper_Wp::get_term_link($ancestor_term, 'kategori') . '"><span>' . $ancestor_term->name . '</span></a>';
															echo '</li>';
													}
											}
									}
									
									// Add current term
									echo '<li>';
									echo '<a href="' . Kanews\Helper_Wp::get_term_link($primary_term, 'kategori') . '"><span>' . $primary_term->name . '</span></a>';
									echo '</li>';
							}
					}
					// Handle ilan post type with ilan-kategori taxonomy
					elseif ($post_type === 'ilan') {
							$terms = get_the_terms($pid, 'ilan-kategori');
							if ($terms && !is_wp_error($terms) && !empty($terms)) {
									// Get primary term if available, otherwise use first term
									$primary_term = null;
									$primary_term_id = get_post_meta($pid, 'kanews_primary_ilan-kategori', true);
									
									if (!empty($primary_term_id)) {
											foreach ($terms as $term) {
													if ($term->term_id == $primary_term_id) {
															$primary_term = $term;
															break;
													}
											}
									}
									
									if (!$primary_term) {
											$primary_term = $terms[0];
									}
									
									// Add ancestors if any
									if ($primary_term->parent) {
											$ancestors = array_reverse(get_ancestors($primary_term->term_id, 'ilan-kategori'));
											foreach ($ancestors as $ancestor_id) {
													$ancestor_term = Kanews\Helper_Wp::get_term_by('id', $ancestor_id, 'ilan-kategori');
													if ($ancestor_term && !is_wp_error($ancestor_term)) {
															echo '<li>';
															echo '<a href="' . Kanews\Helper_Wp::get_term_link($ancestor_term, 'ilan-kategori') . '"><span>' . $ancestor_term->name . '</span></a>';
															echo '</li>';
													}
											}
									}
									
									// Add current term
									echo '<li>';
									echo '<a href="' . Kanews\Helper_Wp::get_term_link($primary_term, 'ilan-kategori') . '"><span>' . $primary_term->name . '</span></a>';
									echo '</li>';
							}
					}
			} elseif (is_category()) {
					$current_category = get_queried_object();
					$categories = array_reverse(get_ancestors($current_category->term_id, 'category'));
					$categories[] = $current_category->term_id;

					foreach ($categories as $cat) {
							$term = Kanews\Helper_Wp::get_term_by('id', $cat, 'category');
							$follow_cat = kanews_get_follow_button($cat, $follow);
							echo '<li>
									<a class="kanews-label kanews-label-sm kanews-label-bg" href="' . Kanews\Helper_Wp::get_term_link($cat, 'category') . '"><span>' . $term->name . '</span></a>' . $follow_cat . '
							</li>';
					}
			} elseif (is_page()) {
					$is_page = true;
					$ancestors = array_reverse(get_post_ancestors($pid));
					foreach ($ancestors as $ancestor) {
							echo '<li>';
							echo '<a href="' . get_permalink($ancestor) . '">';
							echo '<span>' . get_the_title($ancestor) . '</span>';
							echo '</a>';
							echo '</li>';
					}
					
			}
	}
 
	



	if( $is_page ) {
	echo '<li>';
	echo '<a href="' . get_the_permalink(). '">';

	the_title('<span>', '</span>');
	echo '</a>';
	echo '</li>';
	} elseif( ! is_post_type_archive() ) {
		echo '<li>';
		if( is_tax() ) {
			$term = get_queried_object();
			
			// Add post type archive link for custom taxonomies
			if ( isset( $term->taxonomy ) ) {
				$taxonomy = $term->taxonomy;
				
				// Get post types associated with this taxonomy
				$taxonomy_obj = get_taxonomy( $taxonomy );
				if ( $taxonomy_obj && ! empty( $taxonomy_obj->object_type ) ) {
					$post_type = $taxonomy_obj->object_type[0];
					
					// Add post type archive link for firma and ilan
					if ( in_array( $post_type, array( 'firma', 'ilan' ) ) ) {
						$titles = array(
							'firma' => esc_html__( 'Firma Rehberi', 'kanews' ),
							'ilan'  => esc_html__( 'İlan', 'kanews' ),
						);
						
						if ( isset( $titles[ $post_type ] ) && get_post_type_archive_link( $post_type ) ) {
							echo '<a href="' . esc_url( get_post_type_archive_link( $post_type ) ) . '">';
							echo '<span>' . $titles[ $post_type ] . '</span>';
							echo '</a>';
							echo '</li><li>';
						}
					}
				}
			}
			
			// Add taxonomy ancestors if any
			if ( isset( $term->parent ) && $term->parent ) {
				$ancestors = array_reverse( get_ancestors( $term->term_id, $term->taxonomy ) );
				foreach ( $ancestors as $ancestor_id ) {
					$ancestor_term = Kanews\Helper_Wp::get_term_by( 'id', $ancestor_id, $term->taxonomy );
					if ( $ancestor_term && ! is_wp_error( $ancestor_term ) ) {
						echo '<a href="' . esc_url( Kanews\Helper_Wp::get_term_link( $ancestor_term, $term->taxonomy ) ) . '">';
						echo '<span>' . esc_html( $ancestor_term->name ) . '</span>';
						echo '</a>';
						echo '</li><li>';
					}
				}
			}
			
			// Add current term
			echo '<a href="' . esc_url( get_term_link( $term ) ) . '">';
			echo '<span>' . esc_html( $term->name ) . '</span>';
			echo '</a>';
		} else {
			the_title('<span>', '</span>');
		}
		echo '</li>';
	}

	if( is_page() ) {
		// Özel Şablonlar için Breadcrumb
    if (is_page_template('inc/currencies.php')) {
			$name = isset($_GET['parite']) && !empty($_GET['parite']) ? $_GET['parite'] : get_query_var('parite');
			if ($name) {
					echo '<li>';
					echo '<span>' . strtoupper($name) . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/exchange.php')) {
			$name = isset($_GET['hisse']) && !empty($_GET['hisse']) ? $_GET['hisse'] : get_query_var('hisse');
			if ($name) {
					echo '<li>';
					echo '<span>' . strtoupper($name) . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/exchange2.php')) {
			$name = isset($_GET['hisse']) && !empty($_GET['hisse']) ? $_GET['hisse'] : get_query_var('hisse');
			if ($name) {
					echo '<li>';
					echo '<span>' . explode(':', $name)[1]  . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/cryptocurrencies.php') || is_page_template('inc/cryptocurrencies2.php')) {
			$name = isset($_GET['coin']) && !empty($_GET['coin']) ? $_GET['coin'] : get_query_var('coin');
			if ($name) {
					echo '<li>';
					echo '<span>' . ucfirst($name) . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/weather-2.php')) {
			$name = isset($_GET['sehir']) && !empty($_GET['sehir']) ? $_GET['sehir'] : get_query_var('sehir');
			if ($name) {
					echo '<li>';
					echo '<span>' . ucfirst($name) . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/traffic.php')) {
			$name = isset($_GET['sehir']) && !empty($_GET['sehir']) ? $_GET['sehir'] : get_query_var('sehir');
			if ($name) {
					echo '<li>';
					echo '<span>' . ucfirst($name) . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/live.php')) {
			$name = isset($_GET['kanal']) && !empty($_GET['kanal']) ? $_GET['kanal'] : get_query_var('kanal');
			if ($name) {
					echo '<li>';
					echo '<span>' . ucfirst($name) . '</span>';
					echo '</li>';
			}
	} elseif (is_page_template('inc/eczane.php')) {
		$name = (isset($_GET['sehir']) &&  $_GET['sehir'] != 'null' && !empty($_GET['sehir'])) ? ucwords($_GET['sehir']) : get_query_var('sehir');
			if ($name) {
					echo '<li>';
					echo '<a href="'.kanews_get_page_link('sehir', strtolower($name), 'eczane').'">';
					echo '<span>' . ucfirst($name) . '</span>';
					echo '</a>';

					echo '</li>';
			}
	}elseif (is_page_template('inc/emtia.php')) {
		$name = isset($_GET['emtia']) && !empty($_GET['emtia']) ? $_GET['emtia'] : get_query_var('emtia');
		if ($name) {
				echo '<li>';
				echo '<span>' . ucfirst($name) . '</span>';
				echo '</li>';
		}
	}elseif (is_page_template('inc/livescore.php')) {
		$name = isset($_GET['lig']) && !empty($_GET['lig']) ? $_GET['lig'] : get_query_var('lig');
		if ($name) {
			$lig_title = kanews_correct_league_title2($name);

				echo '<li>';
				echo '<span>' . $lig_title . '</span>';
				echo '</li>';
		}
	}elseif (is_page_template('inc/standings.php')) {
		$name = isset($_GET['lig']) && !empty($_GET['lig']) ? $_GET['lig'] : get_query_var('lig');
		if ($name) {
				echo '<li>';
				echo '<span>' . ucwords( str_replace("-", " ", $name)) . '</span>';
				echo '</li>';
		}
	}elseif (is_page_template('inc/prayer.php')) {
		$name = isset($_GET['sehir']) && !empty($_GET['sehir']) ? $_GET['sehir'] : get_query_var('sehir');
		if ($name) {
			$name = isset($_GET['sehir']) && !empty($_GET['sehir']) ? $_GET['sehir'] : get_query_var('sehir');
			$region = (isset($_GET['sehir']) &&  $_GET['sehir'] != 'null' && !empty($_GET['sehir'])) ? esc_html(ucwords($_GET['sehir'])) : kanews_get_option('prayer-page-city', 'Ankara');
			$city = (isset($_GET['ilce']) && $_GET['ilce'] != 'null' && !empty($_GET['ilce'])) ? esc_html(ucwords($_GET['ilce'])) : kanews_get_option('prayer-page-city2', $region);
			if( empty($city) )
			$city = $region;

			if( $region == 'Kocaeli' && $region == $city )
			$city = 'İzmit';

				echo '<li>';
				echo '<span>' . $city . '</span>';
				echo '</li>';
		}
	}elseif (is_page_template('inc/newspaper.php')) {
		$name = isset($_GET['gazete']) && !empty($_GET['gazete']) ? $_GET['gazete'] : get_query_var('gazete');
		if ($name) {
			$newspapers = [
				'aksam' => 'Akşam',
				// 'yeni-safak' => 'Yeni Şafak',
				// 'fanatik' => 'Fanatik',
				'fotomac' => 'Fotomaç',
				'milliyet' => 'Milliyet',
				// 'sozcu' => 'Sözcü',
				'takvim-gazetesi' => 'Takvim',
				'hurriyet' => 'Hürriyet',
				'sabah' => 'Sabah',
				'milli-gazete' => 'Milli',
				'yenicag' => 'Yeni Çağ',
				'milat' => 'Milat',
				'turkiye' => 'Türkiye',
				'turkgun' => 'Türkgün',
				'dunya' => 'Dünya',
				'yenisoz' => 'Yenisöz',
				// 'harbi-gazete' => 'Harbi Gazete',
				'dogru-haber' => 'Doğru Haber',
				'yeni-birlik' => 'Yeni Birlik',
				'aydinlik' => 'Aydınlık',
			];

				echo '<li>';
				echo '<span>' . (isset($newspapers[$name]) ? $newspapers[$name] : $name) . '</span>';
				echo '</li>';
		}
	}

	}

	echo "</ol></div>";
}

function kanews_get_follow_button($category_id, $follow) {
	if (!$follow) return '';

	if (is_user_logged_in()) {
			$user_cats = get_user_option('kanews_subscribe_category', get_current_user_id()) ?: array('');
			$follow_class = in_array($category_id, $user_cats) ? 'category-subscribed' : '';
			return '<span data-cat-id="' . $category_id . '" class="kanews-category-subscribe-button hf1s ' . $follow_class . '" role="tooltip" data-microtip-position="bottom" aria-label="' . esc_html__('Takip Et', 'kanews') . '"><div class="check"></div> <div id="kanews-loader"></div></span>';
	} else {
			return '<span class="kanews-category-subscribe-button" data-toggle="kanews-modal-login" role="tooltip" data-microtip-position="bottom" aria-label="' . esc_html__('Takip Etmek için giriş yap', 'kanews') . '"><i class="icon-add"></i></span>';
	}
}



/*-----------------------------------------------------------------------------------*/
# Get Post Tags
/*-----------------------------------------------------------------------------------*/
function kanews_post_tags($pid = '') {
	$default_options = kanews_get_option('show-post-tags', true);
	$single_options = get_post_meta( $pid, 'show_post_tags', true );
	if($single_options == 'on' )
	the_tags('<div class="kanews-entry-tags"><span>'.esc_html__( 'Haberle ilgili daha fazlası:', 'kanews' ).'</span>',' ','</div>');
	elseif($single_options != 'off' && $default_options != false  )
	the_tags('<div class="kanews-entry-tags"><span>'.esc_html__( 'Haberle ilgili daha fazlası:', 'kanews' ).'</span>',' ','</div>');
}

/*-----------------------------------------------------------------------------------*/
# Post Like Button
/*-----------------------------------------------------------------------------------*/
function kanews_like_button($pid = '', $is_comment = NULL) {
	$default_options = kanews_get_option('post-like', true);
	$single_options = get_post_meta( $pid, 'show_post_like', true );
	if($default_options != false && $single_options != 'off' )
	echo get_simple_likes_button( $pid, $is_comment );
}

/*-----------------------------------------------------------------------------------*/
# Post Date
/*-----------------------------------------------------------------------------------*/
function kanews_post_date( $type = 'post', $tag = 'div' ) {
	$d = 'comment' == $type ? 'get_comment_time' : 'get_post_time';
	return '<'.$tag.' class="kanews-post-date">'.human_time_diff($d('U'), current_time('timestamp')) . " " . __('önce', 'kanews').'</'.$tag.'>';
}

/*-----------------------------------------------------------------------------------*/
# Video Time
/*-----------------------------------------------------------------------------------*/
function kanews_video_time($pid = '') {
	if($pid == '')
	$pid = get_the_ID();
	$single_options = get_post_meta( $pid, 'video_time', true );
	if(has_post_format( 'video') && $single_options)
	echo '<span class="kanews-video-time">'.$single_options.'</span>';
}


/*-----------------------------------------------------------------------------------*/
# Popup
/*-----------------------------------------------------------------------------------*/
add_action('wp_footer', 'kanews_popup');
function kanews_popup() {

	if( (isset($_COOKIE["kan_popup_cookie"]) && is_admin() && $_COOKIE["kan_popup_cookie"] == 'disable') || ! kanews_get_option('popup') )
	return;
	
	$delay = kanews_get_option('popup-delay', 5);
	$expired = kanews_get_option('popup-expired', 7);
	$width = kanews_get_option('popup-width');

	?>
	<div id="kanews-modal-popup" data-delay="<?php echo $delay*1000; ?>" data-expired="<?php echo $expired; ?>" class="kanews-modal kanews-modal-popup align-items-center">
		<div data-toggle="kanews-modal-popup" class="kanews-modal-close"></div>
		<div class="kanews-modal-content" <?php if($width): ?> style="max-width: 100%; width: <?php echo $width; ?>px"<?php endif; ?>>
			<?php if( $title = kanews_get_option('popup-title') ): ?><div class="kanews-modal-title"><?php echo $title; ?></div><?php endif; ?>
			<div data-toggle="kanews-modal-popup" class="kanews-modal-close-btn"><i class="icon-close"></i></div>
			<div class="kanews-modal-content-inner">
				<?php if( kanews_get_option('popup-module') == 'widget' && is_active_sidebar( 'popup' ) ): ?>
					<?php dynamic_sidebar( 'popup' ); ?>
				<?php else: ?>
					<?php echo kanews_get_option('popup-module-custom'); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php 
}

/*-----------------------------------------------------------------------------------*/
# Reading bar
/*-----------------------------------------------------------------------------------*/
add_action('kanews_entry_above', 'kanews_reading_bar');
function kanews_reading_bar() { 
	$default_option = kanews_get_option('show-post-reading', false);
	$single_option = get_post_meta( get_the_ID(), 'show_post_reading_bar', 'default' );
	?>
	<?php if($single_option == 'on' ): ?>
		<div class="kanews-reading-bar">
			<div class="js-bar"></div>
			<div class="container">
				<div class="row align-items-center justify-content-between">
				<div class="col kanews-reading-bar-title truncate truncate-1 d-flex align-items-center gap-1">
					<svg class="hidden-mobile" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24"><path fill="currentColor" d="M17,11H16a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm0,4H16a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM11,9h6a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2ZM21,3H7A1,1,0,0,0,6,4V7H3A1,1,0,0,0,2,8V18a3,3,0,0,0,3,3H18a4,4,0,0,0,4-4V4A1,1,0,0,0,21,3ZM6,18a1,1,0,0,1-2,0V9H6Zm14-1a2,2,0,0,1-2,2H7.82A3,3,0,0,0,8,18V5H20Zm-9-4h1a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm0,4h1a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Z"></path></svg>
					<?php the_title(); ?></div>				
					<div class="col kanews-gha d-flex align-items-center justify-content-end">
							<a title="<?php esc_html_e( 'Yazıyı Büyült', 'kanews' ); ?>" class="increase-text kanews-label" onclick="doSomething()"><svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M6.19983 14H8.3539L9.55389 11H14.4458L15.6458 14H17.7998L12.9998 2H10.9998L6.19983 14ZM11.9998 4.88517 13.6458 9H10.3539L11.9998 4.88517ZM3 16V22L5 22 4.99992 20H18.9999L19 22 21 22 20.9999 16H18.9999V18H4.99992L5 16 3 16Z"></path></svg> +</a>
								<a title="<?php esc_html_e( 'Yazıyı Küçült', 'kanews' ); ?>" class="decrease-text kanews-label" onclick="doSomething()"><svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M6.19983 14H8.3539L9.55389 11H14.4458L15.6458 14H17.7998L12.9998 2H10.9998L6.19983 14ZM11.9998 4.88517 13.6458 9H10.3539L11.9998 4.88517ZM3 16V22L5 22 4.99992 20H18.9999L19 22 21 22 20.9999 16H18.9999V18H4.99992L5 16 3 16Z"></path></svg> -</a>
							<?php if ( comments_open() && ! kanews_get_option('show-post-comments') ): ?>
						<a class="kanews-label" title="<?php esc_html_e( 'Yorum Yap', 'kanews' ); ?>" href="#respond">
<svg width="24" height="24" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.04004 16C7.03989 19.3447 8.90259 22.4109 11.8709 23.9523C14.8392 25.4937 18.4189 25.2534 21.1546 23.3293L24.96 23.68V16C24.96 11.0516 20.9485 7.04004 16 7.04004C11.0516 7.04004 7.04004 11.0516 7.04004 16Z" stroke="currentColor" stroke-width="1.92" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.1602 17.5998C11.63 17.5998 11.2002 18.0296 11.2002 18.5598C11.2002 19.0899 11.63 19.5198 12.1602 19.5198V17.5998ZM17.2802 19.5198C17.8104 19.5198 18.2402 19.0899 18.2402 18.5598C18.2402 18.0296 17.8104 17.5998 17.2802 17.5998V19.5198ZM12.1602 13.7598C11.63 13.7598 11.2002 14.1896 11.2002 14.7198C11.2002 15.2499 11.63 15.6798 12.1602 15.6798V13.7598ZM19.8402 15.6798C20.3704 15.6798 20.8002 15.2499 20.8002 14.7198C20.8002 14.1896 20.3704 13.7598 19.8402 13.7598V15.6798ZM12.1602 19.5198H17.2802V17.5998H12.1602V19.5198ZM12.1602 15.6798H19.8402V13.7598H12.1602V15.6798Z" fill="currentColor"/>
</svg>
<span><?php echo comments_number( '0', '1', '%' ); ?></span></a>
<?php endif; ?>
						<button class="kanews-native-share kanews-label" title="<?php esc_html_e('Paylaş', 'kanews'); ?>"><i class="icon-share"></i> <?php esc_html_e('Paylaş', 'kanews'); ?> </button>
					</div>
				</div>
			</div>
		</div>
	<?php elseif($single_option != 'off' && $default_option != false  ): ?>
		<div class="kanews-reading-bar">
			<div class="js-bar"></div>
			<div class="container">
				<div class="row align-items-center justify-content-between">
					<div class="col kanews-reading-bar-title truncate truncate-1 d-flex align-items-center gap-1">
					<svg class="hidden-mobile" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24"><path fill="currentColor" d="M17,11H16a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm0,4H16a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM11,9h6a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2ZM21,3H7A1,1,0,0,0,6,4V7H3A1,1,0,0,0,2,8V18a3,3,0,0,0,3,3H18a4,4,0,0,0,4-4V4A1,1,0,0,0,21,3ZM6,18a1,1,0,0,1-2,0V9H6Zm14-1a2,2,0,0,1-2,2H7.82A3,3,0,0,0,8,18V5H20Zm-9-4h1a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm0,4h1a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Z"></path></svg>
					<?php the_title(); ?></div>
					<div class="col kanews-gha d-flex align-items-center justify-content-end">

					<a title="<?php esc_html_e( 'Yazıyı Büyült', 'kanews' ); ?>" class="increase-text kanews-label" onclick="doSomething()"><svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M6.19983 14H8.3539L9.55389 11H14.4458L15.6458 14H17.7998L12.9998 2H10.9998L6.19983 14ZM11.9998 4.88517 13.6458 9H10.3539L11.9998 4.88517ZM3 16V22L5 22 4.99992 20H18.9999L19 22 21 22 20.9999 16H18.9999V18H4.99992L5 16 3 16Z"></path></svg> +</a>
					<a title="<?php esc_html_e( 'Yazıyı Küçült', 'kanews' ); ?>" class="decrease-text kanews-label" onclick="doSomething()"><svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M6.19983 14H8.3539L9.55389 11H14.4458L15.6458 14H17.7998L12.9998 2H10.9998L6.19983 14ZM11.9998 4.88517 13.6458 9H10.3539L11.9998 4.88517ZM3 16V22L5 22 4.99992 20H18.9999L19 22 21 22 20.9999 16H18.9999V18H4.99992L5 16 3 16Z"></path></svg> -</a>
					
					<?php if ( comments_open() && ! kanews_get_option('show-post-comments') ): ?>
						<a class="kanews-label" title="<?php esc_html_e( 'Yorum Yap', 'kanews' ); ?>" href="#respond">
<svg width="24" height="24" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.04004 16C7.03989 19.3447 8.90259 22.4109 11.8709 23.9523C14.8392 25.4937 18.4189 25.2534 21.1546 23.3293L24.96 23.68V16C24.96 11.0516 20.9485 7.04004 16 7.04004C11.0516 7.04004 7.04004 11.0516 7.04004 16Z" stroke="currentColor" stroke-width="1.92" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.1602 17.5998C11.63 17.5998 11.2002 18.0296 11.2002 18.5598C11.2002 19.0899 11.63 19.5198 12.1602 19.5198V17.5998ZM17.2802 19.5198C17.8104 19.5198 18.2402 19.0899 18.2402 18.5598C18.2402 18.0296 17.8104 17.5998 17.2802 17.5998V19.5198ZM12.1602 13.7598C11.63 13.7598 11.2002 14.1896 11.2002 14.7198C11.2002 15.2499 11.63 15.6798 12.1602 15.6798V13.7598ZM19.8402 15.6798C20.3704 15.6798 20.8002 15.2499 20.8002 14.7198C20.8002 14.1896 20.3704 13.7598 19.8402 13.7598V15.6798ZM12.1602 19.5198H17.2802V17.5998H12.1602V19.5198ZM12.1602 15.6798H19.8402V13.7598H12.1602V15.6798Z" fill="currentColor"/>
</svg>
<span><?php echo comments_number( '0', '1', '%' ); ?></span></a>
<?php endif; ?>
						<button class="kanews-native-share kanews-label" title="<?php esc_html_e('Paylaş', 'kanews'); ?>"><i class="icon-share"></i> <?php esc_html_e('Paylaş', 'kanews'); ?> </button>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>
<?php }


add_action('wp_footer', 'kanews_mobile_tab_bar');
function kanews_mobile_tab_bar() {
	$option = kanews_get_option('tab-bar', false);
	$hide_desktop = '';

	if( ! kanews_get_option('tab-bar-desktop', false) )
	$hide_desktop = 'hidden-desktop';

	if( ( $hide_desktop == 'hidden-desktop ' && ! kan_is_mobile() )  || !$option)
	return;

	$option2 = kanews_get_option('tab-bar-defaults');
	$option3 = kanews_get_option('tab-bar-items');
	$only_icon = kanews_get_option('tab-bar-icon') ? 'kanews-tab-bar-only-icon' : '';

	$current_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

	
	echo '<div id="kanews-tab-bar" class="kanews-tab-bar '.$only_icon.' '.$hide_desktop.'"><ul class="kanews-tab-bar-wrapper d-flex flex-wrap align-items-center ">';
		if($option2) {
			
			foreach($option2 as $item) {
	
				if($item == 'home') {
					if($current_url == home_url('/')) 
					echo '<li class="current-menu-item">';
					else
					echo '<li>';
						echo '<a href="'.home_url('/').'">';
							echo '<div class="kanews-tab-bar-icon"><svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="home"><path fill="currentColor" d="M21.66,10.25l-9-8a1,1,0,0,0-1.32,0l-9,8a1,1,0,0,0-.27,1.11A1,1,0,0,0,3,12H4v9a1,1,0,0,0,1,1H19a1,1,0,0,0,1-1V12h1a1,1,0,0,0,.93-.64A1,1,0,0,0,21.66,10.25ZM13,20H11V17a1,1,0,0,1,2,0Zm5,0H15V17a3,3,0,0,0-6,0v3H6V12H18ZM5.63,10,12,4.34,18.37,10Z"></path></svg></div>';
							echo '<div class="kanews-tab-bar-label truncate truncate-1">'.esc_html__('Anasayfa', 'kanews').'</div>';
						echo '</a>';
					echo '</li>';
				}elseif($item == 'feed') {
					if($feed_page_id = kanews_get_option('feed-page') ){
					if($current_url == esc_url(get_page_link($feed_page_id))) 
					echo '<li class="current-menu-item">';
					else
					echo '<li>';
							echo '<a href="'.esc_url(get_page_link($feed_page_id)).'">';
								echo '<div class="kanews-tab-bar-icon"><i class="icon-bolt"></i></div>';
								echo '<div class="kanews-tab-bar-label truncate truncate-1">'.esc_html__('Akış', 'kanews').'</div>';
							echo '</a>';
						echo '</li>';
					}

				}elseif($item == 'account') {
					if($account_page_id = kanews_get_option('account-page') ){
					if($current_url == esc_url(get_page_link($account_page_id))) 
					echo '<li class="current-menu-item">';
					else
					echo '<li>';
							echo '<a href="'.esc_url(get_page_link($account_page_id)).'">';
								echo '<div class="kanews-tab-bar-icon"><i class="icon-user"></i></div>';
								echo '<div class="kanews-tab-bar-label truncate truncate-1">'.esc_html__('Hesabım', 'kanews').'</div>';
							echo '</a>';
						echo '</li>';
					}
				}elseif($item == 'notifications') {
					if($account_page_id && kanews_get_option('notifications') ){
					if($current_url == esc_url(get_page_link($account_page_id)).'?islem=bildirimler') 
					echo '<li class="current-menu-item">';
					else
					echo '<li>';
						$not_count = Kanews\Members\Notifications::get_user_notifications('tab');
							echo '<a aria-label="'.sprintf( esc_html__( 'Bildirimler (%s).', 'kanews' ), $not_count).'" href="'.esc_url(get_page_link($account_page_id)).'?islem=bildirimler">';
								echo '<div class="kanews-tab-bar-icon"><i class="icon-notifications"></i></div>';
								echo '<div class="kanews-tab-bar-label truncate truncate-1">'.esc_html__('Bildirimler', 'kanews').'</div>';
								
								echo '<div class="kanews-icon-btn-count">'.$not_count.'</div>';
							echo '</a>';
						echo '</li>';
					}
				}

			}
		}

		if(is_array($option3)) {
			// print_r($option3);
			foreach ($option3 as $action) {

					if($action['title'] && (!empty($action['img']) || !empty($action['icon'])) && (!empty($action['url']) || !empty($action['page']))) {
						if($action['link_type'] == 'page') {
							$page_link =  $action['page'] != '' ? get_page_link( $action['page'] ) : '#';
						} else {
							$page_link =  esc_url($action['url']);
						}
						if($action['icon_type'] == 'image') {
							$icon = kanews_get_local_image($action['img'], array('width' => 18, 'height' => 18, 'alt' => 'icon'));
						} else {
							$icon = '<i class="'.$action['icon'].'"></i>';
						}
						if($current_url == esc_url($page_link)) 
					echo '<li class="current-menu-item">';
					else
					echo '<li>';
							echo '<a href="'.esc_url($page_link).'"">';
								echo '<div class="kanews-tab-bar-icon">'.$icon.'</div>';
								echo '<div class="kanews-tab-bar-label truncate truncate-1">'.$action['title'].'</div>';
							echo '</a>';
							echo '';
						echo '</li>';
					
				}
			}
		}
	echo '</ul></div>';
}

/*-----------------------------------------------------------------------------------*/
#  User Points
/*-----------------------------------------------------------------------------------*/
function kanews_get_user_social_links($id, $label = true, $class = '') {
	if( !is_numeric($id) )
		return;
	$twitter = get_the_author_meta('twitter_profile', $id); if($twitter): ?> <a class="<?php echo ( $class != '' ) ? $class : 'bg-twitter'; ?>" rel="external nofollow noopener" target="_blank" href="https://www.twitter.com/<?php echo esc_attr($twitter); ?>"><i class="icon-twitter"></i> <?php if( $label ): ?> Twitter<?php endif; ?></a><?php endif; ?>
	<?php $facebook = get_the_author_meta('facebook_profile', $id); if($facebook): ?><a class="<?php echo ( $class != '') ? $class : 'bg-facebook'; ?>" rel="external nofollow noopener" target="_blank" href="https://www.facebook.com/<?php echo esc_attr($facebook); ?>"><i class="icon-facebook"></i> <?php if( $label ): ?>Facebok<?php endif; ?></a><?php endif; ?>
	<?php $instagram = get_the_author_meta('instagram_profile', $id); if($instagram): ?><a class="<?php echo ( $class != '') ? $class : 'bg-instagram'; ?>" rel="external nofollow noopener" target="_blank" href="https://www.instagram.com/<?php echo esc_attr($instagram); ?>"><i class="icon-instagram"></i> <?php if( $label ): ?>Instagram<?php endif; ?></a><?php endif; ?>
	<?php $linkedin = get_the_author_meta('linkedin_profile', $id); if($linkedin): ?><a class="<?php echo ( $class != '') ? $class : 'bg-linkedin'; ?>" rel="external nofollow noopener" target="_blank" href="https://www.linkedin.com/<?php echo esc_attr($linkedin); ?>"><i class="icon-linkedin"></i> <?php if( $label ): ?>Linkedin<?php endif; ?></a><?php endif; ?>
	<?php $youtube = get_the_author_meta('youtube_profile', $id); if($youtube): ?><a class="<?php echo ( $class != '') ? $class : 'bg-youtube'; ?>" rel="external nofollow noopener" target="_blank" href="https://www.youtube.com/<?php echo esc_attr($youtube); ?>"><i class="icon-video"></i> <?php if( $label ): ?>Youtube<?php endif; ?></a><?php endif; ?>
	<?php $telegram = get_the_author_meta('telegram_profile', $id); if($telegram): ?><a class="<?php echo ( $class != '') ? $class : 'bg-telegram'; ?>" rel="external nofollow noopener" target="_blank" href="https://t.me/<?php echo esc_attr($telegram); ?>"><i class="icon-telegram"></i> <?php if( $label ): ?>Telegram<?php endif; ?></a><?php endif;
}

add_action('kanews_entry_below', 'kanews_post_summary_ai');
function kanews_post_summary_ai() {
	$post_id = get_the_ID();
	if( ($post_summary = get_post_meta($post_id, 'kanews_post_summary', true)) && !empty($post_summary) )  {
		echo '<button data-post-id="'.$post_id.'" class="kanews-ai-btn"><div>
		<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 48 48">

  <g id="Layer_2" data-name="Layer 2">
    <g id="invisible_box" data-name="invisible box">
      <rect width="48" height="48" fill="none"/>
    </g>
    <g id="Q3_icons" data-name="Q3 icons">
      <g>
        <path d="M45.6,18.7,41,14.9V7.5a1,1,0,0,0-.6-.9L30.5,2.1h-.4l-.6.2L24,5.9,18.5,2.2,17.9,2h-.4L7.6,6.6a1,1,0,0,0-.6.9v7.4L2.4,18.7a.8.8,0,0,0-.4.8v9H2a.8.8,0,0,0,.4.8L7,33.1v7.4a1,1,0,0,0,.6.9l9.9,4.5h.4l.6-.2L24,42.1l5.5,3.7.6.2h.4l9.9-4.5a1,1,0,0,0,.6-.9V33.1l4.6-3.8a.8.8,0,0,0,.4-.7V19.4h0A.8.8,0,0,0,45.6,18.7Zm-5.1,6.8H42v1.6l-3.5,2.8-.4.3-.4-.2a1.4,1.4,0,0,0-2,.7,1.5,1.5,0,0,0,.6,2l.7.3h0v5.4l-6.6,3.1-4.2-2.8-.7-.5V25.5H27a1.5,1.5,0,0,0,0-3H25.5V9.7l.7-.5,4.2-2.8L37,9.5v5.4h0l-.7.3a1.5,1.5,0,0,0-.6,2,1.4,1.4,0,0,0,1.3.9l.7-.2.4-.2.4.3L42,20.9v1.6H40.5a1.5,1.5,0,0,0,0,3ZM21,25.5h1.5V38.3l-.7.5-4.2,2.8L11,38.5V33.1h0l.7-.3a1.5,1.5,0,0,0,.6-2,1.4,1.4,0,0,0-2-.7l-.4.2-.4-.3L6,27.1V25.5H7.5a1.5,1.5,0,0,0,0-3H6V20.9l3.5-2.8.4-.3.4.2.7.2a1.4,1.4,0,0,0,1.3-.9,1.5,1.5,0,0,0-.6-2L11,15h0V9.5l6.6-3.1,4.2,2.8.7.5V22.5H21a1.5,1.5,0,0,0,0,3Z"/>
        <path d="M13.9,9.9a1.8,1.8,0,0,0,0,2.2l2.6,2.5v2.8l-4,4v5.2l4,4v2.8l-2.6,2.5a1.8,1.8,0,0,0,0,2.2,1.5,1.5,0,0,0,1.1.4,1.5,1.5,0,0,0,1.1-.4l3.4-3.5V29.4l-4-4V22.6l4-4V13.4L16.1,9.9A1.8,1.8,0,0,0,13.9,9.9Z"/>
        <path d="M31.5,14.6l2.6-2.5a1.8,1.8,0,0,0,0-2.2,1.8,1.8,0,0,0-2.2,0l-3.4,3.5v5.2l4,4v2.8l-4,4v5.2l3.4,3.5a1.7,1.7,0,0,0,2.2,0,1.8,1.8,0,0,0,0-2.2l-2.6-2.5V30.6l4-4V21.4l-4-4Z"/>
      </g>
    </g>
  </g>
</svg>
'.esc_html__( 'Yapay Zeka ile Oluşturulmuş Yazı Özetini Getir', 'kanews' ).'</div>
		</button>';
	}
}


add_action('wp_ajax_get_post_summary', 'kanews_get_post_summary');
add_action('wp_ajax_nopriv_get_post_summary', 'kanews_get_post_summary');

function kanews_get_post_summary() {
    if( isset($_POST['post_id']) ) {
        $post_id = intval($_POST['post_id']);
        $post_summary = get_post_meta($post_id, 'kanews_post_summary', true);
        
        if( !empty($post_summary) ) {
						wp_send_json_success(array('summary' => wpautop( $post_summary ), 'title' => sprintf( __('Özet: %s','kanews'), get_the_title( $post_id)) ) );
        } else {
            wp_send_json_error();
        }
    } else {
        wp_send_json_error();
    }
}
