<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_audio_briefings extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_audio_briefings kanews-section-flat kanews-section-gutter column_x_gutter');
		$control_ops = array('id_base' => 'kanews_widget_audio_briefings');
		parent::__construct('kanews_widget_audio_briefings', ''.KAN_THEME_NAME .' - '.__( "Haber Bülteni" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$col = (!empty($instance['col'])) ? $instance['col'] : 'col-12';
		$limit = (!empty($instance['limit'])) ? intval($instance['limit']) : 3;

		// Calculate grid columns based on col value
		$grid_cols = '1';
		if (strpos($col, 'col-lg-3') !== false) {
			$grid_cols = '4';
		} elseif (strpos($col, 'col-lg-4') !== false) {
			$grid_cols = '3';
		} elseif (strpos($col, 'col-md-6') !== false) {
			$grid_cols = '2';
		}

		// Check if audio briefing system is enabled
		if (!\Kanews\Kai\Support\Options::get('kai-audio-enabled', false)) {
			?>
			<div class="<?php echo $grid; ?>"> 
				<div id="<?php echo $args['widget_id']; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
					<?php if ( ! empty($instance['title']) ):
						echo ( $args['before_title'] . $title . $args['after_title'] );
					endif; ?>
					<p><?php echo esc_html__('Bulunamadı.', 'kanews'); ?></p>
				</div>
			</div>
			<?php
			return;
		}

		$query = new WP_Query(array(
			'post_type'      => 'kai_audio_brief',
			'posts_per_page' => $limit,
			'post_status'    => 'publish',
			'orderby'        => 'date',
			'order'          => 'DESC',
		));

		if (!$query->have_posts()) {
			?>
			<div class="<?php echo $grid; ?>"> 
				<div id="<?php echo $args['widget_id']; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
					<?php if ( ! empty($instance['title']) ):
						echo ( $args['before_title'] . $title . $args['after_title'] );
					endif; ?>
					<p><?php echo esc_html__('Bulunamadı.', 'kanews'); ?></p>
				</div>
			</div>
			<?php
			return;
		}
		?>
		<div class="<?php echo $grid; ?>"> 
			<div id="<?php echo $args['widget_id']; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
				<?php if ( ! empty($instance['title']) ):
					echo ( $args['before_title'] . $title . $args['after_title'] );
				endif; ?>

				<div class="kai-audio-briefings" style="grid-template-columns: repeat(<?php echo esc_attr($grid_cols); ?>, 1fr);">
					<?php while ($query->have_posts()) : 
						$query->the_post();
						echo kanews_kai_render_audio_briefing_card(get_the_ID());
					endwhile; 
					wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
		<?php
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['grid'] = $new_instance['grid'];
		$instance['col'] = $new_instance['col'];
		$instance['limit'] = $new_instance['limit'];
		
		return $instance;
	}


  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			'title' => '', 
			'grid' => 'col-12', 
			'col' => 'col-12', 
			'limit' => 3,
		);

		$instance = wp_parse_args((array) $instance, $defaults); 
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Başlık', 'kanews'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('grid'); ?>"><?php _e('Genişlik', 'kanews'); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id('grid'); ?>" name="<?php echo $this->get_field_name('grid'); ?>">
				<option value="col-12" <?php selected($instance['grid'], 'col-12'); ?>>12/12</option>
				<option value="col-12 col-lg-8" <?php selected($instance['grid'], 'col-12 col-lg-8'); ?>>12/8</option>
				<option value="col-12 col-lg-6" <?php selected($instance['grid'], 'col-12 col-lg-6'); ?>>12/6</option>
				<option value="col-12 col-lg-4" <?php selected($instance['grid'], 'col-12 col-lg-4'); ?>>12/4</option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('col'); ?>"><?php _e('Grid Başına Item Sayısı', 'kanews'); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id('col'); ?>" name="<?php echo $this->get_field_name('col'); ?>">
				<option value="col-12" <?php selected($instance['col'], 'col-12'); ?>>1</option>
				<option value="col-12 col-md-6" <?php selected($instance['col'], 'col-12 col-md-6'); ?>>2</option>
				<option value="col-12 col-md-6 col-lg-4" <?php selected($instance['col'], 'col-12 col-md-6 col-lg-4'); ?>>3</option>
				<option value="col-12 col-lg-3" <?php selected($instance['col'], 'col-12 col-lg-3'); ?>>4</option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('limit'); ?>"><?php _e('Gösterilecek Haber Bülteni Sayısı', 'kanews'); ?></label>
			<input class="tiny-text" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="number" step="1" min="1" max="10" value="<?php echo esc_attr($instance['limit']); ?>" size="3" />
		</p>
		<?php
	}
}

