<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_calculator extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_calculator kanews-section-gutter');
		$control_ops = array('id_base' => 'kanews_widget_calculator');
		parent::__construct('kanews_widget_calculator', ''.KAN_THEME_NAME .' - '.__( "Hesaplayıcılar" , 'kanews' ), $widget_ops, $control_ops );
	}

  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';
		$show_tabs = isset($instance['show_tabs']) ? 'true' : 'false';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

    wp_enqueue_script('kanews-calculator');


    $title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$tur = $instance['tur'] ? $instance['tur'] : 'doviz';
		$grid = $instance['grid'] ? $instance['grid'] : 'col-12';
		$desc = $instance['desc'];
		$index = isset($instance['index']) ? $instance['index'] : '';

		if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if($sidebar[1] == 'sidebar')
		$grid = 'col-12';
		
		?>

    <div class="<?php echo $grid; ?>"> 
      <div id="<?php echo $this->id; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
        <?php
				if ( ! empty($instance['title']) ){
					echo ( $args['before_title'] . $title . $args['after_title'] );
				}
				?>
        <div>
          <?php echo !empty($desc) ? '<div class="kanews-section-description p-1" style="padding-bottom:0 !important"><p class="mb-0">'.$desc.'</p></div>' : '';
          $shortcode = '[kanews-calculator tur="'.$tur.'" show_tabs="'.$show_tabs.'"';
          if (!empty($index)) {
            $shortcode .= ' index="'.$index.'"';
          }
          $shortcode .= ']';
          echo do_shortcode($shortcode); ?>
        </div>
      </div>
    </div>
    
  <?php
  }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

    $instance['title'] = $new_instance['title'];
    $instance['desc'] = $new_instance['desc'];
		$instance['tur'] = $new_instance['tur'];
		$instance['grid'] = $new_instance['grid'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		$instance['show_tabs'] = $new_instance['show_tabs'];
		$instance['index'] = $new_instance['index'];

		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
      'title' => esc_html__('Çevirici', 'kanews'), 
      'desc' => '',
      'tur' => 'doviz',
      'grid' => 'col-12',
      'hide_desktop' => 'off',
      'hide_mobile' => 'off',
      'show_tabs' => 'on',
      'index' => '',
    );
		$instance = wp_parse_args((array) $instance, $defaults);

    // Genel Ayarlar
    Kanews_Form_Elements::render_accordion_field([
        'title' => __('Genel Ayarlar', 'kanews'),
        'content' => [
            [
                'type' => Kanews_Form_Elements::TYPE_TEXT,
                'id' => $this->get_field_id('title'),
                'name' => $this->get_field_name('title'),
                'label' => __('Başlık', 'kanews'),
                'value' => $instance['title']
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_SELECT,
                'id' => $this->get_field_id('grid'),
                'name' => $this->get_field_name('grid'),
                'label' => __('Genişlik', 'kanews'),
                'value' => $instance['grid'],
                'options' => [
                    'col-12' => '12/12',
                    'col-12 col-lg-8' => '12/8',
                    'col-12 col-lg-6' => '12/6',
                    'col-12 col-lg-4' => '12/4',
                    'col-12 col-md' => __('Sığdır', 'kanews')
                ]
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TEXTAREA,
                'id' => $this->get_field_id('desc'),
                'name' => $this->get_field_name('desc'),
                'label' => __('Açıklama', 'kanews'),
                'value' => $instance['desc']
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_SELECT,
                'id' => $this->get_field_id('tur'),
                'name' => $this->get_field_name('tur'),
                'label' => __('Araç', 'kanews'),
                'value' => $instance['tur'],
                'options' => [
                    'coin' => __('Kripto Para Çevirici', 'kanews'),
                    'doviz' => __('Döviz Çevirici', 'kanews'),
                    'emtia' => __('Altın Çevirici', 'kanews'),
                    'burc' => __('Burç', 'kanews'),
                    'vki' => __('Vücut Kitle İndeksi', 'kanews'),
                    'kredi' => __('Kredi Hesaplayıcı', 'kanews'),
                    'birikim' => __('Yatırım Hesaplayıcı', 'kanews'),
                    // 'birimcevir' => __('Birim Çevirici', 'kanews'), 
                    // 'enflasyon' => __('Enflasyon Hesaplayıcı', 'kanews'),
                    // 'vergi' => __('Vergi Hesaplayıcı', 'kanews'),
                    // 'kkm' => __('Kur Korumalı Mevduat Getiri Hesabı', 'kanews')

                    // 'kkm' => __('Kur Korumalı Mevduat Getiri Hesabı', 'kanews')
                ]
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TEXT,
                'id' => $this->get_field_id('index'),
                'name' => $this->get_field_name('index'),
                'label' => __('Kripto Para Birimi (TRY, USD, EUR)', 'kanews'),
                'value' => $instance['index'],
                'description' => __('Kripto para çevirici için temel para birimi. Boş bırakılırsa varsayılan değer kullanılır.', 'kanews')
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('show_tabs'),
                'name' => $this->get_field_name('show_tabs'),
                'label' => __('Sekmeleri Göster', 'kanews'),
                'value' => $instance['show_tabs']
            ]
        ]
    ]);

    // Görünürlük Ayarları
    Kanews_Form_Elements::render_accordion_field([
        'title' => __('Görünürlük Ayarları', 'kanews'),
        'content' => [
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('hide_desktop'),
                'name' => $this->get_field_name('hide_desktop'),
                'label' => __('Masaüstünde Gizle', 'kanews'),
                'value' => $instance['hide_desktop']
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('hide_mobile'),
                'name' => $this->get_field_name('hide_mobile'),
                'label' => __('Mobilde Gizle', 'kanews'),
                'value' => $instance['hide_mobile']
            ]
        ]
    ]);


	}
}
?>