<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if ( is_admin() || is_customize_preview() ) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_carousel_1 extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_carousel_1 kanews-section-flat kanews-section-gutter');
		$control_ops = array('id_base' => 'kanews_widget_carousel_1');
		parent::__construct('kanews_widget_carousel_1', ''.KAN_THEME_NAME .' - '.__( "Carousel" , 'kanews' ) , $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}

	private static function get_defaults() {
		return array(
			'title'           => '',
			'show_more_link'  => '',
			'variations'      => '1',
			'postnotin'       => 'off',
			'categories'      => array(),
			'posts'           => 5,
			'sortby'          => 'recent',
			'date_range'      => '0',
			'format'          => '0',
			'offset'          => '0',
			'tags'            => '',
			'show_post_cat'   => 'on',
			'show_post_date'  => 'off',
			'include_columist'=> 'off',
			'bg-color'        => '',
			'bg-color2'       => '',
			'hide_desktop'    => 'off',
			'hide_mobile'     => 'off',
		);
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$instance = Kanews_Widget_Helper::normalize_instance( $instance, self::get_defaults() );

		if ( ! Kanews_Widget_Helper::should_render_widget( $instance ) ) {
			return;
		}

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );

		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
		$variations = (isset($instance['variations'])) ? $instance['variations'] : '1';
		$tags = (isset($instance['tags'])) ? $instance['tags'] : '';
		$posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
		$offset = (isset($instance['offset'])) ? $instance['offset'] : '';
		$date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
		$sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$is_do_not_dublicate = $instance['postnotin'] == 'on' ? true : false;
		$format = !empty($instance['format']) ? $instance['format'] : '';
		
		$post_type = !isset($instance['include_columist']) ? 'post' : array('post', 'columist');

		$show_post_cat = !isset($instance['show_post_cat']) ? false : true;
		$show_post_date = !isset($instance['show_post_date']) ? 'off' : 'on';

		$bg_color = !empty($instance['bg-color']) ? $instance['bg-color'] : '';
		$bg_color2 = !empty($instance['bg-color2']) ? $instance['bg-color2'] : '';
		
		$thumb = 'kanews-manset-4';
		$thumb_small = 'kanews-post-1';


		if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
	
		$cols = 5;
		
		if($sidebar[1] == 'content') {
			$cols = 7;
			$thumb = 'kanews-manset-3';
			$thumb_small = 'kanews-post-1';
		}

		if( $variations == '4' ) {
			$thumb = 'kanews-manset-2';
			$thumb_small = 'kanews-post-3';
		}elseif( $variations == '5' ) {
			$thumb = 'full';
			$cols = 5;
			$thumb_small = 'kanews-post-3';
		}
		global $post;
		$args2 = array(
			'showposts' =>  $posts,
			'ignore_sticky_posts' => 1,
			'post_type' => $post_type,
			'tag' => $tags,
			'orderby' => $sortby,
			'cat' => $categories,
			'offset' => $offset,
		);

		if(is_category()) {
			if( ! empty($categories) && $categories != 'all' ) 
			$args2['cat'] = $categories;
			elseif( get_query_var( 'cat' ) )
			$args2['cat'] = get_query_var( 'cat' );
		}

		$counter = 1; 
		$chunks = array_chunk( get_posts( $args2 ), $cols );

		if ($chunks) : 
		$widget_id = '#'. $args['widget_id'];
		$output_css = '';
		if( $bg_color != '' && $bg_color2 != '') {
			$output_css .= "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">";
			$output_css .= "
			.light-mode $widget_id .kanews-post-overlay {
				--gradient-start-color: $bg_color;
				--gradient-end-color: $bg_color2;
			}
			";
			echo ( kan_minify_css($output_css) ) ."</style>";
		}
		$counter = 0;
		?>
		<div class="col-12"> 
			<div id="<?php echo $this->id; ?>" class="kanews-section kanews-carousel-<?php echo $sidebar[1]; ?> <?php echo $this->widget_options['classname']; ?>">
				<?php 
				if ( ! empty($instance['title']) ){
					echo ( $args['before_title'] . $title . $args['after_title'] );
				}
				?>
				<div class="kanews-slider-wrapper">
				<?php foreach( $chunks as $key => $chunk ){ $counter++; ?>
					<div class="kanews-carousel-row kanews-carousel-variation-<?php echo $variations; ?> <?php echo $counter > 1 ? 'kanews-carousel-multiple' : ''; ?>">
						<?php foreach( $chunk as $item => $post ) { setup_postdata( $post ); ?>

							<?php if($variations != 5 && $item == 0 || $variations == 5 && $item == 2 ): ?>
								<div class="kanews-carousel-item kanews-carousel-big-item">
									<div class="kanews-post-overlay">
										<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
										<?php kanews_post_thumbnail($thumb, 'kanews-post-thumb'); ?>
										<?php do_action('kanews_post_hook'); ?>
										<div class="kanews-post-content">
											<?php if($show_post_cat != false): ?>
												<?php echo kanews_primary_category($post->ID); ?>
											<?php endif; ?>
											<?php if($show_post_date != 'off'): ?>
												<?php echo kanews_post_date('post', 'span'); ?>
											<?php endif; ?>
											<?php the_title( sprintf( '<h3 class="kanews-post-headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
											<?php if (kanews_get_option('excerpt-length') != ''): ?>
											<?php the_excerpt(); ?>
										<?php endif; ?>
										</div>
									</div>
								</div>
							<?php else: ?>
								<?php if( $variations != 5 ): ?>
								<div class="kanews-carousel-item kanews-carousel-small-item">
									<div class="kanews-post-overlay">
										<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
										<?php kanews_post_thumbnail($thumb_small, 'kanews-post-thumb'); ?>
										<?php do_action('kanews_post_hook'); ?>
										<div class="kanews-post-content">
											<?php if($show_post_cat != false): ?>
												<?php echo kanews_primary_category($post->ID); ?>
											<?php endif; ?>
											<?php if($show_post_date != 'off'): ?>
												<?php echo kanews_post_date('post', 'span'); ?>
											<?php endif; ?>
											<?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
										</div>
									</div>
								</div>
								<?php else: ?>
									<div class="kanews-post-item kanews-post-grid-item kanews-carousel-small-item">
										<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php echo esc_attr(get_the_title()); ?>"></a>	
										<?php do_action('kanews_post_hook'); ?>
										<?php kanews_post_thumbnail('kanews-post-1', 'kanews-post-thumb'); ?>
										<div class="kanews-post-content">
											<?php if($show_post_cat != false): ?>
												<?php echo kanews_primary_category($post->ID); ?>
											<?php endif; ?>
											<?php the_title( sprintf( '<h4 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
											<?php if($show_post_date != 'off'): ?>
												<?php echo kanews_post_date(); ?>
											<?php endif; ?>
										</div>
									</div>
								<?php endif; ?>
							<?php endif; ?>

							<?php 
							if( $is_do_not_dublicate ){
								Kanews\Helper::do_not_dublicate( $post->ID );
							}
							?>
						<?php } ?>
					</div>
				<?php } ?>
				</div>
				<?php if ( ! empty( $instance['show_more_link'] ) ): ?>
					<div class="col-12">
					<div class="d-flex justify-content-center align-items-center"><a href="<?php echo esc_url( $instance['show_more_link'] ); ?>" class="kanews-label kanews-label-widget"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?></a></div>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<?php wp_reset_postdata(); endif; ?>
	<?php }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['show_more_link'] = $new_instance['show_more_link'];
		$instance['variations'] = $new_instance['variations'];

		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];
		$instance['tags'] = $new_instance['tags'];

		$instance['include_columist'] = $new_instance['include_columist'];
		$instance['show_post_date'] = $new_instance['show_post_date'];
		$instance['show_post_cat'] = $new_instance['show_post_cat'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];

		$instance['bg-color'] = $new_instance['bg-color'];
		$instance['bg-color2'] = $new_instance['bg-color2'];
		
		return $instance;
	}


  // Back-end
	public function form($instance)
	{
		$defaults = self::get_defaults();
		$instance = wp_parse_args((array) $instance, $defaults); 


		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('show_more_link'),
					'name' => $this->get_field_name('show_more_link'),
					'label' => __('Daha Fazla Linki', 'kanews'),
					'value' => $instance['show_more_link']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('variations'),
					'name' => $this->get_field_name('variations'),
					'label' => __('Varyasyon', 'kanews'),
					'value' => $instance['variations'],
					'options' => [
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5'
					]
			 ]
			]
		]);

		// Global Sıralama Ayarları
		Kanews_Form_Elements::render_posts_sorting_settings($this, $instance);

		// İçerik Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_cat'),
					'name' => $this->get_field_name('show_post_cat'),
					'label' => __('Yazı Kategorisini Göster', 'kanews'),
					'value' => $instance['show_post_cat']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_date'),
					'name' => $this->get_field_name('show_post_date'),
					'label' => __('Yazı Tarihini Göster', 'kanews'),
					'value' => $instance['show_post_date']
			 ]
			]
		]);

		// Görünüm Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color'),
					'name' => $this->get_field_name('bg-color'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['bg-color']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color2'),
					'name' => $this->get_field_name('bg-color2'),
					'label' => __('Arkaplan Rengi 2', 'kanews'),
					'value' => $instance['bg-color2']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
			 ]
			]
		]);
	}
}