<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_ilan', array(
    'title'       => KAN_THEME_NAME .' - '."İlan",
    'description' => "İlan sistemi ile alakalı tüm bileşenler.",
    'classname'   => 'kanews_widget_class_ilan',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
        'default' => 'İlanlar'
      ),

      array(
        'id'      => 'widget',
        'type'    => 'select',
        'title'   => 'Kullanılacak Bileşen',
        'options' => array(
          'hero' => 'Hero (Page Header)',
          'post' => 'İlanlar',
          'search' => 'İlan Ara',
        ),
        'default' => 'post'
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      // Search
      array(
        'id'      => 'city',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'search' ),
        'title'   => 'İl',
        'default' => true
      ),
      array(
        'id'      => 'town',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'search' ),
        'title'   => 'İlçe',
        'default' => true
      ),
      array(
        'id'      => 'tags_form',
        'dependency' => array( 'widget', '==', 'search' ),
        'type'    => 'switcher',
        'title'   => 'Etiket',
        'default' => true
      ),
      array(
        'id'      => 'search',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'search' ),
        'title'   => 'Kelime ile',
        'default' => true
      ),

      // Posts
      array(
        'id'      => 'col',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Sütun Başına Yazı',
        'options' => array(
          'col-6 col-lg-12' => '1',
          'col-6 col-lg-6' => '2',
          'col-6 col-lg-4' => '3',
          'col-6 col-md-4 col-lg-3' => '4',
          'col-6 col-md-3 col-lg-2' => '6',
        ),
        'default' => 'col-6 col-md-4 col-lg-3'
      ),
      array(
        'id'      => 'variations',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Varyasyon',
        'options' => array( '1' => '1', '2' => '2' ),
        'default' => '1'
      ),
      array(
        'id'       => 'posts',
        'dependency' => array( 'widget', '==', 'post' ),
        'type'     => 'slider',
        'title'    => 'İlan Sayısı',
        'min'      => 1,
        'step'     => 1,
        'default'  => 6,
      ),
      array(
        'id'      => 'sortby',
        'type'    => 'select',
        'title'   => 'Göre Sırala',
        'dependency' => array( 'widget', '==', 'post' ),
        'options' => array(
          'recent-s' => 'Yayınlanma Tarihine Göre (Yukarı Taşıma Dahil)',
          'recent' => 'Yayınlanma Tarihine Göre',
          'post-modified' => 'Düzenlenme Tarihine Göre',
          'commented' => 'En Çok Yorum Yapılan',
          'random' => 'Rastgele'
        ),
        'default' => 'recent-s'
      ),
      array(
        'id'      => 'date_range',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Zaman Aralığı',
        'options' => array(
          '0' => 'Zaman Aralığı Seçin',
          'day' => 'Son 1 Gün',
          'week' => 'Son 1 Hafta',
          'month' => 'Son 1 Ay',
          'year' => 'Son 1 Yıl',
        ),
        'default' => '0'
      ),
      array(
        'id'      => 'categories',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Kategori',
        'options' => 'kanews_get_terms_ilan_kategori',
        'multiple'=> true,
        'chosen'  => true,
        'default' => '0'
      ),
      array(
        'id'      => 'tags',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Etiket',
        'options' => 'kanews_get_terms_ilan_tag',
        'multiple'=> true,
        'chosen'  => true,
        'default' => '0'
      ),
      array(
        'id'      => 'city_query',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'İl',
      ),
      array(
        'id'      => 'town_query',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'İlçe',
      ),

      array(
        'id'      => 'show_more_link',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),

        'title'   => 'Daha Fazla Linki',
        'default' => ''
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      ),

      // Hero Settings
      array(
        'id'      => 'hero_title',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Başlık',
        'default' => 'İlanlar'
      ),
      array(
        'id'      => 'hero_description',
        'type'    => 'textarea',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Açıklama',
        'default' => 'İlginizi çeken ilanları keşfedin, ilanınızı ücretsiz ekleyin.'
      ),
      array(
        'id'      => 'hero_bg_image',
        'type'    => 'media',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Arka Plan Görseli',
        'library' => 'image',
      ),
      array(
        'id'      => 'hero_bg_color',
        'type'    => 'color',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Arka Plan Rengi',
        'default' => '',
      ),
      array(
        'id'      => 'hero_overlay_color',
        'type'    => 'color',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Overlay Rengi', 
      ),
      array(
        'id'      => 'hero_show_add_button',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'İlan Ekle Butonu Göster',
        'default' => true
      ),
      array(
        'id'      => 'hero_show_all_button',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Tüm İlanlar Butonu Göster',
        'default' => true
      ),
      array(
        'id'      => 'hero_show_search',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Arama Formu Göster',
        'default' => true
      ),
      array(
        'id'      => 'hero_search_hint',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'hero' ),
        'title'   => 'Arama Formu Altı Yazı',
        'default' => 'İlan adı, kategori veya konum ile arama yapabilirsiniz.'
      ),
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_ilan' ) ) {
    function kanews_widget_ilan( $widgets, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if( ! kanews_get_option('ilan-sistemi') )
      return;

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      if( $instance['widget'] == 'hero' ) {
        // Script'i yükle
        if(!wp_script_is('kanews-ilan-search', 'enqueued')) {
          wp_enqueue_script('kanews-ilan-search');
        }
        
        $args_defaults = array( 
          'hero_title'           => 'İlanlar',
          'hero_description'     => 'İlginizi çeken ilanları keşfedin, ilanınızı ücretsiz ekleyin.',
          'hero_bg_image'        => '',
          'hero_bg_color'        => '',
          'hero_overlay_color'   => '',
          'hero_show_add_button' => true,
          'hero_show_all_button' => true,
          'hero_show_search'     => true,
          'hero_search_hint'     => 'İlan adı, kategori veya konum ile arama yapabilirsiniz.',
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        
        // Translate default values if empty
        if (empty($instance['hero_title'])) {
          $args['hero_title'] = esc_html__('İlanlar', 'kanews');
        } else {
          $args['hero_title'] = esc_html($args['hero_title']);
        }
        if (empty($instance['hero_description'])) {
          $args['hero_description'] = esc_html__('İlginizi çeken ilanları keşfedin, ilanınızı ücretsiz ekleyin.', 'kanews');
        } else {
          $args['hero_description'] = esc_html($args['hero_description']);
        }
        if (empty($instance['hero_search_hint'])) {
          $args['hero_search_hint'] = esc_html__('İlan adı, kategori veya konum ile arama yapabilirsiniz.', 'kanews');
        } else {
          $args['hero_search_hint'] = esc_html($args['hero_search_hint']);
        }
        
        // Get background image
        $bg_image = '';
        if (!empty($args['hero_bg_image'])) {
          $bg_image_id = is_array($args['hero_bg_image']) ? $args['hero_bg_image']['id'] : $args['hero_bg_image'];
          if ($bg_image_id) {
            $bg_image = wp_get_attachment_image_url($bg_image_id, 'full');
          }
        }
        
        // Get background color
        $bg_color = !empty($args['hero_bg_color']) ? $args['hero_bg_color'] : '';

        if( empty($bg_image) && empty($bg_color) ) {
          $bg_image = get_template_directory_uri() . '/assets/img/static/Footer.jpg';
        }
        
        // Get overlay color
        $overlay_color = !empty($args['hero_overlay_color']) ? $args['hero_overlay_color'] : '';
        
        // Get links
        $add_ilan_url = kanews_get_option('account-page') ? esc_url(add_query_arg('islem', 'ilan-ekle', kanews_account_page_url())) : '#';
        $all_ilan_url = get_post_type_archive_link('ilan');
        
        // Unique ID for widget instance
        $widget_id = 'widget-' . uniqid();
        
        echo '<div class="col-12"><div class="kanews-widget-ilan-hero container-full">'; ?>
        
        <div class="kanews-page-header kanews-page-header-cpt">
            <div class="kanews-page-header-bg" style="<?php 
              if (!empty($bg_image)) : 
                echo 'background-image: url(\'' . esc_url($bg_image) . '\');';
              endif;
              if (!empty($bg_color)) : 
                echo ' background-color: ' . esc_attr($bg_color) . ';';
              endif;
            ?>"></div>
            <div class="kanews-page-header-overlay" style="<?php 
              if (!empty($overlay_color)) : 
                echo 'background-color: ' . esc_attr($overlay_color) . ';';
              endif;
            ?>"></div>
            
            <div class="container">
                <div class="row align-items-center justify-content-center text-center">
                    <div class="col-12 col-lg-6">
    
                        
                        <h1 class="kanews-page-title"><?php echo esc_html($args['hero_title']); ?></h1>
                        
                        <?php if (!empty($args['hero_description'])) : ?>
                        <p class="kanews-page-description"><?php echo esc_html($args['hero_description']); ?></p>
                        <?php endif; ?>
                        
                        <?php if ($args['hero_show_add_button'] || $args['hero_show_all_button']) : ?>
                        <div class="kanews-page-header-actions gap-1 d-flex flex-wrap">
                            <?php if ($args['hero_show_add_button'] && kanews_get_option('account-page')) : ?>
                            <a href="<?php echo esc_url($add_ilan_url); ?>" class="kanews-btn kanews-btn-sm">
                                <i class="icon-plus"></i> <?php esc_html_e('İlan Ekle', 'kanews'); ?>
                            </a>
                            <?php endif; ?>
                            <?php if ($args['hero_show_all_button']) : ?>
                            <a href="<?php echo esc_url($all_ilan_url); ?>" class="kanews-btn bg-info kanews-btn-sm">
                                <?php esc_html_e('Tüm İlanlar', 'kanews'); ?>
                            </a>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <?php if ($args['hero_show_search']) : ?>
            <div class="kanews-page-header-search">
                    <form method="GET" class="kanews-form-filter" action="<?php echo get_post_type_archive_link('ilan'); ?>">
                        <div class="kanews-form2 mb-0 position-relative">
                            <input value="<?php echo isset($_GET['ilan_name']) ? esc_attr($_GET['ilan_name']) : ''; ?>" type="text" name="search" placeholder="<?php esc_html_e('İlan Adı Ara...', 'kanews'); ?>">
                        </div>
                    </form>
                    <?php if (!empty($args['hero_search_hint'])) : ?>
                    <div class="kanews-search-hint"><?php echo esc_html($args['hero_search_hint']); ?></div>
                    <?php endif; ?>
                </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
       <?php 
        
        echo '</div></div>';
      } else if( $instance['widget'] == 'search' ) {
        if(!wp_script_is('kanews-ilan-search', 'enqueued')) {
          wp_enqueue_script('kanews-ilan-search');
        }
        $args_defaults = array( 
          'grid'     => 'col-12',
          'title'    => '',
          'city'     => true,
          'town'     => true,
          'search'   => true,
          'tags_form'     => true,
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        
        // Unique ID for widget instance
        $widget_id = 'widget-' . uniqid();
        
        echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews-widget-ilan-search">'; ?>
        
        <?php if ( ! empty($args['title']) ):
          echo ( $widgets['before_title'] . $args['title'] . $widgets['after_title'] );
        endif; ?>
  
        <form id="<?php echo esc_attr($widget_id); ?>-widget-form" class="p-1 kanews-form-filter" data-widget-id="<?php echo esc_attr($widget_id); ?>" action="<?php echo get_post_type_archive_link('ilan'); ?>">
          <div class="row no-gutters">
            <?php if( $args['city'] ): ?>
              <div class="col-12">
                <div class="kanews-form2 bgw position-relative">
                  <input type="text" 
                         id="<?php echo esc_attr($widget_id); ?>-ilan-il-search" 
                         class="mb-0" 
                         placeholder="<?php esc_html_e( 'Ara', 'kanews' ); ?>" 
                         autocomplete="off" />
                  <button type="button" class="ilan-clear-btn" id="<?php echo esc_attr($widget_id); ?>-ilan-il-clear" style="display: none;">
                    <i class="icon-close"></i>
                  </button>
                  <select id="<?php echo esc_attr($widget_id); ?>-ilan-il" style="display: none;">
                    <option value=""><?php esc_html_e( 'İl Seç', 'kanews' ); ?></option>
                  </select>
                  <input type="hidden" name="il" id="<?php echo esc_attr($widget_id); ?>-ilan-il-hidden" value="" />
                  <div id="<?php echo esc_attr($widget_id); ?>-ilan-il-dropdown" class="ilan-dropdown" style="display: none;"></div>
                </div>
              </div>
            <?php endif; ?>
            <?php if( $args['city'] &&  $args['town'] ): ?>
              <div class="col-12">
                <div class="kanews-form2 bgw position-relative">
                  <input type="text" 
                         id="<?php echo esc_attr($widget_id); ?>-ilan-ilce-search" 
                         class="mb-0" 
                         placeholder="<?php esc_html_e( 'Ara', 'kanews' ); ?>" 
                         autocomplete="off"
                         disabled />
                  <button type="button" class="ilan-clear-btn" id="<?php echo esc_attr($widget_id); ?>-ilan-ilce-clear" style="display: none;">
                    <i class="icon-close"></i>
                  </button>
                  <select id="<?php echo esc_attr($widget_id); ?>-ilan-ilce" style="display: none;">
                    <option value=""><?php esc_html_e( 'İlçe Seç', 'kanews' ); ?></option>
                  </select>
                  <input type="hidden" name="ilce" id="<?php echo esc_attr($widget_id); ?>-ilan-ilce-hidden" value="" />
                  <div id="<?php echo esc_attr($widget_id); ?>-ilan-ilce-dropdown" class="ilan-dropdown" style="display: none;"></div>
                </div>
              </div>
            <?php endif; ?>
          </div>
          
          <?php 
            // İlan Kategori seçimi
            $kategoriler = get_terms( array(
                'taxonomy' => 'ilan-kategori',
                'hide_empty' => false,
                'parent' => 0
            ) );
            if ( !empty($kategoriler) && !is_wp_error($kategoriler) ) :
              // URL parametresinden veya mevcut taxonomy sayfasından kategori ID'sini al
              $selected_kategori = '';
              if (isset($_GET['kategori']) && !empty($_GET['kategori'])) {
                $selected_kategori = intval($_GET['kategori']);
              } elseif (is_tax('ilan-kategori')) {
                // Eğer ilan-kategori taxonomy sayfasındaysak, mevcut term'i seç
                $current_term = get_queried_object();
                if ($current_term && isset($current_term->term_id)) {
                  // Eğer alt kategori ise, parent'ını bul
                  if ($current_term->parent > 0) {
                    // Alt kategori ise parent'ını seç
                    $selected_kategori = $current_term->parent;
                  } else {
                    // Ana kategori ise direkt seç
                    $selected_kategori = $current_term->term_id;
                  }
                }
              }
              
              $output = '<div class="empty" style="display: block;height: 10px"></div>';
              $output .= '<div class="kanews-form2 bgw">';
              $output .= '<select name="kategori" class="mb-0">';
              $output .= '<option value="">'.esc_html__( 'Kategori Seç', 'kanews' ).'</option>';
              foreach( $kategoriler as $kategori ) {
                $selected = ($selected_kategori == $kategori->term_id) ? ' selected' : '';
                $output .= '<option value="'.esc_attr( $kategori->term_id ).'"'.$selected.'>'.esc_html( $kategori->name ).'</option>';
              }
              $output .= '</select>';
              $output .= '</div>';
              echo $output;
            endif;
          ?>
          
          <?php 
            if( $args['tags_form'] ) {
              $taxonomies = get_terms( array(
                  'taxonomy' => 'ilan-etiket',
                  'hide_empty' => false
              ) );
              if ( !empty($taxonomies) ) :
                $output = '<div class="empty" style="display: block;height: 10px"></div><div class="row kanews-scroll" style="max-height: 200px">';
                foreach( $taxonomies as $category ) {
                  $checked = (isset($_GET['labels']) && in_array($category->term_id, (array)$_GET['labels'])) ? ' checked' : '';
                  $output .= '<div class="col-12 d-flex"><div class="kanews-form"><input type="checkbox" name="labels[]" value="'.esc_attr( $category->term_id ).'" id="'.esc_attr($widget_id).'-ilan-etiket-'.$category->slug.'"'.$checked.' />
                  </div><label for="'.esc_attr($widget_id).'-ilan-etiket-'.$category->slug.'">'.esc_html( $category->name ).'</label></div>';
                }
                $output.='</div>';
                echo $output;
              endif;
            }
          ?>
          <?php if( $args['search'] ): ?>
            <div class="kanews-form2 bgw">
              <input class="mb-0" type="text" name="search" placeholder="<?php esc_html_e('Kelime Ara', 'kanews'); ?>" value="<?php echo isset($_GET['search']) ? esc_attr($_GET['search']) : ''; ?>" />
            </div>
          <?php endif; ?>
          <div class="kanews-form2 bgw">
            <input class="mb-0" type="number" name="p" min="1" placeholder="<?php esc_html_e('İlan no ile ara', 'kanews'); ?>" value="<?php echo isset($_GET['p']) ? esc_attr($_GET['p']) : ''; ?>" />
          </div>
          <button type="submit" class="kanews-btn kanews-btn-block kanews-btn-sm mb-0"><?php esc_html_e( 'Filtrele', 'kanews' ); ?></button>
        </form>
  
        <?php echo '</div></div>';
      } else {
        $args_defaults = array( 
          'grid'       => 'col-12',
          'col'        => 'col-6 col-md-4 col-lg-3',
          'sortby'     => 'recent-s',
          'title'      => '',
          'categories' => '',
          'tags'       => '',
          'city_query' => '',
          'town_query' => '',
          'show_more_link' => '',
          'date_range' => '0',
          'posts'      => 10,
          'post_type'  => 'ilan',
          'variations' => '1',
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        extract($args);


        $query_args = array(
          'number'				=> $posts,
          'sortby' 				=> $sortby,
          'range'				  => $date_range,
          'icat'    			=> $categories,
          'itags'    			=> $tags,
          'city_query'    => $city_query,
          'town_query'    => $town_query,
          'post_type'		  => 'ilan'
        );

        // print_r($query_args);

        $kanews_query = kan_query( $query_args );
        if ($kanews_query->have_posts()) : 
          echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews_widget_ilan ' . ( $variations != 2 ? 'kanews-section-flat' : 'kanews-section-gutter' ) . '">'; ?>
            <?php if ( ! empty($title) ):
              echo ( $widgets['before_title'] . $title . $widgets['after_title'] );
            endif; ?>

            <?php if ( $variations == 2 ) :
              // Slider item sayısı, sidebar ve grid'e göre
              $item = 4;
              if ( isset( $widgets['id'] ) ) {
                $sidebar = explode( '-', $widgets['id'] );
              } else {
                $sidebar = array( '0' => 'home', '1' => 'content' );
              }

              if ( isset( $sidebar[2] ) && $sidebar[2] === 'full' ) {
                switch ( $grid ) {
                  case 'col-12':
                    $item = 4;
                    break;
                  case 'col-12 col-lg-8':
                    $item = 3;
                    break;
                  case 'col-12 col-lg-6':
                    $item = 2;
                    break;
                  case 'col-12 col-lg-4':
                    $item = 1;
                    break;
                }
              } elseif ( $sidebar[1] === 'content' ) {
                $item = 3;
                $grid = 'col-12';
              } elseif ( $sidebar[1] === 'sidebar' ) {
                $item = 1;
                $grid = 'col-12';
              }

              $slick_options = [
                'slidesToShow'   => $item,
                'dots'           => true,
                'adaptiveHeight' => false,
                'arrows'         => true,
                'autoplay'       => 1,
                'responsive'     => [
                  [
                    'breakpoint' => 992,
                    'settings'   => [
                      'slidesToShow' => 3,
                    ],
                  ],
                  [
                    'breakpoint' => 525,
                    'settings'   => [
                      'slidesToShow' => 2,
                    ],
                  ],
                  [
                    'breakpoint' => 400,
                    'settings'   => [
                      'slidesToShow' => 1,
                    ],
                  ],
                ],
              ];

              switch ( $item ) {
                case 1:
                  $item_Col = 'kanews-slider-col col-12 col-md-12';
                  break;
                case 2:
                  $item_Col = 'kanews-slider-col col-12 col-md-4 col-lg-6';
                  break;
                case 3:
                  $item_Col = 'kanews-slider-col col-12 col-md-4 col-lg-4';
                  break;
                case 4:
                default:
                  $item_Col = 'kanews-slider-col col-12 col-md-4 col-lg-3';
                  break;
              }
              ?>
              <div class="kanews-slider-0">
                <div class="kanews-slider-wrapper kanews-slider-grid" data-slick='<?php echo wp_json_encode( $slick_options ); ?>'>
            <?php else : ?>
              <div class="row">
            <?php endif; ?>

              <?php while ( $kanews_query->have_posts() ) : $kanews_query->the_post(); ?>
                <?php if ( $variations == 2 ) : ?>
                  <div class="<?php echo esc_attr( $item_Col ); ?>">
                    <?php get_template_part( 'template-parts/archives/article', 'ilan', array( 'col' => '' ) ); ?>
                  </div>
                <?php else : ?>
                  <?php get_template_part( 'template-parts/archives/article', 'ilan', array( 'col' => $col ) ); ?>
                <?php endif; ?>
              <?php endwhile; wp_reset_postdata();  ?>

              <?php if ( isset( $instance['show_more_link'] ) && ! empty( $instance['show_more_link'] ) ) : ?>
                <div class="col-12">
                  <div class="d-flex justify-content-center align-items-center">
                    <a href="<?php echo esc_url( $instance['show_more_link'] ); ?>" class="kanews-label kanews-label-widget"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?></a>
                  </div>
                </div>
              <?php endif; ?>

            <?php if ( $variations != 2 ) : ?>
                </div>
            <?php else : ?>
              </div>
              </div>
            <?php endif; ?>

          <?php echo '</div></div>';
        endif;
      }
    }
  }
}