<?php 

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_class_imagebox', array(
    'title'       => KAN_THEME_NAME .' - Resim Kutusu',
    'classname'   => 'kanews_widget_class_imagebox kanews-section-flat',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
      ),
      array(
        'id'      => 'style',
        'type'    => 'select',
        'title'   =>'Görünüm',
        'options' => array(
          '1' => sprintf('Görünüm %s - Minimal Gradient', '#1'),
          '2' => sprintf('Görünüm %s - Glassmorphism', '#2'),
          '3' => sprintf('Görünüm %s - Clean Card', '#3'),
          '4' => sprintf('Görünüm %s - Flip Card', '#4'),
          '5' => sprintf('Görünüm %s - Custom', '#5'),
        ),
        'default' => '1'
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   =>'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/4',
          'col-12 col-lg-4' => '12/4',
        ),
        'default' => 'col-12'
      ),
      array(
        'id'      => 'column',
        'type'    => 'select',
        'title'   =>'Sütun Başına',
        'options' => array(
          'col-12' => '1',
          'col-12 col-lg-6' => '2',
          'col-12 col-lg-4' => '3',
          'col-12 col-lg-3' => '4',
          'col-12 col-lg-2' => '6',
        ),
        'default' => 'col-12 col-lg-3'
      ),

      array(
        'id'       => 'image-height',
        'type'     => 'dimensions',
        'width'   => false,
        'title'    =>'Görsel Yüksekliği',
        'default'  => array(
          'height'  => '375',
          'unit'   => 'px',
        ),
      ),

      array(
        'id'     => 'imagebox',
        'type'   => 'group',
        'title'  =>'Gösterilecekler',
        'button_title'  =>'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Başlık'
          ),
          array(
            'id'    => 'subtitle',
            'type'  => 'text',
            'title' => 'Alt Başlık'
          ),
          array(
            'id'    => 'thumb',
            'type'  => 'media',
            'title' => 'Görsel'
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => 'Link'
          ),
          array(
            'id'    => 'color',
            'type'  => 'color',
            'title' =>'Vurgulanan Renk'
          ),
          array(
            'id'    => 'button_text',
            'type'  => 'text',
            'title' => 'Buton Metni'
          ),
          array(
            'id'    => 'button_link',
            'type'  => 'text',
            'title' => 'Buton Linki'
          ),
        ),
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
      ),

      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
      ),

      array(
        'id'      => 'open_in_new_tab',
        'type'    => 'switcher',
        'title'   => 'Linkleri Yeni Sekmede Aç',
        'default' => false,
      ),

      array(
        'id'         => 'style_settings',
        'type'       => 'accordion',
        'title'      => 'Stil Ayarları',
        'accordions' => array(
          array(
            'title'  => 'Stil Ayarları',
            'fields' => array(

          array(
            'id'    => 'border_radius',
            'type'  => 'slider',
            'title' => 'Köşe Yuvarlaklığı',
            'min'   => 0,
            'max'   => 30,
            'step'  => 1,
            'unit'  => 'px',
            'default' => '',
          ),

          array(
            'id'       => 'content_padding',
            'type'     => 'spacing',
            'title'    => 'İçerik Padding',
            'default'  => array(
              'top'    => '',
              'right'  => '',
              'bottom' => '',
              'left'   => '',
              'unit'   => 'px',
            ),
          ),

          array(
            'id'      => 'item_margin_bottom',
            'type'    => 'slider',
            'title'   => 'Öğe Arası Boşluk',
            'min'     => 0,
            'max'     => 60,
            'step'    => 2,
            'unit'    => 'px',
            'default' => '',
          ),

          array(
            'id'      => 'title_font_size',
            'type'    => 'slider',
            'title'   => 'Başlık Font Boyutu',
            'min'     => 12,
            'max'     => 32,
            'step'    => 1,
            'unit'    => 'px',
            'default' => '',
          ),

          array(
            'id'      => 'title_font_weight',
            'type'    => 'select',
            'title'   => 'Başlık Font Ağırlığı',
            'options' => array(
              '300' => 'Light (300)',
              '400' => 'Normal (400)',
              '500' => 'Medium (500)',
              '600' => 'Semi Bold (600)',
              '700' => 'Bold (700)',
            ),
            'default' => '',
          ),

          array(
            'id'      => 'subtitle_font_size',
            'type'    => 'slider',
            'title'   => 'Alt Başlık Font Boyutu',
            'min'     => 10,
            'max'     => 20,
            'step'    => 1,
            'unit'    => 'px',
            'default' => '',
          ),
          array(
            'id'      => 'hover_scale',
            'type'    => 'slider',
            'title'   => 'Hover Zoom Seviyesi',
            'min'     => 100,
            'max'     => 120,
            'step'    => 1,
            'unit'    => '%',
            'default' => '',
          ),

          array(
            'id'      => 'hover_lift',
            'type'    => 'slider',
            'title'   => 'Hover Yükselme Mesafesi',
            'min'     => 0,
            'max'     => 15,
            'step'    => 1,
            'unit'    => 'px',
            'default' => '',
          ),

          array(
            'id'      => 'animation_speed',
            'type'    => 'slider',
            'title'   => 'Animasyon Hızı',
            'min'     => 0.1,
            'max'     => 1.5,
            'step'    => 0.1,
            'unit'    => 's',
            'default' => '',
          ),

            ),
          ),
        ),
      ),

    )
  ) );

  if( ! function_exists( 'kanews_widget_class_imagebox' ) ) {
    function kanews_widget_class_imagebox( $widget, $instance ) {

      $args_defaults = array( 
        'grid'     => 'col-12',
        'column'   => 'col-12 col-lg-3',
        'style'    => '1',
        'imagebox' => '',
        'title'    => '',
        'hide_desktop' => false,
        'hide_mobile'  => false,
        'open_in_new_tab' => false,
        'image-height' => array(
          'height' => '375',
          'unit'   => 'px'
        ),
        'style_settings' => array(
          'border_radius' => '',
          'content_padding' => array(
            'top'    => '',
            'right'  => '',
            'bottom' => '',
            'left'   => '',
            'unit'   => 'px',
          ),
          'item_margin_bottom' => '',
          'title_font_size' => '',
          'title_font_weight' => '',
          'subtitle_font_size' => '',
          'hover_scale' => '',
          'hover_lift' => '',
          'animation_speed' => '',
        ),
      ); 
      $args = wp_parse_args( $instance, $args_defaults );

      if($args['hide_mobile']) {
        if(kan_is_mobile())
        return;
      }
  
      if($args['hide_desktop']) {
        if(!kan_is_mobile())
        return;
      }

      if(empty($args['imagebox']))
      return;

      ?>

      <div class="<?php echo $args['grid']; ?>"> 
        <div id="<?php echo $widget['widget_id']; ?>" class="kanews-section kanews-section-flat kanews-section-gutter <?php echo $widget['class'] ?> kanews-image-box-style-<?php echo esc_attr($args['style']); ?>">
          <?php if($args['title'] != ''): ?>
           <?php echo kanews_widget_title($args['title'], 'h3', 'kanews-image-box-section-title'); ?>
          <?php endif; ?>
          <div class="row">
            <?php 
            $item_index = 0;
            foreach($args['imagebox'] as $item): 
              $item_index++;
              $has_title = isset($item['title']) && $item['title'] !== '';
              $has_subtitle = isset($item['subtitle']) && $item['subtitle'] !== '';
              $has_button = isset($item['button_text']) && $item['button_text'] !== '';
              $has_content = $has_title || $has_subtitle || $has_button;
              $button_link = '#';
              if($has_button) {
                if(isset($item['button_link']) && $item['button_link'] !== '') {
                  $button_link = esc_url($item['button_link']);
                } elseif(isset($item['link']) && $item['link'] !== '') {
                  $button_link = esc_url($item['link']);
                }
              }
              $color_style = ( isset($item['color']) && $item['color'] != '' ) ? 'style="--gradient-start-color: '.esc_attr($item['color']).'"' : '';
            ?>
              <div class="kanews-image-box-item <?php echo $args['column']; ?>" data-index="<?php echo $item_index; ?>">
                <?php if($args['style'] === '4'): ?>
                  <div class="kanews-image-box kanews-image-box-flip">
                    <div class="kanews-image-box-flip-inner">
                      <div class="kanews-image-box-face kanews-image-box-face-front">
                        <?php if($item['thumb'] != ''): ?>
                          <div class="kanews-image-box-image">
                            <?php echo wp_get_attachment_image($item['thumb']['id'], 'full', false, array('loading' => 'lazy')); ?>
                          </div>
                        <?php endif; ?>
                        <?php if($has_title): ?>
                          <div class="kanews-image-box-face-content" <?php echo $color_style; ?>>
                            <h4 class="kanews-image-box-title"><?php echo esc_html($item['title']); ?></h4>
                          </div>
                        <?php endif; ?>
                      </div>
                      <div class="kanews-image-box-face kanews-image-box-face-back">
                        <?php if($has_content): ?>
                          <div class="kanews-image-box-content d-flex flex-column g-10" <?php echo $color_style; ?>>
                            <?php if($has_title): ?>
                              <h3 class="kanews-image-box-title"><?php echo esc_html($item['title']); ?></h3>
                            <?php endif; ?>
                            <?php if($has_subtitle): ?>
                              <div class="kanews-image-box-subtitle"><?php echo esc_html($item['subtitle']); ?></div>
                            <?php endif; ?>
                            <?php if($has_button): ?>
                              <div class="kanews-image-box-button">
                                <a href="<?php echo $button_link; ?>" class="kanews-label" <?php echo $args['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>>
                                  <?php echo esc_html($item['button_text']); ?>
                                </a>
                              </div>
                            <?php endif; ?>
                          </div>
                        <?php endif; ?>
                      </div>
                      <?php if($item['link'] != ''): ?>
                        <a class="kanews-image-box-url" href="<?php echo esc_url($item['link']); ?>" title="<?php echo esc_attr( $item['title'] ); ?>" <?php echo $args['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>></a>
                      <?php endif; ?>
                    </div>
                  </div>
                <?php else: ?>
                  <div class="kanews-image-box">
                    <?php if($item['thumb'] != ''): ?>
                      <div class="kanews-image-box-image">
                        <?php echo wp_get_attachment_image($item['thumb']['id'], 'full', false, array('loading' => 'lazy')); ?>
                      </div>
                    <?php endif; ?>
                    <?php if($item['link'] != ''): ?>
                      <a class="kanews-image-box-url" href="<?php echo esc_url($item['link']); ?>" title="<?php echo esc_attr( $item['title'] ); ?>" <?php echo $args['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>></a>
                    <?php endif; ?>
                    <?php if($has_content): ?>
                      <div class="kanews-image-box-content d-flex flex-column g-10" <?php echo $color_style; ?>>
                        <div>
                        <?php if($has_title): ?>
                          <h4 class="kanews-image-box-title"><?php echo esc_html($item['title']); ?></h4>
                        <?php endif; ?>
                        <?php if($has_subtitle): ?>
                          <div class="kanews-image-box-subtitle"><?php echo esc_html($item['subtitle']); ?></div>
                        <?php endif; ?>
                        </div>
                        <?php if($has_button): ?>
                          <div class="kanews-image-box-button">
                            <a href="<?php echo $button_link; ?>" class="kanews-label" <?php echo $args['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>>
                              <?php echo esc_html($item['button_text']); ?>
                            </a>
                          </div>
                        <?php endif; ?>
                        <?php if($args['style'] == '2'): ?>
                          <div class="kanews-image-box-overlay"></div>
                        <?php endif; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    <?php 

      $widget_id = '#'. $widget['widget_id'];
      $widget_id_clean = str_replace('#', '', $widget['widget_id']);

      $style_settings = isset($args['style_settings']) && is_array($args['style_settings']) ? $args['style_settings'] : array();
      $style_css = '';

      $get_style_setting = function($key) use ($args, $style_settings) {
        if (is_array($style_settings) && array_key_exists($key, $style_settings)) {
          return $style_settings[$key];
        }
        if (array_key_exists($key, $args)) {
          return $args[$key];
        }
        return null;
      };

      $normalize_bool = function($value) {
        if (is_bool($value)) {
          return $value;
        }
        if (is_string($value)) {
          return in_array(strtolower($value), array('1', 'true', 'on', 'yes'), true);
        }
        return (bool) $value;
      };

      // Border Radius
      $border_radius = $get_style_setting('border_radius');
      if ($border_radius !== '' && $border_radius !== null) {
        $radius_value = is_numeric($border_radius) ? $border_radius : intval($border_radius);
        $style_css .= "
          {$widget_id} .kanews-image-box {
            border-radius: {$radius_value}px;
          }
        ";

        if ( $args['style'] == '3' ) {
          $style_css .= "
            {$widget_id}.kanews-image-box-style-3 .kanews-image-box-image {
              border-radius: {$radius_value}px {$radius_value}px 0 0;
            }
            {$widget_id}.kanews-image-box-style-3 .kanews-image-box-content {
              border-radius: 0 0 {$radius_value}px {$radius_value}px;
            }
          ";
        }
      }

      // Content Padding
      $content_padding = $get_style_setting('content_padding');
      if ( is_array($content_padding) ) {
        $padding_unit = isset($content_padding['unit']) && $content_padding['unit'] !== '' ? $content_padding['unit'] : 'px';
        $padding_rules = '';
        $padding_map = array(
          'top'    => 'padding-top',
          'right'  => 'padding-right',
          'bottom' => 'padding-bottom',
          'left'   => 'padding-left',
        );

        foreach ($padding_map as $key => $css_prop) {
          if (isset($content_padding[$key]) && $content_padding[$key] !== '' && $content_padding[$key] !== null) {
            $padding_rules .= "{$css_prop}: {$content_padding[$key]}{$padding_unit};";
          }
        }

        if ($padding_rules !== '') {
          $style_css .= "
            {$widget_id} .kanews-image-box-content {
              {$padding_rules}
            }
          ";
        }
      }

      // Item Margin Bottom
      $item_margin = $get_style_setting('item_margin_bottom');
      if ($item_margin !== '' && $item_margin !== null) {
        $style_css .= "
          {$widget_id} .kanews-image-box-item {
            margin-bottom: {$item_margin}px;
          }
        ";
      }

      // Title Font Size
      $title_font_size = $get_style_setting('title_font_size');
      if ($title_font_size !== '' && $title_font_size !== null) {
        $style_css .= "
          {$widget_id} .kanews-image-box-title {
            font-size: {$title_font_size}px;
          }
        ";
      }

      // Title Font Weight
      $title_font_weight = $get_style_setting('title_font_weight');
      if ($title_font_weight !== '' && $title_font_weight !== null) {
        $style_css .= "
          {$widget_id} .kanews-image-box-title {
            font-weight: {$title_font_weight};
          }
        ";
      }

      // Subtitle Font Size
      $subtitle_font_size = $get_style_setting('subtitle_font_size');
      if ($subtitle_font_size !== '' && $subtitle_font_size !== null) {
        $style_css .= "
          {$widget_id} .kanews-image-box-subtitle {
            font-size: {$subtitle_font_size}px;
          }
        ";
      }

      // Hover Scale
      $hover_scale = $get_style_setting('hover_scale');
      if ($hover_scale !== '' && $hover_scale !== null) {
        $scale_value = floatval($hover_scale) / 100;
        $style_css .= "
          {$widget_id} .kanews-image-box {
            --kanews-hover-scale: {$scale_value};
          }
        ";
      }

      // Hover Lift
      $hover_lift = $get_style_setting('hover_lift');
      if ($hover_lift !== '' && $hover_lift !== null) {
        $lift_value = is_numeric($hover_lift) ? $hover_lift : intval($hover_lift);
        $style_css .= "
          {$widget_id} .kanews-image-box {
            --kanews-hover-lift: {$lift_value}px;
          }
        ";
      }

     

      // Animation Speed
      $animation_speed = $get_style_setting('animation_speed');
      if ($animation_speed !== '' && $animation_speed !== null) {
        $speed_value = floatval($animation_speed);
        $style_css .= "
          {$widget_id} .kanews-image-box {
            transition: all {$speed_value}s cubic-bezier(0.25, 0.46, 0.45, 0.94);
          }
          {$widget_id} .kanews-image-box-image img {
            transition: transform " . ($speed_value * 1.2) . "s cubic-bezier(0.25, 0.46, 0.45, 0.94);
          }
          {$widget_id} .kanews-image-box-item {
            animation-duration: {$speed_value}s;
          }
        ";
      }

      // Custom image height
      if ( isset( $args['image-height']['unit'] ) && isset( $args['image-height']['height'] ) ) {
        $height = $args['image-height']['height'];
        $unit = $args['image-height']['unit'];

        if ( $height !== '' && !($height === '375' && $unit === 'px') ) {
          if ( $args['style'] == '3' ) {
            $image_height = intval($height) * 0.65;
            $style_css .= "
              {$widget_id}.kanews-image-box-style-3 .kanews-image-box {
                min-height: {$height}{$unit};
              }
              {$widget_id}.kanews-image-box-style-3 .kanews-image-box-image {
                height: {$image_height}{$unit};
              }
            ";
          } else {
            $style_css .= "
              {$widget_id} .kanews-image-box {
                height: {$height}{$unit};
              }
            ";
          }
        }
      }

      // Staggered animation delays for items
      $item_count = count($args['imagebox']);
      for($i = 1; $i <= $item_count; $i++) {
        $delay = ($i - 1) * 0.1;
        $style_css .= "
          {$widget_id} .kanews-image-box-item[data-index=\"{$i}\"] {
            animation-delay: {$delay}s;
          }
        ";
      }

      if (trim($style_css) !== '') {
        echo "<style id='kanews-theme-inline-{$widget_id_clean}' scoped type=\"text/css\">{$style_css}</style>";
      }

    }
  }

}