<?php
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if ( is_admin() || is_customize_preview() ) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}


// Widget Class
class kanews_widget_class_manset_3 extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_manset_3 kanews-section-flat');
		$control_ops = array('id_base' => 'kanews_widget_manset_3');
		parent::__construct('kanews_widget_manset_3', ''.KAN_THEME_NAME .' - '.__( "Manşet" , 'kanews' ).' #3' , $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		if ( ! Kanews_Widget_Helper::should_render_widget( $instance ) ) {
			return;
		}

		$grid = Kanews_Widget_Helper::get_value( $instance, 'grid', 'col-12' );
		$title = apply_filters( 'widget_title', isset( $instance['title'] ) ? $instance['title'] : '' );

		$show_nav = Kanews_Widget_Helper::is_toggle_on( $instance, 'show_nav', true );
		$autoplay = Kanews_Widget_Helper::is_toggle_on( $instance, 'autoplay', true );
		$is_do_not_dublicate = Kanews_Widget_Helper::is_toggle_on( $instance, 'postnotin', false );
		$height = Kanews_Widget_Helper::get_value( $instance, 'height', '' );
		$height2 = Kanews_Widget_Helper::get_value( $instance, 'height2', '' );
		$mode = Kanews_Widget_Helper::get_value( $instance, 'mode', 'light' );
		$style = Kanews_Widget_Helper::get_value( $instance, 'style', 'number' );

		$show_post_detail = Kanews_Widget_Helper::is_toggle_on( $instance, 'show_post_detail', true );
		$show_post_read_more = Kanews_Widget_Helper::is_toggle_on( $instance, 'show_post_read_more', false );
		$show_post_cat = Kanews_Widget_Helper::is_toggle_on( $instance, 'show_post_cat', true );
		$show_post_excerpt = Kanews_Widget_Helper::is_toggle_on( $instance, 'show_post_excerpt', false );
		$html = Kanews_Widget_Helper::get_value( $instance, 'html', 'h2' );
		$original_size = Kanews_Widget_Helper::is_toggle_on( $instance, 'original_size', false );
		$manset_featured = Kanews_Widget_Helper::is_toggle_on( $instance, 'manset_thumb', true );

		$ad_settings = Kanews_Widget_Helper::get_ad_settings( $instance, array( 'position' => 2 ) );
		$is_ad_enabled = $ad_settings['enabled'];
		$ad_position = $ad_settings['position'];
		$ad_image = $ad_settings['image'];
		$ad_content = $ad_settings['content'];
		$ad_link = $ad_settings['link'];

		$tags_value = Kanews_Widget_Helper::get_value( $instance, 'tags', '' );
		$query_overrides = array(
			'tags'     => $tags_value,
			'tags_ids' => null,
		);

		$kanews_query = kan_query( Kanews_Widget_Helper::build_query_args( $instance, $query_overrides ) );

		$thumbnail = 'kanews-manset-2';
		$col_thumb = 'col-12 no-gutter';
		$col = 'col-12 no-gutter';

		if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if(isset($sidebar[2]) && $sidebar[2] == 'full') {
			switch($grid) {
				case 'col-12':
					$thumbnail = 'full'; $meta = 'manset_1';
				break;
				case 'col-12 col-lg-8':
					$thumbnail = 'kanews-manset-3'; $meta = 'manset_3';
				break;
				case 'col-12 col-lg-6':
					$thumbnail = 'kanews-manset-4'; $meta = 'manset_4';
				break;
				case 'col-12 col-lg-4':
					$thumbnail = 'kanews-manset-5'; $meta = 'manset_5';
				break;
			}
		}
		elseif($sidebar[1] == 'content') {
			$thumbnail = 'kanews-manset-3'; $meta = 'manset_3';
			$col = 'col-12 no-gutter';
		}
		elseif($sidebar[1] == 'sidebar') {
			$thumbnail = 'kanews-manset-5'; $meta = 'manset_5';
			$col = 'col-12 no-gutter';
			$grid = 'col-12 no-gutter';
		}


		$slick_options = [
			'slidesToShow'  => 1,
			'arrows'			  => $show_nav,
			'dots'			    => true,
			'infinite'			=> false,
			'autoplay'			=> $autoplay
		];

		$counter = 0;

		$styles = $output_css = '';

		$widget_id = '#'. $args['widget_id'];

		if ( ! empty( $height ) || ! empty( $height2 ) || ( $is_ad_enabled && '' != $ad_position ) ){

			$out = "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">";
			
			if($is_ad_enabled && '' != $ad_position) {
				$out .= "
				$widget_id .kanews-slider-global.slick-dots li:nth-child(2) button {
					visibility: visible;
				}
				$widget_id .kanews-slider-global .slick-dots li:nth-child(2) button:after {
					display: none
				}
				$widget_id .kanews-slider-global .slick-dots li:nth-child($ad_position) button {
					visibility: hidden;
				}
				$widget_id .kanews-slider-global .slick-dots li:nth-child($ad_position) button:after {
					content: 'R';
					visibility: visible;
					display: block;
					position: absolute;
					top: 0;
				}
				";
			}

			if ( ! empty( $height ) ){
				$out .= "
				@media (min-width: 768px) {
					$widget_id .kanews-slider-global .kanews-slide, $widget_id .kanews-slider-global .kanews-slider-wrapper, $widget_id .kanews-slider-global .slick-list {
						height: ".$height."px !important;
					}
				}
				";
			}
			if ( ! empty( $height2 ) ){
				$out .= "
				@media (max-width: 768px) {
					$widget_id .kanews-slider-global .kanews-slide, $widget_id .kanews-slider-global .kanews-slider-wrapper, $widget_id .kanews-slider-global .slick-list {
						height: ".$height2."px !important;
					}
				}
				";
			}

			echo ( $out ) ."</style>";
		}

		// print_r($kanews_query);
		?>

		<?php if ($kanews_query->have_posts()) :?>
			<div class="<?php echo $grid; ?>"> 
				<div id="<?php echo $this->id; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
					<?php 
					$custom_manset = kanews_get_option($thumbnail) ? kanews_get_option($thumbnail) : array();
					if ( ! empty($instance['title']) ):
						echo ( $args['before_title'] . $title . $args['after_title'] );
					endif; ?>
					<div class="kanews-slider-global kanews-slider-2 kanews-slider-number-<?php echo $mode; ?> kanews-manset-3 kanews-slider-number-bottom kanews-slider-pag-style-<?php echo $style; ?>">
						<div class="<?php echo $col; ?>">
							<div id="kanews-slider-<?php echo $this->number; ?>" class="kanews-slider-wrapper <?php echo $thumbnail; ?>" data-slick='<?php echo wp_json_encode( $slick_options ); ?>'>
								<?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;   $counter++;
									$manset_detail_position = get_post_meta($post->ID, 'manset_detail_position', true) != '' ? get_post_meta($post->ID, 'manset_detail_position', true) : 'bottom'; 
									$manset_color = get_post_meta($post->ID, 'manset_color', true); 
									$manset_detail = get_post_meta($post->ID, 'post_detail', true); 
									$manset_desc_color = get_post_meta($post->ID, 'manset_desc_color', true);
									$manset_title_color = get_post_meta($post->ID, 'manset_title_color', true);
									$manset_title_typography = get_post_meta($post->ID, 'manset_title_typography', true);
									$manset_desc_typography = get_post_meta($post->ID, 'manset_desc_typography', true);
									$manset_link = get_post_meta( $post->ID, 'kanews_manset_link', true);
									if( $manset_title_typography != '' && ( $manset_title_typography['text-transform'] != '' || $manset_title_typography['font-size'] != '' || $manset_title_typography['type'] != '' ) ) {
										$styles .= '@media (min-width: 768px) {.kanews-slider-global .kanews-slide-pid-'.$post->ID.' .kanews-slide-content .kanews-slide-headline {';
										foreach($manset_title_typography as $key => $value) {
											if($value != '' && $key != 'unit') {
												if($key == 'text-transform' || $key == 'font-weight' || $key == 'font-family') {
													$styles .= $key.': '.$value.';';
												} else {
													$styles .= $key.': '.$value.'px;';
												}
											}
										}
										$styles .= '}}';
									
									}
									if( $manset_desc_typography != '' && ( $manset_desc_typography['text-transform'] != '' || $manset_desc_typography['font-size'] != '' || $manset_desc_typography['type'] != '' ) ) {
										$styles .= '@media (min-width: 768px) {.kanews-slider-global .kanews-slide-pid-'.$post->ID.' .kanews-slide-content .kanews-slide-spot {';
										foreach($manset_desc_typography as $key => $value) {
											if($value != '' && $key != 'unit') {
												if($key == 'text-transform' || $key == 'font-weight') {
													$styles .= $key.': '.$value.';';
												} else {
													$styles .= $key.': '.$value.'px;';
												}
											}
										}
										$styles .= '}}';
									
									}

									if ( $manset_title_color != '' ) {
										$styles .= '.kanews-slider-global .kanews-slide-pid-'.$post->ID.' .kanews-slide-content .kanews-slide-headline a {';
											$styles .= 'color: '.$manset_title_color;
										$styles .= '}';
									}
									if ( $manset_desc_color != '' ) {
										$styles .= '.kanews-slider-global .kanews-slide-pid-'.$post->ID.' .kanews-slide-content .kanews-slide-spot {';
											$styles .= 'color: '.$manset_desc_color;
										$styles .= '}';
									}

									$get_permalink = get_permalink(); 

									$manset_meta = kan_is_mobile() ? get_post_meta($post->ID, 'manset_mobile', true) : get_post_meta($post->ID, 'manset_desktop', true);
									if(isset($manset_meta['id']))
									$manset_thumb = wp_get_attachment_image_src($manset_meta['id'], 'full');
									else
									$manset_thumb = wp_get_attachment_image_src($manset_meta, 'full');
									$style = '';
									if(!empty($manset_color))
									$style = 'background-color: '.$manset_color.'; box-shadow: 0 0 0 5px '.$manset_color;

									if( ! $manset_featured )
									$manset_thumb = '';

									$manset_size = $manset_thumb;
									$thumb_size = $original_size ? 'full' : $thumbnail;

									if ($is_ad_enabled && $counter == $ad_position) {
										if( !empty($ad_image) || !empty($ad_content) ) {
											echo '<div class="manset-ad kanews-slide">';
												if (!empty($ad_link)) {
													echo '<a href="' . esc_url($ad_link) . '" target="_blank">';
											}
											
											if (!empty($ad_image)) {
												echo '<img src="' . esc_url($ad_image) . '" alt="' . esc_attr__('Banner', 'kanews') . '" class="manset-ad-image">';
											} else {
												echo $ad_content;
											}
											
											if (!empty($ad_link)) {
												echo '</a>';
											}
											echo '</div>';
										}
									}
								?>
									<div class="kanews-slide kanews-slide-pid-<?php echo $post->ID; ?> <?php echo $original_size ? 'kanews-slide-fit' : ''; ?>">
										<?php if($manset_thumb != ''): ?>
											<?php kanews_manset_thumbnail($manset_size); ?>
										<?php else: $manset_detail = false;  ?>
											<?php kanews_post_thumbnail($thumb_size, 'kanews-slide-thumb'); ?>
										<?php endif; ?>
										<div class="kanews-slide-item kanews-mansetd-<?php echo $manset_detail_position; ?>">
											<?php $tag_title = get_post_meta($post->ID, 'manset_tag_title', true); if(  $tag_title != '' ) : $tag_bg = get_post_meta($post->ID, 'manset_tag_bg', true); $tag_color = get_post_meta($post->ID, 'manset_tag_color', true); ?>
												<div class="kanews-manset-tag kanews-manset-tag-position-<?php echo get_post_meta($post->ID, 'manset_tag', true); ?> kanews-manset-tag-style-<?php echo get_post_meta($post->ID, 'manset_tag_style', true); ?>" style="<?php echo $tag_bg != '' ? '--kan-theme-color: '.$tag_bg.';' : '';?> <?php echo $tag_color != '' ? 'color:'.$tag_color.';' : '';?>">  <span></span><span></span><span></span><span></span><?php echo $tag_title; ?></div>
											<?php endif; ?>
											<?php do_action('kanews_post_hook'); ?>
											<?php if( $manset_link != '' ):  $get_permalink = $manset_link; ?>
												<a href="<?php echo esc_url( $manset_link ); ?>" class="kanews-slide-href" aria-label="<?php the_title(); ?>"></a>
											<?php else: ?>
												<a href="<?php the_permalink(); ?>" class="kanews-slide-href" aria-label="<?php the_title(); ?>"></a>
											<?php endif; ?>

											<div class="kanews-slide-content <?php echo ( ! $show_post_detail || $manset_detail ) ? 'is-hidden' : ''; ?>">
												<?php if($show_post_cat): ?>
													<?php echo kanews_primary_category($post->ID); ?>
												<?php endif; ?>
												<?php if(!empty($kanews_manset_highlight = get_post_meta($post->ID, 'kanews_manset_highlight', true) )): ?>
														<div class="kanews-slide-headline kanews-slide-hightlight"><a href="<?php echo esc_url( $get_permalink ); ?>"><span style="<?php echo $style; ?>"><?php echo $kanews_manset_highlight; ?></span></a></div>
												<?php endif; ?>
												<?php if(!empty($manset_title = get_post_meta($post->ID, 'kanews_manset_title', true) )): ?>
														<<?php echo $html; ?> class="kanews-slide-headline"><a href="<?php echo esc_url( $get_permalink ); ?>"><span style="<?php echo $style; ?>"><?php echo $manset_title; ?></span></a></<?php echo $html; ?>>
												<?php else: ?>
													<?php the_title( sprintf( '<'.$html.' class="kanews-slide-headline"><a href="%s" rel="bookmark"><span style="'.$style.'">', esc_url( $get_permalink ) ), '</span></a></'.$html.'>' ); ?>
												<?php endif; ?>
												<?php if(get_post_meta( $post->ID, 'kanews_manset_excerpt', true ) && $show_post_excerpt): ?>
													<p class="kanews-slide-spot truncate truncate-2"><span><?php echo get_post_meta( $post->ID, 'kanews_manset_excerpt', true ); ?></span></p>
												<?php endif; ?>
												<?php if($show_post_read_more): ?>
													<?php echo kanews_read_more(); ?>
												<?php endif; ?>
											</div>
										</div>
									</div>
									<?php 
									if( $is_do_not_dublicate ){
										Kanews\Helper::do_not_dublicate( $post->ID );
									}
									?>
								<?php endwhile; wp_reset_postdata(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<?php 	
			if( $styles != '') {
				$output_css .= "<style id='kanews-theme-inline-$widget_id-2' scoped type=\"text/css\">";
				$output_css .= $styles;
				echo ( kan_minify_css($output_css) ) ."</style>";
			}
			?>

		<?php endif;
		

		}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		// Genel Ayarlar
		$instance['title'] = $new_instance['title'];
		$instance['grid'] = $new_instance['grid'];
		$instance['html'] = $new_instance['html'];
		$instance['thumb'] = $new_instance['thumb'];
		$instance['show_nav'] = $new_instance['show_nav'];
		$instance['autoplay'] = $new_instance['autoplay'];
		$instance['mode'] = $new_instance['mode'];
		$instance['style'] = $new_instance['style'];

		// Sıralama Ayarları  
		$instance['sticky_posts'] = $new_instance['sticky_posts'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['categories2'] = $new_instance['categories2'];
		$instance['categories'] = $new_instance['categories'];
		$instance['pids'] = $new_instance['pids'];
		$instance['exclude_pids'] = $new_instance['exclude_pids'];
		$instance['tags'] = $new_instance['tags'];
		$instance['offset'] = $new_instance['offset'];
		$instance['posts'] = $new_instance['posts'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['include_columist'] = $new_instance['include_columist'];

		// İçerik Ayarları
		$instance['show_post_detail'] = $new_instance['show_post_detail'];
		$instance['show_post_excerpt'] = $new_instance['show_post_excerpt'];
		$instance['show_post_cat'] = $new_instance['show_post_cat'];
		$instance['show_post_read_more'] = $new_instance['show_post_read_more'];
		$instance['show_manset_ad'] = isset($new_instance['show_manset_ad']) ? 'on' : 'off';
		$instance['original_size'] = $new_instance['original_size'];
		$instance['manset_thumb'] = $new_instance['manset_thumb'];

		// Diğer Ayarlar
		$instance['height'] = $new_instance['height'];
		$instance['height2'] = $new_instance['height2'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		
		// Reklam Ayarları
		$instance['ad_position'] = $new_instance['ad_position'];
		$instance['ad_image'] = $new_instance['ad_image'];
		$instance['ad_content'] = $new_instance['ad_content'];
		$instance['ad_link'] = $new_instance['ad_link'];
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			// Genel Ayarlar
			'title' => '', 
			'grid' => 'col-12',
			'html' => 'h2',
			'thumb' => 'bottom',
			'show_nav' => 'on',
			'autoplay' => 'on',
			'mode' => 'light',
			'style' => 'number',
			
			// Sıralama Ayarları
			'sticky_posts' => 'off',
			'sortby' => 'recent',
			'date_range' => '0',
			'categories2' => '',
			'categories' => array(),
			'pids' => array(),
			'exclude_pids' => array(),
			'tags' => array(),
			'offset' => '0',
			'posts' => 10,
			'postnotin' => '',
			'include_columist' => 'off',
			
			// İçerik Ayarları
			'show_post_detail' => 'on',
			'show_post_excerpt' => 'off',
			'show_post_cat' => 'on',
			'show_post_read_more' => 'off',
			'show_manset_ad' => 'off',
			'original_size' => 'off',
			'manset_thumb' => 'on',

			'ad_position' => '1',
			'ad_image' => '',
			'ad_content' => '',
			'ad_link' => '',
			
			// Diğer Ayarlar
			'height' => '',
			'height2' => '',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off'
		);
		
		$instance = wp_parse_args((array) $instance, $defaults); 

		// Genel Ayarlar Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => array(
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('html'),
					'name' => $this->get_field_name('html'),
					'label' => __('Yazı Başlığı HTML Tag', 'kanews'),
					'value' => $instance['html'],
					'options' => array(
						'div' => 'Div',
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('thumb'),
					'name' => $this->get_field_name('thumb'),
					'label' => __('Numaraların Konumu', 'kanews'),
					'value' => $instance['thumb'],
					'options' => array(
						'left' => __('Sol Yanında(Numaralı Görünüm)', 'kanews'),
						'right' => __('Sağ Yanında (Numaralı Görünüm)', 'kanews'),
						'bottom' => __('Aşağıda', 'kanews')
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('style'),
					'name' => $this->get_field_name('style'),
					'label' => __('Numara Görünümü', 'kanews'),
					'value' => $instance['style'],
					'options' => array(
						'number' => __('Numaralı', 'kanews'),
						'line' => __('Çizgili', 'kanews')
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('mode'),
					'name' => $this->get_field_name('mode'),
					'label' => __('Numaraların Renk Modu', 'kanews'),
					'value' => $instance['mode'],
					'options' => array(
						'dark' => __('Koyu', 'kanews'),
						'light' => __('Açık', 'kanews')
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_nav'),
					'name' => $this->get_field_name('show_nav'),
					'label' => __('Navigasyon Butonları', 'kanews'),
					'value' => $instance['show_nav']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('autoplay'),
					'name' => $this->get_field_name('autoplay'),
					'label' => __('Otomatik Oynat', 'kanews'),
					'value' => $instance['autoplay']
				)
			)
		));

		// Sıralama Ayarları - Global metod kullanımı
		Kanews_Form_Elements::render_manset_sorting_settings($this, $instance);

		// İçerik Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_detail'),
					'name' => $this->get_field_name('show_post_detail'),
					'label' => __('Yazı Detaylarını Göster', 'kanews'),
					'value' => $instance['show_post_detail']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_excerpt'),
					'name' => $this->get_field_name('show_post_excerpt'),
					'label' => __('Yazı Açıklamasını Göster', 'kanews'),
					'value' => $instance['show_post_excerpt']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_cat'),
					'name' => $this->get_field_name('show_post_cat'),
					'label' => __('Yazı Kategorisini Göster', 'kanews'),
					'value' => $instance['show_post_cat']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_read_more'),
					'name' => $this->get_field_name('show_post_read_more'),
					'label' => __('Devamını Oku Butonunu Göster', 'kanews'),
					'value' => $instance['show_post_read_more']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('original_size'),
					'name' => $this->get_field_name('original_size'),
					'label' => __('Görselleri Orjinal Boyutta Göster', 'kanews'),
					'value' => $instance['original_size']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('manset_thumb'),
					'name' => $this->get_field_name('manset_thumb'),
					'label' => __('Varsa Manşet Görselini Kullan', 'kanews'),
					'value' => $instance['manset_thumb']
				)
			)
		));

		// Diğer Ayarlar Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Diğer Ayarlar', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_SLIDER,
					'id' => $this->get_field_id('height'),
					'name' => $this->get_field_name('height'),
					'label' => __('Yükseklik (Masaüstü)', 'kanews'),
					'value' => $instance['height'],
					'min' => 0,
					'max' => 1000,
					'step' => 10,
					'unit' => 'px'
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SLIDER,
					'id' => $this->get_field_id('height2'),
					'name' => $this->get_field_name('height2'),
					'label' => __('Yükseklik (Mobil)', 'kanews'),
					'value' => $instance['height2'],
					'min' => 0,
					'max' => 1000,
					'step' => 10,
					'unit' => 'px'
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				)
			)
		));

		// Add Ad Settings Section
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Reklam Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_manset_ad'),
					'name' => $this->get_field_name('show_manset_ad'),
					'label' => __('Reklamları Göster', 'kanews'),
					'value' => isset($instance['show_manset_ad']) ? $instance['show_manset_ad'] : 'off'
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SLIDER,
					'id' => $this->get_field_id('ad_position'),
					'name' => $this->get_field_name('ad_position'),
					'label' => __('Reklam Pozisyonu', 'kanews'),
					'value' => isset($instance['ad_position']) ? $instance['ad_position'] : 2,
					'min' => 1,
					'max' => 10,
					'step' => 1,
					'unit' => ''
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_MEDIA,
					'id' => $this->get_field_id('ad_image'),
					'name' => $this->get_field_name('ad_image'),
					'label' => __('Reklam Görseli', 'kanews'),
					'value' => isset($instance['ad_image']) ? $instance['ad_image'] : '',
					'description' => __('Reklam için görsel seçin', 'kanews'),
					'button_text' => __('Görsel', 'kanews'),
					'preview_size' => 'medium'
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('ad_link'),
					'name' => $this->get_field_name('ad_link'),
					'label' => __('Reklam Link URL', 'kanews'),
					'value' => isset($instance['ad_link']) ? $instance['ad_link'] : ''
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXTAREA,
					'id' => $this->get_field_id('ad_content'),
					'name' => $this->get_field_name('ad_content'),
					'label' => __('Reklam HTML İçeriği', 'kanews'),
					'value' => isset($instance['ad_content']) ? $instance['ad_content'] : '',
					'description' => __('HTML içeriği girin (görsel seçilirse bu alan kullanılmaz)', 'kanews'),
					'allow_html' => true
				)
			)
		));
	}
}
?>