<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_newsletter extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_newsletter');
		$control_ops = array('id_base' => 'kanews_widget_newsletter');
		parent::__construct('kanews_widget_newsletter', KAN_THEME_NAME .' - '.__( "E-Posta Abonelik Formu" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		if ((isset($instance['hide_mobile']) && $instance['hide_mobile'] === 'on' && kan_is_mobile()) ||
			(isset($instance['hide_desktop']) && $instance['hide_desktop'] === 'on' && !kan_is_mobile())) {
			return;
		}

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$subscribe_text = isset($instance['desc']) ? $instance['desc'] : '';

		echo ( $args['before_widget'] ); ?>

			


			<?php 
					if ( ! empty($instance['title']) ):
						echo ( $args['before_title'] . $title . $args['after_title'] );
					endif; ?>


<div class="kanews-newsletter">
				
				<?php if( ! empty( $instance['mailchimp'] ) ) : ?>

					<form action="<?php echo esc_attr( $instance['mailchimp'] ) ?>" method="post" name="mc-embedded-subscribe-form"  target="_blank" novalidate>
						<div class="kanews-form2">
							<input type="email" value="" required id="mce-EMAIL" name="EMAIL" placeholder="<?php esc_html_e( 'E-Posta Adresiniz', 'kanews' ); ?>">
							<button type="submit" class="kanews-btn mb-0 mt-0"><?php esc_attr_e( 'Abone Ol', 'kanews' ); ?></button>
						</div>
						
					</form>
		
				<?php endif; ?>

				<?php if( ! empty($subscribe_text) ): ?>
					<p><?php echo $subscribe_text; ?></p>
				<?php endif; ?>
				
			</div>
			
		<?php echo ( $args['after_widget'] );
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['desc'] = $new_instance['desc'];
		$instance['mailchimp'] = $new_instance['mailchimp'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];

		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			'title' => esc_html__( 'Bültenimize Katılın', 'kanews' ), 
			'desc' => esc_html__( 'Hemen ücretsiz üye olun ve yeni güncellemelerden haberdar olan ilk kişi olun.', 'kanews' ),
			'mailchimp' => '', 
			'hide_desktop' 	 => 'off',
			'hide_mobile' 	 => 'off'
    );
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXTAREA,
					'id' => $this->get_field_id('desc'),
					'name' => $this->get_field_name('desc'),
					'label' => __('Açıklama', 'kanews'),
					'value' => $instance['desc']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('mailchimp'),
					'name' => $this->get_field_name('mailchimp'),
					'label' => __('Mailchimp Form Action URL', 'kanews'),
					'value' => $instance['mailchimp']
			 ]
		 ]
	 ]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
			 ]
		 ]
	 ]);
	}
}
?>