<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if ( is_admin() || is_customize_preview() ) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_posts_1 extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_posts_1 kanews-section-flat kanews-section-gutter column_x_gutter');
		$control_ops = array('id_base' => 'kanews_widget_posts_1');
		parent::__construct('kanews_widget_posts_1', ''.KAN_THEME_NAME .' - '.__( "Yazılar" , 'kanews' ).' #1' , $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
	
	private static function get_defaults() {
		return array(
			// Genel Ayarlar
			'title' => '',
			'show_more_link' => '',
			'grid' => 'col-12',
			'col' => 'col-12 col-md-6 col-lg-4',
			'html_tag' => 'h4',

			// Sıralama Ayarları
			'postnotin' => 'off',
			'tags' => '',
			'categories' => array(),
			'posts' => 8,
			'sortby' => 'recent',
			'date_range' => '0',
			'format' => '0',
			'offset' => '0',
			'include_columist' => 'off',

			// İçerik Ayarları
			'cover' => 'off',
			'cat_list' => 'off',
			'show_post_cat' => 'on',
			'show_post_excerpt' => 'off',
			'show_post_date' => 'on',
			'dark_mode' => 'off',

			// Görünüm Ayarları
			'accent-color' => '',
			'bg-color' => '',
			'bg-color2' => '',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off',
		);
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$instance = Kanews_Widget_Helper::normalize_instance( $instance, self::get_defaults() );

		if ( ! Kanews_Widget_Helper::should_render_widget( $instance ) ) {
			return;
		}

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$col = (!empty($instance['col'])) ? $instance['col'] : 'col-12 col-lg-4';
		$html = !empty($instance['html']) ? $instance['html'] : 'h2';

		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
		$tags = (isset($instance['tags'])) ? $instance['tags'] : '';
    $posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
    $offset = (isset($instance['offset'])) ? $instance['offset'] : '';
    $date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
    $sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$format = !empty($instance['format']) ? $instance['format'] : '';
		$accent_color = !empty($instance['accent-color']) ? $instance['accent-color'] : '';
		$bg_color = !empty($instance['bg-color']) ? $instance['bg-color'] : '';
		$bg_color2 = !empty($instance['bg-color2']) ? $instance['bg-color2'] : '';
		$categories_for_list = is_array( $categories ) ? $categories : ( '' !== $categories ? array( $categories ) : array() );


		$post_type = !isset($instance['include_columist']) ? 'post' : array('post', 'columist');
		$cover = isset($instance['cover']) ? true : false;
		$cat_list = !isset($instance['cat_list']) ? false : true;
		$show_post_cat = !isset($instance['show_post_cat']) ? false : true;
		$show_post_excerpt = !isset($instance['show_post_excerpt']) ? false : true;
		$show_post_date = !isset($instance['show_post_date']) ? false : true;
		$is_do_not_dublicate = $instance['postnotin'] == 'on' ? true : false;
		$dark_mode = !isset($instance['dark_mode']) ? '' : 'dark-mode';
		$show_more_link = !empty($instance['show_more_link']) ? $instance['show_more_link'] : '';
		
		$query_args = array(
			'post_type'			=> $post_type,
			'number'				=> $posts,
			'id'    				=> $categories,
			'sortby' 				=> $sortby,
			'tags_ids' 			=> $tags,
			'offset' 				=> $offset,
			'range'				  => $date_range,
			'format'				=> $format 
		);
		$kanews_query = kan_query( $query_args );

    $thumbnail = 'kanews-post-2';

    if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if(isset($sidebar[2]) && $sidebar[2] == 'full') {
			if($col == 'col-12 col-md-6') 
				$thumbnail = 'kanews-post-2';
			elseif($col == 'col-12') {
        if( $grid == 'col-12' )
				$thumbnail = 'kanews-manset-2';
				else 
				$thumbnail = 'kanews-post-3';
			} elseif($col == 'col-12 col-md-6 col-lg-4')
        $thumbnail = 'kanews-post-3';
			elseif($col == 'col-12 col-lg-3')
        $thumbnail = 'kanews-post-1';
		}elseif($sidebar[1] == 'content') {
			$grid = 'col-12';
			$thumbnail = 'kanews-post-1';
			if($col == 'col-12')
        $thumbnail = 'kanews-manset-3';
				elseif($col == 'col-12 col-md-6')
        $thumbnail = 'kanews-post-3';
		}elseif($sidebar[1] == 'sidebar') {
			$grid = 'col-12';
			$col = 'col-12';
			$thumbnail = 'kanews-post-3';
		}

		if(kan_is_mobile()) {
		$thumbnail = 'kanews-post-1'; 
		$col = str_replace('col-12', 'col-6', $col);	
	}

		

    if ($kanews_query->have_posts()) : 
			$widget_id = '#'. $args['widget_id'];
			$output_css = '';
			if( $bg_color != '' && $bg_color2 != '') {
				$output_css .= "
				.light-mode $widget_id.kanews-section.kanews-section-flat .kanews-post-item {
					background: linear-gradient(135deg,  $bg_color, $bg_color2 ) !important;
				}
				";
				
			}
			if( $accent_color != '') {
				$output_css .= "
				$widget_id {
					--kan-theme-color: $accent_color
				}
				";
			}

			if( !empty($output_css) ) {
				echo "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">".( kan_minify_css($output_css) ) ."</style>";
			}
			?>
			<div class="<?php echo $grid; ?> <?php echo $dark_mode; ?>"> 
				<div id="<?php echo $args['widget_id']; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
					<?php if ( ! empty($instance['title']) ):
						echo ( $args['before_title'] . $title . $args['after_title'] );
					endif; ?>

					<?php if ( $cat_list && count( $categories_for_list ) > 1 ) : ?>

					<div class="kanews_widget_posts_6">
						<div class="kanews-tab">
							<ul class="nav nav-tabs d-flex flex-wrap">

								<?php $number= 0; if( ! empty( $categories_for_list ) ): foreach( $categories_for_list as $category ) {  $number++;?>
									<li class="nav-item">
										<a href="<?php echo get_category_link($category); ?>" class="nav-link">	<?php echo get_cat_name($category); ?></a>
									</li>
								<?php } endif; ?>
							</ul>
						</div>
					</div>

					<?php endif; ?>
          
          <div class="row equal-height">
            <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; ?>
              <div class="<?php echo $col; ?>">
                <div class="<?php echo ($cover) ? 'kanews-post-overlay' : 'kanews-post-item kanews-post-grid-item'; ?>">
									<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php echo esc_attr(get_the_title()); ?>"></a>	
									<?php do_action('kanews_post_hook'); ?>
                  <?php kanews_post_thumbnail($thumbnail, 'kanews-post-thumb'); ?>
                  <div class="kanews-post-content">
										
                    <?php the_title( sprintf( '<'.$html.' class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></'.$html.'>' ); ?>
										
										<?php if ( kanews_get_option('excerpt-length') != '' && $show_post_excerpt ): ?>
											<?php the_excerpt(); ?>
										<?php endif; ?>

										<div class="kanews-post-meta">
											<?php if ( $show_post_date ): ?>
												<?php echo kanews_post_date(); ?>
											<?php endif; ?>
											<?php if ( $show_post_cat ): ?>
												<?php echo kanews_primary_category($post->ID, 'style-2'); ?>
											<?php endif; ?>
										</div>
									</div>
                </div>
              </div>
							<?php 
							if( $is_do_not_dublicate ){
								Kanews\Helper::do_not_dublicate( $post->ID );
							}
							?>
            <?php endwhile; wp_reset_postdata(); ?>
						<?php if ( ! empty( $show_more_link ) ): ?>
							<div class="col-12">
							<div class="d-flex justify-content-center align-items-center"><a href="<?php echo esc_url( $show_more_link ); ?>" class="kanews-label kanews-label-widget"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?></a></div>
							</div>
						<?php endif; ?>
          </div>
        </div>
			</div>

		<?php endif; ?>
	<?php }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
$instance['show_more_link'] = $new_instance['show_more_link'];
$instance['html_tag'] = $new_instance['html_tag'];
		
		$instance['grid'] = $new_instance['grid'];
		$instance['col'] = $new_instance['col'];

		$instance['categories'] = $new_instance['categories'];
		$instance['tags'] = $new_instance['tags'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];
		$instance['cover'] = $new_instance['cover'];

		$instance['show_post_cat'] = $new_instance['show_post_cat'];
		$instance['show_post_excerpt'] = $new_instance['show_post_excerpt'];
		$instance['show_post_date'] = $new_instance['show_post_date'];
		$instance['dark_mode'] = $new_instance['dark_mode'];
		$instance['include_columist'] = $new_instance['include_columist'];

		$instance['cat_list'] = $new_instance['cat_list'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		$instance['accent-color'] = $new_instance['accent-color'];
		$instance['bg-color'] = $new_instance['bg-color'];
		$instance['bg-color2'] = $new_instance['bg-color2'];
		
		return $instance;
	}


  // Back-end
	public function form($instance)
	{
		$defaults = self::get_defaults();
		$instance = wp_parse_args((array) $instance, $defaults); 

		// Genel Ayarlar Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('show_more_link'),
					'name' => $this->get_field_name('show_more_link'),
					'label' => __('Daha Fazla Linki', 'kanews'),
					'value' => $instance['show_more_link']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => array(
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('col'),
					'name' => $this->get_field_name('col'),
					'label' => __('Sütun Başına Yazı', 'kanews'),
					'value' => $instance['col'],
					'options' => array(
						'col-12' => '1',
						'col-12 col-md-6' => '2',
						'col-12 col-md-6 col-lg-4' => '3',
						'col-12 col-lg-3' => '4'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('html_tag'),
					'name' => $this->get_field_name('html_tag'),
					'label' => __('Yazı Başlığı HTML Tag', 'kanews'),
					'value' => $instance['html_tag'],
					'options' => array(
						'div' => 'Div',
						'h1' => 'H1',
						'h2' => 'H2',
						'h4' => 'h4',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6'
					)
				)
			)
		));

		// Sıralama Ayarları - Global metod kullanımı
		Kanews_Form_Elements::render_posts_sorting_settings($this, $instance);

		// İçerik Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('cover'),
					'name' => $this->get_field_name('cover'),
					'label' => __('İçeriği Görselle Kapla', 'kanews'),
					'value' => $instance['cover']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_excerpt'),
					'name' => $this->get_field_name('show_post_excerpt'),
					'label' => __('Yazı Açıklamasını Göster', 'kanews'),
					'value' => $instance['show_post_excerpt']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_cat'),
					'name' => $this->get_field_name('show_post_cat'),
					'label' => __('Yazı Kategorisini Göster', 'kanews'),
					'value' => $instance['show_post_cat']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_date'),
					'name' => $this->get_field_name('show_post_date'),
					'label' => __('Yazı Tarihini Göster', 'kanews'),
					'value' => $instance['show_post_date']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('dark_mode'),
					'name' => $this->get_field_name('dark_mode'),
					'label' => __('Koyu Mod', 'kanews'),
					'value' => $instance['dark_mode']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('cat_list'),
					'name' => $this->get_field_name('cat_list'),
					'label' => __('Kategorileri Listele', 'kanews'),
					'value' => $instance['cat_list']
				)
			)
		));

		// Görünüm Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('accent-color'),
					'name' => $this->get_field_name('accent-color'),
					'label' => __('Birincil Renk', 'kanews'),
					'value' => $instance['accent-color']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color'),
					'name' => $this->get_field_name('bg-color'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['bg-color']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color2'),
					'name' => $this->get_field_name('bg-color2'),
					'label' => __('Arkaplan Rengi 2', 'kanews'),
					'value' => $instance['bg-color2']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				)
			)
		));

	}
}