<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_secim2023', array(
    'title'       => KAN_THEME_NAME .' - '."Seçim",
    'classname'   => 'kanews_widget_class_secim2023',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
        'default'   => 'Seçim',
      ),

      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      array(
        'id'      => 'col',
        'type'    => 'select',
        'title'   => 'Sütun Başına',
        'options' => array(
          'col-12' => '1',
          'col-12 col-md-4 col-lg-6' => '2',
          'col-12 col-md-4 col-lg-4' => '3',
          'col-12 col-md-4 col-lg-3' => '4',
          'col-12 col-md-4 col-lg-2' => '6',
        ),
        'default' => 'col-12'
      ),

      array(
        'id'      => 'secmen',
        'type'    => 'number',
        'title'   => 'Toplam Seçmen'
      ),

      array(
        'id'      => 'sandik_oran',
        'type'    => 'number',
        'title'   => 'Açılan Sandık Oranı'
      ),

      array(
        'id'     => 'adaylar',
        'type'   => 'group',
        'title'  => 'Adaylar',
        'button_title'  => 'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Aday Adı',
          ),
          array(
            'id'    => 'img',
            'type'  => 'media',
            'desc'  => 'Örnek Görsel: https://i.sozcu.com.tr/secim2018/images/candidate/recep-tayyip-erdogan.png',
            'title' => 'Görsel',
          ),
          array(
            'id'    => 'vote',
            'type'  => 'number',
            'title' => 'Aldığı Oy',
          ),
        ),
      ),


      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      ),
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_secim2023' ) ) {
    function kanews_widget_secim2023( $widgets, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      $args_defaults = array( 
        'grid'     => 'col-12',
        'col'      => 'col-12',
        'title'    => '',
        'secmen'   => 0,
        'sandik_oran' => 0,
        'adaylar'  => array(),
      ); 
      $args = wp_parse_args( $instance, $args_defaults );
      
      echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews-widget-secim kanews-section-flat">';
      
        if ( ! empty($args['title']) ) {
          echo ( $widgets['before_title'] . $args['title'] . $widgets['after_title'] );
        }

        $secmen = ( !empty($args['secmen'] ) ) ? $args['secmen'] : 0;

        if( isset($args['adaylar']) && !empty($args['adaylar']) ) {
          $toplam = 0;
          $toplam_oy = array_reduce($args['adaylar'], function($toplam, $kisi) {
            if (isset($kisi['vote']) && is_numeric($kisi['vote'])) {
                return $toplam + $kisi['vote'];
            }
            return $toplam;
        }, 0);
        
          echo '<div class="pull-right">Açılan Sandık Oranı: '.$args['sandik_oran'].'%</div>';
          echo '<div class="row">';
          foreach($args['adaylar'] as $aday) {
            $img = (isset($aday['img']['thumbnail']) && !empty($aday['img']['thumbnail'])) ? 'style="background-image: url('.$aday['img']['thumbnail'].')"' : '';
            $name = ( isset($aday['title']) && !empty($aday['title'])) ? $aday['title'] : 'Aday Adı';
            $percent = ( isset($aday['vote']) && !empty($aday['vote']) && is_numeric($toplam_oy) ) ? round(( $aday['vote'] / $toplam_oy  ) * 100, 1) : 0;

            echo '<div class="'.$args['col'].'"><div class="kanews-section d-flex" '.$img.'>
              <div class="item-inner">
                  <div class="name">'.$name.'</div>
                  <div class="percent d-flex align-items-center" data-percent="'.$percent.'%"><span style="width:'.$percent.'%"></span></div>
              </div>
            </div></div>';
          }
          echo '</div>';
        } else {
          echo 'Adaylar geçersiz';
        }
      
      echo '</div></div>';
    
    }
  }
}