<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_services', array(
    'title'       => KAN_THEME_NAME .' - '."Servis Alanı",
    'classname'   => 'kanews_widget_class_services',
    'fields'      => array(

      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),
      
      array(
        'id'      => 'currencies',
        'type'    => 'button_set',
        'title'   => 'Gözükecek Para Birimleri',
        'multiple' => true,
        'options' => array(
          'usd' => 'Dolar',
          'euro' => 'Euro',
          'chf' => 'İsviçre Frangı',
          'jpy' => 'Japon Yeni',
          'rub' => 'Rus Rublesi',
          'rub' => 'Rus Rublesi',
          'cny' => 'Çin Yuanı',
          'gbp' => 'İngiliz Sterlini',
          'eur-usd' => 'Euro/Dolar',
          'ise-100' => 'Bist 100',
          'ukoil' => 'Petrol',
          'gau' => 'Gram Altın',
          'btc' => 'Bitcoin',
          'eth' => 'Ethereum',
          'bch' => 'Bitcoin Cash',
          'xrp' => 'XRP',
          'ltc' => 'Litecoin',
          'bnb' => 'Binance Coin',
          'sol' => 'Solana',
          'avax' => 'Avalanche',
          'ada' => 'Cardano',
          'dot' => 'Polkadot',
          'doge' => 'Doge Coin',
          'shib' => 'Shiba Inu'
        ),
        'default' => array('usd', 'euro', 'gbp', 'btc', 'ise-100', 'gau')
      ),

      array(
        'id'         => 'weather-city',
        'type'       => 'text',
        'title'      => 'Hava Durumu Varsayılan Şehir',
        'default'    => 'İstanbul',
      ),

      array(
        'id'     => 'links',
        'type'   => 'group',
        'title'  => 'Linkler',
        'button_title'  => 'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Başlık',
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
        ),
        'default' => array(
          array(
            'title' => 'Yol Durumu',
            'url' => '#',
          ),
          array(
            'title' => 'İlanlar',
            'url' => '#',
          ),
          array(
            'title' => 'Firma Rehberi',
            'url' => '#',
          ),
        ),
      ),

      
      array(
        'id'      => 'bg',
        'type'    => 'color',
        'title'   => 'Arkaplan Rengi',
        'default' => ''
      ),
      array(
        'id'      => 'dark-mode',
        'type'    => 'switcher',
        'title'   => 'Gece Modu',
        'default' => false
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      )
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_services' ) ) {
    function kanews_widget_services( $widget, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if($hide_mobile == 'on' ) {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      $args_defaults = array( 
        'grid'        => 'col-12',
        'currencies'  => array('usd', 'euro', 'gbp', 'btc', 'ise-100', 'gau'),
        'links'       => array(
          array(
            'title' => 'Yol Durumu',
            'url' => '#',
          ),
          array(
            'title' => 'İlanlar',
            'url' => '#',
          ),
          array(
            'title' => 'Firma Rehberi',
            'url' => '#',
          ),
        ),
        'weather-city'=> 'İstanbul',
        'bg' => '',
        'dark-mode' => false,
        'hide_mobile' => false,
        'hide_desktop'=> false,
      ); 
      $args = wp_parse_args( $instance, $args_defaults );

      $args['weather-city'] = ( is_user_logged_in() && !empty($city_meta = get_the_author_meta( 'my_city', get_current_user_id() )) ) ? $city_meta : $args['weather-city']; 

      $widget_id = '#'. $widget['widget_id'];
			$output_css = '';
			if( $args['bg'] != '' ) {
				$output_css .= "
				.light-mode $widget_id.kanews-section {
					background: ".$args['bg']." !important
				}
				";
			}


			if( !empty($output_css) ) {
				echo "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">".( kan_minify_css($output_css) ) ."</style>";
			}

      ?>
      <div class="<?php echo $args['grid']; ?> <?php echo (isset($args['dark-mode']) && $args['dark-mode']) ? 'dark-mode' : ''; ?>"> 
        <div id="<?php echo $widget['widget_id']; ?>" class="kanews-section kanews-widget-services">
        
          <div class="row justify-space-between align-items-center">
            <div class="col-left col-auto">
              <div class="row align-items-center">
                <div class="col-auto d-flex flex-wrap flex-column g-10">
                  <?php if( !empty($args['weather-city']) ) : ?>
                    <div class="d-flex flex-column g-10">
                      <div data-toggle="<?php echo $widget['widget_id']; ?>-2" class="kanews-label cursor-pointer justify-content-between"><?php echo $args['weather-city']; ?> <i aria-hidden="true" class="icon-arrow icon-180deg"></i></div>
                      <div class="kanews-city-weather-wrapper d-flex align-items-center" data-city="<?php echo $args['weather-city']; ?>"></div>
                      <?php echo kanews_get_turkey_cities($widget['widget_id'].'-2', true); ?>
                    </div>
                  <?php endif; ?>
                  <?php if( !empty($args['links']) && is_array($args['links']) ) : ?>
                  <ul class="d-flex kanews-widget-services-links flex-wrap justify-content-center">
                    <?php foreach( $args['links'] as $link ) : ?>
                      <?php if( $link['title'] != '' ) : ?>
                        <li><a href="<?php echo esc_url( $link['url'] ); ?>"><?php echo $link['title']; ?></a></li>
                      <?php endif; ?>
                    <?php endforeach; ?>
                  </ul>
                <?php endif; ?>
                </div>
                
                

              </div>
            </div>
            
              <?php if( !empty($args['currencies']) ): ?>
                <div class="col-right col">
                  <div class="site-currencies"><div class="d-flex justify-content-end flex-wrap gap-1"><?php Kanews\Currencies::get_currencies($args['currencies'], true, true, true); ?></div></div>
                </div>
              <?php endif; ?>
            
          </div>

        </div>
      </div>
      <?php

    }
  }
}