<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if ( is_admin() || is_customize_preview() ) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}


// Widget Class
class kanews_widget_class_slider_3 extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_slider_3 kanews-section-flat');
		$control_ops = array('id_base' => 'kanews_widget_slider_3');
		parent::__construct('kanews_widget_slider_3', ''.KAN_THEME_NAME .' - '.__( "Slider" , 'kanews' ).' #3' , $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}

	private static function get_defaults() {
		return array(
			'title'             => '',
			'show_more_link'    => '',
			'grid'              => 'col-12',
			'thumb'             => 'off',
			'show_nav'          => 'on',
			'autoplay'          => 'on',
			'html_tag'          => 'h4',
			'cat_list'          => 'off',
			'postnotin'         => 'off',
			'categories'        => array(),
			'tags'              => '',
			'posts'             => 10,
			'sortby'            => 'recent',
			'date_range'        => '0',
			'offset'            => '0',
			'format'            => '0',
			'show_post_cat'     => 'on',
			'show_post_date'    => 'off',
			'dark_mode'         => 'off',
			'include_columist'  => 'off',
			'accent-color'      => '',
			'bg-color'          => '',
			'bg-color2'         => '',
			'hide_desktop'      => 'off',
			'hide_mobile'       => 'off',
		);
	}

  // Front-end
	public function widget($args, $instance)
	{
		$instance = Kanews_Widget_Helper::normalize_instance( $instance, self::get_defaults() );

		if ( ! Kanews_Widget_Helper::should_render_widget( $instance ) ) {
			return;
		}

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$html = !empty($instance['html']) ? $instance['html'] : 'h2';

		$show_nav = isset($instance['show_nav']) ? true : false;
		$autoplay = isset($instance['autoplay']) ? true : false;

		$post_type = !isset($instance['include_columist']) ? 'post' : array('post', 'columist');
		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
		$tags = (isset($instance['tags'])) ? $instance['tags'] : '';
		$posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
		$offset = (isset($instance['offset'])) ? $instance['offset'] : '';
		$date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
		$sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$is_do_not_dublicate = $instance['postnotin'] == 'on' ? true : false;
		
		$show_post_cat = isset($instance['show_post_cat']) ? 'on' : 'off';
		$show_post_date = isset($instance['show_post_date']) ? 'on' : 'off';
		$dark_mode = !isset($instance['dark_mode']) ? 'light-mode' : 'dark-mode';

		$format = !empty($instance['format']) ? $instance['format'] : '';

		$bg_color = !empty($instance['bg-color']) ? $instance['bg-color'] : '';
		$bg_color2 = !empty($instance['bg-color2']) ? $instance['bg-color2'] : '';
		$accent_color = !empty($instance['accent-color']) ? $instance['accent-color'] : '';
		$cat_list = !isset($instance['cat_list']) ? false : true;
		$categories_for_list = is_array( $categories ) ? $categories : ( '' !== $categories ? array( $categories ) : array() );

		
		$query_args = array(
			'post_type'			=> $post_type,
			'number'				=> $posts,
			'id'    				=> $categories,
			'sortby' 				=> $sortby,
			'tags_ids' 					=> $tags,
			'offset' 				=> $offset,
			'range'				  => $date_range,
			'format'				=> $format
		);
		$kanews_query = kan_query( $query_args );

    $item = 4;
    $thumbnail = 'kanews-post-1';

    if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if(isset($sidebar[2]) && $sidebar[2] == 'full') {
			switch($grid) {
				case 'col-12':
					$item = 4;
				break;
				case 'col-12 col-lg-8':
					$item =3;
				break;
				case 'col-12 col-lg-6':
					$item = 2;
				break;
				case 'col-12 col-lg-4':
					$item = 2;
				break;
			}
		}
    elseif($sidebar[1] == 'content') {
      $item = 3;
      $grid = 'col-12';
		}
		elseif($sidebar[1] == 'sidebar') {
      $item = 2;
      $grid = 'col-12';
		}
    
		$slick_options = [
			'slidesToShow'  => $item,
			'arrows'			  => $show_nav,
			'autoplay'			=> $autoplay,
			'responsive' 			=> [
				[
					'breakpoint' 	 => 992,
					'settings'		 => [
						'slidesToShow' => 3
					]
				],
				[
					'breakpoint' 	 => 525,
					'settings'		 => [
						'slidesToShow' => 2
					]
				],
				[
					'breakpoint' 	 => 375,
					'settings'		 => [
						'slidesToShow' => 1
					]
				],
			]
		];

		switch($item) {
			case 2:
				$item_Col = 'kanews-slider-col col-6 col-md-4 col-lg-6';
				break;
			case 3:
				$item_Col = 'kanews-slider-col col-6 col-md-4 col-lg-4';
				break;
			case 4:
				$item_Col = 'kanews-slider-col col-6 col-md-4 col-lg-3';
				break;
		}

    if ($kanews_query->have_posts()) : 
			$widget_id = '#'. $args['widget_id'];
			$output_css = '';
			if( $bg_color != '' && $bg_color2 != '') {
				$output_css .= "
				.light-mode $widget_id.kanews-section.kanews-section-flat .kanews-post-item {
					background: linear-gradient(135deg,  $bg_color, $bg_color2 ) !important;
				}
				";
			}

			if( $accent_color != '') {
				$output_css .= "
				$widget_id {
					--kan-theme-color: $accent_color
				}
				";
			}

			if( !empty($output_css) ) {
				echo "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">".( kan_minify_css($output_css) ) ."</style>";
			}
			?>
			<div class="<?php echo $grid; ?> <?php echo $dark_mode; ?>"> 
        <div id="<?php echo $this->id; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">

					<?php if ( ! empty( $instance['title'] ) ):
						echo ( $args['before_title'] . $title . $args['after_title'] );
					endif; ?>

					<?php if ( $cat_list && count( $categories_for_list ) > 1 ) : ?>

						<div class="kanews_widget_posts_6">
							<div class="kanews-tab">
								<ul class="nav nav-tabs d-flex flex-wrap">

									<?php $number= 0; foreach( $categories_for_list as $category ) {  $number++;?>
										<li class="nav-item">
											<a href="<?php echo get_category_link($category); ?>" class="nav-link">	<?php echo get_cat_name($category); ?></a>
										</li>
									<?php } ?>
								</ul>
							</div>
						</div>

					<?php endif; ?>

          <div class="kanews-slider-3" >

						<div class="kanews-slider-wrapper kanews-slider-grid" data-slick='<?php echo wp_json_encode( $slick_options ); ?>'>
							<?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; ?>
								<div class="<?php echo $item_Col; ?>">
								<div class="kanews-post-item kanews-post-grid-item">
									<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
		
									<?php do_action('kanews_post_hook'); ?>
									<?php kanews_post_thumbnail($thumbnail, 'kanews-post-thumb'); ?>
	
									<div class="kanews-post-content">
										<?php if($show_post_cat != 'off'): ?>
											<?php echo kanews_primary_category($post->ID, 'style-2'); ?>
										<?php endif; ?>
										
										<?php the_title( sprintf( '<'.$html.' class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></'.$html.'>' ); ?>
										<?php if($show_post_date == 'on'): ?>
											<?php echo kanews_post_date('post'); ?>
										<?php endif; ?>
									</div>
								</div>
								</div>
								<?php 
								if( $is_do_not_dublicate ){
									Kanews\Helper::do_not_dublicate( $post->ID );
								}
								?>
							<?php endwhile; wp_reset_postdata(); ?>
						</div>

						<?php if ( ! empty( $instance['show_more_link'] ) ): ?>
							<div class="col-12">
							<div class="d-flex justify-content-center align-items-center"><a href="<?php echo esc_url( $instance['show_more_link'] ); ?>" class="kanews-label kanews-label-widget"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?></a></div>
							</div>
						<?php endif; ?>

          </div>
        </div>
			</div>
		<?php endif; ?>
	<?php }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
$instance['show_more_link'] = $new_instance['show_more_link'];
		$instance['grid'] = $new_instance['grid'];
		$instance['show_nav'] = $new_instance['show_nav'];
		$instance['autoplay'] = $new_instance['autoplay'];
		$instance['html_tag'] = $new_instance['html_tag'];

		$instance['tags'] = $new_instance['tags'];
		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];

		$instance['show_post_date'] = $new_instance['show_post_date'];
		$instance['show_post_cat'] = $new_instance['show_post_cat'];
		$instance['dark_mode'] = $new_instance['dark_mode'];
		$instance['include_columist'] = $new_instance['include_columist'];

		$instance['cat_list'] = $new_instance['cat_list'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		$instance['bg-color'] = $new_instance['bg-color'];
		$instance['bg-color2'] = $new_instance['bg-color2'];
		$instance['accent-color'] = $new_instance['accent-color'];
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = self::get_defaults();
		$instance = wp_parse_args((array) $instance, $defaults); 

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('show_more_link'),
					'name' => $this->get_field_name('show_more_link'),
					'label' => __('Daha Fazla Linki', 'kanews'),
					'value' => $instance['show_more_link']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_nav'),
					'name' => $this->get_field_name('show_nav'),
					'label' => __('Navigasyon Butonları', 'kanews'),
					'value' => $instance['show_nav']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('autoplay'),
					'name' => $this->get_field_name('autoplay'),
					'label' => __('Otomatik Oynat', 'kanews'),
					'value' => $instance['autoplay']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('html_tag'),
					'name' => $this->get_field_name('html_tag'),
					'label' => __('Yazı Başlığı HTML Tag', 'kanews'),
					'value' => $instance['html_tag'],
					'options' => [
						'div' => 'Div',
						'h1' => 'H1',
						'h2' => 'H2',
						'h4' => 'h4',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6'
					]
				]
			]
		]);

		// Global Sıralama Ayarları
		Kanews_Form_Elements::render_posts_sorting_settings($this, $instance);

		// İçerik Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_cat'),
					'name' => $this->get_field_name('show_post_cat'),
					'label' => __('Yazı Kategorisini Göster', 'kanews'),
					'value' => $instance['show_post_cat']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_date'),
					'name' => $this->get_field_name('show_post_date'),
					'label' => __('Yazı Tarihini Göster', 'kanews'),
					'value' => $instance['show_post_date']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('dark_mode'),
					'name' => $this->get_field_name('dark_mode'),
					'label' => __('Koyu Mod', 'kanews'),
					'value' => $instance['dark_mode']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('cat_list'),
					'name' => $this->get_field_name('cat_list'),
					'label' => __('Kategorileri Listele', 'kanews'),
					'value' => $instance['cat_list']
				]
			]
		]);

		// Görünüm Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('accent-color'),
					'name' => $this->get_field_name('accent-color'),
					'label' => __('Birincil Renk', 'kanews'),
					'value' => $instance['accent-color']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color'),
					'name' => $this->get_field_name('bg-color'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['bg-color']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color2'),
					'name' => $this->get_field_name('bg-color2'),
					'label' => __('Arkaplan Rengi 2', 'kanews'),
					'value' => $instance['bg-color2']
				]
			]
		]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);
		?>

		<script type="text/javascript">
			jQuery(document).ready(function($) {
				$('#<?php echo $this->id; ?>-select-cat').select2({
					width: 'resolve',
					placeholder: 'Tüm Kategoriler'
				});
			});
		</script>

<script type="text/javascript">
	<?php if($instance['hide_mobile'] == 'on' && $instance['hide_desktop'] != 'on'): ?>
		jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-desktop');
	<?php elseif($instance['hide_desktop'] == 'on' && $instance['hide_mobile'] != 'on'): ?>
		jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-mobile');
	<?php else: ?>
		jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-all');
	<?php endif; ?>
</script>
		<?php
	}
}
?>