<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_standings extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_standings');
		$control_ops = array('id_base' => 'kanews_widget_standings');
		parent::__construct('kanews_widget_standings', KAN_THEME_NAME .' - '.__( "Puan Durumları" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

		$leagues = [
			'super-lig',
			'almanya-bundesliga',
			'ingiltere-premier-ligi',
			'italya-serie-a',
			'fransa-ligue-1',
			'ispanya-la-liga',
			'tff-1-lig',
			'euroleague',
			'erkek-basketbol',
			'kadin-basketbol',
			'efeler-ligi',
			'sultanlar-ligi'
		];

    $title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
    $grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
    $lig = (!empty($instance['lig'])) ? $instance['lig'] : 'super-lig';
    $upper = (!empty($instance['upper'])) ? $instance['upper'] : '4';
    $teams = (!empty($instance['team'])) ? $instance['team'] : '5';
    $pages = (!empty($instance['pages'])) ? $instance['pages'] : '';

    ?>

    <div class="<?php echo esc_attr($grid); ?>">
      <div class="kanews-section">
				<?php if ( ! empty($instance['title']) ):
					echo ( $args['before_title'] . $title . $args['after_title'] );
				endif; 
						
				$api  =  new SuperLigStandings();
				$simpleStandings  =  $api->getStandings($lig);
				?>

				<div class="kanews-table-2 kanews-table-standing">
	
					<div class="kanews-table-heading d-flex align-items-center">
						<div class="kanews-table-item w-40">#</div>
						<div class="kanews-table-item col"><?php esc_html_e('Takım', 'kanews'); ?></div>
						<div class="kanews-table-item w-40">O</div>
						<div class="kanews-table-item w-40 hidden-mobile">AV</div>
						<div class="kanews-table-item w-40">P</div>

					</div>
					<div class="kanews-table-content">
					<?php 
					$counter = 0;
						if(!empty($simpleStandings)) {
							foreach ($simpleStandings as $team) { $counter++;
								if($counter <= $teams) {
									// Pozisyon sınıfını belirle
									$position_class = '';
									if($counter <= 4) {
										$position_class = 'position-' . $counter;
									} elseif($counter == 5) {
										$position_class = 'position-5';
									} elseif($counter > ($teams - 3)) {
										$position_class = 'relegation';
									}
									echo '<div class="kanews-table-wrap d-flex align-items-center">';
										echo '<div class="kanews-table-item w-40 '. esc_attr($position_class) . '">'. $team->position. '</div>';
										if($team->logo)
										echo '<div class="kanews-table-item col"><img src="'.esc_url(kanews_lazyload_placeholder('1e1')).'" class="kanews-lazy" data-src="'.$team->logo.'" width="24" height="24" alt="logo" /> <span class="hidden-mobile">'.$team->name. '</span><span class="hidden-desktop">'.$team->middleName.'</span></div>';
										else
										echo '<div class="kanews-table-item col"><span class="hidden-mobile">'.$team->name. '</span><span class="hidden-desktop">'.$team->middleName.'</span></div>';
										echo '<div class="kanews-table-item w-40">'. $team->played . '</div>';
										echo '<div class="kanews-table-item w-40 hidden-mobile">'. $team->average . '</div>';
										echo '<div class="kanews-table-item w-40">'. $team->points . '</div>';
									echo '</div>';
								} 
							} 
						} else {
							echo '<p class="text-center py-4">' . esc_html__('Veri alınamadı!', 'kanews') . '</p>';
						}
						
						?>
					</div>
				</div>
        
				<?php if($pages != '' && $pages != 'all'): ?>
					<div class="d-flex justify-content-between align-items-center p-1">
						<a href="<?php echo esc_url( add_query_arg( 'lig', $lig, get_page_link($pages) ) ); ?>" class="kanews-label kanews-label-widget" target="_blank"><?php esc_html_e( 'Detaylı Sıralama', 'kanews' ); ?></a>
					
					</div>
				<?php endif; ?>
      </div>
    </div>
  <?php
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['lig'] = $new_instance['lig'];
		$instance['grid'] = $new_instance['grid'];
		$instance['team'] = $new_instance['team'];
		$instance['pages'] = $new_instance['pages'];

		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		
		return $instance;
	}

  // Back-end
	public function form($instance) {
		$defaults = array( 
			'title' => esc_html__('Puan Durumu', 'kanews'), 
			'grid' => 'col-12', 
			'categories' => '', 
			'pages' => 'all', 
			'lig' => 'super-lig', 
			'team' => '5', 
			'hide_desktop' => 'off',
			'hide_mobile' => 'off'
		);
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col' => __('Sığdır', 'kanews'),
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				]
			]
		]);

		// İçerik Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('lig'),
					'name' => $this->get_field_name('lig'),
					'label' => __('Lig', 'kanews'),
					'value' => $instance['lig'],
					'options' => [
						'super-lig' => __('Süper Lig', 'kanews'),
						'almanya-bundesliga' => __('Bundesliga', 'kanews'),
						'ingiltere-premier-ligi' => __('Premier Lig', 'kanews'),
						'italya-serie-a' => __('Serie A', 'kanews'),
						'fransa-ligue-1' => __('Ligue 1', 'kanews'),
						'ispanya-la-liga' => __('La Liga', 'kanews'),
						'tff-1-lig' => __('TFF 1. Lig', 'kanews'),
						'euroleague' => __('Euroleague', 'kanews'),
						'erkek-basketbol' => __('Erkek Basketbol', 'kanews'),
						'kadın-basketbol' => __('Kadın Basketbol', 'kanews'),
						'efeler-ligi' => __('Efeler Ligi', 'kanews'),
						'sultanlar-ligi' => __('Sultanlar Ligi', 'kanews'),
						'sampiyonlar-ligi' => __('Şampiyonlar Ligi', 'kanews'),
						'avrupa-ligi' => __('Avrupa Ligi', 'kanews'),
						'konferans-ligi' => __('Konferans Ligi', 'kanews')
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_NUMBER,
					'id' => $this->get_field_id('team'),
					'name' => $this->get_field_name('team'),
					'label' => __('Gösterilecek Takım Sayısı', 'kanews'),
					'value' => $instance['team']
				]
			]
		]);

		// Sayfa Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Sayfa Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('pages'),
					'name' => $this->get_field_name('pages'),
					'label' => __('Puan Durumları Sayfası', 'kanews'),
					'value' => $instance['pages'],
					'options' => Kanews_Form_Elements::get_pages_options()
				]
			]
		]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);

		?>
		<script type="text/javascript">
			<?php if($instance['hide_mobile'] == 'on' && $instance['hide_desktop'] != 'on'): ?>
				jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-desktop');
			<?php elseif($instance['hide_desktop'] == 'on' && $instance['hide_mobile'] != 'on'): ?>
				jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-mobile');
			<?php else: ?>
				jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-all');
			<?php endif; ?>
		</script>
		<?php
	}
}
?>