<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}
// Widget Class
class kanews_widget_class_tab_menu extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_tab_menu  kanews-section-gutter');
		$control_ops = array('id_base' => 'kanews_widget_tab_menu');
		parent::__construct('kanews_widget_tab_menu', ''.KAN_THEME_NAME .' - '.__( "Tab Menü" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

		$title = (isset($instance['title'])) ? $instance['title'] : esc_html__( 'Popüler Haberler', 'kanews' );
		$title2 = (isset($instance['title2'])) ? $instance['title2'] : esc_html__( 'Son Haberler', 'kanews' );

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';

		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
		$tags = (isset($instance['tags'])) ? $instance['tags'] : '';
    $posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
    $offset = (isset($instance['offset'])) ? $instance['offset'] : '';
    $date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		$format = !empty($instance['format']) ? $instance['format'] : '';
		$pop_sortby = !empty($instance['pop_sortby']) ? $instance['pop_sortby'] : 'commented';
		$post_thumb_position = (!empty($instance['post_thumb_position'])) ? 'post-thumb-'.$instance['post_thumb_position'] : 'post-thumb-left';

		$show_post_cat = !isset($instance['show_post_cat']) ? false : true;
		$show_post_thumb = !isset($instance['show_post_thumb']) ? false : true;
		$show_post_date = !isset($instance['show_post_date']) ? false : true;

		$query_args = array(
			'number'				=> $posts,
			'id'    				=> $categories,
			'sortby' 				=> 'recent',
			'tags' 					=> $tags,
			'range'				  => $date_range,
			'format'				=> $format
		);
		$kanews_recent_query = kan_query( $query_args );
		
		$query_args = array(
			'number'				=> $posts,
			'id'    				=> $categories,
			'sortby' 				=> $pop_sortby,
			'tags' 					=> $tags,
			'range'				  => $date_range,
			'format'				=> $format
		);
		$kanews_popular_query = kan_query( $query_args );
		

		$thumbnail = 'kanews-post-2';
		$number = $this->number;
		$col = 'col-12';
		?>
		<div class="<?php echo $grid; ?>">
			<div class="kanews-section <?php echo $this->widget_options['classname']; ?>">
				<div class="kanews-tab">
					<!-- Tab Panel -->
					<ul class="nav nav-tabs d-flex flex-wrap" id="kanewsTab-<?php echo $number; ?>" role="tablist">
						<li class="nav-item" role="presentation">
							<div class="nav-link active" id="popular-tab-<?php echo $number; ?>" data-toggle="tab" href="#popular-<?php echo $number; ?>" role="tab" data-controls="popular-<?php echo $number; ?>" data-selected="true"><?php echo $title; ?></div>
						</li>
						<li class="nav-item" role="presentation">
							<div class="nav-link" id="recent-tab-<?php echo $number; ?>" data-toggle="tab" href="#recent-<?php echo $number; ?>" role="tab" data-controls="recent-<?php echo $number; ?>" data-selected="false"><?php echo $title2; ?></div>
						</li>
					</ul>
					<!-- Tab Content -->
					<div class="tab-content" id="kanewsTabContent-<?php echo $number; ?>">

						<!-- Popular Posts -->
						<div class="tab-pane fade show active" id="popular-<?php echo $number; ?>" role="tabpanel" data-labelledby="popular-tab-<?php echo $number; ?>">
							<?php if ($kanews_popular_query->have_posts()) : ?>
								<div class="row">
									<?php while($kanews_popular_query->have_posts()): $kanews_popular_query->the_post(); global $post; ?>
										<div class="<?php echo $col; ?>">
											<div class="kanews-post-item kanews-post-grid-item kanews-post-small-item <?php echo $post_thumb_position; ?>">
												<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
												<?php do_action('kanews_post_hook'); ?>
												<?php if($show_post_thumb != false): ?>
													<?php kanews_post_thumbnail('thumbnail', 'kanews-post-thumb'); ?>
												<?php endif; ?>
												<div class="kanews-post-content">
													<?php if($show_post_cat != false): ?>
														<?php echo kanews_primary_category($post->ID); ?>
														<?php echo Kanews\PostViews::get_post_views($post->ID, '', true, false); ?>
													<?php endif; ?>
													<?php the_title( sprintf( '<h4 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
													
												</div>
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							<?php else: ?>
								<p><?php esc_html_e( 'Gösterilecek yazı bulunamadı.', 'kanews' ); ?></p>
							<?php endif; ?>
						</div>

						<!-- Recent Posts -->
						<div class="tab-pane fade" id="recent-<?php echo $number; ?>" role="tabpanel" data-labelledby="recent-tab-<?php echo $number; ?>">
							<?php if ($kanews_recent_query->have_posts()) : ?>
								<div class="row">
									<?php while($kanews_recent_query->have_posts()): $kanews_recent_query->the_post(); global $post; ?>
										<div class="<?php echo $col; ?>">
											<div class="kanews-post-item kanews-post-grid-item kanews-post-small-item <?php echo $post_thumb_position; ?>">
												<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
												<?php do_action('kanews_post_hook'); ?>
												<?php if($show_post_thumb != false): ?>
													<?php kanews_post_thumbnail('thumbnail', 'kanews-post-thumb'); ?>
												<?php endif; ?>
												<div class="kanews-post-content">
													<?php if($show_post_cat != false): ?>
														<?php echo kanews_primary_category($post->ID); ?>
													<?php endif; ?>
													<?php if($show_post_date == true): ?>
														<?php echo kanews_post_date('post', 'post'); ?>
													<?php endif; ?>
													<?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
												
												</div>
											</div>
										</div>
									<?php endwhile; ?>
								</div>
							<?php else: ?>
								<p><?php esc_html_e( 'Gösterilecek yazı bulunamadı.', 'kanews' ); ?></p>
							<?php endif;  wp_reset_postdata(); ?>
						</div>

					</div>
				</div>
			</div>
		</div>
	<?php }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['title2'] = $new_instance['title2'];
		
		$instance['grid'] = $new_instance['grid'];
		$instance['col'] = $new_instance['col'];

		$instance['pop_sortby'] = $new_instance['pop_sortby'];
		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];

		$instance['show_post_cat'] = $new_instance['show_post_cat'];
		$instance['show_post_date'] = $new_instance['show_post_date'];
		$instance['show_post_thumb'] = $new_instance['show_post_thumb'];
		$instance['post_thumb_position'] = $new_instance['post_thumb_position'];

		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			'title' => esc_html__( 'Popüler Haberler', 'kanews' ), 
			'title2' => esc_html__( 'Yeni Haberler', 'kanews' ), 

			'grid' => 'col-12', 

			'offset'  => '', 
			'postnotin'  => '', 
			'categories' => 'all', 
			'posts' 		 => 5, 
			'date_range' => '0', 
			'format' 		 => '0',
			'format' 		 => '0',
			'pop_sortby' => 'commented',

			'show_post_cat'       => 'on',
			'show_post_thumb'     => 'on',
			'show_post_date'     => 'off',
			'post_thumb_position' => 'left',
			'hide_desktop' 	 => 'off',
			'hide_mobile' 	 => 'off'
    );
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		
		<h3 class="kanews-widgets-title"><?php _e('Genel Ayarlar', 'kanews'); ?></h3>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'kanews') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title2' ); ?>"><?php _e( 'Başlık' , 'kanews') ?> #2</label>
			<input id="<?php echo $this->get_field_id( 'title2' ); ?>" name="<?php echo $this->get_field_name( 'title2' ); ?>" value="<?php echo $instance['title2']; ?>" class="widefat" type="text" />
		</p>

		<p class="kanews-grid-select">
			<label for="<?php echo $this->get_field_id('grid'); ?>"><?php _e( 'Genişlik' , 'kanews') ?></label> 
			<select id="<?php echo $this->get_field_id('grid'); ?>" name="<?php echo $this->get_field_name('grid'); ?>" class="widefat" style="width:100%;">
				<option value='col-12' <?php if ('col-12' == $instance['grid']) echo 'selected="selected"'; ?>>12/12</option>
				<option value='col-12 col-lg-8' <?php if ('col-12 col-lg-8' == $instance['grid']) echo 'selected="selected"'; ?>>12/8</option>
				<option value='col-12 col-lg-6' <?php if ('col-12 col-lg-6' == $instance['grid']) echo 'selected="selected"'; ?>>12/6</option>
				<option value='col-12 col-lg-4' <?php if ('col-12 col-lg-4' == $instance['grid']) echo 'selected="selected"'; ?>>12/4</option>
			</select>
		</p> 


		<div class="kanews-divider"></div>
		<h3 class="kanews-widgets-title"><?php _e('Sıralama Ayarları', 'kanews'); ?></h3>

		<p>
			<label for="<?php echo $this->get_field_id('pop_sortby'); ?>"><?php _e( 'Popüler Haberlerin Sıralanışı' , 'kanews') ?></label> 
			<select id="<?php echo $this->get_field_id('pop_sortby'); ?>" name="<?php echo $this->get_field_name('pop_sortby'); ?>" class="widefat" style="width:100%;">
			<option value='post-viewed' <?php if ('post-viewed' == $instance['pop_sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'kanews') ?></option>
			<option value='commented' <?php if ('commented' == $instance['pop_sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'kanews') ?></option>
			</select>
		</p>
    
    <p>
			<label for="<?php echo $this->get_field_id('date_range'); ?>"><?php _e( 'Zaman Aralığı' , 'kanews') ?></label> 
			<select id="<?php echo $this->get_field_id('date_range'); ?>" name="<?php echo $this->get_field_name('date_range'); ?>" class="widefat" style="width:100%;">
				<option value='0' <?php if ('0' == $instance['date_range']) echo 'selected="selected"'; ?>><?php _e( 'Zaman Aralığı Seçin' , 'kanews') ?></option>
				<option value='day' <?php if ('day' == $instance['date_range']) echo 'selected="selected"'; ?>><?php _e( 'Son 1 Gün' , 'kanews') ?></option>
				<option value='week' <?php if ('week' == $instance['date_range']) echo 'selected="selected"'; ?>><?php _e( 'Son 1 Hafta' , 'kanews') ?></option>
				<option value='month' <?php if ('month' == $instance['date_range']) echo 'selected="selected"'; ?>><?php _e( 'Son 1 Ay' , 'kanews') ?></option>
				<option value='year' <?php if ('year' == $instance['date_range']) echo 'selected="selected"'; ?>><?php _e( 'Son 1 Yıl' , 'kanews') ?></option>
			</select>
		</p>

    <p>
			<label for="<?php echo $this->get_field_id('categories'); ?>"><?php _e( 'Kategori' , 'kanews') ?></label> 
			<select id="<?php echo $this->get_field_id('categories'); ?>" name="<?php echo $this->get_field_name('categories'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>><?php _e( 'Tüm Kategoriler' , 'kanews') ?></option>
				<?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($categories as $category) { ?>
				<option value='<?php echo $category->term_id; ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo $category->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('format'); ?>"><?php _e( 'Yazı Formatı' , 'kanews') ?></label> 
			<select id="<?php echo $this->get_field_id('format'); ?>" name="<?php echo $this->get_field_name('format'); ?>" class="widefat" style="width:100%;">
				<option value='0' <?php if ('0' == $instance['format']) echo 'selected="selected"'; ?>><?php _e( 'Yazı Formatı Seçin' , 'kanews') ?></option>
				<option value='video' <?php if ('video' == $instance['format']) echo 'selected="selected"'; ?>><?php _e( 'Video' , 'kanews') ?></option>
				<option value='gallery' <?php if ('gallery' == $instance['format']) echo 'selected="selected"'; ?>><?php _e( 'Fotoğraf' , 'kanews') ?></option>
			</select>
		</p>

    <p>
      <label for="<?php echo $this->get_field_id('offset'); ?>"><?php _e( 'Offset' , 'kanews') ?></label>
      <i style="margin-bottom:5px;display:block;"><?php _e('Örneğin 1 girerseniz birinci yazıyı hariç tutar, ikinci yazıdan başlar.', 'kanews'); ?></i>
      <input type="number" class="widefat" id="<?php echo $this->get_field_id('offset'); ?>" name="<?php echo $this->get_field_name('offset'); ?>" value="<?php echo $instance['offset']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'kanews') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'kanews'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>

    <p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Yazı Sayısı' , 'kanews') ?></label>
			<input type="number" class="widefat" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>

		<div class="kanews-divider"></div>

		<h3 class="kanews-widgets-title"><?php _e('İçerik Ayarları', 'kanews'); ?></h3>

		<p>
			<label for="<?php echo $this->get_field_id('post_thumb_position'); ?>"><?php _e( 'Yazı Görseli Konumu' , 'kanews') ?></label> 
			<select id="<?php echo $this->get_field_id('post_thumb_position'); ?>" name="<?php echo $this->get_field_name('post_thumb_position'); ?>" class="widefat" style="width:100%;">
				<option value='left' <?php if ('0' == $instance['post_thumb_position']) echo 'selected="selected"'; ?>><?php _e( 'Sol' , 'kanews') ?></option>
				<option value='right' <?php if ('day' == $instance['post_thumb_position']) echo 'selected="selected"'; ?>><?php _e( 'Sağ' , 'kanews') ?></option>
			</select>
		</p>

		<p>
      <label for="<?php echo $this->get_field_id('show_post_thumb'); ?>"><?php _e( 'Yazı Görselini Göster' , 'kanews') ?></label>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_post_thumb'], 'on'); ?> id="<?php echo $this->get_field_id('show_post_thumb'); ?>" name="<?php echo $this->get_field_name('show_post_thumb'); ?>" /> 
		</p>

		<p>
      <label for="<?php echo $this->get_field_id('show_post_date'); ?>"><?php _e( 'Yazı Tarihini Göster' , 'kanews') ?></label>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_post_date'], 'on'); ?> id="<?php echo $this->get_field_id('show_post_date'); ?>" name="<?php echo $this->get_field_name('show_post_date'); ?>" /> 
		</p>

		<p>
      <label for="<?php echo $this->get_field_id('show_post_cat'); ?>"><?php _e( 'Yazı Kategorisini Göster' , 'kanews') ?></label>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_post_cat'], 'on'); ?> id="<?php echo $this->get_field_id('show_post_cat'); ?>" name="<?php echo $this->get_field_name('show_post_cat'); ?>" /> 
		</p>

		<div class="kanews-divider"></div>

		<h3 class="kanews-widgets-title"><?php _e('Diğer Ayarlar', 'kanews'); ?></h3>

		<p>
      <label for="<?php echo $this->get_field_id('hide_desktop'); ?>"><?php _e( 'Masaüstünde Gizle' , 'kanews') ?></label>
			<input class="checkbox" type="checkbox" <?php checked($instance['hide_desktop'], 'on'); ?> id="<?php echo $this->get_field_id('hide_desktop'); ?>" name="<?php echo $this->get_field_name('hide_desktop'); ?>" /> 
		</p>

		<p>
      <label for="<?php echo $this->get_field_id('hide_mobile'); ?>"><?php _e( 'Mobilde Gizle' , 'kanews') ?></label>
			<input class="checkbox" type="checkbox" <?php checked($instance['hide_mobile'], 'on'); ?> id="<?php echo $this->get_field_id('hide_mobile'); ?>" name="<?php echo $this->get_field_name('hide_mobile'); ?>" /> 
		</p>

<script type="text/javascript">
	<?php if($instance['hide_mobile'] == 'on' && $instance['hide_desktop'] != 'on'): ?>
		jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-desktop');
	<?php elseif($instance['hide_desktop'] == 'on' && $instance['hide_mobile'] != 'on'): ?>
		jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-mobile');
	<?php else: ?>
		jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-all');
	<?php endif; ?>
</script>
		
	<?php }
}