<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_term_images', array(
    'title'       => KAN_THEME_NAME .' - '."Resimli Terimler",
    'description' => "Kategori, etiket veya sayfalarınızı görsel olarak listelemeye yarar.",
    'classname'   => 'kanews_widget_class_term_images',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      array(
        'id'      => 'style',
        'type'    => 'select',
        'title'   => 'Görünüm',
        'options' => array(
          '1' => '1',
          '2' => '2',
        ),
        'default' => '1'
      ),
      array(
        'id'     => 'terms',
        'type'   => 'group',
        'title'  => 'Terim'.' #1',
        'button_title'  => 'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Başlık'
          ),
          array(
            'id'    => 'thumb',
            'type'  => 'media',
            'title' => 'Görsel'
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => 'Link'
          ),
          array(
            'id'    => 'color',
            'type'  => 'color',
            'title' => 'Vurgulanan Renk'
          ),
        ),
      ),
      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      )
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_term_images' ) ) {
    function kanews_widget_term_images( $widget, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      $args_defaults = array( 
        'grid'        => 'col-12',
        'title'       => '',
        'terms'       => '',
        'style'       => '1',
        'hide_mobile' => false,
        'hide_desktop' => false,
      ); 
      $args = wp_parse_args( $instance, $args_defaults );

      if(empty($args['terms']))
      return;




      $slick_options2 = [
        'infinite' 		=> false,
        'variableWidth' => true
      ];

      ?>
      <div class="<?php echo $args['grid']; ?>"> 
        <div class="kanews-section kanews_widget_term_images kanews-section-flat kanews-section-gutter">
          <?php 
          if ( ! empty($args['title']) ){
            echo ( $widget['before_title'] . $args['title'] . $widget['after_title'] );
          }
          ?>
          <?php if($args['style'] == '1'): ?>
            <div class="row kanews-term-imagebox g-3">
              <?php foreach($args['terms'] as $term):
                if( empty($term['thumb']['id']) ) {
                  continue;
                }
                $title = isset($term['title']) ? $term['title'] : '';
                $link = isset($term['link']) && $term['link'] !== '' ? esc_url($term['link']) : '';
                $color_style = ( isset($term['color']) && $term['color'] != '' ) ? 'style="--gradient-start-color: '.esc_attr($term['color']).'"' : '';
              ?>
                <div class="col-12 col-sm-6 col-lg-3">
                  <div class="kanews-image-box">
                    <div class="kanews-image-box-image">
                      <?php echo wp_get_attachment_image($term['thumb']['id'], 'large', false, array('loading' => 'lazy', 'alt' => esc_attr($title))); ?>
                    </div>
                    <?php if($link !== ''): ?>
                      <a class="kanews-image-box-url" href="<?php echo $link; ?>" title="<?php echo esc_attr( $title ); ?>"></a>
                    <?php endif; ?>
                    <?php if($title !== ''): ?>
                      <div class="kanews-image-box-content" <?php echo $color_style; ?>>
                        <h3 class="kanews-image-box-title"><?php echo esc_html($title); ?></h3>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          <?php else: ?>
            <div class="kanews-slider-cats kanews-slider-cats-<?php echo $args['style']; ?> kanews-slider-global">
              <div class="kanews-slider-wrapper" data-slick='<?php echo wp_json_encode( $slick_options2); ?>'>
                <?php foreach($args['terms'] as $term): ?>
                  <?php if(isset($term['thumb']['id'])): ?>
                    <a href="<?php echo esc_url($term['link']); ?>" class="kanews-slider-cat d-flex align-items-center justify-content-center">
                      <?php echo wp_get_attachment_image($term['thumb']['id'], 'full', '', array('title' => esc_attr($term['title']), 'alt' => sanitize_title($term['title']))); ?>
                    </a>
                  <?php endif; ?>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endif; ?>

        </div>
      </div>
      <?php

    }
  }
}