<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_ticker extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_ticker');
		$control_ops = array('id_base' => 'kanews_widget_ticker');
		parent::__construct('kanews_widget_ticker', KAN_THEME_NAME .' - '.__( "Son Dakika Çubuğu" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
    $posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
		$offset = (isset($instance['offset'])) ? $instance['offset'] : '';
		$tags = (isset($instance['tags'])) ? $instance['tags'] : '';
    $date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
    $sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$is_do_not_dublicate = $instance['postnotin'] == 'on' ? true : false;
		$post_type = !isset($instance['include_columist']) ? 'post' : array('post', 'columist');


		$format = !empty($instance['format']) ? $instance['format'] : '';

		$query_args = array(
			'post_type'			=> $post_type,
			'number'				=> $posts,
			'id'    				=> $categories,
			'sortby' 				=> $sortby,
			'tags_ids' 					=> $tags,
			'offset' 				=> $offset,
			'range'				  => $date_range,
			'format'				=> $format
		);
		$query = kan_query( $query_args );

		$background_color = isset($instance['background_color']) ? $instance['background_color'] : '#e74c3c';
		$link_color = isset($instance['link_color']) ? $instance['link_color'] : '#ffffff';

		echo '<style>
			.light-mode #'.$args['widget_id'].'.kanews-section .kanews-ticker-2 {
				background-color: ' . esc_attr($background_color) . ';
			}
			.light-mode #'.$args['widget_id'].'.kanews-section .kanews-ticker-2 .vf144a span {
				color: ' . esc_attr($link_color) . ';
			}
			.light-mode #'.$args['widget_id'].'.kanews-section .kanews-ticker-2 .kanews-ticker-x li a {
				color: ' . esc_attr($link_color) . ' !important;
			}
			.light-mode #'.$args['widget_id'].'.kanews-section .kanews-ticker-2 ul li::after {
				background-color: ' . esc_attr($link_color) . ' !important;
			}
		</style>';

    echo '<div class="'.$grid.'">';
			echo '<div id="'.$args['widget_id'].'" class="kanews-section '.$this->widget_options['classname'].'">';
			if ($query->have_posts()) {
				echo '<div class="kanews-ticker-2 d-flex align-items-center">';
	
					if ($title != '') 
						echo '<div class="col-auto vf144a"><span>'.$title.':</span></div>';

						echo '<ul class="kanews-ticker-x d-flex">';
							while($query->have_posts()): $query->the_post(); global $post;
								echo '<li class="col-auto"><a href="'.get_the_permalink($post->ID).'">'.get_the_title($post->ID).'</a></li>';
								if( $is_do_not_dublicate ){
									Kanews\Helper::do_not_dublicate( $post->ID );
								}
							endwhile; wp_reset_postdata();
						echo '</ul>';
	
				echo '</div>';
			} else {
				echo esc_html__( 'Haber bulanamadı.', 'kanews' );
			}
			echo '</div>';
    echo '</div>';
		
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);

		$instance['grid'] = $new_instance['grid'];
		$instance['tags'] = $new_instance['tags'];
		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];
		$instance['include_columist'] = $new_instance['include_columist'];
		$instance['postnotin'] = $new_instance['postnotin'];

		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		
		$instance['background_color'] = sanitize_hex_color($new_instance['background_color']);
		$instance['link_color'] = sanitize_hex_color($new_instance['link_color']);
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			'title' => 'Son Dakika', 
			'grid'  => 'col-12', 
			'tags'  => '', 
			'postnotin'  => '', 
			'categories' => 'all', 
			'posts' => 5, 
			'sortby' => 'recent', 
			'date_range' => '0', 
			'offset' => '0',
			'format' => '0',
			'include_columist' => 'off',
			'postnotin' => 'off',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off',
			'background_color' => '',
			'link_color' => ''
		);
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col' => __('Sığdır', 'kanews'),
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				]
			]
		]);

		// Global Sıralama Ayarları
		Kanews_Form_Elements::render_posts_sorting_settings($this, $instance);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);

		// Renk Ayarları accordion'u
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Renk Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('background_color'),
					'name' => $this->get_field_name('background_color'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['background_color']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('link_color'),
					'name' => $this->get_field_name('link_color'),
					'label' => __('Link Rengi', 'kanews'),
					'value' => $instance['link_color']
				]
			]
		]);

	}
}
