<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}
// Widget Class
class kanews_widget_class_weather extends WP_Widget {
	private $defaults = [
		'grid' => 'col-12',
		'title' => '',
		'city' => 'İstanbul',
		'show_wind' => 'on',
		'show_humidity' => 'on',
		'show_pressure' => 'on',
		'show_min_temp' => 'on',
		'show_max_temp' => 'on',
		'show_forecast' => 'off',
		'forecast_days' => 5,
		'hide_desktop' => 'off',
		'hide_mobile' => 'off',
		'show_dropdown' => true,
		'gradient_start' => '',
		'gradient_end' => '',
		'use_custom_gradient' => 'off'
	];

	// Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_weather  kanews-section-gutter');
		$control_ops = array('id_base' => 'kanews_widget_weather');
		parent::__construct('kanews_widget_weather', KAN_THEME_NAME .' - '.__( "Hava Durumu" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		
		// Gradient stil oluştur
		$custom_style = '';
		if (!empty($instance['gradient_start']) && !empty($instance['gradient_end']) ) {

			
			$custom_style = sprintf(
				'<style>
					.light-mode #%s .weather-widget {
						background: linear-gradient(%s 0%%, %s 100%%);
					}
				</style>',
				$args['widget_id'],
				esc_attr($instance['gradient_start']),
				esc_attr($instance['gradient_end'])
			);
		}
		
		$weather_options = [
			'city' => !empty($instance['city']) ? $instance['city'] : 'İstanbul',
			'show_wind' => !empty($instance['show_wind']),
			'show_humidity' => !empty($instance['show_humidity']),
			'show_pressure' => !empty($instance['show_pressure']),
			'show_min_temp' => !empty($instance['show_min_temp']),
			'show_max_temp' => !empty($instance['show_max_temp']),
			'show_forecast' => !empty($instance['show_forecast']),
			'forecast_days' => !empty($instance['forecast_days']) ? absint($instance['forecast_days']) : 5,
			'show_full_link' => true,
			'title' => !empty($instance['title']) ? $instance['title'] : '',
			'show_dropdown' => !empty($instance['show_dropdown']),
			'widget_id' => $args['widget_id']
		];

		// Özel stil ve widget HTML'ini yazdır
		echo $custom_style;
		echo '<div id="'.$args['widget_id'].'" class="kanews-section kanews-section-flat kanews_widget_weather '.$grid.'">';
		$weather = new KANEWS_WEATHER($weather_options);
		echo '</div>';
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = [];

		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['city'] = sanitize_text_field($new_instance['city']);
		$instance['show_wind'] = $new_instance['show_wind'];
		$instance['grid'] = $new_instance['grid'];
		$instance['show_humidity'] = $new_instance['show_humidity'];
		$instance['show_pressure'] = $new_instance['show_pressure'];
		$instance['show_min_temp'] = $new_instance['show_min_temp'];
		$instance['show_max_temp'] = $new_instance['show_max_temp'];
		$instance['show_forecast'] = $new_instance['show_forecast'];
		$instance['forecast_days'] = $new_instance['forecast_days'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['show_dropdown'] = $new_instance['show_dropdown'];
		$instance['gradient_start'] = sanitize_text_field($new_instance['gradient_start']);
		$instance['gradient_end'] = sanitize_text_field($new_instance['gradient_end']);
		$instance['use_custom_gradient'] = $new_instance['use_custom_gradient'];

		if( ! empty( $instance['city'] ) ){
			KANEWS_WEATHER::clear_cache( $instance['city'] );
		}
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		
		$instance = wp_parse_args((array) $instance, $this->defaults);

    // Genel Ayarlar
    Kanews_Form_Elements::render_accordion_field([
      'title' => __('Genel Ayarlar', 'kanews'),
      'content' => [
        [
          'type' => Kanews_Form_Elements::TYPE_TEXT,
          'id' => $this->get_field_id('title'),
          'name' => $this->get_field_name('title'),
          'label' => __('Başlık', 'kanews'),
          'value' => $instance['title']
        ],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				],
        [
          'type' => Kanews_Form_Elements::TYPE_TEXT,
          'id' => $this->get_field_id('city'),
          'name' => $this->get_field_name('city'),
          'label' => __('Şehir', 'kanews'),
          'value' => $instance['city']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_dropdown'),
					'name' => $this->get_field_name('show_dropdown'),
					'label' => __('Şehir Seçimi Göster', 'kanews'),
					'value' => $instance['show_dropdown']
			 ]
      ]
    ]);

    // Gösterim Ayarları
    Kanews_Form_Elements::render_accordion_field([
      'title' => __('Gösterim Ayarları', 'kanews'),
      'content' => [
        [
          'type' => Kanews_Form_Elements::TYPE_TOGGLE,
          'id' => $this->get_field_id('show_wind'),
          'name' => $this->get_field_name('show_wind'),
          'label' => __('Rüzgar Bilgisi', 'kanews'),
          'value' => $instance['show_wind']
        ],
        [
          'type' => Kanews_Form_Elements::TYPE_TOGGLE,
          'id' => $this->get_field_id('show_humidity'),
          'name' => $this->get_field_name('show_humidity'),
          'label' => __('Nem Bilgisi', 'kanews'),
          'value' => $instance['show_humidity']
        ],
        [
          'type' => Kanews_Form_Elements::TYPE_TOGGLE,
          'id' => $this->get_field_id('show_pressure'),
          'name' => $this->get_field_name('show_pressure'),
          'label' => __('Basınç Bilgisi', 'kanews'),
          'value' => $instance['show_pressure']
        ],
        [
          'type' => Kanews_Form_Elements::TYPE_TOGGLE,
          'id' => $this->get_field_id('show_min_temp'),
          'name' => $this->get_field_name('show_min_temp'),
          'label' => __('Minimum Sıcaklık', 'kanews'),
          'value' => $instance['show_min_temp']
        ],
        [
          'type' => Kanews_Form_Elements::TYPE_TOGGLE,
          'id' => $this->get_field_id('show_max_temp'),
          'name' => $this->get_field_name('show_max_temp'),
          'label' => __('Maksimum Sıcaklık', 'kanews'),
          'value' => $instance['show_max_temp']
        ]
      ]
    ]);

    // Tahmin Ayarları
    Kanews_Form_Elements::render_accordion_field([
      'title' => __('Tahmin Ayarları', 'kanews'),
      'content' => [
        [
          'type' => Kanews_Form_Elements::TYPE_TOGGLE,
          'id' => $this->get_field_id('show_forecast'),
          'name' => $this->get_field_name('show_forecast'),
          'label' => __('Hava Tahmini Göster', 'kanews'),
          'value' => $instance['show_forecast']
        ],
        [
          'type' => Kanews_Form_Elements::TYPE_NUMBER,
          'id' => $this->get_field_id('forecast_days'),
          'name' => $this->get_field_name('forecast_days'),
          'label' => __('Tahmin Gün Sayısı', 'kanews'),
          'value' => $instance['forecast_days'],
          'min' => 1,
          'max' => 6
        ]
      ]
    ]);

		// Renk Ayarlarıı
    Kanews_Form_Elements::render_accordion_field([
			'title' => __('Renk Ayarlarıı', 'kanews'),
			'content' => [
					[
							'type' => Kanews_Form_Elements::TYPE_COLOR,
							'id' => $this->get_field_id('gradient_start'),
							'name' => $this->get_field_name('gradient_start'),
							'label' => __('Başlangıç Rengi', 'kanews'),
							'value' => $instance['gradient_start']
					],
					[
							'type' => Kanews_Form_Elements::TYPE_COLOR,
							'id' => $this->get_field_id('gradient_end'),
							'name' => $this->get_field_name('gradient_end'),
							'label' => __('Bitiş Rengi', 'kanews'),
							'value' => $instance['gradient_end']
					]
			]
	]);

    // Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
			 ],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
			 ],
				
		 ]
		]);

    

	}
}
?>