<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Kanews_Widget_Helper {

	/**
	 * Determine if widget should be rendered according to device visibility options.
	 */
	public static function should_render_widget( $instance ) {
		$hide_mobile  = self::is_toggle_on( $instance, 'hide_mobile', false );
		$hide_desktop = self::is_toggle_on( $instance, 'hide_desktop', false );

		$is_mobile = false;

		if ( function_exists( 'kan_is_mobile' ) ) {
			$is_mobile = kan_is_mobile();
		} elseif ( function_exists( 'wp_is_mobile' ) ) {
			$is_mobile = wp_is_mobile();
		}

		if ( $hide_mobile && $is_mobile ) {
			return false;
		}

		if ( $hide_desktop && ! $is_mobile ) {
			return false;
		}

		return true;
	}

	/**
	 * Normalize toggle values to boolean.
	 */
	public static function is_toggle_on( $instance, $key, $default = false ) {
		if ( ! array_key_exists( $key, $instance ) ) {
			return (bool) $default;
		}

		return 'on' === $instance[ $key ];
	}

	/**
	 * Safely fetch a value from widget instance.
	 */
	public static function get_value( $instance, $key, $default = '' ) {
		return isset( $instance[ $key ] ) ? $instance[ $key ] : $default;
	}

	/**
	 * Safely fetch integer value from widget instance.
	 */
	public static function get_int( $instance, $key, $default = 0 ) {
		if ( isset( $instance[ $key ] ) && '' !== $instance[ $key ] ) {
			return absint( $instance[ $key ] );
		}

		return absint( $default );
	}

	/**
	 * Resolve post type including optional columnist support.
	 */
	public static function resolve_post_type( $instance ) {
		return self::is_toggle_on( $instance, 'include_columist', false ) ? array( 'post', 'columist' ) : 'post';
	}

	/**
	 * Build common query args for manset widgets.
	 */
	public static function build_query_args( $instance, $overrides = array() ) {
		$date_range = self::get_value( $instance, 'date_range', '0' );

		$args = array(
			'sticky'    => self::is_toggle_on( $instance, 'sticky_posts', false ),
			'post_type' => self::resolve_post_type( $instance ),
			'number'    => self::get_int( $instance, 'posts', 5 ),
			'id'        => self::get_value( $instance, 'categories', '' ),
			'sortby'    => self::get_value( $instance, 'sortby', 'recent' ),
			'offset'    => self::get_value( $instance, 'offset', '' ),
			'range'     => ( ! empty( $date_range ) && '0' !== $date_range ) ? $date_range : null,
			'exclude'   => self::get_value( $instance, 'exclude_pids', array() ),
			'pids'      => self::get_value( $instance, 'pids', array() ),
		);

		$tags = self::get_value( $instance, 'tags', '' );
		if ( '' !== $tags ) {
			$args['tags_ids'] = $tags;
		}

		$manset = self::get_value( $instance, 'categories2', '' );
		if ( '' !== $manset ) {
			$args['manset'] = $manset;
		}

		foreach ( $overrides as $key => $value ) {
			if ( is_null( $value ) ) {
				unset( $args[ $key ] );
				continue;
			}

			$args[ $key ] = $value;
		}

		return $args;
	}

	/**
	 * Normalize advertisement settings for manset widgets.
	 */
	public static function get_ad_settings( $instance, $defaults = array() ) {
		$settings = array(
			'enabled'  => self::is_toggle_on( $instance, 'show_manset_ad', false ),
			'position' => self::get_int( $instance, 'ad_position', isset( $defaults['position'] ) ? absint( $defaults['position'] ) : 2 ),
			'image'    => self::get_value( $instance, 'ad_image', '' ),
			'content'  => self::get_value( $instance, 'ad_content', '' ),
			'link'     => self::get_value( $instance, 'ad_link', '' ),
		);

		return wp_parse_args( $settings, $defaults );
	}

	/**
	 * Normalize widget instance with defaults.
	 */
	public static function normalize_instance( $instance, $defaults = array() ) {
		if ( empty( $defaults ) ) {
			return (array) $instance;
		}

		return wp_parse_args( (array) $instance, $defaults );
	}
}

