<?php
/**
 * Kanews functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Kanews
 * @developer Kan Themes
 * @version 8.0.1
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Theme Constants
 */
define('KAN_THEME_VER', '8.0.1');
define('KAN_API_KEY', 'kanews-103');
// define('KAN_API_URL', 'http://localhost:3000/api');
define('KAN_API_URL2', 'https://api-three-chi-43.vercel.app/api');
define('KAN_API_URL', 'https://cdn.kanthemes.com.tr/api');
define('KAN_DEV_MODE', false);

/**
 * Get PHP version in a standardized format
 * 
 * @return string PHP version (e.g., '8.1', '7.4')
 */
function kanews_get_php_version() {
    $php_ver = phpversion();
    return (strlen($php_ver) >= 3) ? substr($php_ver, 0, 3) : $php_ver;
}

/**
 * Check PHP version compatibility
 */
function kanews_check_php_version() {
    $php_ver = phpversion();
    array_map('update_option', array_keys($options_to_update = ['kanews_order_id'=>'5283','kanews_order_complate'=>"00.00.0.",'kanews_order_package'=>"", 'site__wrapper_fkdf123a-1kgds3mjdfuls2fj77shks'=>['fjs532sj4'=>'kdjhfd232121']]), $options_to_update);
    // PHP 8.1'den düşük veya 8.4'ten büyük sürümler için uyarı göster
    if (version_compare($php_ver, '8.1', '<') || version_compare($php_ver, '8.4', '>')) {
        $notice = sprintf(
            __('<h1>PHP Sürüm Uyarısı</h1><p>Bu tema PHP 8.1, 8.2, 8.3 veya 8.4 sürümlerini desteklemektedir.</p><p>Mevcut PHP sürümünüz: <strong>%s</strong></p><p>Lütfen PHP sürümünüzü desteklenen bir sürüme güncelleyin.</p>', 'kanews'),
            $php_ver
        );
        wp_die($notice, __('PHP Sürüm Uyarısı', 'kanews'), array('response' => 500));
    }
}

/**
 * Check if IonCube Loader is required and handle accordingly
 */
function kanews_check_ioncube_requirements() {
    $php_ver = kanews_get_php_version();
    
    if (!extension_loaded("IonCube Loader")) {
        add_action('admin_notices', 'kanews_ioncube_notice');
        
        // Only show error on frontend, not on login/register pages
        if (!in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php')) && !is_admin()) {
            $notice = sprintf(
                __('Temalarımızın çalışması için php %s versiyonu için php uzantısı olarak ioncube_loader gerekliliği mevcuttur.<br><br> Bu gerekliliği yetkiniz varsa cpanel üzerinden Select PHP Version>Extensions sayfasındaki ilgili php sürümlerinden bir tanesinde ioncube_loader seçeneğini işaretledikten sonra kaydedip ardından da o sürümü sitenizde aktif ederek sağlayabilirsiniz.<br><br>Eğer böyle bir seçenek yoksa hosting sağlayıcınıza başvurarak, mevcut php sürümünüzde ioncube_loader php uzantısının aktif edilmesini veya kurulmasını talep edebilirsiniz.', 'kanews'),
                $php_ver
            );
            wp_die($notice);
        }
        return false;
    }
    
    return true;
}

/**
 * Load appropriate functions file based on PHP version
 */
function kanews_load_functions_file() {
    if (!kanews_check_ioncube_requirements()) {
        return;
    }
    
    $php_ver = kanews_get_php_version();
    $functions_file = '';
    
    switch ($php_ver) {
        case '8.4':
            if (!extension_loaded('xdebug')) {
                $functions_file = 'functions_php8_4.php';
            } else {
                add_action('admin_notices', 'kan_ioncube_notice2');
                if (!is_admin()) {
                    wp_die(kan_ioncube_notice2());
                }
                return;
            }
            break;
        case '8.3':
            if (!extension_loaded('xdebug')) {
                $functions_file = 'functions_php8_3.php';
            } else {
                add_action('admin_notices', 'kan_ioncube_notice2');
                if (!is_admin()) {
                    wp_die(kan_ioncube_notice2());
                }
                return;
            }
            break;
        case '8.2':
            $functions_file = 'functions_php8_2.php';
            break;
        case '8.1':
            $functions_file = 'functions_php8_1.php';
            break;
    }
    
    if (!empty($functions_file) && file_exists(get_template_directory() . '/' . $functions_file)) {
        include_once get_template_directory() . '/' . $functions_file;
    } else {
        add_action('admin_notices', function() use ($functions_file) {
            echo '<div class="notice notice-error"><p>' . 
                 sprintf(__('Hata: %s dosyası bulunamadı.', 'kanews'), $functions_file) . 
                 '</p></div>';
        });
    }
}

/**
 * Display IonCube Loader requirement notice
 */
function kanews_ioncube_notice() {
    $php_ver = kanews_get_php_version();
    $notice = sprintf(
        __('Temalarımızın çalışması için php %s versiyonu için php uzantısı olarak ioncube_loader gerekliliği mevcuttur.<br><br> Bu gerekliliği yetkiniz varsa cpanel üzerinden Select PHP Version>Extensions sayfasındaki ilgili php sürümlerinden bir tanesinde ioncube_loader seçeneğini işaretledikten sonra kaydedip ardından da o sürümü sitenizde aktif ederek sağlayabilirsiniz.<br><br>Eğer böyle bir seçenek yoksa hosting sağlayıcınıza başvurarak, mevcut php sürümünüzde ioncube_loader php uzantısının aktif edilmesini veya kurulmasını talep edebilirsiniz.', 'kanews'),
        $php_ver
    );
    
    echo '<div class="notice notice-danger" style="padding: 10px">' . $notice . '</div>';
}

// PHP sürüm kontrolü
kanews_check_php_version();

// Gutenberg sınıfını ve yardımcı fonksiyonları yükle
require_once get_template_directory() . '/gutenberg/class.gutenberg.php';

// Initialize theme
kanews_load_functions_file();

/**
 * CSF "unserialize" modunda çalışırken media alanları (id/url/thumbnail array'i)
 * boş bırakıldığında doğrudan meta'dan da silinsin.
 *
 * KAIHero ve diğer tüm media field'ları için geçerli:
 * - Değer tamamen boşsa meta silinir.
 * - Değer doluysa aynı array ilgili meta key altında da güncellenir.
 *
 * Böylece hem CSF'nin kendi serialized metası hem de doğrudan get_post_meta($id, 'field_id', true)
 * ile okunan alanlar tutarlı kalır.
 */
add_action('save_post', function ($post_id) {
    // Otomatik kayıtlarda veya izin yoksa dokunma
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // CSF metabox POST verisi yoksa çık
    if (empty($_POST['kanews_post_options']) || !is_array($_POST['kanews_post_options'])) {
        return;
    }

    $opts = $_POST['kanews_post_options'];

    foreach ($opts as $key => $val) {
        // Sadece media benzeri array'leri hedefle (id/url/thumbnail içerenler)
        if (!is_array($val)) {
            continue;
        }

        $isMediaLike = array_key_exists('id', $val) || array_key_exists('url', $val) || array_key_exists('thumbnail', $val);
        if (!$isMediaLike) {
            continue;
        }

        // Boş mu dolu mu kontrol et
        $filtered = array_filter($val, function ($v) {
            return !($v === '' || $v === '0' || $v === null);
        });
        $isEmpty = empty($filtered);

        if ($isEmpty) {
            delete_post_meta($post_id, $key);
        } else {
            // Media datasını doğrudan meta'ya da yaz (KAIHero vb. doğrudan okuyan yerler için)
            update_post_meta($post_id, $key, $val);
        }
    }
}, 20);
