<?php 
$path = preg_replace( '/wp-content(?!.*wp-content).*/', '', __DIR__ );
require_once( $path . 'wp-load.php' );

$country = (isset($_GET['country']) && $_GET['country'] != 'null' && !empty($_GET['country'])) ? ucwords($_GET['country']) : 'Turkey';
$region = (isset($_GET['region']) &&  $_GET['region'] != 'null' && !empty($_GET['region'])) ? ucwords($_GET['region']) : 'Ankara';
$city = (isset($_GET['city']) && $_GET['city'] != 'null' && !empty($_GET['city'])) ? ucwords($_GET['city']) : $region;
$date = date('Y-m-d');


$folder_path = ABSPATH . 'prayer-cache'; // Klasör yolunu belirtin
if (file_exists($folder_path.'/'.urlencode($city).'.json')) {
  $response = get_local_file_contents(ABSPATH."/prayer-cache/".urlencode($city).".json");
  $data = json_decode($response, true);
  $keys = array_keys($data['times']);
  $firstKey = $keys[0];
  if ( $firstKey === $date ) {
    echo $response;
    exit();
  }
}

$query = array('timezoneOffset' => 180, 'country' => $country, 'region' => $region, 'city' => $city, 'date' => $date, 'days' => 30);
$api_url = add_query_arg( $query, 'https://prayer-api-gamma.vercel.app/api/timesFromPlace' );

$api = wp_remote_get( $api_url, array( 'timeout' => 10 ) );

if( is_wp_error( $api ) ) {
  echo array( 'error' => $api->get_error_message() );
  exit();
} else {

  $prayer_data = json_decode( $api['body'], true );

  if( isset($prayer_data['error']) ) {
    echo json_encode($prayer_data);
  } else {
    if (!file_exists($folder_path)) {
      mkdir($folder_path);
    }

    $file_name = urlencode($city) . '.json'; // Dosya adını zaman damgasıyla oluştur
    $file_path = $folder_path . '/' . $file_name; // Dosya yolunu oluştur
    file_put_contents($file_path, json_encode($prayer_data)); // JSON verilerini dosyaya kaydet
    echo json_encode($prayer_data);
  }

}