<?php
/**
 * Template Name: Döviz Kurları
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Döviz Kurları', 'kanews' );
wp_enqueue_script('kanews-calculator');

defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$parite = ( isset($_GET['parite']) ) ? esc_html(strtoupper($_GET['parite'])) : NULL;
$response2 = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/currencies/currencies.json");
$data2 = json_decode($response2, true);

$last_update_date =   ( isset($data2['lastUpdate']) && !empty($data2['lastUpdate']['formatted']) ) ? $data2['lastUpdate']['formatted'] : NULL;


if(isset($data2['data']) )
$data2 = $data2['data'];

unset($data2['LYD']);
unset($data2['CSK']);
unset($data2['CSK']);

if( $parite !== NULL ) {
$search  = array( 'CZK' );
$replace = array( 'CSK' );
$parite2 = str_replace($search, $replace, $parite);

$array = array(
  'USD' => [
    'code' => 'USD',
    'name' => 'Amerikan Doları'
  ],
  'AUD' => [
    'code' => 'AUD',
    'name' => 'Avustralya Doları'
  ],
  'DKK' => [
    'code' => 'DKK',
    'name' => 'Danimarka Kronu'
  ],
  'EUR' => [
    'code' => 'EUR',
    'name' => 'Euro'
  ],
  'GBP' => [
    'code' => 'GBP',
    'name' => 'İngiliz Sterlini'
  ],
  'CHF' => [
    'code' => 'CHF',
    'name' => 'İsviçre Frangı'
  ],
  'SEK' => [
    'code' => 'SEK',
    'name' => 'İsveç Kronu'
  ],
  'CAD' => [
    'code' => 'CAD',
    'name' => 'Kanada Doları'
  ],
  'KWD' => [
    'code' => 'KWD',
    'name' => 'Kuveyt Dinarı'
  ],
  'NOK' => [
    'code' => 'NOK',
    'name' => 'Norveç Kronu'
  ],
  'SAR' => [
    'code' => 'SAR',
    'name' => 'Suudi Arabistan Riyali'
  ],
  'JPY' => [
    'code' => 'JPY',
    'name' => 'Japon Yeni'
  ],
  'BGN' => [
    'code' => 'BGN',
    'name' => 'Bulgar Levası'
  ],
  'RON' => [
    'code' => 'RON',
    'name' => 'Rumen Leyi'
  ],
  'RUB' => [
    'code' => 'RUB',
    'name' => 'Rus Rublesi'
  ],
  'IRR' => [
    'code' => 'IRR',
    'name' => 'İran Riyali'
  ],
  'CNY' => [
    'code' => 'CNY',
    'name' => 'Çin Yuanı'
  ],
  'PKR' => [
    'code' => 'PKR',
    'name' => 'Pakistan Rupisi'
  ],
  'QAR' => [
    'code' => 'QAR',
    'name' => 'Katar Riyali'
  ]
);
}
if( isset($_GET['tvwidgetsymbol']) ) {
  $value  = esc_url($_GET['tvwidgetsymbol']);
  $end    = substr($value, -6 ,6); // Sondan 10 Karakteri Alıyoruz.
  $parite_2 = substr($end, 0, 3);
  wp_redirect( kanews_get_page_link('parite', strtolower($parite_2), 'doviz'), 301);
    die;
}

if($parite != NULL) {

  if(empty($data2) || !is_array($data2) || !isset($data2[$parite])) {
    wp_redirect( get_the_permalink(), 301);
    die;
  }
  
  $new_title = wp_sprintf( esc_html__('%1$s Ne Kadar, Kaç TL?', 'kanews'), (isset($array[$parite]) ? $array[$parite]['name'] : $parite) ).' - '.get_bloginfo( 'name' );


  function generate_custom_title($title) {
    global $new_title;
    if($new_title)
    $title = $new_title;
    return $title;  
  }
  add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
  add_filter( 'wpseo_title', 'generate_custom_title', 15 );
}

get_header(); ?>
<link rel='dns-prefetch' href='//s3.tradingview.com' />
  <?php if($parite == NULL) :  while ( have_posts() ) : the_post(); ?>
    <?php kanews_page_header($post->ID, $title, '', '', false); ?>
  <?php endwhile; endif; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>

          <?php if( kanews_get_option('breadcrumb') ) : ?>
					<div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
					</div>
        <?php endif; ?>

          <?php if($parite != NULL) : 
            

            $change = $data2[$parite2]['Change'];
            ?>
            <div class="col-12">
              <div class="single-layout-flat">
                <div class="kanews-section-box">
                  <div class="kanews-article-header p-0 mb-1">
                    <div class="d-flex align-items-center g-10 mb-1">
                    <?php if (strlen($parite) > 3) : ?>
                      <img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/TR.svg" width="48" height="48" alt="<?php echo esc_attr($parite); ?>" />
                    <?php else : ?>
                      <img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/<?php echo substr($parite, 0, -1); ?>.svg" width="48" height="48" alt="<?php echo esc_attr($parite); ?>" />
                    <?php endif; ?>
                    <h1 class="kanews-article-title mb-0"><?php echo isset($array[$parite]) ? $array[$parite]['name'] : (isset($data2[$parite2]['Name']) ? $data2[$parite2]['Name'] : $parite); ?></h1>
                    </div>
                    <h2 style="font-weight:400"><?php $page_desc = sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir. Fiyatı son 24 saatte %3$s%% değişim göstermiştir..', 'kanews'), (isset($array[$parite]) ? $array[$parite]['name'] : (isset($data2[$parite2]['Name']) ? $data2[$parite2]['Name'] : $parite)), currency_format_number($data2[$parite2]['Selling']).' '.esc_html__( 'Türk Lirası', 'kanews' ), $change ); echo $page_desc; ?></h2>
                    
                    <div class="d-flex flex-wrap align-items-center g-10 mt-1">
                    <?php 
                    echo '<div style="font-size: 2rem">';
                    echo '<strong>'.currency_format_number($data2[$parite2]['Selling']).'</strong> ';
                    echo esc_html__( 'Türk Lirası', 'kanews' );
                    echo '</div>';
                    
                    if ($change < 0) {
                      $green = false;
                      // echo '<span class="border-danger color-danger percentage">'.$currency_data['price_change_24h'].'</span>';
                      echo '<div class="border-danger color-danger percentage kanews-label">'.$change.'%</div>';
                      
                    } else {
                      $green = true;
                      // echo '<span class="border-success color-success percentage">+'.$currency_data['price_change_24h'].'</span>';
                      echo '<div class="border-success color-success percentage kanews-label">+'.$change.'%</div>';
                      
                    }
                    ?>
                    </div>
        
                  </div>

                  <div class="mt-0">
                    <ul class="row">
 
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Alış', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo isset($data2[$parite2]['Buying']) ? $data2[$parite2]['Buying'] : '0.00'; ?> <span class="currency">TRY</span></div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Satış', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo isset($data2[$parite2]['Selling']) ? $data2[$parite2]['Selling'] : '0.00'; ?> <span class="currency">TRY</span></div>
                      </li>
                      </li>
                      <li class="col-auto">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Değişim', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo isset($data2[$parite2]['Change']) ? $data2[$parite2]['Change'] : '0.00'; ?><span class="currency">%</span></div>
                      </li>


                      <li class="col-auto">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Son Güncelleme', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $last_update_date; ?></div>
                      </li>
                    </ul>
                  </div>

                </div>
              </div>
              <div class="row justify-content-between no-gutters">
                <div class="kanews-tab-3">
                  <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0">
                    <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'chart', 'tradingview', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link active"><?php _e('Tradingview', 'kanews'); ?></a></li>
                    <li class="nav-item"><a href="<?php the_permalink(); ?>" class="nav-link"><?php _e('Diğer Paritelere Göz At', 'kanews'); ?></a></li>
                  </ul>
                </div>
              </div>
            
              <div class="kanews-section" style="overflow:hidden">
                <?php 
                $compabilities = [
                  'USD', 'EUR', 'GBP', 'CHF', 'CAD', 'JPY'
                ];
                if( in_array($parite, $compabilities) ) {
                  $exchange = "FX_IDC";
                  $symbol = 'FX_IDC:'.$parite.'TRY';
                } else if($parite == 'BRENT') {
                  $exchange = "PYTH";
                  $symbol = 'BRENT3!';
                } else if($parite == 'EURUSD') {
                  $exchange = "FX_IDC";
                  $symbol = 'FX_IDC:EURUSD';
                } else if($parite == 'BIST') {
                  $exchange = "BIST";
                  $symbol = 'BIST:XU100';
                } else {
                  $exchange = "FX_IDC";
                  $symbol = 'FX_IDC:'.$parite.'USD*FX_IDC:USDTRY';
                }
                ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div id="tradingview_12510"></div>
                  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/symbols/<?php echo $parite; ?>TRY?exchange=<?php echo $exchange; ?>" rel="noopener" target="_blank"><span class="blue-text"><?php echo $parite; ?> TRY Chart</span></a> by TradingView</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                  <script type="text/javascript">
                  new TradingView.widget(
                  {
                    "width": 1170,
                    "height": 610,
                    "symbol": "<?php echo $symbol; ?>",
                    "interval": "240",
                    "timezone": "Europe/Istanbul",
                    "theme": "light",
                    "style": "1",
                    "locale": "tr",
                    "toolbar_bg": "#ccc",
                    "enable_publishing": false,
                    "hide_top_toolbar": false,
                    "withdateranges": false,
                    "details": true,
                    "hide_side_toolbar": false,
                    "allow_symbol_change": true,
                    "show_popup_button": true,
                    "studies": [
                      // "MACD@tv-basicstudies",
                      // "Supertrend@tv-kivancozbilgic",
                      "RSI@tv-basicstudies"
                    ],
                    "hotlist": true,
                    "popup_width": "1000",
                    "popup_height": "650",
                    "container_id": "tradingview_e8ead",
                    "isTransparent": false,
                  }
                  );
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>

              <div class="row">

                <div class="col-12 col-lg-8">
                <div class="kanews-section kanews-section-flat">
                  <div class="kanews-section-box">
                    <div class="kanews-article-content entry-content">
                      <div class="entry-content-wrapper">
                        <div class="entry-content-inner" id="glkj1">
                          <?php $emtia_name = isset($array[$parite]) ? $array[$parite]['name'] : $parite;
                          $emtia_selling = $data2[$parite2]['Selling'];
                          $emtia_buying = $data2[$parite2]['Buying'];
                          ?>
                          <h2><?php echo sprintf(esc_html__('1 %1$s ne kadar? 1 %1$s  bugün kaç TL?', 'kanews'), $emtia_name); ?></h2>
                          <p><?php echo sprintf(esc_html__('Güncel verilere göre, %1$s alış fiyatı %2$s, satış fiyatı ise %3$s olarak belirlenmiştir. Bu fiyatlar, %4$s itibarıyla güncellenmiştir ve 15 dakikada bir yenilenerek canlı rakamlarla sunulmaktadır. %1$s fiyatları hakkında anlık bilgilere erişmek için %1$s sayfasını ziyaret edebilirsiniz.', 'kanews'), $emtia_name, currency_format_number($emtia_buying).' TL', currency_format_number($emtia_selling), $last_update_date ); ?></p>

                          <?php if ($change < 0): ?>
                          <h3><?php echo sprintf(esc_html__('%s (%s) fiyatı bugün yükseldi.', 'kanews'), $emtia_name, 'TL'); ?></h3>
                          <?php else: ?>
                          <h3><?php echo sprintf(esc_html__('%s (%s) fiyatı bugün düştü.', 'kanews'), $emtia_name, 'TL'); ?></h3>
                          <?php endif; ?>
                          <p><?php echo sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir ve 24 saatlik yaklaşık işlem hacmi %3$s. Fiyatı son 24 saatte %4$s değişim göstermiştir..', 'kanews'), $emtia_name, currency_format_number($emtia_selling).' TL', 0, currency_format_number($change) ); ?></p>
                          <p><?php echo sprintf(esc_html__('%1$s hesaplama işlemleri için, sayfanın üstünde yer alan çevirici aracını kullanarak mevcut fiyatlar üzerinden hızlı ve kolay bir şekilde çevirme işlemlerinizi gerçekleştirebilirsiniz. %1$s fiyatları hakkında detaylı bilgi ve anlık güncellemeler için doğru adrestesiniz..', 'kanews'), $emtia_name ); ?></p>
                          <ul>
                          <li><a href="<?php echo kanews_get_page_link('parite', 'usd', 'doviz'); ?>">1 Dolar Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('parite', 'eur', 'doviz'); ?>">1 Euro Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('parite', 'gbp', 'doviz'); ?>">1 Euro Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('parite', 'chf', 'doviz'); ?>">1 CHF Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('parite', 'rub', 'doviz'); ?>">1 RUB Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('parite', 'cny', 'doviz'); ?>">1 CNY Kaç TL ?</a></li>
                          </ul>
                          <div class="css-17eoayh"></div>
                        </div>
                        <p class="css-15q1ax4" role="button"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?><svg viewBox="0 0 24 24" focusable="false" class="chakra-icon css-2yee4i"><path fill="currentColor" d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path></svg></p>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="kanews-section kanews-section-shortcode">
                <?php echo kanews_widget_title(sprintf(esc_html__('%s Çevirici', 'kanews'), $emtia_name), 'h3'); ?>
                <?php echo do_shortcode( '[kanews-calculator tur="doviz" show_tabs="true" exclude_types="burc,vki"]' ); ?>
              </div>
                </div>

                <div id="sidebar" class="col-12 col-lg-4">
                    <?php get_sidebar('xpage'); ?>
                </div>

                <div class="col-12">
                  <?php 
                    get_template_part('template-parts/content/components/related', 'page2', array( 
                      'posts_per_page' => 10,
                      's' => isset($array[$parite]) ? $array[$parite]['name'] : $parite
                    ) ); ?>
                </div>

              </div>

            </div>

            <script>
              document.getElementsByTagName('title')[0].innerHTML = "<?php echo $new_title; ?>";
              document.getElementsByTagName('meta')["description"].content = "<?php echo $page_desc; ?>";
            </script>
          <?php else: ?>
            <div class="col-12 mb-1">
              <div class="kanews-section kanews-section-shortcode">
                <?php echo kanews_widget_title(esc_html__( 'Döviz Çevirici', 'kanews' ), 'h2'); ?>
                <?php echo do_shortcode( '[kanews-calculator tur="doviz" show_tabs="true" exclude_types="burc,vki"]' ); ?>
              </div>
            </div>

            <div class="col-12 col-lg-8 mb-1">

              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Tüm Pariteler', 'kanews' ), 'h2'); ?>
                <?php 
                if( isset($last_update_date) && !empty($last_update_date) )
                echo '<div class="kanews-table-date">'.$last_update_date.'</div>'; ?>

                <div class="kanews-scroll" style="max-height: 545px">
                  <table class="kanews-table table-search table-currencies table-auto mb-0">
                    <thead>
                      <tr>
                        <th><span class="nobr"><?php esc_html_e( 'Döviz', 'kanews' ); ?></span></th>
                        <th><span class="nobr"><?php esc_html_e( 'Alış', 'kanews' ); ?></span></th>
                        <th><span class="nobr"><?php esc_html_e( 'Satış', 'kanews' ); ?></span></th>
                        <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      // print_r($data2);
                      if(!empty($data2) && is_array($data2) ) {

                        foreach($data2 as $key => $currency) {
      
                            if (isset($currency['Change']) && $currency['Change'] < 0) {
                              $class = 'color-danger';
							  $icon = '<svg class="icon-trending icon-180deg" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
                            } else {
                              $class = 'color-success';
							  $icon = '<svg class="icon-trending" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
                            }
                            $search  = array( 'CSK' );
                            $replace = array( 'CZK' );
                            $key = str_replace($search, $replace, $key);
                            echo '<tr onclick="window.location=\''.kanews_get_page_link('parite', strtolower($key), 'doviz').'\';">';
                              echo '<td>';
                              if (strlen($key) > 3) {
                                echo '<img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/TR.svg" width="18" height="18" alt="'.$key.'" />';
                              } else {
                                echo '<img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/'.substr($key, 0, -1).'.svg" width="18" height="18" alt="'.$key.'" />';
                              }
                              echo '<a href="'.kanews_get_page_link('parite', strtolower($key), 'doviz').'">
                              <h3>'.( isset($currency['Name']) ? $currency['Name'] : $key ).'</h3></a></td>';
                              echo '<td>'.(string)$currency['Buying'].'</td>';
                              echo '<td>'.(string)$currency['Selling'].'</td>';
                              echo '<td class="'.$class.'"><span>'.(string)$currency['Change'].'% '.$icon.'</span></td>';
                            echo '</tr>';
                          
                        }


                        
                      } else {
                        echo '<tr><td>'.esc_html__( ('Veri alınamadı!'), 'kanews' ).'</td></tr>';
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
              
              </div>

        
          
    
            </div>

            <div class="col-12 col-lg-4">
            
              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Canlı Veriler', 'kanews' ), 'h3'); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/markets/indices/" rel="noopener" target="_blank"><span class="blue-text">Indices</span></a> TradingView'den</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-overview.js" async>
                  {
                  "colorTheme": "light",
                  "dateRange": "12M",
                  "showChart": true,
                  "locale": "tr",
                  "autosize": true,
                  "width": 370,
                  "height": 540,
                  "isTransparent": false,
                  "showSymbolLogo": true,
                  "plotLineColorGrowing": "rgba(33, 150, 243, 1)",
                  "plotLineColorFalling": "rgba(33, 150, 243, 1)",
                  "gridLineColor": "rgba(240, 243, 250, 1)",
                  "scaleFontColor": "rgba(120, 123, 134, 1)",
                  "belowLineFillColorGrowing": "rgba(33, 150, 243, 0.12)",
                  "belowLineFillColorFalling": "rgba(33, 150, 243, 0.12)",
                  "symbolActiveColor": "rgba(33, 150, 243, 0.12)",
                  "largeChartUrl": "<?php the_permalink(); ?>",
                  "tabs": [
                    {
                      "title": "Indices",
                      "symbols": [
                        {
                          "s": "OANDA:USDTRY",
                          "d": "Dolar - Türk Lirası"
                        },
                        {
                          "s": "FX_IDC:EURTRY",
                          "d": "Euro - Türk Lirası"
                        },
                        {
                          "s": "CURRENCYCOM:GBPTRY",
                          "d": "Sterlin - Türk Lirası"
                        },
                        {
                          "s": "CURRENCYCOM:CHFTRY",
                          "d": "İsviçre Frangı - Türk Lirası"
                        }
                      ],
                      "originalTitle": "Indices"
                    }
                  ]
                }

                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>

            <div class="col-12">

              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Isı Haritası', 'kanews' ), 'h3'); ?>
                  <!-- TradingView Widget BEGIN -->
                  <div class="tradingview-widget-container">
                    <div class="tradingview-widget-container__widget"></div>
                    <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/markets/currencies/forex-heat-map/" rel="noopener" target="_blank"><span class="blue-text">Forex ısı haritası</span></a> TradingView tarafından</div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-forex-heat-map.js" async>
                    {
                      "width": 1170,
                      "height": 610,
                      "currencies": [
                          "EUR",
                          "USD",
                          "JPY",
                          "GBP",
                          "CHF",
                          "AUD",
                          "CAD",
                          "NZD",
                          "CNY",
                          "TRY"
                        ],
                        "isTransparent": false,
                        "colorTheme": "light",
                        "locale": "tr",
                        "largeChartUrl": "<?php the_permalink(); ?>"  
                      }
                    </script>
                  </div>
                  <!-- TradingView Widget END -->
              </div>

            </div>

            <div class="col-12 col-lg-12">
              <div div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Çapraz Döviz Kurları', 'kanews' ), 'h3'); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/markets/currencies/forex-heat-map/" rel="noopener" target="_blank"><span class="blue-text">Forex Isı Haritası</span></a> TradingView'den</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-forex-cross-rates.js" async>
                  {
                  "width": "100%",
                  "height": "400",
                  "currencies": [
                    "EUR",
                    "USD",
                    "JPY",
                    "GBP",
                    "CHF",
                    "AUD",
                    "CAD",
                    "NZD",
                    "CNY",
                    "TRY"
                  ],
                  "isTransparent": false,
                  "colorTheme": "light",
                  "locale": "tr",
                  "largeChartUrl": "<?php the_permalink(); ?>"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>
    
            <div class="col-12" >
              <div class="row">

                <div class="col-12 col-lg-4">
                  <div class="kanews-section">
                    <?php echo kanews_widget_title(esc_html__( '24s En Çok Düşenler', 'kanews' ), 'h3');?>
                    <table class="kanews-table table-search table-currencies table-auto mb-0">
                      <tbody>
                        <?php
                        
                        if(!empty($data2)) {
                          $kfd2 = array_slice($data2, 1);
                          uasort($kfd2, function($a, $b) {
                            if ($b['Change'] == $a['Change']) {
                                return 0;
                            }
                            return ($b['Change'] > $a['Change']) ? -1 : 1;
                        });
                        
                        
                          $counter = 0;  
                          foreach($kfd2 as $name=>$coin) {
                            if( $coin['Type'] != 'Gold' ) {
                              $counter++;
                              $change =  $coin['Change'];
                              if ($change < 0) {
                                $class = 'currencies-down-item';
                              } else {
                                $class = 'currencies-up-item';
                              }
                              echo '<tr onclick="window.location=\''.kanews_get_page_link('parite', strtolower($name), 'doviz').'\';">';
                                echo '<td><img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/'.substr($name, 0, -1).'.svg" width="18" height="18" alt="'.$name.'" /><a href="'.kanews_get_page_link('parite', strtolower($name), 'doviz').'">'.$name.'/TRY</a></td>';
                                echo '<td>'.(string)$coin['Selling'].'</td>';
                                echo '<td class="'.$class.'"><span>'.$coin['Change'].'%</span></td>';
                              echo '</tr>';
                            }
                            
                            if($counter==10)
                            break;
                          }
                        } else {
                          echo '<tr><td>'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</td></tr>';
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                </div>

                <div class="col-12 col-lg-4">
                  <div class="kanews-section">
                    <?php echo kanews_widget_title(esc_html__( '24s En Çok Yükselenler', 'kanews' ), 'h3');?>
                    <table class="kanews-table table-search table-currencies table-auto mb-0">
                      <tbody>
                        <?php
                        
                        if(!empty($data2)) {
                          $kfd2 = array_slice($data2, 1);
                          uasort($kfd2, function($a, $b) {
                            return strnatcmp($b['Change'], $a['Change']);
                          });
                          $counter = 0;  
                          foreach($kfd2 as $name=>$coin) {
                            if( $coin['Type'] != 'Gold' ) {
                              $counter++;
                              $change =  $coin['Change'];
                              if ($change < 0) {
                                $class = 'currencies-down-item';
                              } else {
                                $class = 'currencies-up-item';
                              }
                              echo '<tr onclick="window.location=\''.kanews_get_page_link('parite', strtolower($name), 'doviz').'\';">';
                                echo '<td><img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/'.substr($name, 0, -1).'.svg" width="18" height="18" alt="'.$name.'" /><a href="'.kanews_get_page_link('parite', strtolower($name), 'doviz').'">'.$name.'/TRY</a></td>';
                                echo '<td>'.(string)$coin['Selling'].'</td>';
                                echo '<td class="'.$class.'"><span>'.$coin['Change'].'%</span></td>';
                              echo '</tr>';
                            }
                            
                            if($counter==10)
                            break;
                          }
                        } else {
                          echo '<tr><td>'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</td></tr>';
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                </div>

                <div class="col-12 col-lg-4">
                  <div class="kanews-section">
                    <?php echo kanews_widget_title(esc_html__( 'Kripto Para Fiyatları', 'kanews' ), 'h3'); ?>
                    <table class="kanews-table table-currencies">
                      <tbody>
                        <?php
                        $indexes = [
                          'try' => esc_html__( 'Türk Lirası', 'kanews' ),
                          'usdt' => esc_html__( 'Amerikan Doları', 'kanews' ),
                          'eur' => esc_html__( 'Euro', 'kanews' ),
                          'btc' => esc_html__( 'Bitcoin', 'kanews' ),
                          'eth' => esc_html__( 'Ethereum', 'kanews' ),
                        ];
                        $index = isset($_GET['index']) ? esc_html($_GET['index']) : kanews_get_option('crypto-page-index', 'try');
                        $data = json_decode(kanews_crypto_data($index)); 
                        
                        if(!empty($data)) {
                          foreach($data as $coin) {
                            if($coin->market_cap_rank == 8) 
                            break;
                            $change =  $coin->price_change_percentage_24h;
                            if ($change > 0 ) {
                              $class = 'color-danger';
                              $icon = '-';
                            } else {
                              $class = 'color-success';
                              $icon = '';
                            }
                            echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', strtolower($coin->id), 'doviz').'\';">';
                              echo '<td><div class="d-flex align-items-center">'.kanews_get_local_image($coin->image, array('width' => 32, 'height' => 32, 'alt' => $coin->symbol)).'<a href="'.kanews_get_page_link('coin', strtolower($coin->id), 'crypto').'"><div>'.strtoupper($coin->symbol).'</div><div class="color-muted">'. $coin->name .'</div></a></div></td>';
                              echo '<td class="text-right"><div class="d-flex align-items-center justify-content-end"><div class="shrink-0">'.currency_format_number($coin->current_price).' '.strtoupper($index).'<div class="'.$class.'">'.$icon.currency_format_number($change).'%</div></div></div></td>';
                            echo '</tr>';
                          }
                        } else {
                          echo '<tr><td>'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</td></tr>';
                        }
                        
                        ?>
                      </tbody>
                    </table>
                  </div>  
                  

                </div>

              </div>
            </div>
    
            <?php get_template_part('template-parts/content/components/related', 'page'); ?>
              
            
            <?php while ( have_posts() ) : the_post(); 
              if ($post->post_content): ?>
                <div class="col-12">
                  <div class="kanews-article kanews-section-flat kanews-article-1">
                    <div class="kanews-article-content entry-content">
                      <?php the_content(); ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            <?php endwhile; ?>
          <?php endif; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
