<?php
/**
 * Dashboard Listing Template
 * 
 * Displays user's listings in the dashboard
 */
?>
<h2 class="kanews-custom-page-title mb-1"><?php esc_html_e('İlanlarım', 'kanews'); ?></h2>
<?php
// Get current page number
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

// Get current user ID
$current_user_id = get_current_user_id();

// Query arguments for user's listings
$args = array(
  'post_type'      => 'ilan',
  'posts_per_page' => 9,
  'author'         => $current_user_id,
  'paged'          => $paged,
  'post_status'    => array('publish', 'pending', 'draft')
);

// Run the query
$listing_query = new WP_Query($args);

if ($listing_query->have_posts()) : ?>
  <div class="kanews-section kanews-section-flat">
    <div class="row">
      <?php 
      while ($listing_query->have_posts()) : 
        $listing_query->the_post(); 
        global $post; 
      ?>
        <div class="col-6 col-lg-4">
          <div class="kanews-post-item kanews-post-grid-item">
            <?php if ($post->post_status == 'publish' || $post->post_status == 'pending') : ?>
              <?php if ($post->post_status == 'publish') : ?>
                <a href="<?php echo esc_url(get_permalink()); ?>" class="kanews-post-href"></a>
              <?php else : ?>
                <div style="position: absolute;right:0;top:0;background:#f00;color:#fff;padding:5px 8px !important;font-size:12px;z-index:200;">
                  <?php esc_html_e('Onay Bekliyor!', 'kanews'); ?>
                </div>
              <?php endif; ?>
              <a href="<?php echo esc_url(kanews_account_page_url() . '?islem=ilan-duzenle&id=' . $post->ID); ?>" 
                 style="position: absolute;left:0;top:0;background:rgba(0,0,0,1);color:#fff;padding:5px 8px !important;font-size:12px;z-index: 200">
                <?php esc_html_e('Düzenle', 'kanews'); ?>
              </a>
            <?php else : ?>
              <div style="position: absolute;right:0;top:0;background:#f00;color:#fff;padding:5px 8px !important;font-size:12px;z-index:200;">
                <?php esc_html_e('Onay Bekliyor!', 'kanews'); ?>
              </div>
            <?php endif; ?>
            
            <?php kanews_post_thumbnail('kanews-post-1', 'kanews-post-thumb'); ?>
            <div class="kanews-post-content">
              <?php the_title(sprintf('<h3 class="kanews-post-headline truncate truncate-3">', esc_url(get_permalink())), '</h3>'); ?>
            </div>
          </div>
        </div>
      <?php 
      endwhile; 
      wp_reset_postdata(); 
      ?>
    </div>
  </div>
<?php else : ?>
  <p><?php esc_html_e('Henüz herhangi bir içerik paylaşmamışsınız.', 'kanews'); ?></p>
<?php endif; ?>

<?php if ($listing_query->max_num_pages > 1) : ?>
  <div class="navigation pagination">
    <div class="nav-links">
      <?php 
      echo paginate_links(array(
        'base'         => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
        'total'        => $listing_query->max_num_pages,
        'current'      => max(1, get_query_var('paged')),
        'format'       => '?paged=%#%',
        'show_all'     => false,
        'type'         => 'plain',
        'end_size'     => 2,
        'mid_size'     => 1,
        'prev_next'    => true,
        'prev_text'    => '<i class="icon-arrow icon-90degg"></i>',
        'next_text'    => '<i class="icon-arrow icon-90deg"></i>',
        'add_args'     => false,
        'add_fragment' => '',
      ));
      ?>
    </div>
  </div>
<?php endif; ?>