<?php 
/**
 * Dashboard Likes Template
 * 
 * Displays user's liked posts in the dashboard
 */

// Check if likes feature is enabled
if ( kanews_get_option('post-like') == true ): 
?>
  <h2 class="kanews-custom-page-title mb-1"><?php esc_html_e( 'Beğendiklerim', 'kanews' ); ?></h2>
  <?php
  // Get current page number
  $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
  
  // Get current user ID
  $current_user_id = get_current_user_id();
  
  // Query arguments for liked posts
  $args = array(
    'posts_per_page' => 9,
    'paged'          => $paged,
    'meta_query'     => array(
      array(
        'key'     => '_user_liked',
        'value'   => $current_user_id,
        'compare' => 'LIKE'
      )
    )
  );
  
  // Run the query
  $like_query = new WP_Query( $args );
  $post_count = 0;
  
  if ( $like_query->have_posts() ) : 
  ?>
    <div class="kanews-section kanews-section-flat">
      <div class="row">
        <?php 
        while ( $like_query->have_posts() ) : 
          $like_query->the_post(); 
          global $post;
          
          // Double check if user has liked this post
          $liked_users = get_post_meta($post->ID, '_user_liked', true);
          if ( is_array($liked_users) && in_array($current_user_id, $liked_users) ) :
            $post_count++;
            get_template_part('template-parts/archives/article-3');
          endif;
        endwhile; 
        ?>
      </div>
    </div>
    
    <?php if ( $post_count === 0 ) : ?>
      <p><?php esc_html_e( 'Henüz herhangi bir şey beğenmemişsin.', 'kanews' ); ?></p>
    <?php endif; ?>
    
  <?php 
  else: 
  ?>
    <p><?php esc_html_e( 'Henüz herhangi bir şey beğenmemişsin.', 'kanews' ); ?></p>
  <?php 
  endif; 
  
  // Reset post data
  wp_reset_postdata(); 
  
  // Show pagination if there are more than 9 posts
  if ( $like_query->max_num_pages > 1 ) : 
  ?>
    <div class="navigation pagination">
      <div class="nav-links">
        <?php 
        echo paginate_links( array(
          'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
          'total'        => $like_query->max_num_pages,
          'current'      => max( 1, get_query_var( 'paged' ) ),
          'format'       => '?paged=%#%',
          'show_all'     => false,
          'type'         => 'plain',
          'end_size'     => 2,
          'mid_size'     => 1,
          'prev_next'    => true,
          'prev_text'    => '<i class="icon-arrow icon-90degg"></i>',
          'next_text'    => '<i class="icon-arrow icon-90deg"></i>',
          'add_args'     => false,
          'add_fragment' => '',
        ) );
        ?>
      </div>
    </div>
  <?php endif; ?>
<?php else: ?>
  <p><?php esc_html_e( 'Bu özellik geçici olarak devre dışıdır.', 'kanews' ); ?></p>
<?php endif; ?>