<?php 
$action2 = isset($_GET['islem']) ? $_GET['islem'] : NULL; ?>
<div class="kanews-lr-page d-flex flex-wrap">
  <div class="kanews-lr-page-left col-12 col-lg-4 d-flex flex-column justify-content-end hidden-mobile">
    <div class="kanews-lr-page-left-top">
      <h2><?php echo kanews_translate('login-left-title', esc_html__( 'Topluluğumuza hoş geldiniz', 'kanews' )); ?></h2>
    </div>
    <div class="kanews-lr-page-left-bottom">
      <p><?php echo kanews_translate('login-left-description', esc_html__( 'Kişiselleştirilmiş, günlük olarak güncellenen ve güzel bir şekilde sunulan platformumuzda, işlevselliğine tam erişim elde etmek için hesap oluşturun.', 'kanews' )); ?></p>
      <div class="d-flex">
        <?php 
        $count = count_users();
        $user_count = (isset($count['avail_roles']['subscriber']) && is_numeric($count['avail_roles']['subscriber'])) ? $count['avail_roles']['subscriber'] : 0 ;
        if ($user_count > 0) {
          $args = array(
              'role' => 'subscriber',
              'number' => 5,
              'orderby' => 'rand',
              'fields' => 'ID'
          );
          
          $users = Kanews\Util\Cache::get_users( $args );
          echo '<div class="kanews-lr-page-users d-flex">';
            foreach ( $users as $userID ) {
              echo kanews_user_avatar(get_the_author_meta('ID', $userID), '48');
            }
          echo '</div>';
        }
        ?>
        <p><?php echo sprintf( esc_html__('%s kişi aramıza katıldı, şimdi sıra sizde.', 'kanews' ), $user_count); ?></p>
      </div>
    </div>
  </div>
  <div class="kanews-lr-page-right col-12 col-lg-8 kanews-scroll" style="height: 100%">
    <div class="kanews-lr-page-inner d-flex flex-column">
      <a class="back-to-site kanews-btn kanews-btn-sm" href="<?php echo home_url('/'); ?>"><?php esc_html_e( 'Siteye Geri Dön', 'kanews' ); ?></a>
      <?php switch($action2) {
        case 'kayit': ?>
          <div class="mb-2">
            <h1 class="kanews-page-title"><?php esc_html_e( 'Hesap Oluştur', 'kanews' ); ?></h1>
            <p><?php echo kanews_translate('login-description', sprintf( esc_html__('%s ayrıcalıklarından yararlanmak için hemen giriş yapın veya hesap oluşturun, üstelik tamamen ücretsiz!', 'kanews' ), get_bloginfo( 'name' ))); ?></p>
          </div>
					
          <?php if ( get_option( 'users_can_register' ) ): ?>
            
            <form id="kanews-register-form" class="mb-1">
              <div class="kanews-form bgw">
                <input type="text" name="username" value="" autofocus autocomplete="username" required>
                <span class="highlight"></span>
                <span class="bar"></span>
                <label><i class="icon-user"></i> <?php _e('Kullanıcı adı', 'kanews'); ?></label>
              </div>
              <div class="kanews-form bgw">
                <input type="text" name="email" value="" autocomplete="email" required>
                <span class="highlight"></span>
                <span class="bar"></span>
                <label><i>@</i> <?php _e('E-Posta', 'kanews'); ?></label>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="kanews-form bgw">
                    <input type="password" name="password" value="" autocomplete="new-password" required>
                    <span class="highlight"></span>
                    <span class="bar"></span>
                    <label><i class="icon-vpn_key"></i> <?php _e('Şifreniz', 'kanews'); ?></label>
                    <span class="kanews-show-password">
                      <i class="icon-view"></i>
                    </span>
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="kanews-form bgw">
                    <input type="password" name="password2" value=""  autocomplete="new-password" required>
                    <span class="highlight"></span>
                    <span class="bar"></span>
                    <label><i class="icon-vpn_key"></i> <?php _e('Şifrenizi Tekrarlayın', 'kanews'); ?></label>
                    <span class="kanews-show-password">
                      <i class="icon-view"></i>
                    </span>
                  </div>
                </div>
              </div>
              <?php if(kanews_get_option('privacy-policy-page') != ''): ?>
                <div class="d-flex">
                  <div class="kanews-form">
                    <input name="privacy" type="checkbox" id="privacy" value="1" required>
                  </div>
                  <label style="margin-bottom: 0;" for="privacy" class="clear-label"><?php echo '<a target="_blank" style="text-decoration:underline" href="'.get_page_link(kanews_get_option('ks-page')).'">'.esc_html__( 'Kullanım Koşulları\'nı', 'kanews' ).'</a> '; _e( 'okudum ve onaylıyorum.', 'kanews' ); ?></label>
                </div>
              <?php endif; ?>

              <?php echo kanews_get_recaptcha('registration_form'); ?>
        
              <button class="kanews-btn kanews-btn-block" type="submit"><?php esc_html_e( 'Kayıt Ol', 'kanews' ); ?><div id="kanews-loader"></div></button>
              
              <?php wp_nonce_field( 'register_action', 'register_field' ); ?>
            </form>
            <?php 
            if(class_exists('NextendSocialLogin', false)){
              echo NextendSocialLogin::renderButtonsWithContainer();
            } ?>
          <?php else: ?>
            <p class="kanews-response"><?php esc_html_e( 'Bu siteye kayıtlar kapalıdır.', 'kanews' ); ?></p>
          <?php endif; ?>
          <div class="d-flex justify-content-between align-items-center">
            <div class="hidden-mobile mr-1"><?php echo kanews_translate('login-text', esc_html__( 'Zaten hesabınız var mı? O zaman giriş yapın.', 'kanews' )); ?></div>
            <a href="<?php the_permalink(); ?>" class="kanews-btn kanews-btn-light col-lg-auto col m-0"><?php esc_html_e( 'Giriş Yap', 'kanews' ); ?></a>
          </div>
          <?php break;
        default: ?>
          <div class="mb-2">
            <h1 class="kanews-page-title"><?php esc_html_e( 'Giriş Yap', 'kanews' ); ?></h1>
            <p><?php echo kanews_translate('login-description', sprintf( esc_html__('%s ayrıcalıklarından yararlanmak için hemen giriş yapın veya hesap oluşturun, üstelik tamamen ücretsiz!', 'kanews' ), get_bloginfo( 'name' ))); ?></p>
						<?php echo apply_filters('kan/login_info', ''); ?>
					</div>
          <form id="kanews-login-form">
            <div class="kanews-form bgw">      
              <input autofocus type="text" id="username" name="username" value="">
              <span class="highlight"></span>
              <span class="bar"></span>
              <label><i class="icon-user"></i> <?php _e('Kullanıcı adı veya e-posta', 'kanews'); ?></label>
            </div>
            <div class="kanews-form bgw">      
              <input type="password" id="password" name="password" value="">
              <span class="highlight"></span>
              <span class="bar"></span>
              <label><i class="icon-vpn_key"></i> <?php _e('Şifreniz', 'kanews'); ?></label>
              <span class="kanews-show-password">
                <i class="icon-view"></i>
              </span>
            </div>
            <div class="d-flex justify-content-between">
              <div class="d-flex">
                <div class="kanews-form bgw">
                  <input name="rememberme" type="checkbox" id="rememberme" value="1">
                </div>
                <label for="rememberme" style="margin-bottom: 0;"><?php esc_html_e( ' Beni hatırla', 'kanews' ); ?></label>
              </div>
              <div><a href="<?php echo wp_lostpassword_url(home_url( add_query_arg( [], $GLOBALS['wp']->request ) )); ?>"><?php esc_html_e( 'Şifremi Unuttum', 'kanews' ); ?></a></div>
            </div>
            <button class="kanews-btn kanews-btn-block" type="submit"><?php esc_html_e( 'Giriş Yap', 'kanews' ); ?> <div id="kanews-loader"></div></button>
            <?php echo kanews_get_recaptcha('login_form'); ?>
            <?php wp_nonce_field( 'login_action', 'login_field' ); ?>
          </form>
          <?php if ( get_option( 'users_can_register' ) || class_exists('NextendSocialLogin', false)) : ?>
          <div class="or-div"><span><?php esc_attr_e( 'veya', 'kanews' ); ?></span></div>
          <?php endif; ?>
          <?php 
          if(class_exists('NextendSocialLogin', false)){
            echo NextendSocialLogin::renderButtonsWithContainer();
          } ?>
          <?php if ( get_option( 'users_can_register' ) ): ?>
            <div class="d-flex justify-content-between align-items-center mt-1">
              <div class="hidden-mobile mr-1"><?php echo kanews_translate('register-text', esc_html__( 'Tamamen ücretsiz olarak üyeliğinizi başlatın.', 'kanews' )); ?></div>
              <a href="<?php the_permalink(); ?>?islem=kayit" class="kanews-btn kanews-btn-light col-lg-auto col m-0"><?php esc_html_e( 'Hesap Oluştur', 'kanews' ); ?></a>
            </div>
          <?php endif; 
        break;
      } ?>
    </div>
  </div>
</div>
