<?php
/**
 * Dashboard Notifications Template
 * 
 * Displays user's notifications in the dashboard
 */

// Check if user is logged in
if (!is_user_logged_in()) {
    wp_die(esc_html__('Bu sayfayı görüntülemek için giriş yapmalısınız.', 'kanews'));
}

try {
    // Get user's notifications using the Notifications class
    $notifications = Kanews\Members\Notifications::get_user_notifications('account');
    
    if (!empty($notifications)) : ?>
        <h2 class="kanews-custom-page-title mb-1"><?php esc_html_e('Bildirimler', 'kanews'); ?></h2>
        
        <div class="kanews-notifications-list">
            <?php foreach ($notifications as $notification) : ?>
                <div class="kanews-notification-item">
                    <div class="notification-content">
                        <?php echo wp_kses_post($notification['message'] ?? ''); ?>
                    </div>
                    <div class="notification-meta">
                        <span class="notification-date">
                            <?php 
                            if (isset($notification['date'])) {
                                echo esc_html(human_time_diff(strtotime($notification['date']), current_time('timestamp')));
                                echo ' ' . esc_html__('önce', 'kanews');
                            }
                            ?>
                        </span>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else : ?>
        <p><?php esc_html_e('Henüz bildiriminiz bulunmuyor.', 'kanews'); ?></p>
    <?php endif;
    
} catch (Exception $e) {
    // Log the error and display a user-friendly message
    error_log('Kanews Notifications Error: ' . $e->getMessage());
    ?>
    <div class="kanews-error-message">
        <?php esc_html_e('Bildirimler yüklenirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.', 'kanews'); ?>
    </div>
    <?php
}