<?php
/**
 * Dashboard Subscription Template
 * 
 * Displays user's subscription information in the dashboard
 */

// Check if WooCommerce is active and insights feature is enabled
if (class_exists('WooCommerce') && kanews_get_option('kanews-insights') == true) : 
?>
  <h2 class="kanews-custom-page-title mb-1"><?php esc_html_e('Abonelik', 'kanews'); ?></h2>
  
  <?php 
  // Get user's orders
  $args = array(
    'customer_id' => get_current_user_id(), 
    'limit'       => 5
  ); 
  $orders = wc_get_orders($args); 
  
  if ($orders) : 
  ?>
    <table class="kanews-table">
      <thead>
        <tr>
          <th><span class="nobr"><?php esc_html_e('ID', 'kanews'); ?></span></th>
          <th><span class="nobr"><?php esc_html_e('Paket', 'kanews'); ?></span></th>
          <th><span class="nobr"><?php esc_html_e('Geçerlilik', 'kanews'); ?></span></th>
          <th><span class="nobr"><?php esc_html_e('Kalan Süre', 'kanews'); ?></span></th>
        </tr>
      </thead>
      <tbody>
        <?php kanews_order_lists($orders); ?>
      </tbody>
    </table>
    
    <p class="kanews-response bg-info mb-1 mt-1">
      <?php esc_html_e('UYARI: Son satın alınan geçerlidir, öncekiler işlem dışı kalır. Otomatik yenilemez bittiğinde tekrar satın almanız gerekir.', 'kanews'); ?>
    </p>
    
    <a class="kanews-btn kanews-btn-sm" href="<?php echo esc_url(kanews_insights_page_url()); ?>">
      <?php esc_html_e('Paket Yükselt', 'kanews'); ?>
    </a>
  <?php else : ?>
    <p class="kanews-response bg-success mb-1 mt-1">
      <?php esc_html_e('Bir abonelik başlatmak için hemen aşağıdaki butona tıklayın ve işlemleri tamamlayın.', 'kanews'); ?>
    </p>
    <a class="kanews-btn" href="<?php echo esc_url(kanews_insights_page_url()); ?>">
      <?php esc_html_e('Abone Ol', 'kanews'); ?>
    </a>
  <?php endif; ?>
<?php else : ?>
  <p class="kanews-response bg-dark mb-1 mt-1">
    <?php esc_html_e('Bu sistem geçici olarak devre dışıdır.', 'kanews'); ?>
  </p>
<?php endif; ?>