<?php
/**
 * Template Name: Son Depremler
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Son Depremler', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header(); ?>
  <?php while ( have_posts() ) : the_post(); ?>
    <?php kanews_page_header($post->ID); ?>
  <?php endwhile; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
          <?php 

          $earthquakes = array();
          $transient_name = 'kanews-earthquake';
          $transient_time = 30 * MINUTE_IN_SECONDS;

          if ( false === ( $earthquakes = get_transient( $transient_name ) ) ) {
            require_once KAN_TEMPLATE_PATH.'/framework/class/Earthquake.php';
            $earthquakes = new earthquake();
            $earthquakes = json_encode($earthquakes->Earth());
            set_transient( $transient_name, $earthquakes, $transient_time);
          }

          $earthquakes = json_decode($earthquakes);

          // Şehirlere göre depremleri grupla (istatistikler için)
          $grouped_by_city = array();
          if( !empty($earthquakes) ) {
            foreach ($earthquakes as $Earth) {
              // Location'dan şehir adını çıkar (ilk kelime genellikle şehir)
              $location_parts = explode(' ', trim($Earth->Location));
              $city = !empty($location_parts[0]) ? $location_parts[0] : $Earth->Location;
              
              // Şehir adını normalize et (büyük harf)
              $city = strtoupper($city);
              
              if (!isset($grouped_by_city[$city])) {
                $grouped_by_city[$city] = array(
                  'count' => 0,
                  'max_magnitude' => 0,
                  'latest_date' => '',
                  'latest_time' => '',
                  'total_magnitude' => 0,
                  'earthquakes' => array()
                );
              }
              
              $grouped_by_city[$city]['count']++;
              $grouped_by_city[$city]['total_magnitude'] += floatval($Earth->Ml);
              
              if (floatval($Earth->Ml) > $grouped_by_city[$city]['max_magnitude']) {
                $grouped_by_city[$city]['max_magnitude'] = floatval($Earth->Ml);
              }
              
              // En son deprem tarihini bul
              if (empty($grouped_by_city[$city]['latest_date']) || 
                  $Earth->Date > $grouped_by_city[$city]['latest_date'] ||
                  ($Earth->Date == $grouped_by_city[$city]['latest_date'] && 
                   $Earth->Time > $grouped_by_city[$city]['latest_time'])) {
                $grouped_by_city[$city]['latest_date'] = $Earth->Date;
                $grouped_by_city[$city]['latest_time'] = $Earth->Time;
              }
              
              $grouped_by_city[$city]['earthquakes'][] = $Earth;
            }
            
            // Deprem sayısına göre sırala (en çok deprem olan şehirler önce)
            uasort($grouped_by_city, function($a, $b) {
              return $b['count'] - $a['count'];
            });
          }

          ?>
          <div class="col-12">
            <div class="kanews-section">
              <?php echo kanews_widget_title(esc_html__( 'Deprem Listesi', 'kanews' ), 'h2'); ?>
              
              <div class="kanews-tab kanews-tab-4">
                <!-- Tab Panel -->
                <ul class="nav nav-tabs d-flex flex-wrap" id="earthquakeTab" role="tablist">
                  <li class="nav-item" role="presentation">
                    <div class="nav-link active" id="list-tab" data-toggle="tab" href="#list" role="tab" data-controls="list" data-selected="true"><?php esc_html_e( 'Liste', 'kanews' ); ?></div>
                  </li>
                  <li class="nav-item" role="presentation">
                    <div class="nav-link" id="stats-tab" data-toggle="tab" href="#stats" role="tab" data-controls="stats" data-selected="false"><?php esc_html_e( 'İstatistikler', 'kanews' ); ?></div>
                  </li>
                </ul>
                
                <!-- Tab Content -->
                <div class="tab-content" id="earthquakeTabContent">
                  
                  <!-- Liste Tab -->
                  <div class="tab-pane fade show active" id="list" role="tabpanel" data-labelledby="list-tab">
                    <input placeholder="<?php _e('Hangi Şehirdeki Depremleri Görmek İstiyorsun?', 'kanews'); ?>" id="kanews-currencies-search">
                    <div style="max-height: 768px;overflow: auto">
              <table class="kanews-table table-search table-currencies table-auto table-earthquake">
                <thead>
                  <tr>
                    <th><span class="nobr"><?php esc_html_e( 'Tarih', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Yer', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Tip', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Büyüklük', 'kanews' ); ?></span></th>
                    <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Derinlik', 'kanews' ); ?></span></th>
                    
                    
                    <th><span class="nobr"><?php esc_html_e( 'Harita', 'kanews' ); ?></span></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  if( !empty($earthquakes) ) {
                    $earthquakes = array_slice($earthquakes, 2);
                    foreach ($earthquakes as $Earth) {
                
                      $class = '';

                      echo '<tr class="'.$class.'">';
                        echo '<td>'.$Earth->Date.' '.$Earth->Time.'</td>';
                        echo '<td>'.$Earth->Location.'</td>';
                        echo '<td>ML</td>';
                        
                        // Büyüklüğe göre badge
                        $magnitude = floatval($Earth->Ml);
                        if( $magnitude >= 5.0 ) {
                          $badge_class = 'kanews-label bg-danger color-white';
                          $badge_text = 'Yüksek';
                        } elseif( $magnitude >= 3.5 ) {
                          $badge_class = 'kanews-label bg-warning color-white';
                          $badge_text = 'Orta';
                        } elseif( $magnitude >= 2.0 ) {
                          $badge_class = 'kanews-label bg-info color-white';
                          $badge_text = 'Düşük';
                        } else {
                          $badge_class = 'kanews-label bg-secondary';
                          $badge_text = 'Çok Düşük';
                        }
                        echo '<td><span class="'.$badge_class.'" style="border-radius: 4px;">'.$Earth->Ml.'</span> <span>('.$badge_text.')</span></td>';
                        
                        echo '<td>'.$Earth->Depth.'km</td>';
                        
                       
                        echo '<td><a class="kanews-label color-dark" href="https://maps.google.com/maps?q='.$Earth->Latitude.','.$Earth->Longitude.'" target="_blank">'.esc_html__( 'Haritada Göster', 'kanews' ).'</a></td>';
          
                      echo '</tr>';
                    }
                  } else {
                    echo '<tr><td>'.esc_html__( ('Veri alınamadı!'), 'kanews' ).'</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
                    </div>
                  </div>
                  
                  <!-- İstatistikler Tab -->
                  <div class="tab-pane fade" id="stats" role="tabpanel" data-labelledby="stats-tab">
                    <input placeholder="<?php _e('Şehir ara', 'kanews'); ?>" id="kanews-stats-search">
                    <div style="max-height: 768px;overflow: auto">
                      <table class="kanews-table table-search table-currencies table-auto table-earthquake">
                        <thead>
                          <tr>
                            <th><span class="nobr"><?php esc_html_e( 'Şehir', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Deprem Sayısı', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'En Büyük Deprem', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Ortalama Büyüklük', 'kanews' ); ?></span></th>
                            <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Son Deprem Tarihi', 'kanews' ); ?></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          if( !empty($grouped_by_city) ) {
                            foreach ($grouped_by_city as $city => $data) {
                              $avg_magnitude = $data['count'] > 0 ? number_format($data['total_magnitude'] / $data['count'], 2) : 0;
                              
                              // Büyüklüğe göre renk sınıfı
                              if( $data['max_magnitude'] >= 5.0 )
                                $class = 'bg-danger color-white';
                              elseif( $data['max_magnitude'] >= 3.5 )
                                $class = 'bg-warning color-white';
                              else
                                $class = '';

                              echo '<tr class="'.$class.'">';
                                echo '<td><strong>'.$city.'</strong></td>';
                                echo '<td>'.$data['count'].'</td>';
                                echo '<td>'.number_format($data['max_magnitude'], 2).'</td>';
                                echo '<td>'.$avg_magnitude.'</td>';
                                echo '<td class="hidden-mobile">'.$data['latest_date'].' '.$data['latest_time'].'</td>';
                              echo '</tr>';
                            }
                          } else {
                            echo '<tr><td colspan="5">'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</td></tr>';
                          }
                          ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  
                </div>
              </div>
            </div>
          </div>
          
          <!-- Önemli Telefonlar ve Web Siteleri -->
          <div class="col-12">
            <div class="row">
              <div class="col-12 col-lg-6 col-md-6" style="padding-right: 5px;">
                <div class="kanews-section">
                  <?php echo kanews_widget_title(esc_html__( 'Önemli Telefonlar', 'kanews' ), 'h2'); ?>
                  <div class="kanews-scroll p-1" style="height: 435px">
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Afet Arama Kurtarma</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Kahramanmaraş</span>
                      <span class="link"><a href="tel:03442214991">0344 221 49 91</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Adana</span>
                      <span class="link"><a href="tel:03222272854">0322 227 28 54</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Hatay</span>
                      <span class="link"><a href="tel:03262335415">0326 233 54 15</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Gaziantep</span>
                      <span class="link"><a href="tel:03424281118">0342 428 11 18</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Diyarbakır</span>
                      <span class="link"><a href="tel:04123261158">0412 326 11 58</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Adıyaman</span>
                      <span class="link"><a href="tel:04162161231">0416 216 12 31</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Şanlıurfa</span>
                      <span class="link"><a href="tel:04143137290">0414 313 72 90</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Malatya</span>
                      <span class="link"><a href="tel:04222128432">0422 212 84 32</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Osmaniye</span>
                      <span class="link"><a href="tel:03288262002">0328 826 20 02</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Kilis</span>
                      <span class="link"><a href="tel:03488134478">0348 813 44 78</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Genel Merkez</span>
                      <span class="link"><a href="tel:02122170410">0212 217 04 10</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Kızılay Çağrı Merkezi</span>
                      <span class="link"><a href="tel:168">168</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Polis</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">İtfaiye</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Ambulans</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Jandarma</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Sahil Güvenlik</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Orman Yangın İhbar</span>
                      <span class="link"><a href="tel:112">112</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Su Arıza İhbar</span>
                      <span class="link"><a href="tel:185">185</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Elektrik Arıza İhbar</span>
                      <span class="link"><a href="tel:186">186</a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0;">
                      <span class="title">Doğalgaz Arıza İhbar</span>
                      <span class="link"><a href="tel:187">187</a></span>
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="col-12 col-lg-6 col-md-6" style="padding-left: 5px;">
                <div class="kanews-section">
                  <?php echo kanews_widget_title(esc_html__( 'Önemli Web Siteleri', 'kanews' ), 'h2'); ?>
                  <div class="contentItems p-1">
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD</span>
                      <span class="link"><a href="https://www.afad.gov.tr/" title="AFAD" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Kızılay</span>
                      <span class="link"><a href="https://www.kizilay.org.tr/" title="Kızılay" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AKUT</span>
                      <span class="link"><a href="https://www.akut.org.tr/" title="AKUT" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AHBAP</span>
                      <span class="link"><a href="https://ahbap.org/" title="AHBAP" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Karayolları Genel Müdürlüğü</span>
                      <span class="link"><a href="https://twitter.com/KarayollariGM" title="Karayolları Genel Müdürlüğü" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Afet Harita</span>
                      <span class="link"><a href="https://afetharita.com/" title="Afet Harita" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">Afet Harita (İhtiyaç Haritası)</span>
                      <span class="link"><a href="https://afetharitasi.org/" title="Afet Harita (İhtiyaç Haritası)" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0; border-bottom: 1px solid var(--kan-border-color);">
                      <span class="title">AFAD Türkiye Deprem Tehlike Haritaları</span>
                      <span class="link"><a href="https://www.turkiye.gov.tr/afad-turkiye-deprem-tehlike-haritalari" title="AFAD Türkiye Deprem Tehlike Haritaları" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                    <div class="items d-flex justify-content-between align-items-center" style="padding: 10px 0;">
                      <span class="title">AFAD Afet ve Acil Durum Toplanma Alanı Sorgulama</span>
                      <span class="link"><a href="https://www.turkiye.gov.tr/afet-ve-acil-durum-yonetimi-acil-toplanma-alani-sorgulama" title="AFAD Afet ve Acil Durum Toplanma Alanı Sorgulama" target="_blank"><?php esc_html_e( 'Sayfaya Git', 'kanews' ); ?></a></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          
          <?php get_template_part('template-parts/content/components/related', 'page2', array( 'posts_per_page' => 10, 's' => 'Deprem' )); ?>
        
          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-flat kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
