<?php
/**
 * Template Name: Yabancı Borsa
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Yabancı Borsa', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$hisse = isset($_GET['hisse']) ? esc_html(strtoupper($_GET['hisse'])) : NULL;
$endeks = isset($_GET['endeks']) ? esc_html(strtoupper($_GET['endeks'])) : NULL;
$index = isset($_GET['index']) ? esc_html($_GET['index']) : 'america';

$indexes = [
  'america' => 'USA (NASDAQ, NYSE, NYSE ARCA, OTC)',
  'canada' => 'Canada (TSX, TSXV, CSE, NEO)',
  'china' => 'China (SSE)',
  'germany' => 'Germany (FWB, SWB, XETR, BER, DUS, HAM, HAN, MUN, TRADEGATE)',
  'turkey' => 'Turkey (BIST)',
  'uae' => 'UAE (ADX)',
  'uk' => 'United Kingdom (LSE, LSIN)',
  'switzerland' => 'Switzerland (SIX, BX)',
];

if( isset($_GET['tvwidgetsymbol']) ) {
  $value  = esc_url($_GET['tvwidgetsymbol']);
  wp_redirect( esc_url( add_query_arg( 'hisse', $value, get_the_permalink() ) ), 301);
  die;
}

if($hisse != NULL || $endeks != NULL) {
  $ex = $hisse;
  if( $endeks != NULL )
  $ex = $endeks;
  $response = wp_remote_get('https://tr.tradingview.com/symbols/'.$ex);
  if ( ( !is_wp_error($response)) && (200 !== wp_remote_retrieve_response_code( $response ) ) ) {
    wp_redirect( get_the_permalink(), 301);
    die;
  }
  
  if( $endeks != NULL )
  $new_title = wp_sprintf( esc_html__('%1$s — Hisse Senedi Endeksi Grafiği ve Piyasa Değeri', 'kanews'), explode(':', $endeks)[1] ).' - '.get_bloginfo( 'name' );
  else
  $new_title = wp_sprintf( esc_html__('%1$s — Hisse Senedi Grafiği ve Piyasa Değeri', 'kanews'), explode(':', $hisse)[1] ).' - '.get_bloginfo( 'name' );
  
  function generate_custom_title($title) {
    global $new_title;
    if($new_title)
    $title = $new_title;
    return $title;  
  }
  add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
  add_filter( 'wpseo_title', 'generate_custom_title', 15 );
}

$lang = get_locale();
if ( strlen( $lang ) > 0 ) {
$lang = explode( '_', $lang )[0];
}

get_header(); ?>
<?php if($hisse == NULL) : ?>
  <?php while ( have_posts() ) : the_post(); ?>
  <div class="kanews-page-header">
    <div class="container">
      <div class="row align-items-center justify-space-between">
        <?php if(!empty($new_title2)): ?>
        <div class="col"><h1 class="kanews-page-title"><?php echo $new_title2; ?></h1></div>
        <?php else: ?>
        <div class="col"><h1 class="kanews-page-title"><?php the_title(); ?></h1></div>
        <?php endif; ?>
        
        <div class="col-auto">
          <div class="kanews-dropdown">
            <div data-toggle="kanews-modal-categories" class="kanews-btn kanews-btn-light m-0">
              
              <?php echo isset($indexes[$index]) ? $indexes[$index] : 'America'; ?>
              <i class="icon-caret icon-180deg"></i>
            </div>
            <div id="kanews-modal-categories" class="kanews-dropdown-content">
              <ul>

                <?php foreach($indexes as $key => $value) {
                  if($key == $index)
                  echo '<li><a href="'. esc_url( add_query_arg( array('index' => $key), get_the_permalink() ) ).'" class="color-primary">'.$value.'</a></li>';
                  else
                  echo '<li><a href="'. esc_url( add_query_arg( array('index' => $key), get_the_permalink()) ).'" class="">'.$value.'</a></li>';
                } ?>
                
              </ul>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <?php endwhile; ?>
  <?php endif; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
    
          <?php if($hisse == NULL && $endeks == NULL) : ?>

            <div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
            </div>
            
            <div class="col-12">
              <div class="kanews-section">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/screener/" rel="noopener" target="_blank"><span class="blue-text">Stock screener</span></a> by TradingView</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-screener.js" async>
                  {
                  "width": "100%",
                  "height": "768",
                  "defaultColumn": "overview",
                  "defaultScreen": "most_capitalized",
                  "market": "<?php echo $index; ?>",
                  "showToolbar": true,
                  "colorTheme": "light",
                  "largeChartUrl": "<?php the_permalink(); ?>?hisse={tvexchange}:{tvsymbol}",
                  "locale": "<?php echo $lang; ?>"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>

            <div class="col-12 col-lg-8">
              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Endeksler', 'kanews' ), 'h2'); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/markets/" rel="noopener" target="_blank"><span class="blue-text">Market summary</span></a> by TradingView</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-quotes.js" async>
                  {
                  "width": "100%",
                  "height": "425",
                  "largeChartUrl": "<?php the_permalink(); ?>?endeks={tvexchange}:{tvsymbol}",
                  "symbolsGroups": [
                    {
                      "name": "Indices",
                      "originalName": "Indices",
                      "symbols": [
                        {
                          "name": "CAPITALCOM:DXY",
                          "displayName": "DXY"
                        },
                        {
                          "name": "FOREXCOM:SPXUSD",
                          "displayName": "S&P 500"
                        },
                        {
                          "name": "FOREXCOM:NSXUSD",
                          "displayName": "US 100"
                        },
                        {
                          "name": "FOREXCOM:DJI",
                          "displayName": "Dow 30"
                        },
                        {
                          "name": "INDEX:NKY",
                          "displayName": "Nikkei 225"
                        },
                        {
                          "name": "INDEX:DEU40",
                          "displayName": "DAX Index"
                        },
                        {
                          "name": "FOREXCOM:UKXGBP",
                          "displayName": "UK 100"
                        },
                        {
                          "name": "BIST:XU100",
                          "displayName": "BIST 100"
                        },
                        {
                          "name": "BIST:XU050",
                          "displayName": "BIST 50"
                        },
                        {
                          "name": "BIST:XU030",
                          "displayName": "BIST 30"
                        },
                        {
                          "name": "BIST:XBANK",
                          "displayName": "BIST Banka"
                        }
                      ]
                    }
                  ],
                  "showSymbolLogo": true,
                  "colorTheme": "light",
                  "isTransparent": false,
                  "locale": "<?php echo $lang; ?>"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>

            <div class="col-12 col-lg-4">
              <div class="kanews-section">
              <?php echo kanews_widget_title(esc_html__( 'Ekonomik Takvim', 'kanews' ), 'h2'); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/economic-calendar/" rel="noopener" target="_blank"><span class="blue-text">Ekonomik takvim</span></a> TradingView tarafından</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-events.js" async>
                  {
                  "width": "100%",
                  "height": "425",
                  "colorTheme": "light",
                  "isTransparent": false,
                  "locale": "tr",
                  "importanceFilter": "0,1",
                  "currencyFilter": "USD,EUR,ITL,NZD,CHF,AUD,FRF,JPY,ZAR,TRL,CAD,DEM,MXN,ESP,GBP"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>

            <?php while ( have_posts() ) : the_post(); 
              if ($post->post_content): ?>
                <div class="col-12">
                  <div class="kanews-article kanews-section-flat kanews-article-1">
                    <div class="kanews-article-content entry-content">
                      <?php the_content(); ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            <?php endwhile; ?>

            <?php get_template_part('template-parts/content/components/related', 'page'); ?>
          <?php else: 
            if( $endeks !== NULL)
            $hisse = $endeks;
            ?>
             <div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
            </div>
            <div class="col-12">

              <div class="row">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright">TradingView'den <a href="https://tr.tradingview.com/symbols/<?php echo $hisse; ?>/" rel="noopener" target="_blank"><span class="blue-text"><?php echo $hisse; ?> Fiyatı</span></a></div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-symbol-info.js" async>
                  {
                  "symbol": "<?php echo $hisse; ?>",
                  "width": "100%",
                  "locale": "<?php echo $lang; ?>",
                  "colorTheme": "light",
                  "largeChartUrl": "<?php the_permalink(); ?>?hisse={tvexchange}:{tvsymbol}",
                  "isTransparent": true
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
                
              </div>

              <div class="row justify-content-between no-gutters">
                <div class="kanews-tab-3">
                  <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0">
                    <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'chart', 'tradingview', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link active"><?php _e('Tradingview', 'kanews'); ?></a></li>
                    <li class="nav-item"><a href="<?php the_permalink(); ?>" class="nav-link"><?php _e('Diğer Hisselere Göz At', 'kanews'); ?></a></li>
                  </ul>
                </div>
              </div>
            
              <div class="kanews-section" style="overflow:hidden">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div id="tradingview_12510"></div>
                  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/symbols/<?php echo $hisse; ?>?exchange=BIST" rel="noopener" target="_blank"><span class="blue-text"><?php echo $hisse; ?> Chart</span></a> by TradingView</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                  <script type="text/javascript">
                  new TradingView.widget(
                  {
                    "width": 1170,
                    "height": 610,
                    "symbol": "<?php echo $hisse; ?>",
                    "timezone": "Europe/Istanbul",
                    "interval": "240",
                    "theme": "light",
                    "style": "1",
                    "locale": "<?php echo $lang; ?>",
                    "toolbar_bg": "#ccc",
                    "enable_publishing": false,
                    "hide_top_toolbar": false,
                    "withdateranges": false,
                    "details": true,
                    "hide_side_toolbar": false,
                    "allow_symbol_change": true,
                    "show_popup_button": true,
                    "studies": [
                      // "MACD@tv-basicstudies",
                      "RSI@tv-basicstudies"
                    ],
                    "hotlist": true,
                    "popup_width": "1000",
                    "popup_height": "650",
                    "container_id": "tradingview_e8ead",
                    "isTransparent": false,
                  }
                  );
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>

              <div class="kanews-section">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/symbols/<?php echo $hisse; ?>" rel="noopener" target="_blank"><span class="blue-text"><?php echo $hisse; ?> temel gerçekler</span></a> TradingView tarafından</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-symbol-profile.js" async>
                  {
                  "width": "100%",
                  "height": "400",
                  "colorTheme": "light",
                  "isTransparent": false,
                  "largeChartUrl": "<?php the_permalink(); ?>?hisse={tvexchange}:{tvsymbol}",
                  "symbol": "<?php echo $hisse; ?>",
                  "locale": "<?php echo $lang; ?>"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>

              <div class="kanews-section">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/symbols/<?php echo $hisse; ?>/financials-overview/" rel="noopener" target="_blank"><span class="blue-text"><?php echo $hisse; ?> temeller</span></a> TradingView tarafından</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-financials.js" async>
                  {
                  "colorTheme": "light",
                  "isTransparent": false,
                  "largeChartUrl": "",
                  "displayMode": "regular",
                  "width": "100%",
                  "largeChartUrl": "<?php the_permalink(); ?>?hisse={tvexchange}:{tvsymbol}",
                  "height": "625",
                  "symbol": "<?php echo $hisse; ?>",
                  "locale": "<?php echo $lang; ?>"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
        
              <?php get_template_part('template-parts/content/components/related', 'page2', array( 
                'posts_per_page' => 10,
                's' => $hisse 
              ) ); ?>

            </div>

            <script>
              document.getElementsByTagName('title')[0].innerHTML = "<?php echo $new_title; ?>";
            </script>
          <?php endif; ?>

        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
