<?php
/**
 * Template Name: Canlı Tv
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Canlı Tv', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$watch = isset($_GET['kanal']) ? esc_html($_GET['kanal']) : NULL;
$channel = isset($_GET['no']) ? esc_html(($_GET['no'])) : 0;
$list = kanews_get_option('live-tv') ? kanews_get_option('live-tv') : array();
if(isset($list[$channel]['title'])) {
  $title = $list[$channel]['title'].' '.esc_html__( 'Canlı İzle', 'kanews' );
  $new_title = $title.' - '.get_bloginfo('name');
} else {
  wp_redirect( get_the_permalink(), 301);
  die;
}
function generate_custom_title($title) {
  global $new_title;
  if($new_title)
  $title = $new_title;
  return $title;  
}

add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );
get_header(); ?>
  <?php while ( have_posts() ) : the_post(); 
    if(!isset($list[$channel]['title']))
    $title = get_the_title($post->ID);
  else 
  $desc = $list[$channel]['title'];
    
    $desc = wp_sprintf( __('%1$s canlı yayını HD kalitesinde izle! Sevilen dizi, film, haber ve eğlence programlarını kesintisiz takip edin..', 'kanews'), $desc );
  ?>
    <?php kanews_page_header($post->ID, $title, '', $desc); ?>
  <?php endwhile; ?>

  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">

        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>

          <div class="col-12">
            <div class="kanews-watch-panel d-flex flex-wrap no-gutters">
              <div class="kanews-watch-panel-left col-12 col-lg-9">

                <div class="kanews-watch-panel-top d-flex justify-content-between align-items-stretch">
                  <div class="kanews-watch-panel-title col">
                    <span class="kanews-live"><?php esc_html_e( 'Canlı', 'kanews' ); ?></span>
                    <?php if( ! empty( $list[$channel]['channel-title'] ) ): ?>
                      <h2><?php echo $list[$channel]['channel-title']; ?></h2>
                    <?php else: ?>
                      <h2><?php echo $list[$channel]['title']; ?></h2>
                    <?php endif; ?>
                  </div>
                  <div class="kanews-watch-panel-action d-flex flex-wrap">
                    <div id="expandPlayer" role="tooltip" aria-label="<?php esc_html_e( 'Genişlet', 'kanews' ); ?>" data-microtip-position="bottom">
                      <img src="<?php echo kanews_lazy_link(); ?>" class="kanews-lazy" data-src="<?php echo KAN_TEMPLATE_URL.'/assets/img/expand.png'; ?>" width="12" height="12" alt="expand" />
                    </div>
                    <?php if($channel > 0): ?>
                    <a id="prevChannel" href="<?php the_permalink(); ?>?no=<?php echo ($channel-1); ?>" role="tooltip" aria-label="<?php esc_html_e( 'Önceki Kanal', 'kanews' ); ?>" data-microtip-position="bottom"><i class="icon-arrow-long"></i></a>
                    <?php endif; ?>
                    <a id="nextChannel" href="<?php the_permalink(); ?>?no=<?php echo ($channel+1); ?>" role="tooltip" aria-label="<?php esc_html_e( 'Sonraki Kanal', 'kanews' ); ?>" data-microtip-position="bottom"><i class="icon-arrow-long icon-180deg"></i></a>
                  </div>
                </div>
                <div class="embed-containers">

                  <?php 
                    if($list[$channel]['iframe-src']) {
                      echo '<div class="plyr__video-embed" id="player">';
                        echo '<iframe src="'.esc_attr($list[$channel]['iframe-src']).'" allowfullscreen allowtransparency allow="autoplay"></iframe>';
                      echo '</div>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/plyr/3.7.8/plyr.css" integrity="sha512-yexU9hwne3MaLL2PG+YJDhaySS9NWcj6z7MvUDSoMhwNghPgXgcvYgVhfj4FMYpPh1Of7bt8/RK5A0rQ9fPMOw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/plyr/3.7.8/plyr.min.js" integrity="sha512-vONptKEoKbP1gaC5UkbYDa9OPr04ur4bxaaqT7DAJxGHB2oogtseCPrl5e5hPFokGYotlGNV4d+GM593ka7iNA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  
<script>
    const player = new Plyr("#player");
    const supported = Plyr.supported("video", "html5", true);
    player.play();
  </script>
                      ';
                    
                    }elseif($list[$channel]['custom-embed']) {

                      

                      echo '
<link href="https://unpkg.com/video.js/dist/video-js.min.css" rel="stylesheet">
<link href="https://unpkg.com/@videojs/themes@1/dist/forest/index.css" rel="stylesheet">

<script src="https://cdnjs.cloudflare.com/ajax/libs/video.js/7.21.1/video.min.js"></script>
<script src="https://unpkg.com/videojs-flash/dist/videojs-flash.js"></script>
<script src="https://unpkg.com/browse/@videojs/http-streaming@2.6.0/dist/videojs-http-streaming.min.js"></script>
                      <video id="example-video" class="video-js vjs-theme-forest" controls>
                      <source src="'.$list[$channel]['custom-embed'].'"  type="application/x-mpegURL">
                    </video>
<script>
var player = videojs("example-video");
player.play();
</script>
                </script>
                    ';
                    } else {
                      echo '<img class="kanews-lazy" src="'.kanews_lazy_link().'" data-src="https://dummyimage.com/870x490/1d1f26/555555&text='.__('Kaynak Bulunamadı', 'kanews').'" alt="example" width="870" height="490" />';
                    } 
                  ?>
                </div>
                
              </div>
              <div class="kanews-watch-panel-right no-gutters col-12 col-lg-3">
                <div class="kanews-watch-panel-top col-auto">
                  <form>
                    <input placeholder="<?php esc_html_e( 'Kanal Ara', 'kanews' ); ?>" id="kanews-live-search" type="text">
                    <i class="icon-search"></i>
                  </form>
                </div>
                <div class="kanews-watch-panel-right-content col">
                  <?php $counter=0; foreach($list as $tv) :  
                    if($counter == $channel) 
                      $class = 'is-active';
                    else
                      $class = '';
                    ?>
                    <a href="<?php the_permalink(); ?>?kanal=<?php echo kanews_seflink($tv['title']); ?>&no=<?php echo $counter; ?>" data-search="<?php echo $tv['title']; ?>" class="kanews-live-search-item kanews-watch-panel-right-content-item <?php echo $class; ?>">
                      <?php if($tv['logo']): ?>
                        <img class="kanews-lazy" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAIUlEQVR42mN895+BIsA4asCoAaMGjBowasCoAaMGDDcDAGyePcHhFJhdAAAAAElFTkSuQmCC" data-src="<?php echo $tv['logo']; ?>" width="32" height="32" alt="tv" />
                      <?php else: ?>
                        <img class="kanews-lazy" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAIUlEQVR42mN895+BIsA4asCoAaMGjBowasCoAaMGDDcDAGyePcHhFJhdAAAAAElFTkSuQmCC" data-src="https://dummyimage.com/32x32/ccc/ccc" width="32" height="32" alt="tv" />
                      <?php endif; ?>
                      <?php if($tv['title']): ?>
                        <span><?php echo $tv['title']; ?></span>
                      <?php else: ?>
                        <span><?php _e('Kanal Adı', 'kanews'); ?></span>
                      <?php endif; ?>
                    </a>
                  <?php $counter++; endforeach;?>
                </div>
                <div class="kanews-watch-panel-right-action col-auto">
                  <div class="kanews-btn-group">
                  <a href="#comments" class="kanews-btn kanews-btn-block"><?php esc_html_e( 'Yorum Yap', 'kanews' ); ?></a>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <?php 
            if ( ! empty( $list[$channel]['content'] )): ?>
              <div class="col-12 mt-2">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php echo $list[$channel]['content']; ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php while ( have_posts() ) : the_post();  if ( comments_open() || get_comments_number() ) : ?>
              
              <div class="col-12 mt-2">
                <?php comments_template(); ?>
              </div>
            <?php endif;?> 
          <?php endwhile; ?>

          <?php get_template_part('template-parts/content/components/related', 'page'); ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>
      </div>
    </div>
  </main>
  
<?php get_footer();