<?php
/**
 * Template Name: Akış
 * @url kanthemes.com
 */
__( 'Akış', 'kanews' );
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
wp_enqueue_script('kanews-infinite-scroll');

get_header(); ?>
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); endwhile; endif; ?>
<?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
	<?php if(is_user_logged_in()): ?>
		<div class="kanews-page-header">
			<div class="container">
				<div class="row align-items-center justify-space-between">
					<div class="col"><h1 class="kanews-page-title"><?php the_title(); ?></h1></div>
          <?php $user_cats = get_user_option( 'kanews_subscribe_category', get_current_user_id() );
          $user_cats = is_array($user_cats) ? $user_cats : array();
          if(!empty($user_cats)): ?>
          <div class="col-auto">
            <div data-toggle="kanews-modal-categories" class="kanews-btn kanews-btn-light m-0"><?php esc_html_e( 'Akışımı Yönet', 'kanews' ); ?> <i class="icon-caret icon-180deg"></i></div>
            <div id="kanews-modal-categories" class="kanews-modal">
              <div data-toggle="kanews-modal-categories" class="kanews-modal-close"></div>
              <div class="kanews-modal-content">
                <div class="kanews-modal-title"><?php esc_html_e( 'Abone Olabileceğin Konular', 'kanews' ); ?></div>
                <div data-toggle="kanews-modal-categories" class="kanews-modal-close-btn"><i class="icon-close"></i></div>
                <div class="kanews-modal-content-inner">
                  <div class="kanews-category-subscribe-wrapper">
                  <?php 
                  
                    $categories = Kanews\Util\Cache::get_categories();
                    foreach($categories as $category) {
                      if(in_array($category->term_id, $user_cats)) 
                      echo '<a class="kanews-category-subscribe-button hf1s category-subscribed" data-cat-id="'.$category->term_id.'" onclick="doSomething()">'.$category->name.' <div class="check"></div> <div id="kanews-loader"></div></a>';
                      else
                      echo '<a class="kanews-category-subscribe-button hf1s" data-cat-id="'.$category->term_id.'" onclick="doSomething()">'.$category->name.' <div class="check"></div> <div id="kanews-loader"></div></a>';
                    }
                  ?>
                  </div>
                </div>
              </div>
              
            </div>
          </div>
          <?php else:
            $user_cats[0] = '';
          endif; ?>
				</div>
			</div>
		</div>
    

		<main id="main" class="site-main">
			<div class="container ">
        <div class="kanews-widgets-top column_x_gutter">
          
          <?php 
          $paged = isset($_GET['pagi']) ? $_GET['pagi'] : 1;
          $following = get_user_option( 'kanews_subscribe_authors', get_current_user_id() ) ? get_user_option( 'kanews_subscribe_authors', get_current_user_id() ) : array('');
          if( isset($_GET['list']) && $_GET['list'] == 'author' && !empty($following) ) {
            $kanews_query = new WP_Query(
              array( 
                'author__in' => $following,
                'posts_per_page' => 13,
                'paged' => $paged, 
              )
            );
          } else {
            $kanews_query = new WP_Query(
              array( 
                'category__in' => $user_cats,
                'posts_per_page'    => 13,
                'paged' => $paged, 
              )
            );
          }
          
          if ($kanews_query->have_posts()) : ?>
          <div class="row justify-content-between no-gutters kanews_widget_posts_6">
            <div class="kanews-tab">
              <ul class="nav nav-tabs d-flex flex-wrap m-0 mb-2">
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( array( 'style' => 'default', 'pagi' => 1), $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo ( !isset($_GET['style']) || (isset($_GET['style']) && $_GET['style'] != 'grid')) ? 'active' : ''; ?>"><svg class="icon-90deg" width="22" height="22" fill="currentColor" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g><g><g><rect x="192" y="277.333" width="128" height="234.667"/><rect x="362.667" width="149.333" height="149.333"/><rect x="192" width="128" height="234.667"/><rect x="362.667" y="192" width="149.333" height="128"/><rect width="149.333" height="512"/><rect x="362.667" y="362.667" width="149.333" height="149.333"/></g></g></g></svg></a></li>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( array( 'style' => 'grid', 'pagi' => 1), $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo ( isset($_GET['style']) && $_GET['style'] == 'grid') ? 'active' : ''; ?>"><svg fill="currentColor" width="22" height="22" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><title>grid</title><path d="M3 10.25h5c1.242-0.002 2.248-1.008 2.25-2.25v-5c-0.002-1.242-1.008-2.248-2.25-2.25h-5c-1.242 0.002-2.248 1.008-2.25 2.25v5c0.002 1.242 1.008 2.248 2.25 2.25h0zM3.25 3.25h4.5v4.5h-4.5zM13.5 10.25h5c1.242-0.002 2.248-1.008 2.25-2.25v-5c-0.002-1.242-1.008-2.248-2.25-2.25h-5c-1.242 0.002-2.248 1.008-2.25 2.25v5c0.002 1.242 1.008 2.248 2.25 2.25h0zM13.75 3.25h4.5v4.5h-4.5zM24 10.223h4.973c1.242-0.002 2.248-1.008 2.25-2.25v-4.973c-0.002-1.242-1.008-2.248-2.25-2.25h-4.973c-1.242 0.002-2.248 1.008-2.25 2.25v4.973c0.002 1.242 1.008 2.248 2.25 2.25h0zM24.25 3.25h4.473v4.473h-4.473zM3.014 20.75h5c1.242-0.002 2.248-1.008 2.25-2.25v-5c-0.002-1.242-1.008-2.248-2.25-2.25h-5c-1.242 0.002-2.248 1.008-2.25 2.25v5c0.002 1.242 1.008 2.248 2.25 2.25h0zM3.264 13.75h4.5v4.5h-4.5zM13.514 20.75h5c1.242-0.002 2.248-1.008 2.25-2.25v-5c-0.002-1.242-1.008-2.248-2.25-2.25h-5c-1.242 0.002-2.248 1.008-2.25 2.25v5c0.002 1.242 1.008 2.248 2.25 2.25h0zM13.764 13.75h4.5v4.5h-4.5zM24.014 20.723h4.973c1.242-0.002 2.248-1.008 2.25-2.25v-4.973c-0.002-1.242-1.008-2.248-2.25-2.25h-4.973c-1.242 0.002-2.248 1.008-2.25 2.25v4.973c0.002 1.242 1.008 2.248 2.25 2.25h0zM24.264 13.75h4.473v4.473h-4.473zM8.027 21.75h-5c-1.242 0.002-2.248 1.008-2.25 2.25v5c0.002 1.242 1.008 2.248 2.25 2.25h5c1.242-0.002 2.248-1.008 2.25-2.25v-5c-0.002-1.242-1.008-2.248-2.25-2.25h-0zM7.777 28.75h-4.5v-4.5h4.5zM18.527 21.75h-5c-1.242 0.002-2.248 1.008-2.25 2.25v5c0.002 1.242 1.008 2.248 2.25 2.25h5c1.242-0.002 2.248-1.008 2.25-2.25v-5c-0.002-1.242-1.008-2.248-2.25-2.25h-0zM18.277 28.75h-4.5v-4.5h4.5zM29 21.75h-4.973c-1.242 0.002-2.248 1.008-2.25 2.25v4.973c0.002 1.242 1.008 2.248 2.25 2.25h4.973c1.242-0.002 2.248-1.008 2.25-2.25v-4.973c-0.002-1.242-1.008-2.248-2.25-2.25h-0zM28.75 28.723h-4.473v-4.473h4.473z"></path></svg></a></li>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( array( 'list' => 'category', 'pagi' => 1), $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo ( !isset($_GET['list']) || (isset($_GET['list']) && $_GET['list'] != 'author')) ? 'active' : ''; ?>"><?php esc_html_e('Takip Ettiğim Kategorilerden', 'kanews'); ?></a></li>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( array( 'list' => 'author', 'pagi' => 1), home_url($_SERVER['REQUEST_URI']) ) ); ?>" class="nav-link <?php echo ( isset($_GET['list']) && $_GET['list'] == 'author') ? 'active' : ''; ?>"><?php esc_html_e('Takip Ettiğim Yazarlardan', 'kanews'); ?></a></li>
              
              </ul>
            </div>
          </div>
            <div class="row"  kanews-data-load-more data-status="1">
              <?php $counter=0; while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; $counter++; ?>
                <?php 
                  $cat_color = get_term_meta( (int) Kanews\Helper_Wp::primary_category_id($post->ID), '_category_color', true );
                  $col = 'col-6 col-md-3';
                  $thumbnail = 'kanews-manset-5';
                  $big_class = '';

                  if($counter % 5 == 1) {
                    $big_class = 'kanews-post-big';
                    $col = 'col-12 col-md-6';
                    $thumbnail = 'kanews-manset-3';
                  }
                ?>
                <?php if( isset($_GET['style']) && $_GET['style'] == 'grid' ): ?>
                  <?php get_template_part('template-parts/archives/article-3'); ?>
                <?php else: ?>
                  <div class="<?php echo $col; ?> toinfinite">
                    <?php get_template_part('template-parts/post-blocks/block-4', null, array('cat_color' => $cat_color, 'thumbnail' => $thumbnail, 'item_class' => $big_class)); ?>
                  </div>
                <?php endif; ?>
              <?php endwhile; ?>
            </div>

            <?php
              $total_pages = $kanews_query->max_num_pages;
              if ($total_pages > 1){
                echo '<nav class="navigation pagination" style="width: 100%" hidden role="navigation"><div class="nav-links">';
                $current_page = max(1, get_query_var('paged'));
                echo '<a href="'.esc_url(add_query_arg( 'pagi', ($current_page+1), $_SERVER['REQUEST_URI'])).'" class="next"></a>';
                echo '</div></nav>';
              }
            ?> 
            <div id="load-more-posts-button-wrapper">
              <div style="display:none" class="page-load-status">
                <div class="loader-ellips infinite-scroll-request">
                  <svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40px" height="40px" viewBox="0 0 40 40" enable-background="new 0 0 40 40" xml:space="preserve"> <path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/> <path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"> <animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/> </path> </svg>
                </div>
                <p class="infinite-scroll-last"><?php _e('Daha fazla gösterilecek yazı bulunamadı!', 'kanews'); ?></p>
                <p class="infinite-scroll-error"><?php _e('Tekrar deneyiniz.', 'kanews'); ?></p>
              </div>
            </div>
          <?php else: ?>
            <div class="kanews-section kanews-subs-section kanews-section-flat">
              <?php if( isset($_GET['list']) && $_GET['list'] == 'author' && !empty($following) ): ?>
                <p><?php _e('Daha fazla gösterilecek yazı bulunamadı!', 'kanews'); ?></p>
                
              <?php else: ?>
                <h2><?php echo kanews_translate('feed-title', esc_html__( 'İlgi alanların neler?', 'kanews' )); ?></h2>
                <p><?php echo kanews_translate('feed-description', esc_html__( 'Deneyimini kişiselleştirmene yardımcı olması için, ilgini çeken birkaç konu seç. Takip edebileceğin konulara aşağıdan ulaşabilirsin.', 'kanews' )); ?></p>
                
                <div class="kanews-category-subscribe-wrapper">
                  <?php 

                    $user_cats = get_user_option( 'kanews_subscribe_category', get_current_user_id() ) ? get_user_option( 'kanews_subscribe_category', get_current_user_id() ) : array('');
                    $categories = Kanews\Util\Cache::get_categories();
                    foreach($categories as $category) {
                      if(in_array($category->term_id, $user_cats)) 
                      echo '<a class="kanews-category-subscribe-button hf1s category-subscribed" data-cat-id="'.$category->term_id.'" onclick="doSomething()">'.$category->name.' <div class="check"></div> <div id="kanews-loader"></div></a>';
                      else
                      echo '<a class="kanews-category-subscribe-button hf1s" data-cat-id="'.$category->term_id.'" onclick="doSomething()">'.$category->name.' <div class="check"></div> <div id="kanews-loader"></div></a>';
                    }
                  ?>
                </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </main>
  <?php else: ?>
    <div class="container" style="padding: 0 7.5px;">
			<div class="row">
				<div class="col-12 mobile-col">
					<div class="kanews-lr-page d-flex flex-wrap">
						<div class="kanews-lr-page-right col-12 ">
							<div class="kanews-lr-page-inner d-flex flex-column">
                <div class="mb-2">
              <h1 class="kanews-page-title"><?php esc_html_e( 'Giriş Yap', 'kanews' ); ?></h1>
              <p><?php echo kanews_translate('login-description', sprintf( esc_html__('%s ayrıcalıklarından yararlanmak için hemen giriş yapın veya hesap oluşturun, üstelik tamamen ücretsiz!', 'kanews' ), get_bloginfo( 'name' ))); ?></p>
            </div>
            <form id="kanews-login-form">
              <div class="kanews-form bgw">      
                <input autofocus type="text" id="username" name="username" value="">
                <span class="highlight"></span>
                <span class="bar"></span>
                <label><i class="icon-user"></i> <?php _e('Kullanıcı adı veya e-posta', 'kanews'); ?></label>
              </div>
              <div class="kanews-form bgw">      
                <input type="password" id="password" name="password" value="">
                <span class="highlight"></span>
                <span class="bar"></span>
                <label><i class="icon-vpn_key"></i> <?php _e('Şifreniz', 'kanews'); ?></label>
                <span class="kanews-show-password">
                  <i class="icon-view"></i>
                </span>
              </div>
              <div class="d-flex justify-content-between">
                <div class="d-flex">
                  <div class="kanews-form bgw">
                    <input name="rememberme" type="checkbox" id="rememberme" value="1">
                  </div>
                  <label for="rememberme" style="margin-bottom: 0;margin-top: 3px;"><?php esc_html_e( ' Beni hatırla', 'kanews' ); ?></label>
                </div>
                <div><a href="<?php echo wp_lostpassword_url(home_url( add_query_arg( [], $GLOBALS['wp']->request ) )); ?>"><?php esc_html_e( 'Şifremi Unuttum', 'kanews' ); ?></a></div>
              </div>
              <button class="kanews-btn kanews-btn-block" type="submit"><?php esc_html_e( 'Giriş Yap', 'kanews' ); ?> <div id="kanews-loader"></div></button>
              <?php echo kanews_get_recaptcha('login_form'); ?>
              <?php wp_nonce_field( 'login_action', 'login_field' ); ?>
            </form>
            <div class="or-div"><span><?php esc_attr_e( 'veya', 'kanews' ); ?></span></div>
            <?php 
            if(class_exists('NextendSocialLogin', false)){
              echo NextendSocialLogin::renderButtonsWithContainer();
            } ?>
            <?php if ( get_option( 'users_can_register' ) ): ?>
              <div class="d-flex justify-content-between align-items-center mt-1">
                <div class="hidden-mobile"><?php echo kanews_translate('register-text', esc_html__( 'Tamamen ücretsiz olarak üyeliğinizi başlatın.', 'kanews' )); ?></div>
                <a href="<?php echo kanews_account_page_url(true); ?>" class="kanews-btn kanews-btn-light m-0"><?php esc_html_e( 'Hesap Oluştur', 'kanews' ); ?></a>
              </div>
            <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
<?php endwhile; endif; ?>
<?php else: ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
      </div>
    </div>
  </main>
<?php endif; ?>
<script>
  window.onload = function() {
    var isFirst = true;
    jQuery(document).on("click", '.kanews-category-subscribe-button', function() {
      if(isFirst){  
        jQuery('.kanews-subs-section').append('<a href="<?php global $wp; echo home_url( $wp->request ); ?>" style="position: fixed;left:15px;bottom:15px" class="kanews-btn"><?php esc_html_e( 'Sayfayı Yenile', 'kanews' ); ?></a>');
        isFirst=false;
      }
    })

  }
</script>
<?php get_footer(); ?>