<?php 
/**
* Open Graph Meta for posts
*/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
add_action('amp_post_template_head', 'kanews_add_open_graph_meta_meta');
add_action('wp_head', 'kanews_add_open_graph_meta_meta', 5);
function kanews_add_open_graph_meta_meta(){

if( ! kanews_get_option('open-graph') )
return;

echo '<!-- Kanews: Open Graph Meta -->'."\n";

global $post;
$site_name = get_bloginfo( 'name' );
$site_desc = get_bloginfo( 'description' );
$default_thumb = kanews_get_option('default-thumbnail') ? kanews_get_option('default-thumbnail') : '';

$output_meta = [    
    'title'       => $site_name,
    'description' => $site_desc,
    'type'        => 'website',
    'url'         => home_url('/'),
];
$name = '';


if( is_page() ) {
    $output_meta['title'] = get_the_title($post->ID);
    $output_meta['type'] = 'website';
    $output_meta['url'] = get_permalink($post->ID);

    if( get_the_excerpt($post) != '' )
    $output_meta['description'] = get_the_excerpt($post);
    if( is_page_template( 'inc/currencies.php' )  ) {
        $name = kanews_get_request_param( 'parite' );
        if( $name ) {
        $output_meta['url'] = kanews_get_page_link('parite', $name, 'doviz');
        $output_meta['title'] = wp_sprintf( __('%1$s Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($name).'/TRY' );
        $output_meta['description'] = wp_sprintf( __('%1$s kuru ve analizi ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), strtoupper($name).'/TRY' );
        }
    }elseif( is_page_template( 'inc/standings.php' ) ) {
        $name = kanews_get_request_param( 'lig' );
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('lig', $name, 'puan');

            $output_meta['title'] = wp_sprintf( __('%1$s Puan Durumu', 'kanews'), ucwords( str_replace("-", " ", $name)) );
            $output_meta['description'] = wp_sprintf( __('%1$s puan durumunu, genel, ev/deplasman puan durumunu ve %1$s 2025 puan durumunda form durumunu (son 5 maç) görün.', 'kanews'), ucwords( str_replace("-", " ", $name)) );
        } else {
            $name = kanews_get_request_param( 'lig', kanews_get_option('league-default', 'super-lig') );
            $output_meta['title'] = wp_sprintf( __('%1$s Puan Durumu', 'kanews'), ucwords( str_replace("-", " ", $name)) );
            $output_meta['description'] = wp_sprintf( __('%1$s puan durumunu, genel, ev/deplasman puan durumunu ve %1$s 2025 puan durumunda form durumunu (son 5 maç) görün.', 'kanews'), ucwords( str_replace("-", " ", $name)) );

        }
    }elseif( is_page_template( 'inc/livescore.php' ) ) {
        global $wp;
        $name = kanews_get_request_param( 'lig' );
        $tarih = kanews_get_request_param( 'tarih', date('Y-m-d') );
        if( $name ) {
            $output_meta['url'] = home_url(add_query_arg( array('lig' => urlencode( $name ), 'tarih' => $tarih), $wp->request));

            $lig_title = kanews_correct_league_title2($name);
            $output_meta['title'] = sprintf(esc_html__('%s Canlı Maç Sonuçları (%s)', 'kanews'), $lig_title, $tarih);
            $output_meta['description'] = wp_sprintf( __('%1$s (%2$s) canlı maç sonuçlarını anlık olarak takip edin! Güncel skorlar, puan durumu ve takım istatistikleri bir arada.', 'kanews'), $lig_title, $tarih );
        }
    }elseif( is_page_template( 'inc/newspaper.php' ) ) {
        $name = kanews_get_request_param( 'gazete' );
        if( $name ) {
            $today = kanews_get_turkish_date_string();

            $newspapers = [
            'aksam' => 'Akşam',
            // 'yeni-safak' => 'Yeni Şafak',
            // 'fanatik' => 'Fanatik',
            'fotomac' => 'Fotomaç',
            'milliyet' => 'Milliyet',
            // 'sozcu' => 'Sözcü',
            'takvim-gazetesi' => 'Takvim',
            'hurriyet' => 'Hürriyet',
            'sabah' => 'Sabah',
            'milli-gazete' => 'Milli',
            'yenicag' => 'Yeni Çağ',
            'milat' => 'Milat',
            'turkiye' => 'Türkiye',
            'turkgun' => 'Türkgün',
            'dunya' => 'Dünya',
            'yenisoz' => 'Yenisöz',
            // 'harbi-gazete' => 'Harbi Gazete',
            'dogru-haber' => 'Doğru Haber',
            'yeni-birlik' => 'Yeni Birlik',
            'aydinlik' => 'Aydınlık',
            ];
            if( isset($newspapers[$name]) ) {
                $output_meta['title'] =  wp_sprintf(esc_html__('%1$s Gazetesi %2$s Günü Gazete Manşetleri', 'kanews'), $newspapers[$name], $today);
                $output_meta['url'] = kanews_get_page_link('gazete', $name, 'gazete');
                $output_meta['description'] = wp_sprintf( __('%1$s gazetesinin %2$s tarihli gazete manşetlerine göz atın, en son gelişmeler ve öne çıkan haberlerle Türkiye\'nin gündemini takip edin!', 'kanews'), $newspapers[$name], $today );
            }
        }
    }elseif( is_page_template( 'inc/exchange.php' ) ) {
        $name = kanews_get_request_param( 'hisse' );
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('hisse', $name, 'exchange');

        $output_meta['title'] = wp_sprintf( __('%1$s — Hisse Senedi Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($name) );
        $output_meta['description'] = wp_sprintf( __('%1$s hisse senedi ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), strtoupper($name) );
        }
    }elseif( is_page_template( 'inc/exchange2.php' ) ) {
        $name = kanews_get_request_param( 'hisse' );
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('hisse', $name, 'exchange2');

        $output_meta['title'] = wp_sprintf( __('%1$s — Hisse Senedi Grafiği ve Piyasa Değeri', 'kanews'), explode(':', $name)[1] );
        $output_meta['description'] = wp_sprintf( __('%1$s hisse senedi ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), explode(':', $name)[1] );
        }
    }elseif( (is_page_template( 'inc/cryptocurrencies.php' ) || is_page_template( 'inc/cryptocurrencies2.php'))  ) {
        $index = kanews_get_request_param( 'index', kanews_get_option('crypto-page-index', 'try') );
        $name = kanews_get_request_param( 'coin' );
        if( $name ) {
        
        $output_meta['url'] = kanews_get_page_link('coin', $name, 'crypto');
        $output_meta['title'] = wp_sprintf( __('%1$s Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($name.'/'.$index));
        $output_meta['description'] = wp_sprintf( __('%1$s kripto parası ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), strtoupper($name.'/'.$index));
        }
    }elseif( is_page_template( 'inc/emtia.php' ) ) {
        $name = kanews_get_request_param( 'emtia' );
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('emtia', $name, 'emtia');

            $search  = array('ONS', 'GRA', 'CEY', 'YAR', 'TAM', 'CUM', 'ATA', 'RES', 'HAM', 'IKI', 'GRE', 'BES', 'ODA', 'OSA', 'YIA', 'GUM' );
            $replace = array('ONS Altın ', 'Gram Altın', 'Çeyrek Altın', 'Yarım Altın', 'Tam Altın', 'Cumhuriyet Altın', 'Ata Altın', 'Reşat Altın', 'Hamit Altın', 'İkibuçuk Altın', 'Gremse Altın', 'Beşli Altın', '14 Ayar Altın', '18 Ayar Altın', '22 Ayar Altın', 'Gümüş Gram');

            $output_meta['title'] = wp_sprintf( esc_html__('%1$s Ne Kadar, Kaç TL?', 'kanews'), esc_html(str_replace($search, $replace, strtoupper($name))) );
            $output_meta['description'] = wp_sprintf( __('1 %1$s ne kadar? 1 %1$s bugün kaç TL?, %1$s ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), esc_html(str_replace($search, $replace, strtoupper($name))));
        }
    }elseif( is_page_template( 'inc/weather-2.php' ) ) {
        $name = kanews_get_request_param( 'sehir' );
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('sehir', $name, 'weather');
            $output_meta['title'] = wp_sprintf( esc_attr__('%s için Hava Durumu', 'kanews'), ucfirst($name));
            $output_meta['description'] = wp_sprintf( __('%1$s için detaylı hava durumu, sıcaklık, nem ve yağış bilgisi, saatlik ve 5 günlük saatlik hava tahmini verilmektedir.', 'kanews'), ucfirst($name) );
        } else {
            $default_city = kanews_get_option('weather-cities') ? kanews_get_option('weather-cities') : '745042';
            $name = ucwords(kanews_get_turkey_cities2('key', $default_city));
            $output_meta['title'] = wp_sprintf( esc_attr__('%s için Hava Durumu', 'kanews'), ucfirst($name));
            $output_meta['description'] = wp_sprintf( __('%1$s için detaylı hava durumu, sıcaklık, nem ve yağış bilgisi, saatlik ve 5 günlük saatlik hava tahmini verilmektedir.', 'kanews'), ucfirst($name) );
        }
    }elseif( is_page_template( 'inc/prayer.php' ) ) {
        $name = kanews_get_request_param( 'sehir' );
        $region_raw = kanews_get_request_param( 'sehir', kanews_get_option('prayer-page-city', 'Ankara') );
        $city_raw = kanews_get_request_param( 'ilce', kanews_get_option('prayer-page-city2', $region_raw) );
        $region = esc_html( ucwords( $region_raw ) );
        $city = esc_html( ucwords( $city_raw ) );
        if( empty($city) )
        $city = $region;

        if( $region == 'Kocaeli' && $region == $city )
        $city = 'İzmit';

        if( $name ) 
        $output_meta['url'] = kanews_get_page_link('sehir', $name, 'namaz');
        $output_meta['title'] = wp_sprintf( esc_html__('%1$s Namaz Vakitleri', 'kanews'), $city );
        $output_meta['description'] = wp_sprintf( __('%1$s namaz vakitlerini 30 günlük periyotla takip edin! Güncel namaz saatleri takip edin ve ibadetlerinizi zamanında yerine getirin.', 'kanews'), $city);

    }elseif( is_page_template( 'inc/eczane.php' ) ) {
        $name_raw = kanews_get_request_param( 'sehir' );
        $name = $name_raw ? ucwords( $name_raw ) : '';
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('sehir', strtolower($name), 'eczane');
            $output_meta['title'] = wp_sprintf( esc_html__('%1$s Nöbetçi Eczaneler', 'kanews'), $name );
            $output_meta['description'] = wp_sprintf( __('%1$s nöbetçi eczaneleri hızlıca bulun! Güncel adres, telefon ve konum bilgileriyle ihtiyaçlarınıza anında ulaşın.', 'kanews'), ucfirst($name) );
        } else {
            $name = kanews_get_option('eczane-page-city', 'Ankara');
            $output_meta['title'] = wp_sprintf( esc_html__('%1$s Nöbetçi Eczaneler', 'kanews'), $name );
            $output_meta['description'] = wp_sprintf( __('%1$s nöbetçi eczaneleri hızlıca bulun! Güncel adres, telefon ve konum bilgileriyle ihtiyaçlarınıza anında ulaşın.', 'kanews'), ucfirst($name) );
        }
    }elseif( is_page_template( 'inc/live.php' ) ) {
        $name = kanews_get_request_param( 'kanal' );
        $name = $name ? ucwords( $name ) : '';
        if( $name ) {
            $output_meta['description'] = wp_sprintf( __('%1$s canlı yayını HD kalitesinde izle! Sevilen dizi, film, haber ve eğlence programlarını kesintisiz takip edin..', 'kanews'), ucfirst($name) );
        } else {
            $output_meta['description'] = wp_sprintf( __('Canlı TV kanallarını HD kalitesinde izleyin! Haber, spor, eğlence ve daha fazlasını kesintisiz takip edin."', 'kanews'), ucfirst($name) );
        }
    }
} elseif( is_singular() ) {



    $output_meta['type'] = 'article';
    $output_meta['title'] = get_the_title();
    $output_meta['published'] = get_the_time('c', $post->ID);
    $output_meta['modified'] = get_the_modified_time('c', $post->ID);
    $output_meta['description'] = wp_strip_all_tags(get_post_field('post_excerpt', $post->ID));
    $output_meta['url'] = get_permalink($post->ID);
    $output_meta['image'] = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');

    // Get post type for article section
    $post_type = get_post_type($post->ID);
    if ($post_type === 'columist') {
        $output_meta['article_section'] = 'columnist';
    } elseif ($post_type === 'video') {
        $output_meta['article_section'] = 'video';
    } else {
        $output_meta['article_section'] = 'news';
    }
	
	if( get_post_meta( $post->ID, 'kanews_bik_id', true) ) {
		$output_meta['article_section'] = 'resmiilan';
	}

    // Get author information
    $author_id = get_post_field('post_author', $post->ID);
    $author_name = get_the_author_meta('display_name', $author_id);
    
    // Check for custom author meta field (for external sources like İHA, BÜLTEN)
    $custom_author = get_post_meta($post->ID, 'kanews_article_author', true);
    if (!empty($custom_author)) {
        $output_meta['article_author'] = $custom_author;
    } else {
        $output_meta['article_author'] = $author_name;
    }

    // Output article structured data meta tags
    echo '<meta name="datePublished" content="'.esc_attr($output_meta['published']).'" />'."\n";
    echo '<meta name="dateModified" content="'.esc_attr($output_meta['modified']).'" />'."\n";
    echo '<meta name="url" content="'.esc_url($output_meta['url']).'" />'."\n";
    echo '<meta name="articleSection" content="'.esc_attr($output_meta['article_section']).'" />'."\n";
    echo '<meta name="articleAuthor" content="'.esc_attr($output_meta['article_author']).'" />'."\n";
    echo '<meta property="article:published_time" content="'.esc_attr($output_meta['published']).'" />'."\n";
} elseif( is_post_type_archive( 'columist' )  ) {

    $output_meta['title'] = esc_html__( 'Yazarlarımız', 'kanews');
    $output_meta['description'] = esc_html__( 'Deneyimli editörlerimiz ve uzman yazarlarımızla güncel, doğru ve etkileyici haber içerikleri sunuyoruz. Ekibimizi keşfedin!', 'kanews' );
    
}

if( get_the_archive_description() ){
    $output_meta['description'] = get_the_archive_description();
}

$url = filter_var($output_meta['url'], FILTER_SANITIZE_URL); // URL'i temizle


echo '<meta property="og:site_name" content="'.esc_attr($site_name) .'" />
<meta property="og:type" content="'.$output_meta['type'].'" />
<meta property="og:url" content="'.esc_url_raw($url).'" />'."\n";
if( is_home() || is_front_page() ) { 
echo '<meta property="og:title" content="'.esc_attr($output_meta['title']).' - '.$site_desc .'" />
<meta property="twitter:title" content="'.esc_attr($output_meta['title']).' - '.$site_desc .'" />'."\n"; 
} else {
echo '<meta property="og:title" content="'.esc_attr($output_meta['title']) .' - '.$site_name.'" />
<meta property="twitter:title" content="'.esc_attr($output_meta['title']) .' - '.$site_name.'" />'."\n"; 
}

if(isset($output_meta['description']) && $output_meta['description'] != '') {
    $output_meta['description'] = strip_tags( strip_shortcodes( $output_meta['description'] ) );
    echo '<meta property="og:description" content="'.esc_attr(wp_html_excerpt($output_meta['description'], 150, '..')).'" />'."\n";
    echo '<meta property="twitter:description" content="'.esc_attr(wp_html_excerpt($output_meta['description'], 150, '..')).'" />'."\n";
    echo '<meta name="description" content="'.esc_attr(wp_html_excerpt($output_meta['description'], 150, '..')).'" />'."\n";
}

if (is_singular() && has_post_thumbnail($post->ID) && isset($output_meta['image'][0]) && isset($output_meta['image'][0])) 
echo '<meta name="twitter:card" content="summary_large_image" />
<meta property="og:image:width" content="'.esc_attr($output_meta['image'][1]).'" />
<meta property="og:image:height" content="'.esc_attr($output_meta['image'][2]).'" />
<meta property="og:image" content="'.esc_url($output_meta['image'][0]).'" />
<meta property="twitter:image" content="'.esc_url($output_meta['image'][0]).'" />'."\n";	
elseif(isset($default_thumb['id']) && $default_thumb['url'] != '')
echo '<meta name="twitter:card" content="summary_large_image" />
<meta property="og:image:width" content="'.esc_attr($default_thumb['width']).'" />
<meta property="og:image:height" content="'.esc_attr($default_thumb['height']).'" />
<meta property="og:image" content="'.esc_url($default_thumb['url']).'" />
<meta property="twitter:image" content="'.esc_url($default_thumb['url']).'" />'."\n";
echo '<!-- /Kanews: Open Graph Meta -->'."\n";
}

/**
* Open Graph namespace
*/
add_filter('language_attributes', 'opengraph_namespace');
function opengraph_namespace( $input ){
    if( is_admin() || ( ! is_singular() && ! is_home() && ! is_front_page()) ) {
        return $input;
    }
    return $input.' prefix="og: http://ogp.me/ns#"';
}

/**
* Check Seo Plugins
*/
function check_opengraph_plugins(){

    $is_active = false;

    // Yoast SEO
    if( class_exists( 'WPSEO_Frontend' ) ){
        $yoast = get_option( 'wpseo_social' );
        if( ! empty( $yoast['opengraph'] ) ) {
            $is_active = true;
        }
    }

    // Open Graph and Twitter Card Tags
    elseif( class_exists( 'Webdados_FB' ) )
    $is_active = true;

    // Rank Math SEO
    elseif( function_exists('rank_math') )
    $is_active = true;

    return $is_active;
}

if ( ! function_exists( 'kanews_get_request_param' ) ) {
/**
 * Safely retrieve request parameter (GET/query_var)
 *
 * @param string $key     Parameter key.
 * @param mixed  $default Default value.
 *
 * @return string
 */
function kanews_get_request_param( $key, $default = '' ) {
    if ( isset( $_GET[ $key ] ) && $_GET[ $key ] !== '' && $_GET[ $key ] !== 'null' ) {
        return sanitize_text_field( wp_unslash( $_GET[ $key ] ) );
    }

    $query_var = get_query_var( $key );
    if ( ! empty( $query_var ) && $query_var !== 'null' ) {
        return sanitize_text_field( wp_unslash( $query_var ) );
    }

    return $default;
}
}

if ( ! function_exists( 'kanews_get_turkish_date_string' ) ) {
/**
 * Get Turkish formatted date string (fallback if helper not defined elsewhere)
 *
 * @return string
 */
function kanews_get_turkish_date_string() {
    if ( function_exists( 'kanews_get_turkish_date' ) ) {
        return kanews_get_turkish_date();
    }

    $timezone = new DateTimeZone( 'Europe/Istanbul' );
    $date = new DateTime( 'now', $timezone );

    if ( class_exists( 'IntlDateFormatter' ) ) {
        $formatter = new IntlDateFormatter( 'tr_TR', IntlDateFormatter::LONG, IntlDateFormatter::NONE, $timezone );
        return $formatter->format( $date );
    }

    $day_num = $date->format( 'j' );
    $month_num = (int) $date->format( 'n' );
    $year_num = $date->format( 'Y' );
    $weekday_num = (int) $date->format( 'w' ); // 0 (Sunday) to 6 (Saturday)

    $months = [ '', 'Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık' ];
    $weekdays = [ 'Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi' ];

    return $day_num . ' ' . $months[ $month_num ] . ' ' . $year_num . ', ' . $weekdays[ $weekday_num ];
}
}