<?php
/**
 * Template Name: Haber Bültenleri
 * Description: Günün üç haber bültenini KAI'den otomatik gösterir.
 *
 * @package Kanews
 */

get_header();

$eyebrow     = \Kanews\Kai\Support\Options::get('kai-audio-hero-eyebrow', get_bloginfo('name'));
$hero_title  = \Kanews\Kai\Support\Options::get('kai-audio-hero-title', 'KAI Haber Bülteni');
$hero_desc   = \Kanews\Kai\Support\Options::get('kai-audio-hero-description', 'Günün kritik başlıklarını KAI üç farklı zaman diliminde haber bültenine dönüştürür. Kulaklığınızı takın, gündemi dakikalar içinde yakalayın.');
?>
<main id="primary" class="site-main kai-audio-page">
    <header class="kai-audio-page__hero" style="margin-top: -20px">
        <div class="container">
            <div class="kai-audio-page__hero-content">
                <p class="kai-audio-page__eyebrow"><?php echo esc_html($eyebrow); ?></p>
                <h1 class="kai-audio-page__title"><?php echo esc_html($hero_title); ?></h1>
                <p class="kai-audio-page__description"><?php echo esc_html($hero_desc); ?></p>
            </div>
        </div>
    </header>

    <section class="kai-audio-page__grid">
        <div class="container">
            <?php
            echo do_shortcode('[kai_audio_briefings limit="12"]');
            ?>
        </div>
    </section>
</main>

<?php

get_footer();

