<?php
/**
 * Template Name: Puan Durumu
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Puan Durumu', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$default_league = kanews_get_option('league-default', 'super-lig');
if ($default_league == 'spor-toto-super-lig') {
  $default_league = 'super-lig';
}
$lig = isset($_GET['lig']) ? esc_html($_GET['lig']) : $default_league;
$leagues = [
  'super-lig',
  'almanya-bundesliga',
  'ingiltere-premier-ligi',
  'italya-serie-a',
  'fransa-ligue-1',
  'ispanya-la-liga',
  'tff-1-lig',
  'euroleague',
  'erkek-basketbol',
  'kadin-basketbol',
  'efeler-ligi',
  'sampiyonlar-ligi',
  'avrupa-ligi',
  'konferans-ligi',
  'sultanlar-ligi'
];

$leagues = kanews_get_option('league-standings', $leagues);
if (($key = array_search('spor-toto-super-lig', $leagues)) !== false) {
    $leagues[$key] = 'super-lig';
}


$active = ''; $active2 = ''; $active3 = ''; $active4 = ''; $active5 = ''; $active6 = ''; $active7 = ''; $active8 = ''; $active9 = ''; $active10 = ''; $active11 = ''; $active12 = ''; $active13 = ''; $active14 = ''; $active15 = '';
if( in_array($lig, $leagues)) {
switch($lig) {
  case 'super-lig':
    $active = 'active';
  break;
  case 'almanya-bundesliga':
    $active2 = 'active';
  break;
  case 'ingiltere-premier-ligi':
    $active3 = 'active';
  break;
  case 'italya-serie-a':
    $active4 = 'active';
  break;
  case 'fransa-ligue-1':
    $active5 = 'active';
  break;
  case 'ispanya-la-liga':
    $active6 = 'active';
  break;
  case 'tff-1-lig':
    $active7 = 'active';
    break;
  case 'euroleague':
    $active8 = 'active';
    break;
  case 'erkek-basketbol':
    $active9 = 'active';
    break;
  case 'kadin-basketbol':
    $active10 = 'active';
  break;
  case 'efeler-ligi':
    $active11 = 'active';
    break;
  case 'sampiyonlar-ligi':
    $active13 = 'active';
    break;
  case 'avrupa-ligi':
    $active14 = 'active';
    break;
  case 'konferans-ligi':
    $active15 = 'active';
    break;
  case 'sultanlar-ligi':
    $active12 = 'active';
  break;
  
  default:
  wp_redirect( get_the_permalink(), 301);
  die;
    break;
  }
} else {
  wp_redirect( get_the_permalink(), 301);
  die;
}

$lig_title = str_replace("-", " ", $lig);
if( $lig_title == 'super lig' ) {
  $lig_title = 'Trendyol Süper Lig';
}
$new_title = wp_sprintf( __('%1$s Puan Durumu', 'kanews'), ucwords($lig_title)).' - '.get_bloginfo("name");

add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );
function generate_custom_title($title) {
  global $new_title;
  $title = $new_title;
  return $title;  
}


get_header(); ?>
  <?php while ( have_posts() ) : the_post(); ?>
    <?php kanews_page_header($post->ID, explode(' - ', $new_title)[0]); ?>
  <?php endwhile; ?>

  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">

        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
          <div class="col-12">
            <?php 
            $api  =  new SuperLigStandings();
            $simpleStandings  =  $api->getStandings($lig);
            ?>

          <div class="kanews-section mt-1">
            <div class="kanews-tab">
              <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0">
              <?php if( in_array('super-lig', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'super-lig', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active; ?>"><?php _e('Süper Lig', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('almanya-bundesliga', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'almanya-bundesliga', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active2; ?>"><?php _e('Bundesliga', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('ingiltere-premier-ligi', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'ingiltere-premier-ligi', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active3; ?>"><?php _e('Premier Lig', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('italya-serie-a', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'italya-serie-a', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active4; ?>"><?php _e('Serie A', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('fransa-ligue-1', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'fransa-ligue-1', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active5; ?>"><?php _e('Ligue 1', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('ispanya-la-liga', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'ispanya-la-liga', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active6; ?>"><?php _e('La Liga', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('tff-1-lig', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'tff-1-lig', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active7; ?>"><?php _e('TFF 1. Lig', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('euroleague', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'euroleague', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active8; ?>"><?php _e('Euroleague', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('erkek-basketbol', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'erkek-basketbol', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active9; ?>"><?php _e('Erkek Basket', 'kanews'); ?></a></li>
              <?php endif; ?>
              <?php if( in_array('kadin-basketbol', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'kadin-basketbol', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active10; ?>"><?php _e('Kadın Basket', 'kanews'); ?></a></li>
              <?php endif; ?>
                <?php if( in_array('efeler-ligi', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'efeler-ligi', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active11; ?>"><?php _e('Efeler Ligi', 'kanews'); ?></a></li>
              <?php endif; ?>
                <?php if( in_array('sultanlar-ligi', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'sultanlar-ligi', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active12; ?>"><?php _e('Sultanlar Ligi', 'kanews'); ?></a></li>
              <?php endif; ?>
                <?php if( in_array('sampiyonlar-ligi', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'sampiyonlar-ligi', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active13; ?>"><?php _e('Şampiyonlar Ligi', 'kanews'); ?></a></li>
              <?php endif; ?>
                <?php if( in_array('avrupa-ligi', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'avrupa-ligi', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active14; ?>"><?php _e('Avrupa Ligi', 'kanews'); ?></a></li>
              <?php endif; ?>
                <?php if( in_array('konferans-ligi', $leagues)): ?>
                <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'lig', 'konferans-ligi', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $active15; ?>"><?php _e('Konferans Ligi', 'kanews'); ?></a></li>
              <?php endif; ?>
              </ul>
            </div>
            <div class="tab-content">
              <div class="tab-pane fade show active">
                <div class="kanews-table-2 kanews-table-standing">
                  <div class="kanews-table-heading d-flex align-items-center">
                    <div class="kanews-table-item w-40"></div>
                    <div class="kanews-table-item col"><?php esc_html_e( 'Takım Adı', 'kanews' ); ?></div>
                    <div class="kanews-table-item w-40">O</div>
                    <div class="kanews-table-item w-40">G</div>
                    <?php if( $lig != 'efeler-ligi' && $lig != 'sultanlar-ligi' && $lig != 'erkek-basketbol' && $lig != 'euroleague' && $lig != 'kadin-basketbol' ): ?>
                    <div class="kanews-table-item w-40">B</div>
                    <?php endif; ?>
                    <div class="kanews-table-item w-40">M</div>
                    <?php if( $lig != 'efeler-ligi' && $lig != 'sultanlar-ligi' && $lig != 'erkek-basketbol' && $lig != 'euroleague' && $lig != 'kadin-basketbol' ): ?>
                    <div class="kanews-table-item w-40 hidden-mobile">AG</div>
                    <?php else: ?>
                    <div class="kanews-table-item w-40 hidden-mobile">AS</div>
                    <?php endif; ?>
                    <?php if( $lig != 'efeler-ligi' && $lig != 'sultanlar-ligi' && $lig != 'erkek-basketbol' && $lig != 'euroleague' && $lig != 'kadin-basketbol' ): ?>
                    <div class="kanews-table-item w-40 hidden-mobile">YG</div>
                    <?php else: ?>
                    <div class="kanews-table-item w-40 hidden-mobile">YS</div>
                    <?php endif; ?>
                    <div class="kanews-table-item w-40 hidden-mobile">AV</div>
                    <div class="kanews-table-item w-40">P</div>
                    <?php if( $lig != 'efeler-ligi' && $lig != 'sultanlar-ligi' && $lig != 'erkek-basketbol' && $lig != 'euroleague' && $lig != 'kadin-basketbol' ): ?>
                    <div class="kanews-table-item w-100 col-auto hidden-mobile">Form</div>
                    <?php endif; ?>

                  </div>
                  <div class="kanews-table-content d-flex flex-wrap no-gutters">
                  <?php 
                    if(!empty($simpleStandings)) {
                      foreach ($simpleStandings as $team) {
                        $delta = '';
                        if($team->delta <= -1)
                        $delta = '<em class="icon-caret icon-3x color-success"></em>';
                        elseif($team->delta >= 1)
                        $delta = '<em class="icon-caret icon-3x icon-180deg color-danger"></em>';
                        echo '<div class="kanews-table-wrap col-12 d-flex align-items-center">';
                          if($team->position_status)
                          echo '<div aria-label="'.$team->position_status.'" role="tooltip" data-microtip-position="right" class="kanews-table-item w-40">'. $team->position. '</div>';
                          else
                          echo '<div class="kanews-table-item w-40">'. $team->position. '</div>';
                          if($team->logo) {
                            $nextMatchInfo = '';
                            if(isset($team->nextMatch) && $team->nextMatch) {
                              $homeTeamName = isset($team->nextMatch->homeTeam->name) ? $team->nextMatch->homeTeam->name : '';
                              $awayTeamName = isset($team->nextMatch->awayTeam->name) ? $team->nextMatch->awayTeam->name : '';
                              $matchDate = isset($team->nextMatch->date) ? $team->nextMatch->date : '';
                              
                              if($homeTeamName && $awayTeamName && $matchDate) {
                                $nextMatchInfo = ' data-microtip-position="right" role="tooltip" aria-label="Sonraki Maç: ' . 
                                  $homeTeamName . ' vs ' . $awayTeamName . 
                                  ' (' . $matchDate . ')"';
                              }
                            }
                            echo '<div class="kanews-table-item col"><img src="'.kanews_lazyload_placeholder('1e1').'" class="kanews-lazy" data-src="'.$team->logo.'" width="18" height="18" alt="logo" /> <span class="hidden-mobile"'.$nextMatchInfo.'>'.$team->name.$delta. '</span><span class="hidden-desktop"'.$nextMatchInfo.'>'.$team->middleName.'</span></div>';
                          } else {
                            $nextMatchInfo = '';
                            if(isset($team->nextMatch) && $team->nextMatch) {
                              $homeTeamName = isset($team->nextMatch->homeTeam->name) ? $team->nextMatch->homeTeam->name : '';
                              $awayTeamName = isset($team->nextMatch->awayTeam->name) ? $team->nextMatch->awayTeam->name : '';
                              $matchDate = isset($team->nextMatch->date) ? $team->nextMatch->date : '';
                              
                              if($homeTeamName && $awayTeamName && $matchDate) {
                                $nextMatchInfo = ' data-microtip-position="right" role="tooltip" aria-label="Sonraki Maç: ' . 
                                  $homeTeamName . ' vs ' . $awayTeamName . 
                                  ' (' . $matchDate . ')"';
                              }
                            }
                            echo '<div class="kanews-table-item col"><span class="hidden-mobile"'.$nextMatchInfo.'>'.$team->name. '</span><span class="hidden-desktop"'.$nextMatchInfo.'>'.$team->middleName.'</span></div>';
                          }
                          echo '<div class="kanews-table-item w-40">'. $team->played . '</div>';
                          echo '<div class="kanews-table-item w-40 ">'.$team->won . '</div>';
                          if( $lig != 'efeler-ligi' && $lig != 'sultanlar-ligi' && $lig != 'erkek-basketbol' && $lig != 'euroleague' && $lig != 'kadin-basketbol' )
                          echo '<div class="kanews-table-item w-40">'. $team->drawn. '</div>';
                          echo '<div class="kanews-table-item w-40 ">'. $team->lost . '</div>';
                          echo '<div class="kanews-table-item w-40 hidden-mobile">'. $team->scored . '</div>';
                          echo '<div class="kanews-table-item w-40 hidden-mobile">'. $team->against . '</div>';
                          echo '<div class="kanews-table-item w-40 hidden-mobile">'. $team->average . '</div>';
                          echo '<div class="kanews-table-item w-40">'. $team->points . '</div>';

                          // Form durumu
                          if( $lig != 'efeler-ligi' && $lig != 'sultanlar-ligi' && $lig != 'erkek-basketbol' && $lig != 'euroleague' && $lig != 'kadin-basketbol' ) {
                            echo '<div class="kanews-table-item col-auto hidden-mobile w-100">';
                              foreach($team->formStatus as $game) {
                                if($game->statusType == 1)
                                echo '<span aria-label="Galibiyet" role="tooltip" data-microtip-position="top" class="form-status bg-success"><i>✓</i></span>';
                                elseif($game->statusType == -1)
                                echo '<span aria-label="Mağlubiyet" role="tooltip" data-microtip-position="top" class="form-status bg-danger"><i>✕</i></span>';
                                elseif($game->statusType == -2)
                                echo '<span aria-label="Veri Yok" role="tooltip" data-microtip-position="top" class="form-status" style="background-color: #999;"><i>?</i></span>';
                                else
                                echo '<span aria-label="Beraberlik" role="tooltip" data-microtip-position="top" class="form-status bg-dark"><i>-</i></span>';
                              }
                            echo '</div>';
                          }


                        echo '</div>';
                      } 
                    } else {
                      echo '<p>'.esc_html__( ('Veri alınamadı!'), 'kanews' ).'</p>';
                    }
                    
                    ?>
                  </div>
                </div>

              </div>
            </div>
            </div>
          </div>

          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          <?php endwhile; ?>

          <div class="col-12">
            <?php get_template_part('template-parts/content/components/related', 'page2', array( 
              'posts_per_page' => 20,
              's' => sanitize_text_field(str_replace('-', ' ', $lig))
            ) ); ?>
          </div>

        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>
      </div>
    </div>
  </main>
<?php get_footer();