<?php
/**
 * Template Name: Abonelik Tanıtım
 * @url kanthemes.com
 */
__( 'Abonelik Tanıtım', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header(); ?>


<main id="main" class="site-main">
  <div class="container">
    <div class="row align-items-center mt-3 mb-3">

    <div class="col-12 col-lg-6">
    <h1 class="kanews-page-title"><?php the_title(); ?></h1>
    <p class="kanews-page-subtitle"><?php echo kanews_translate('subscrion-plan-text', esc_html__( 'Reklamsız bir deneyim için, premium içeriklere erişebilmek için hemen planını seç ve bir premium başlat.', 'kanews' )); ?></p>

    <?php if(kanews_get_option('subscription-faq') != ''): ?>
          <div id="accordion-faq" class="accordion mt-3">
            <h2 class="mb-1"><?php esc_html_e( 'Sıkça Sorulan Sorular', 'kanews' ); ?></h2>
            <?php $counter = 0; foreach(kanews_get_option('subscription-faq') as $faq): $counter++; ?>
              <div class="collapse-item">
                <div class="collapse-item-header" id="accordion-faq-<?php echo $counter; ?>">
                  <button class="collapsed collapse-btn" data-toggle="collapse" data-target="#accordion-faq-<?php echo $counter; ?>a" aria-expanded="true" aria-controls="accordion-faq-<?php echo $counter; ?>a">
                    <h3><?php echo $faq['title']; ?></h3>
                  </button>
                </div>
                <div id="accordion-faq-<?php echo $counter; ?>a" class="collapse" aria-labelledby="accordion-faq-<?php echo $counter; ?>" data-parent="#accordion-faq">
                  <div class="collapse-item-body">
                    <p><?php echo $faq['content']; ?></p>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
 
      <?php endif; ?>
    </div>
    <div class="col-12 col-lg-6">

      <?php 
			if(class_exists( 'WooCommerce' )):
      $args = array( 
        'status' => 'publish', 
      );
      $products = wc_get_products($args); 
      $products  = wc_products_array_orderby( $products, 'price', 'ASC' ); ?>
      <div class="kanews-pricing-row">
        <div class="kanews-pricing-heading">
          <svg style="margin-right:8px" width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M10.0072 2.10365C8.60556 1.64993 7.08193 2.28104 6.41168 3.59294L5.6059 5.17011C5.51016 5.35751 5.35775 5.50992 5.17036 5.60566L3.59318 6.41144C2.28128 7.08169 1.65018 8.60532 2.10389 10.0069L2.64935 11.6919C2.71416 11.8921 2.71416 12.1077 2.64935 12.3079L2.10389 13.9929C1.65018 15.3945 2.28129 16.9181 3.59318 17.5883L5.17036 18.3941C5.35775 18.4899 5.51016 18.6423 5.6059 18.8297L6.41169 20.4068C7.08194 21.7187 8.60556 22.3498 10.0072 21.8961L11.6922 21.3507C11.8924 21.2859 12.1079 21.2859 12.3081 21.3507L13.9931 21.8961C15.3947 22.3498 16.9183 21.7187 17.5886 20.4068L18.3944 18.8297C18.4901 18.6423 18.6425 18.4899 18.8299 18.3941L20.4071 17.5883C21.719 16.9181 22.3501 15.3945 21.8964 13.9929L21.3509 12.3079C21.2861 12.1077 21.2861 11.8921 21.3509 11.6919L21.8964 10.0069C22.3501 8.60531 21.719 7.08169 20.4071 6.41144L18.8299 5.60566C18.6425 5.50992 18.4901 5.3575 18.3944 5.17011L17.5886 3.59294C16.9183 2.28104 15.3947 1.64993 13.9931 2.10365L12.3081 2.6491C12.1079 2.71391 11.8924 2.71391 11.6922 2.6491L10.0072 2.10365ZM8.19271 4.50286C8.41612 4.06556 8.924 3.8552 9.39119 4.00643L11.0762 4.55189C11.6768 4.74632 12.3235 4.74632 12.9241 4.55189L14.6091 4.00643C15.0763 3.8552 15.5841 4.06556 15.8076 4.50286L16.6133 6.08004C16.9006 6.64222 17.3578 7.09946 17.92 7.38668L19.4972 8.19246C19.9345 8.41588 20.1448 8.92375 19.9936 9.39095L19.4481 11.076C19.2537 11.6766 19.2537 12.3232 19.4481 12.9238L19.9936 14.6088C20.1448 15.076 19.9345 15.5839 19.4972 15.8073L17.92 16.6131C17.3578 16.9003 16.9006 17.3576 16.6133 17.9197L15.8076 19.4969C15.5841 19.9342 15.0763 20.1446 14.6091 19.9933L12.9241 19.4479C12.3235 19.2535 11.6768 19.2535 11.0762 19.4479L9.3912 19.9933C8.924 20.1446 8.41612 19.9342 8.19271 19.4969L7.38692 17.9197C7.09971 17.3576 6.64246 16.9003 6.08028 16.6131L4.50311 15.8073C4.06581 15.5839 3.85544 15.076 4.00668 14.6088L4.55213 12.9238C4.74656 12.3232 4.74656 11.6766 4.55213 11.076L4.00668 9.39095C3.85544 8.92375 4.06581 8.41588 4.50311 8.19246L6.08028 7.38668C6.64246 7.09946 7.09971 6.64222 7.38692 6.08004L8.19271 4.50286ZM6.75972 11.7573L11.0023 15.9999L18.0734 8.92885L16.6592 7.51464L11.0023 13.1715L8.17394 10.343L6.75972 11.7573Z"></path></svg>
          <?php esc_html_e( 'Paketinizi Belirleyin ve hemen aboneliğinizi başlatın', 'geo' ); ?>
        </div>
        <?php foreach ( $products as $product ){
          if(get_post_meta ( $product->get_id() , 'kanews_insights' , true  ) != '0' && get_post_meta ( $product->get_id() , 'kanews_insights' , true  ) != '' && $product->get_price_html() ) {
          switch(get_post_meta ( $product->get_id() , 'kanews_insights' , true  )) {
            case 'weekly':
              $expired = esc_html__( '1 Haftalık', 'kanews' );
            break;
            case 'monthly':
              $expired = esc_html__( '1 Aylık', 'kanews' );
            break;
            case 'six_months':
              $expired = esc_html__( '6 Aylık', 'geo' );
            break;
            case 'three_months':
              $expired = esc_html__( '3 Aylık', 'geo' );
            break;
            case 'yearly':
              $expired = esc_html__( '1 Yıllık', 'kanews' );
            break;
            case 'forever':
              $expired = esc_html__( 'Ömür Boyu', 'kanews' );
            break;
          }
          ?>
            <div class="kanews-pricing" data-product-id="<?php echo $product->get_id(); ?>">
              
              <div class="kanews-pricing-content">
                
                <div class="d-flex justify-content-between">
                  
                  <div class="d-flex align-items-center">
                    <div class="kanews-pricing-checkbox"></div>
                    <div>
                    <h2 class="kanews-pricing-title"><?php echo $product->get_name(); ?></h2>
                    
                    </div>
                  </div>
                  
                  <div>
                  <div class="price"><?php echo $product->get_price_html(); ?></div>
                  <div class="expired"><?php echo $expired; ?></div>
                  </div>
                </div>
                <?php if($product->get_short_description() != '') :?>
                      <h3 class="kanews-pricing-desc">
                        <?php echo $product->get_short_description(); ?>
                      </h3>
                    <?php endif; ?>
              </div>
              <div class="kanews-pricing-expand">
              <?php if($product->get_description() != '') :?>
                      <h3 class="kanews-pricing-desc">
                        <?php echo $product->get_description(); ?>
                      </h3>
                    <?php endif; ?>
              </div>
              

            </div>
        
        <?php }} ?>


      </div>

      <?php endif; ?>

      <button id="continue-subs" class="kanews-btn kanews-btn-block bg-success"><?php _e('Abonelik Başlat', 'kanews'); ?></button>

      <script>
// Tüm kanews-pricing divlerini seç
const pricingDivs = document.querySelectorAll('.kanews-pricing');
const continueButton = document.getElementById('continue-subs');

// Her bir pricingDiv için click event listener ekle
pricingDivs.forEach(div => {
  div.addEventListener('click', () => {
    // Önce tüm divlerden 'selected' sınıfını kaldır
    pricingDivs.forEach(d => d.classList.remove('selected'));

    // Tıklanan div'e 'selected' sınıfını ekle
    div.classList.add('selected');

    // data-product-id değerini al ve butona ekle
    const productId = div.getAttribute('data-product-id');
    continueButton.setAttribute('data-product-id', productId);
  });
});

// Butona tıklandığında ürünü sepete ekle ve sepete yönlendir
continueButton.addEventListener('click', () => {
  // Butonun data-product-id'sini al
  const productId = continueButton.getAttribute('data-product-id');
  if (productId) {
    // ?add-to-cart= parametresiyle sepete ekle ve yönlendir
    window.location.href = `?add-to-cart=${productId}`;
  } else {
    alert('Lütfen bir seçenek seçin!');
  }
});


      </script>
      </div>

      <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12 mt-2">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
         
                </div>
              </div>
            <?php endif; ?>
          <?php endwhile; ?>

    </div>
  </div>
</main>
<?php get_footer();