<?php
/**
 * Template Name: Trafik Durumu 
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Trafik Durumu', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

$sehir = isset($_GET['sehir']) ? esc_html($_GET['sehir']) : kanews_get_option('traffic-city', 'İstanbul');
$plaka = kanews_get_plaka($sehir)-1;
$sehirler_json = '[{"plaka": 1, "il_adi": "ADANA", "lat": 37, "lon": 35.3213333, "northeast_lat": 37.072004, "northeast_lon": 35.461995, "southwest_lat": 36.935523, "southwest_lon": 35.174706},{"plaka": 2, "il_adi": "ADIYAMAN", "lat": 37.7641667, "lon": 38.2761667, "northeast_lat": 37.825667, "northeast_lon": 38.335465, "southwest_lat": 37.717086, "southwest_lon": 38.188188},{"plaka": 3, "il_adi": "AFYONKARAHİSAR", "lat": 38.76376, "lon": 30.54034, "northeast_lat": 38.802105, "northeast_lon": 30.611167, "southwest_lat": 38.714289, "southwest_lon": 30.44232},{"plaka": 4, "il_adi": "AĞRI", "lat": 39.7216667, "lon": 43.0566667, "northeast_lat": 39.748605, "northeast_lon": 43.085241, "southwest_lat": 39.688144, "southwest_lon": 43.001778},{"plaka": 5, "il_adi": "AMASYA", "lat": 40.65, "lon": 35.8333333, "northeast_lat": 40.672834, "northeast_lon": 35.856321, "southwest_lat": 40.636911, "southwest_lon": 35.789091},{"plaka": 6, "il_adi": "ANKARA", "lat": 39.92077, "lon": 32.85411, "northeast_lat": 40.100981, "northeast_lon": 33.024866, "southwest_lat": 39.722821, "southwest_lon": 32.499097},{"plaka": 7, "il_adi": "ANTALYA", "lat": 36.88414, "lon": 30.70563, "northeast_lat": 36.975178, "northeast_lon": 30.840953, "southwest_lat": 36.785866, "southwest_lon": 30.516095},{"plaka": 8, "il_adi": "ARTVİN", "lat": 41.1833333, "lon": 41.8166667, "northeast_lat": 41.207078, "northeast_lon": 41.854799, "southwest_lat": 41.155415, "southwest_lon": 41.777361},{"plaka": 9, "il_adi": "AYDIN", "lat": 37.8444, "lon": 27.8458, "northeast_lat": 37.870997, "northeast_lon": 27.885355, "southwest_lat": 37.819573, "southwest_lon": 27.790522},{"plaka": 10, "il_adi": "BALIKESİR", "lat": 39.648369, "lon": 27.88261, "northeast_lat": 39.693666, "northeast_lon": 27.95241, "southwest_lat": 39.612411, "southwest_lon": 27.838313},{"plaka": 11, "il_adi": "BİLECİK", "lat": 40.150131, "lon": 29.983061, "northeast_lat": 40.197617, "northeast_lon": 30.013592, "southwest_lat": 40.106243, "southwest_lon": 29.956657},{"plaka": 12, "il_adi": "BİNGÖL", "lat": 38.885349, "lon": 40.498291, "northeast_lat": 38.897963, "northeast_lon": 40.525929, "southwest_lat": 38.872987, "southwest_lon": 40.477258},{"plaka": 13, "il_adi": "BİTLİS", "lat": 38.4, "lon": 42.1166667, "northeast_lat": 38.453638, "northeast_lon": 42.148879, "southwest_lat": 38.385312, "southwest_lon": 42.09384},{"plaka": 14, "il_adi": "BOLU", "lat": 40.739479, "lon": 31.611561, "northeast_lat": 40.758004, "northeast_lon": 31.658418, "southwest_lat": 40.716802, "southwest_lon": 31.573324},{"plaka": 15, "il_adi": "BURDUR", "lat": 37.726909, "lon": 30.288876, "northeast_lat": 37.76375, "northeast_lon": 30.336662, "southwest_lat": 37.691433, "southwest_lon": 30.191757},{"plaka": 16, "il_adi": "BURSA", "lat": 40.18257, "lon": 29.06687, "northeast_lat": 40.297194, "northeast_lon": 29.211237, "southwest_lat": 40.162997, "southwest_lon": 28.85963},{"plaka": 17, "il_adi": "ÇANAKKALE", "lat": 40.155312, "lon": 26.41416, "northeast_lat": 40.199462, "northeast_lon": 26.457106, "southwest_lat": 40.088086, "southwest_lon": 26.378026},{"plaka": 18, "il_adi": "ÇANKIRI", "lat": 40.6, "lon": 33.6166667, "northeast_lat": 40.655159, "northeast_lon": 33.684853, "southwest_lat": 40.557709, "southwest_lon": 33.596571},{"plaka": 19, "il_adi": "ÇORUM", "lat": 40.5505556, "lon": 34.9555556, "northeast_lat": 40.609317, "northeast_lon": 35.006438, "southwest_lat": 40.495214, "southwest_lon": 34.887634},{"plaka": 20, "il_adi": "DENİZLİ", "lat": 37.77652, "lon": 29.08639, "northeast_lat": 37.847366, "northeast_lon": 29.188915, "southwest_lat": 37.716171, "southwest_lon": 28.981373},{"plaka": 21, "il_adi": "DİYARBAKIR", "lat": 37.91441, "lon": 40.230629, "northeast_lat": 37.976174, "northeast_lon": 40.245803, "southwest_lat": 37.879624, "southwest_lon": 40.106159},{"plaka": 22, "il_adi": "EDİRNE", "lat": 41.6666667, "lon": 26.5666667, "northeast_lat": 41.697939, "northeast_lon": 26.603093, "southwest_lat": 41.649935, "southwest_lon": 26.514059},{"plaka": 23, "il_adi": "ELAZIĞ", "lat": 38.680969, "lon": 39.226398, "northeast_lat": 38.713568, "northeast_lon": 39.277314, "southwest_lat": 38.630564, "southwest_lon": 39.133405},{"plaka": 24, "il_adi": "ERZİNCAN", "lat": 39.75, "lon": 39.5, "northeast_lat": 39.769164, "northeast_lon": 39.531743, "southwest_lat": 39.729884, "southwest_lon": 39.460253},{"plaka": 25, "il_adi": "ERZURUM", "lat": 39.9043189, "lon": 41.2678853, "northeast_lat": 39.954533, "northeast_lon": 41.303594, "southwest_lat": 39.866715, "southwest_lon": 41.177093},{"plaka": 26, "il_adi": "ESKİŞEHİR", "lat": 39.784302, "lon": 30.51922, "northeast_lat": 39.816793, "northeast_lon": 30.66769, "southwest_lat": 39.724752, "southwest_lon": 30.414084},{"plaka": 27, "il_adi": "GAZİANTEP", "lat": 37.06622, "lon": 37.38332, "northeast_lat": 37.113722, "northeast_lon": 37.466958, "southwest_lat": 37.005947, "southwest_lon": 37.303709},{"plaka": 28, "il_adi": "GİRESUN", "lat": 40.912811, "lon": 38.38953, "northeast_lat": 40.927995, "northeast_lon": 38.450044, "southwest_lat": 40.877876, "southwest_lon": 38.309018},{"plaka": 29, "il_adi": "GÜMÜŞHANE", "lat": 40.4602778, "lon": 39.4813889, "northeast_lat": 40.471359, "northeast_lon": 39.520641, "southwest_lat": 40.430201, "southwest_lon": 39.446914},{"plaka": 30, "il_adi": "HAKKARİ", "lat": 37.5833333, "lon": 43.7333333, "northeast_lat": 37.601656, "northeast_lon": 43.762257, "southwest_lat": 37.551549, "southwest_lon": 43.69809},{"plaka": 31, "il_adi": "HATAY", "lat": 36.4018488, "lon": 36.3498097, "northeast_lat": 37.014921, "northeast_lon": 36.697535, "southwest_lat": 35.812692, "southwest_lon": 35.779375},{"plaka": 32, "il_adi": "ISPARTA", "lat": 37.7666667, "lon": 30.55, "northeast_lat": 37.830719, "northeast_lon": 30.609197, "southwest_lat": 37.73988, "southwest_lon": 30.503673},{"plaka": 33, "il_adi": "MERSİN(İÇEL)", "lat": 36.8, "lon": 34.6333333, "northeast_lat": 36.878272, "northeast_lon": 34.716702, "southwest_lat": 36.699503, "southwest_lon": 34.457655},{"plaka": 34, "il_adi": "İSTANBUL", "lat": 41.00527, "lon": 28.97696, "northeast_lat": 41.320786, "northeast_lon": 29.456456, "southwest_lat": 40.80275, "southwest_lon": 27.971307},{"plaka": 35, "il_adi": "İZMİR", "lat": 38.41885, "lon": 27.12872, "northeast_lat": 38.506773, "northeast_lon": 27.304415, "southwest_lat": 38.343157, "southwest_lon": 27.017192},{"plaka": 36, "il_adi": "KARS", "lat": 40.59267, "lon": 43.077831, "northeast_lat": 40.624843, "northeast_lon": 43.1339, "southwest_lat": 40.577484, "southwest_lon": 43.056432},{"plaka": 37, "il_adi": "KASTAMONU", "lat": 41.38871, "lon": 33.78273, "northeast_lat": 41.436059, "northeast_lon": 33.814989, "southwest_lat": 41.350668, "southwest_lon": 33.752901},{"plaka": 38, "il_adi": "KAYSERİ", "lat": 38.7333333, "lon": 35.4833333, "northeast_lat": 38.818797, "northeast_lon": 35.627675, "southwest_lat": 38.622002, "southwest_lon": 35.304324},{"plaka": 39, "il_adi": "KIRKLARELİ", "lat": 41.7333333, "lon": 27.2166667, "northeast_lat": 41.760054, "northeast_lon": 27.24222, "southwest_lat": 41.710615, "southwest_lon": 27.182843},{"plaka": 40, "il_adi": "KIRŞEHİR", "lat": 39.15, "lon": 34.1666667, "northeast_lat": 39.203939, "northeast_lon": 34.217743, "southwest_lat": 39.081293, "southwest_lon": 34.125532},{"plaka": 41, "il_adi": "KOCAELİ", "lat": 40.8532704, "lon": 29.8815203, "northeast_lat": 41.20976, "northeast_lon": 30.359684, "southwest_lat": 40.532782, "southwest_lon": 29.333462},{"plaka": 42, "il_adi": "KONYA", "lat": 37.8666667, "lon": 32.4833333, "northeast_lat": 38.05063, "northeast_lon": 32.680116, "southwest_lat": 37.719031, "southwest_lon": 32.338737},{"plaka": 43, "il_adi": "KÜTAHYA", "lat": 39.4166667, "lon": 29.9833333, "northeast_lat": 39.442718, "northeast_lon": 30.066503, "southwest_lat": 39.379473, "southwest_lon": 29.919199},{"plaka": 44, "il_adi": "MALATYA", "lat": 38.35519, "lon": 38.30946, "northeast_lat": 38.397559, "northeast_lon": 38.453244, "southwest_lat": 38.305123, "southwest_lon": 38.232622},{"plaka": 45, "il_adi": "MANİSA", "lat": 38.619099, "lon": 27.428921, "northeast_lat": 38.642289, "northeast_lon": 27.487976, "southwest_lat": 38.602376, "southwest_lon": 27.326086},{"plaka": 46, "il_adi": "KAHRAMANMARAŞ", "lat": 37.5833333, "lon": 36.9333333, "northeast_lat": 37.605261, "northeast_lon": 36.997678, "southwest_lat": 37.530309, "southwest_lon": 36.829703},{"plaka": 47, "il_adi": "MARDİN", "lat": 37.3122361, "lon": 40.735112, "northeast_lat": 37.330554, "northeast_lon": 40.764486, "southwest_lat": 37.305109, "southwest_lon": 40.716971},{"plaka": 48, "il_adi": "MUĞLA", "lat": 37.2152778, "lon": 28.3636111, "northeast_lat": 37.22581, "northeast_lon": 28.414498, "southwest_lat": 37.194651, "southwest_lon": 28.341279},{"plaka": 49, "il_adi": "MUŞ", "lat": 38.7432926, "lon": 41.5064823, "northeast_lat": 38.783503, "northeast_lon": 41.540625, "southwest_lat": 38.718224, "southwest_lon": 41.472306},{"plaka": 50, "il_adi": "NEVŞEHİR", "lat": 38.62442, "lon": 34.723969, "northeast_lat": 38.684107, "northeast_lon": 34.764759, "southwest_lat": 38.589047, "southwest_lon": 34.669752},{"plaka": 51, "il_adi": "NİĞDE", "lat": 37.9666667, "lon": 34.6833333, "northeast_lat": 37.979913, "northeast_lon": 34.691585, "southwest_lat": 37.956992, "southwest_lon": 34.661906},{"plaka": 52, "il_adi": "ORDU", "lat": 40.9833333, "lon": 37.8833333, "northeast_lat": 41.02034, "northeast_lon": 37.978976, "southwest_lat": 40.931631, "southwest_lon": 37.825992},{"plaka": 53, "il_adi": "RİZE", "lat": 41.02005, "lon": 40.523449, "northeast_lat": 41.046492, "northeast_lon": 40.586802, "southwest_lat": 41.010782, "southwest_lon": 40.478578},{"plaka": 54, "il_adi": "SAKARYA", "lat": 40.7568793, "lon": 30.378138, "northeast_lat": 40.825518, "northeast_lon": 30.439832, "southwest_lat": 40.686199, "southwest_lon": 30.322138},{"plaka": 55, "il_adi": "SAMSUN", "lat": 41.292782, "lon": 36.33128, "northeast_lat": 41.344134, "northeast_lon": 36.381205, "southwest_lat": 41.235002, "southwest_lon": 36.249519},{"plaka": 56, "il_adi": "SİİRT", "lat": 37.94429, "lon": 41.93288, "northeast_lat": 37.95594, "northeast_lon": 41.963658, "southwest_lat": 37.909671, "southwest_lon": 41.872547},{"plaka": 57, "il_adi": "SİNOP", "lat": 42.0264222, "lon": 35.1550745, "northeast_lat": 42.032135, "northeast_lon": 35.194947, "southwest_lat": 42.012675, "southwest_lon": 35.115957},{"plaka": 58, "il_adi": "SİVAS", "lat": 39.747662, "lon": 37.017879, "northeast_lat": 39.783669, "northeast_lon": 37.061673, "southwest_lat": 39.699024, "southwest_lon": 36.919858},{"plaka": 59, "il_adi": "TEKİRDAĞ", "lat": 40.9833333, "lon": 27.5166667, "northeast_lat": 40.996723, "northeast_lon": 27.600252, "southwest_lat": 40.937704, "southwest_lon": 27.468993},{"plaka": 60, "il_adi": "TOKAT", "lat": 40.3166667, "lon": 36.55, "northeast_lat": 40.358932, "northeast_lon": 36.593219, "southwest_lat": 40.267868, "southwest_lon": 36.469662},{"plaka": 61, "il_adi": "TRABZON", "lat": 41, "lon": 39.7333333, "northeast_lat": 41.01237, "northeast_lon": 39.82051, "southwest_lat": 40.955736, "southwest_lon": 39.652407},{"plaka": 62, "il_adi": "TUNCELİ", "lat": 39.1079868, "lon": 39.5401672, "northeast_lat": 39.113477, "northeast_lon": 39.55185, "southwest_lat": 39.094534, "southwest_lon": 39.530015},{"plaka": 63, "il_adi": "ŞANLIURFA", "lat": 37.15, "lon": 38.8, "northeast_lat": 37.189639, "northeast_lon": 38.840876, "southwest_lat": 37.098274, "southwest_lon": 38.767868},{"plaka": 64, "il_adi": "UŞAK", "lat": 38.682301, "lon": 29.40819, "northeast_lat": 38.71588, "northeast_lon": 29.469838, "southwest_lat": 38.630679, "southwest_lon": 29.355936},{"plaka": 65, "il_adi": "VAN", "lat": 38.4941667, "lon": 43.38, "northeast_lat": 38.580314, "northeast_lon": 43.455356, "southwest_lat": 38.42188, "southwest_lon": 43.269524},{"plaka": 66, "il_adi": "YOZGAT", "lat": 39.82, "lon": 34.8044444, "northeast_lat": 39.838423, "northeast_lon": 34.858236, "southwest_lat": 39.798968, "southwest_lon": 34.771094},{"plaka": 67, "il_adi": "ZONGULDAK", "lat": 41.456409, "lon": 31.798731, "northeast_lat": 41.480784, "northeast_lon": 31.874425, "southwest_lat": 41.425296, "southwest_lon": 31.757052},{"plaka": 68, "il_adi": "AKSARAY", "lat": 38.36869, "lon": 34.03698, "northeast_lat": 38.446724, "northeast_lon": 34.088698, "southwest_lat": 38.297012, "southwest_lon": 33.932515},{"plaka": 69, "il_adi": "BAYBURT", "lat": 40.255169, "lon": 40.22488, "northeast_lat": 40.272636, "northeast_lon": 40.238261, "southwest_lat": 40.242881, "southwest_lon": 40.208762},{"plaka": 70, "il_adi": "KARAMAN", "lat": 37.17593, "lon": 33.228748, "northeast_lat": 37.229373, "northeast_lon": 33.334244, "southwest_lat": 37.148257, "southwest_lon": 33.166003},{"plaka": 71, "il_adi": "KIRIKKALE", "lat": 39.846821, "lon": 33.515251, "northeast_lat": 39.872843, "northeast_lon": 33.597968, "southwest_lat": 39.813802, "southwest_lon": 33.468289},{"plaka": 72, "il_adi": "BATMAN", "lat": 37.881168, "lon": 41.13509, "northeast_lat": 37.947274, "northeast_lon": 41.17603, "southwest_lat": 37.85657, "southwest_lon": 41.080591},{"plaka": 73, "il_adi": "ŞIRNAK", "lat": 37.5163889, "lon": 42.4611111, "northeast_lat": 37.533572, "northeast_lon": 42.471127, "southwest_lat": 37.500093, "southwest_lon": 42.444631},{"plaka": 74, "il_adi": "BARTIN", "lat": 41.6344444, "lon": 32.3375, "northeast_lat": 41.656542, "northeast_lon": 32.37105, "southwest_lat": 41.613513, "southwest_lon": 32.297457},{"plaka": 75, "il_adi": "ARDAHAN", "lat": 41.110481, "lon": 42.702171, "northeast_lat": 41.121467, "northeast_lon": 42.717129, "southwest_lat": 41.09891, "southwest_lon": 42.686418},{"plaka": 76, "il_adi": "IĞDIR", "lat": 39.9166667, "lon": 44.0333333, "northeast_lat": 39.950163, "northeast_lon": 44.092825, "southwest_lat": 39.884109, "southwest_lon": 43.980729},{"plaka": 77, "il_adi": "YALOVA", "lat": 40.65, "lon": 29.2666667, "northeast_lat": 40.66806, "northeast_lon": 29.316536, "southwest_lat": 40.634138, "southwest_lon": 29.210233},{"plaka": 78, "il_adi": "KARABÜK", "lat": 41.2, "lon": 32.6333333, "northeast_lat": 41.238129, "northeast_lon": 32.675518, "southwest_lat": 41.163014, "southwest_lon": 32.592582},{"plaka": 79, "il_adi": "KİLİS", "lat": 36.718399, "lon": 37.12122, "northeast_lat": 36.747819, "northeast_lon": 37.159541, "southwest_lat": 36.702673, "southwest_lon": 37.085183},{"plaka": 80, "il_adi": "OSMANİYE", "lat": 37.06805, "lon": 36.261589, "northeast_lat": 37.104061, "northeast_lon": 36.287941, "southwest_lat": 37.04694, "southwest_lon": 36.208034},{"plaka": 81, "il_adi": "DÜZCE", "lat": 40.843849, "lon": 31.15654, "northeast_lat": 40.891762, "northeast_lon": 31.195807, "southwest_lat": 40.824717, "southwest_lon": 31.106662}]';
$sehirler = array_values(json_decode($sehirler_json, true));

if(!isset($sehirler[$plaka])) {
  wp_redirect( get_the_permalink(), 301);
  die;
}

$title = $sehirler[$plaka]['il_adi'];
// $title = replace_tr(strtolower($title));
// $title = ucfirst($title);
$title = sprintf(esc_html__( '%s Yol Durumu', 'kanews' ), $title);
$new_title = $title.' - '.get_bloginfo('name');

function generate_custom_title($title) {
  global $new_title;
  if($new_title)
  $title = $new_title;
  return $title;  
}
add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );
// print_r($sehirler);
get_header(); ?>
<?php while ( have_posts() ) : the_post(); ?>
  <div class="kanews-page-header">
    <div class="container">
      <div class="row align-items-center justify-space-between">
        <div class="col"><h1 class="kanews-page-title"><?php echo $title; ?></h1></div>
        <div class="col-auto">
          <div data-toggle="kanews-traffic-select-city" class="kanews-btn kanews-btn-light"><?php _e('Şehir Şeçin', 'kanews'); ?> <i class="icon-caret icon-180deg"></i></div>
          <div id="kanews-traffic-select-city" class="kanews-waether-cities kanews-scroll" style="right: 15px;left: auto">
            <?php foreach(kanews_get_sehir() as $city) {
              echo '<a class="kanews-weather-city" href="'.get_the_permalink().'?sehir='.$city.'">'.$city.'</a>';
            } ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php endwhile; ?>

  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main m-0">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
        <div class="col-12">
        <div id="kanews_yandexTraffic"></div>
        </div>

        <script src="https://api-maps.yandex.ru/2.1/?lang=tr-TR" type="text/javascript"></script>
        <script type="text/javascript">
        ymaps.ready(init);
        function init () {
          var kanews_yandexTraffic = new ymaps.Map('kanews_yandexTraffic', {
            center: [<?php echo $sehirler[$plaka]['lat'];?>, <?php echo $sehirler[$plaka]['lon']; ?>],
            zoom: 12,
            controls: ['zoomControl'],
          });
          var secondButton = new ymaps.control.Button({
            data: {
              content: "<?php echo $new_title; ?>"
            },
            options: {
              maxWidth: 375
            }
          });
          kanews_yandexTraffic.controls.add(secondButton);

          var trafficControl = new ymaps.control.TrafficControl({ state: {
            providerKey: 'traffic#actual',
            trafficShown: true
          }});
          kanews_yandexTraffic.controls.add(trafficControl);
          trafficControl.getProvider('traffic#actual').state.set('infoLayerShown', true);    
        }
        </script>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();