<?php

/**
 * Template Name: Hava Durumu 2
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Hava Durumu 2', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

$sehir = 'İstanbul';
if(!isset($_GET['sehir'])) {
  $default_city = kanews_get_option('weather-cities') ? kanews_get_option('weather-cities') : '745042';
} else {
  $sehir = isset($_GET['sehir']) ? esc_html(ucfirst( $_GET['sehir'])) : 'İstanbul';
  $seh3 = array( 'Adiyaman', 'Agri', 'Aydin', 'Balikesir', 'Bartin', 'Bingol', 'Canakkale', 'Cankiri', 'Corum', 'Diyarbakir', 'Elazig', 'Eskisehir', 'Gumushane', 'Istanbul', 'Izmir', 'Kirklareli', 'Kirsehir', 'Kutahya', 'Kahramanmaras', 'Mugla', 'Mus', 'Nevsehir', 'Nigde', 'Tekirdag', 'Sanliurfa', 'Usak', 'Kirikkale', 'Sirnak', 'Igdir', 'Karabuk', 'Duzce', 'Lefkosa', 'Gazimagusa', 'Guzelyurt', 'Iskele' );
  $sh21 = array( 'Adıyaman', 'Ağrı', 'Aydın', 'Balıkesir', 'Bartın', 'Bingöl', 'Çanakkale', 'Çankırı', 'Çorum', 'Diyarbakır', 'Elazığ', 'Eskişehir', 'Gümüşhane', 'İstanbul', 'İzmir', 'Kırklareli', 'Kırşehir', 'Kütahya', 'Kahramanmaraş', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Tekirdağ', 'Şanlıurfa', 'Uşak', 'Kırıkkale', 'Şırnak', 'Iğdır', 'Karabük', 'Düzce', 'Lefkoşa', 'Gazimağusa', 'Güzelyurt', 'İskele' );
  $sehir = str_replace( $seh3 , $sh21 , $sehir); 
  $fixedCity = ucwords(str_replace('-', ' ', $sehir));
  foreach(kanews_get_turkey_cities2() as $key => $value) {
    if($value == $fixedCity)  {
      $default_city = $key;
    }
  }
}

$city_name = ucwords(kanews_get_turkey_cities2('key', $default_city));
$plaka = kanews_get_plaka($city_name)-1;
$response = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/turkiye.json");
$data3= json_decode($response, true);

if( isset($data3['status']) && $data3['status'] == 'OK' && isset($_GET['ilce']) && !empty($_GET['ilce']) ) {
  foreach($data3['data'][$plaka]['districts'] as $key => $value) {
    if ( ( kanews_seflink($value['name']) == $_GET['ilce'] ) ) {
      $city_name =  $value['name'];
      break;
    }
  }
}

$fixedCity = ucwords(str_replace('-', ' ', $sehir));
if(!in_array($fixedCity, kanews_get_turkey_cities2())) {
  wp_redirect( get_the_permalink(), 301);
  die;
}

$new_title = sprintf(esc_html__('%s için Hava Durumu', 'kanews'), $city_name).' - '.get_bloginfo("name");
function generate_custom_title($title) {
  global $new_title;
  $title = $new_title;
  return $title;  
}

add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );

get_header(); 

// Weather widget ve tahmin için ayarları hazırla
$weather_options = [
    'city' => $city_name,
    'show_wind' => true,
    'show_humidity' => true,
    'show_pressure' => true,
    'show_min_temp' => true,
    'show_max_temp' => true,
    'show_forecast' => true,
    'forecast_days' => 6,
    'show_full_link'=> false,
    'show_dropdown' => true,
    'widget_id' => 'weather-page',
    // 'title' => 'Hava Durumu'
];

?>
<?php while ( have_posts() ) : the_post(); ?>
<?php endwhile; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main m-0 pt-1">
    <div class="container">
      <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
        <div class="row">
          <div class="col-12 mt-2">
            <div id="ilceler" class="kanews-label-group">
              <?php 
              if( isset($data3['status']) && $data3['status'] == 'OK' ) {
                if (isset($data3['data'][$plaka]['districts']) && is_array($data3['data'][$plaka]['districts'])) {
                  foreach($data3['data'][$plaka]['districts'] as $key => $value) {
                    if( $value['name'] === 'Merkez' )
                      echo '<a class="kanews-label" href="'.esc_url( get_permalink() ).'">'.$value['name'].'</a>';
                    else
                      echo '<a class="kanews-label" href="'.esc_url( add_query_arg( array('ilce' => kanews_seflink($value['name'])), kanews_get_page_link('sehir', strtolower(replace_tr(kanews_get_turkey_cities2('key', $default_city))), 'weather') )).'">'.$value['name'].'</a>';
                  }
                }
              }
              ?>
            </div>
          </div>

          <div class="col-12 mb-3">
             <?php $weather = new KANEWS_WEATHER($weather_options); ?>
          </div>

          <div class="col-12">
            <div class="kanews-section kanews-section-flat">
                <?php 
                $slick_options = [
                    'infinite' => false,
                    'slidesToShow' => 7,
                    'responsive' => [
                        ['breakpoint' => 992, 'settings' => ['slidesToShow' => 5]],
                        ['breakpoint' => 525, 'settings' => ['slidesToShow' => 4]],
                        ['breakpoint' => 425, 'settings' => ['slidesToShow' => 2]],
                    ]
                ];
                $weather->show_hourly_forecast($slick_options);
                ?>
            </div>
          </div>

          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-flat kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          <?php endwhile; ?>
        </div>
      <?php else: ?>
        <div class="row">
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        </div>
      <?php endif; ?>
    </div>
  </main>
<?php get_footer();