<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly 
wp_enqueue_script('kanews-ilan-search');
?>
<div class="col-12 col-lg-3">

  <div class="kanews-section widget_accordion_menu">
        
    <?php echo kanews_widget_title(esc_html__( 'Firma Kategorileri', 'kanews' ), 'h4'); ?>

    <?php 
      $taxonomies = get_terms( array(
        'taxonomy' => 'kategori',
        'hide_empty' => false,
        'parent' => 0 
      ) );
      if ( !is_wp_error($taxonomies) && !empty($taxonomies) ) :
      $output = '<div><ul class="widget-accordion-menu">';
      foreach( $taxonomies as $category ) {
        $children = get_terms( array(
          'parent' => $category->term_id,
          'taxonomy' => 'kategori',
          'hide_empty' => false,
        ) );
        $output.= '<li class="page_item menu-item-has-children"><a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori')).'">'. $category->name .' <i class="icon-arrow icon-180deg"></i></a>';
        if(!is_wp_error($children)) {
          $output .= '<ul class="sub-menu">';
          $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori')).'">'.esc_html__( 'Hepsi', 'kanews' ).'</a></li>';
          foreach($children as $child) {
            $output.= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, 'kategori')).'">'. $child->name;
            if($args['show_count'])
            $output.= '('.$child->count.')';
            $output.= '</a>';
          }
          $output .= '</ul>';
        }
        $output .= '</li>';
      }
      $output.='</ul></div>';
      echo $output;
      endif;
    ?>
  </div>

  <div class="kanews-section">
    <?php echo kanews_widget_title(esc_html__( 'Firma Ara', 'kanews' )); ?>
    <div class="d-flex flex-wrap p-1 justify-content-center gap-1">
      <a href="<?php echo get_post_type_archive_link('firma'); ?> " class="kanews-label kanews-label-widget text-center"><?php esc_html_e( 'Tüm Firmalar', 'kanews' ); ?></a>
      <?php if( kanews_get_option('account-page') ) : ?>
        <a href="<?php echo esc_url( get_page_link( kanews_get_option('account-page') ) ); ?>" class="kanews-label kanews-label-widget text-center"><?php esc_html_e( 'Firma Ekle', 'kanews' ); ?></a>
      <?php endif; ?>
    </div>
    <form method="GET" class="kanews-form-filter" action="<?php echo get_post_type_archive_link('firma'); ?> ">
      <div class="d-flex flex-wrap" style="padding: 1em 0">
        <div class="col-12">
          <div class="kanews-form2 mb-0">
            <input value="<?php echo isset($_GET['comp_name']) ? esc_attr($_GET['comp_name']) : ''; ?>" type="text" name="comp_name" placeholder="<?php esc_html_e( 'Firma Adı', 'kanews' ); ?>">
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2 bgw position-relative">
            <input type="text" 
                   id="firma-il-search" 
                   class="mb-0" 
                   placeholder="<?php esc_html_e( 'Ara', 'kanews' ); ?>" 
                   autocomplete="off" />
            <button type="button" class="ilan-clear-btn" id="firma-il-clear" style="display: none;">
              <i class="icon-close"></i>
            </button>
            <select id="firma-il" style="display: none;">
              <option value=""><?php esc_html_e( 'İl Seç', 'kanews' ); ?></option>
            </select>
            <input type="hidden" name="il" id="firma-il-hidden" value="" />
            <div id="firma-il-dropdown" class="ilan-dropdown" style="display: none;"></div>
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2 bgw position-relative">
            <input type="text" 
                   id="firma-ilce-search" 
                   class="mb-0" 
                   placeholder="<?php esc_html_e( 'Ara', 'kanews' ); ?>" 
                   autocomplete="off"
                   disabled />
            <button type="button" class="ilan-clear-btn" id="firma-ilce-clear" style="display: none;">
              <i class="icon-close"></i>
            </button>
            <select id="firma-ilce" style="display: none;">
              <option value=""><?php esc_html_e( 'İlçe Seç', 'kanews' ); ?></option>
            </select>
            <input type="hidden" name="ilce" id="firma-ilce-hidden" value="" />
            <div id="firma-ilce-dropdown" class="ilan-dropdown" style="display: none;"></div>
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2 mb-0">
            <?php $select_value = isset($_POST['comp_cat']) ? $_POST['comp_cat'] : ''; ?>
            <?php 
            if( $terms = get_terms( array(
              'taxonomy' => 'kategori', // to make it simple I use default categories
              'orderby' => 'name'
          ) ) ) : 
            // if categories exist, display the dropdown
            echo '<select value="'.$select_value.'" name="comp_cat"><option value="">'.esc_html__( 'Sektör', 'kanews' ).'</option>';
            foreach ( $terms as $term ) :
              echo '<option value="' . $term->term_id . '">' . $term->name . '</option>'; // ID of the category as an option value
            endforeach;
            echo '</select>';
          endif;
          ?>
          </div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="kanews-form2 mb-0">
            <select name="comp_rating_min">
              <option value=""><?php esc_html_e( 'Minumum Puan', 'kanews' ); ?></option>
              <option <?php echo $_GET['comp_rating_min'] == '1' ? 'selected="select""': ''; ?> value="1">1</option>
              <option <?php echo $_GET['comp_rating_min'] == '2' ? 'selected="select""': ''; ?>  value="2">2</option>
              <option <?php echo $_GET['comp_rating_min'] == '3' ? 'selected="select""': ''; ?>  value="3">3</option>
              <option <?php echo $_GET['comp_rating_min'] == '4' ? 'selected="select""': ''; ?>  value="4">4</option>
              <option <?php echo $_GET['comp_rating_min'] == '5' ? 'selected="select"': ''; ?>  value="5">5</option>
            </select>
          </div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="kanews-form2 mb-0">
            <select name="comp_rating_max">
              <option value=""><?php esc_html_e( 'Maksimum Puan', 'kanews' ); ?></option>
              <option <?php echo $_GET['comp_rating_max'] == '1' ? 'selected="select""': ''; ?> value="1">1</option>
              <option <?php echo $_GET['comp_rating_max'] == '2' ? 'selected="select""': ''; ?>  value="2">2</option>
              <option <?php echo $_GET['comp_rating_max'] == '3' ? 'selected="select""': ''; ?>  value="3">3</option>
              <option <?php echo $_GET['comp_rating_max'] == '4' ? 'selected="select""': ''; ?>  value="4">4</option>
              <option <?php echo $_GET['comp_rating_max'] == '5' ? 'selected="select"': ''; ?>  value="5">5</option>
            </select>
          </div>
        </div>
        <div class="col-12">
          <button type="submit" class="kanews-btn kanews-btn-block m-0 kanews-btn-sm"><?php esc_html_e( 'Ara', 'kanews' ); ?></button>
        </div>
      </div>
    </form>
  </div>

  <div class="kanews-section">
    <div class="kanews-icon-box">
      <div class="kanews-icon-box-header">
        <i class="icon-star"></i>
      </div>
      
      <div class="kanews-icon-box-content p-1 gap-1 d-flex flex-column align-items-center">
        <h4><?php esc_html_e( 'Firma Ekle', 'kanews' ); ?></h4>
        <p><?php esc_html_e( 'Tamamen ücretsiz olarak firmanı rehberimize ekleyebilirsiniz.', 'kanews' ); ?></p>
        <a href="<?php echo kanews_account_page_url(); ?>?islem=firma-ekle" class="kanews-label kanews-label-widget text-center"><?php echo esc_html_e( 'Yeni Firma Ekle', 'kanews' ); ?></a>
      </div>
    </div>
  </div>

</div>